C*****  SVESSQ  Sum of Vector Signed Squares      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SVESSQ (A,IA,C,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output scalar.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine sums the signed squares of the elements
C       of a vector A and stores the sum in scalar C.
C
C            C = SUM[A(i)*ABS(A(i))]    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL SVESSQ (A,1,C,5)
C
C       Input Operands:
C
C       A = -1.500
C           -1.000
C            0.000
C            1.000
C            2.000
C
C       Output Operands:
C
C       C = 1.750
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE SVESSQ(A,IA,C,N)
C
      INTEGER IA,N,II,M
      REAL A(1),C
      IF (N.LE.0) GO TO 12
      II = 1
      C = 0.0
      DO 10 M=1,N
        C = C + A(II) * ABS(A(II))
        II = II+IA
10    CONTINUE
12    RETURN
      END
