C*****  VAVEXP  Vector Exponential Averaging      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VAVEXP (A,IA,B,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar discount factor.
C
C       C       Real input/output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C        This routine updates the roughly exponential average vector
C        C to include a new vector A.
C
C             C(i) = (C(i) * (B-1.0) + A(i)) / B    for i = 1,N
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VAVEXP (A,1,B,C,1,5)
C
C       Input Operands:
C
C       A =  5.00
C           13.00
C           18.00
C           26.00
C           32.00
C
C       B = 2.000
C
C       C = 11.00
C           22.00
C           33.00
C           44.00
C           55.00
C
C       Output Operands:
C
C       C =  8.00
C           17.50
C           25.50
C           35.00
C           43.50
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VAVEXP(A,IA,B,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),B,C(1),WT,BFACT
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      BFACT = 1.0 / B
      WT = 1.0 - BFACT
      DO 10 M=1,N
        C(KK) = C(KK) * WT + A(II) * BFACT
        II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
