C*****  VCLIP   Vector Clip                       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VCLIP (A,IA,B,C,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar, lower threshold.
C
C       C       Real input scalar, upper threshold.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine clips the values of a vector to within a
C       range specified by scalars B and C.  The results are
C       stored in vector D.
C
C            D(i) = B,    if A(i) < B,
C                 = A(i), if B <= A(i) < C,
C                 = C,    if C <= A(i)     for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VCLIP (A,1,B,C,D,1,5)
C
C       Input Operands:
C
C       A = -2.000
C           -1.000
C            0.000
C            1.000
C            2.000
C
C       B = -1.000
C
C       C =  1.000
C
C       Output Operands:
C
C       D = -1.000
C           -1.000
C            0.000
C            1.000
C            1.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VCLIP(A,IA,B,C,D,ID,N)
C
      INTEGER IA,ID,N,II,LL,M
      REAL A(1),B,C,D(1)
      IF (N.LE.0) GO TO 12
      II = 1
      LL = 1
      DO 10 M=1,N
        IF (A(II).LT.B) GOTO 4
        IF (A(II).GE.C) GOTO 6
          D(LL) = A(II)
        GOTO 8
4         D(LL) = B
        GOTO 8
6         D(LL) = C
8       II = II+IA
        LL = LL+ID
10    CONTINUE
12    RETURN
      END
