C*****  VCLR    Vector Clear                      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VCLR (C,IC,N)
C
C       where,
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine sets all the elements of a vector C to zero.
C
C            C(i) = 0.0    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VCLR (C,1,5)
C
C       Output Operands:
C
C       C = 0.00
C           0.00
C           0.00
C           0.00
C           0.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VCLR(C,IC,N)
C
      INTEGER IC,N,KK,M
      REAL C(1)
      IF (N.LE.0) GO TO 12
      KK = 1
      DO 10 M=1,N
        C(KK) = 0.0
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
