C*****  VGEN   Generate Vector                     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VGEN (A,B,C,IC,N)
C
C       where,
C
C       A       Real input scalar.
C
C       B       Real input scalar.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine fills the elements of a vector C with
C       a ramp beginning with A and ending with B.
C
C          C(i) = A + ((i-1)*(B-A) / (N-1)   for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VGEN (A,B,C,1,5)
C
C       Input Operands:
C
C       A = 1.00     B = 1.40
C
C       Output Operands:
C
C       C = 1.00
C           1.10
C           1.20
C           1.30
C           1.40
C
C  HISTORY
C         1) Jul 86      D. Benua      Original.
C
      SUBROUTINE VGEN(A,B,C,IC,N)
C
      INTEGER IC,N,KK,M
      REAL A,B,C(1),NM1,BMA
      IF (N.LE.0) GO TO 12
      NM1 = FLOAT(N-1)
      BMA = B - A
      KK = 1
      DO 10 M=1,N
        C(KK) = A + ((M-1) * BMA) / NM1
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
