C*****  VIMAG   Extract Imags of Complex Vector   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VIMAG (A,IA,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine extracts the imaginary parts of a complex
C       vector A to form a real vector C.
C
C            C(i) = imag(A(i))    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VIMAG (A,2,C,1,2)
C
C       Input Operands:
C
C       A = ( 1.000,-2.000)
C           (-3.000, 4.000)
C
C       Output Operands:
C
C       C = -2.000
C            4.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VIMAG(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1)
      IF (N.LE.0) GOTO 12
      II = 2
      KK = 1
      DO 10 M=1,N
        C(KK) = A(II)
        II = II + IA
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
