C*****  VINDEX  Vector Index                      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VINDEX (A,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector, values.
C
C       B       Real input vector, indices.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine uses the elements of one vector B as the
C       subscripts by which to select the elements of another
C       vector A, to form another vector C.
C
C            C(i) = A(FIX(B(i)+1)    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VINDEX (A,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.00       B = 2.80
C           2.00           4.20
C           3.00           0.20
C           4.00           3.10
C           5.00           1.75
C
C       Output Operands:
C
C       C = 3.00
C           5.00
C           1.00
C           4.00
C           2.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VINDEX(A,B,IB,C,IC,N)
C
      INTEGER IB,IC,N,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 12
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = A(1+IFIX(B(JJ)))
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
