C*****  VINTB  Vector Interpolate                MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VINTB (A,IA,B,IB,C,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input scalar, interpolation constant.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine interpolates values of vectors A and B
C       according to the interpolation constant C.  The results
C       are stored in vector D.
C
C         D(i) = A(i) + C * ( B(i) - A(i) )  for i=1,N
C
C
C  REFERENCE
C
C       P. Lancaster and K. Salkauskas.  1986.  Curve and sur-
C       face fitting: an introduction.  New York: Academic
C       Press.
C
C
C  EXAMPLE
C
C       CALL VINTB (A,1,B,1,C,D,1,5)
C
C       Input Operands:
C
C       A = 5.00
C          13.00
C          18.00
C          26.00
C          15.00
C
C       B = 2.00
C           2.50
C           2.66
C           5.50
C           8.25
C
C       C = 0.44
C
C       Output Operands:
C
C       D =  3.68
C            8.38
C           11.25
C           16.98
C           12.03
C
C  HISTORY
C         1) Jul 86     D. Benua          Original.
C
      SUBROUTINE VINTB(A,IA,B,IB,C,D,ID,N)
C
      INTEGER IA,IB,ID,N,II,JJ,KK,M
      REAL A(1),B(1),C,D(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
         D(KK) = A(II) + C * (B(JJ) - A(II))
         II = II + IA
         JJ = JJ + IB
         KK = KK + ID
10    CONTINUE
12    RETURN
      END
