C*****  VLIM    Vector Limit                      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VLIM (A,IA,B,C,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar threshold.
C
C       C       Real input scalar replacement value.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine creates a vector D with only two values,
C       C or -C.  The sign of each element of D depends on
C       whether the corresponding element of A is less than the
C       threshold B value.
C
C            D(i) = -C,  if A(i) < B,
C                 =  C,  if A(i) >= B    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VLIM (A,1,B,C,D,1,5)
C
C       Input Operands:
C
C       A = -2.000
C           -1.000
C            0.000
C            1.000
C            2.000
C
C       B = -1.000
C
C       C =  1.000
C
C       Output Operands:
C
C       D = -1.000
C            1.000
C            1.000
C            1.000
C            1.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VLIM(A,IA,B,C,D,ID,N)
C
      INTEGER IA,ID,N,II,LL,M
      REAL A(1),B,C,D(1)
      IF (N.LE.0) GO TO 12
      II = 1
      LL = 1
      DO 10 M=1,N
        IF (A(II).LT.B) GOTO 6
          D(LL) = C
        GOTO 8
6         D(LL) = -C
8       II = II+IA
        LL = LL+ID
10    CONTINUE
12    RETURN
      END
