C*****  VLMERG  Logical Vector Merge              MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VLMERG (A,IA,B,IB,C,IC,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input vector.
C
C       IC      Integer input stride for vector C.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine uses vector C as a switch to select
C       elements from either vector A or B to form a fourth
C       vector D.
C
C            D(i) = A(i), if C(i) <> 0.0
C                 = B(i), if C(i) = 0.0,    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VLMERG (A,1,B,1,C,1,D,1,5)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C       B = 0.100
C           0.200
C           0.300
C           0.400
C           0.500
C
C       C = 0.000
C           1.000
C           0.000
C           1.000
C           0.000
C
C       Output Operands:
C
C       D = 0.100
C           2.000
C           0.300
C           4.000
C           0.500
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VLMERG(A,IA,B,IB,C,IC,D,ID,N)
C
      INTEGER IA,IB,IC,ID,N,II,JJ,KK,LL,M
      REAL A(1),B(1),C(1),D(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      LL = 1
      DO 10 M=1,N
        IF (C(KK).EQ.0.0) GOTO 6
          D(LL) = A(II)
        GOTO 8
6         D(LL) = B(JJ)
8       II = II+IA
        JJ = JJ+IB
        KK = KK+IC
        LL = LL+ID
10    CONTINUE
12    RETURN
      END
