C*****  VLOG10  Vector Logarithm (Base 10)        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VLOG10 (A,IA,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine takes the base 10 logarithm of the elements of a
C       vector A and stores the results in vector C.
C
C            C(i) = LOG10(A(i))    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VLOG10 (A,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.0
C          10.0
C         100.0
C        1000.0
C       10000.0
C
C       Output Operands:
C
C       C = 0.00
C           1.00
C           2.00
C           3.00
C           4.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VLOG10(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL C(1),A(1)
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = ALOG10(A(II))
        II = II + IA
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
