C*****  VMAXMG  Vector Maximum Magnitude          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VMAXMG (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine selects the maximum absolute value of
C       corresponding pairs of elements of vectors A and B
C       and stores the results in vector C.
C
C            C(i) = MAX(ABS(A(i)),ABS(B(i)))    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VMAXMG (A,1,B,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C       B = -5.00
C           -4.00
C           -3.00
C           -2.00
C           -1.00
C
C       Output Operands:
C
C       C = 5.000
C           4.000
C           3.000
C           4.000
C           5.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VMAXMG(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = AMAX1(ABS(A(II)),ABS(B(JJ)))
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
