C*****  VPOLY   Vector Polynomial Evaluation      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VPOLY (A,IA,B,IB,C,IC,N,M)
C
C       where,
C
C       A       Real input vector of length M + 1, polynomial
C               coefficients starting with the highest order
C               coefficient.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector, independent variable values.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       M       Integer input order of polynomial.
C
C
C  DESCRIPTION
C
C       This routine evaluates a vector polynomial.
C
C            C(j) = SUM{A(i) * [B(j)**(M-i+1)]}
C            for i = 1,M+1 and j=1,N
C
C       M must be greater than or equal to 0.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VPOLY (A,1,B,1,C,1,5,2)
C
C       Input Operands:
C
C       A =  1.000
C            2.000
C            3.000
C
C       B = -2.000
C           -1.000
C            1.000
C            2.000
C            3.000
C
C       Output Operands:
C
C       C =  3.000
C            2.000
C            6.000
C           11.000
C           18.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C         2) Oct 90     R. Coleman      Modified algorithm to fix problem
C                                       and improve performance.
C
      SUBROUTINE VPOLY(A,IA,B,IB,C,IC,N,M)
C
      INTEGER IA,IB,IC,N,M,II,JJ,KK,MM,Q
      REAL    A(1),B(1),C(1),X,VAL
      IF (N.LE.0 .OR. M.LT.0) GO TO 12
      JJ = 1
      KK = 1
      DO 10 MM=1,N
        X   = B(JJ)
        II  = 1
        VAL = A(II)
        DO 8 Q=1,M
          II  = II+IA
          VAL = VAL * X + A(II)
8       CONTINUE
        C(KK) = VAL
        JJ    = JJ+IB
        KK    = KK+IC
10    CONTINUE
12    RETURN
      END
