C*****  VRAND   Vector Uniform Random Number Generator  MATH ADVANTAGE REL 3.0
C
C  **   COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VRAND(IS,C,IC,N)
C
C       where,
C
C       IS      Integer seed value.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count for vector C.
C
C
C  DESCRIPTION
C
C       This routine fills vector C with a sequence
C       of uniformly distributed random numbers between 0.0 and 1.0.
C       Every element of vector C is filled with a different random
C       number.
C
C       Different values of IS will result in different
C       pseudo-random sequences of values being stored in vector C.
C
C  REFERENCE
C
C       US Department of Commerce, National Bureau of Stan-
C       dards, 1977.  Data encryption standard.  Federal Infor-
C       mation Processing Standards Publication no. 46,
C
C
C  EXAMPLE
C
C       CALL VRAND(IS,C,1,5)
C
C       Input operands:
C
C       IS = 1234
C
C       Output operands:
C
C       C =  0.18154356
C            0.10630794
C            0.76813674
C            0.25185317
C            0.79505807
C
C
C  HISTORY
C
C       1) August 1986  L. A. Westerman
C       2) February 1987  L.J. Shanbeck
C               Removed check for IC <= 0
C
        SUBROUTINE VRAND(IS,C,IC,N)
C
        INTEGER IS, IC, N
        REAL C(1), QTC026
C
        INTEGER J, K
C
        IF ( N .LE. 0 ) GO TO 99
        K = 1
        DO 10 J = 1, N
            C(K) = QTC026(IS)
            K = K + IC
10      CONTINUE
C
99      CONTINUE
C
        RETURN
        END
