C*****  VSCATR  Vector Scatter                    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VSCATR (A,IA,B,IB,C,N)
C
C       where,
C
C       A       Real input vector, values.
C
C       IA      Integer input stride for vector A.
C
C       B       Integer input vector, indices.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine stores the elementsof one vector A into another
C       vector C using the elements of a third vector B as the
C       subscripts by which to select the elements of vector C.
C
C            C(B(i)) = A(i)    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VSCATR (A,1,B,1,C,5)
C
C       Input Operands:
C
C       A = 1.00       B = 3
C           3.00           5
C           5.00           1
C           7.00           4
C           9.00           2
C
C       Output Operands:
C
C       C = 5.00
C           9.00
C           1.00
C           7.00
C           3.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VSCATR(A,IA,B,IB,C,N)
C
      INTEGER B(1),IA,IB,M,II,JJ,N
      REAL A(1),C(1)
      IF (N .LE. 0) GO TO 800
      II = 1
      JJ = 1
      DO 110 M = 1, N
         C(B(JJ)) = A(II)
         II = II + IA
         JJ = JJ + IB
110   CONTINUE
800   RETURN
      END
