C*****  ZRFUNC  Zeros of a Function           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL ZRFUNC(FUNC,A,B,MAXITR,ZTOL,C,IERR)
C
C       where,
C
C       FUNC    Real input function, from which the zero in the
C               range A < C < B will be calculated. Must be
C               declared as EXTERNAL by calling program.
C
C       A       Real input scalar representing the minimum value
C               of the range in which the zero of the function will
C               be derived.
C
C       B       Real input scalar representing the maximum value
C               of the range in which the zero of the function will
C               be derived.
C
C       MAXITR  Integer input representing the maximum
C               number of iterations used in the convergence.
C
C       ZTOL    Real input scalar representing the accuracy of the
C               result.
C
C       C       Real output scalar representing the value within the
C               specified range that the output of the function
C               converges to zero.
C
C       IERR    Integer output completion code:
C                   If IERR = 0, routine terminated normally.
C                   If IERR = 1, root not found between A and B.
C                   If IERR = 2, maximum number of iterations reached.
C
C
C  DESCRIPTION
C
C       This routine finds the root of a function FUNC known to
C       lie between A and B.  The root will be returned as C with
C       an accuracy of ZTOL.
C
C
C  REFERENCES
C
C       Richard P. Brent. 1973. Algorithms for Minimization without
C       Derivatives. New Jersey: Prentice Hall.
C
C       George E. Forsythe, Michael A. Malcolm, Cleve B. Moler. 1977.
C       Computer Methods for Mathematical Computations. Englewood Cliffs,
C       N.J.: Prentice Hall.
C
C
C  EXAMPLE
C
C       Function defined as:
C
C       REAL FUNCTION FUNC(X)
C       FUNC = (X-2.0)*(X+2.0)
C       RETURN
C       END
C       .
C       .
C       .
C       EXTERNAL FUNC
C
C       CALL ZRFUNC(FUNC,A,B,MAXITR,ZTOL,C,IERR)
C
C       Input Operands:
C
C       A = -3.0
C
C       B = 1.0
C
C       MAXITR = 100
C
C       ZTOL = 1.0E-10
C
C       Output Operands:
C
C       C = -2.0
C
C       IERR = 0
C
C
C  HISTORY
C         1) Feb 88       C. Ward         Original.
C
      SUBROUTINE ZRFUNC(FUNC,A,B,MAXITR,ZTOL,C,IERR)
C
      REAL EPS,TINY,HUGE
      REAL FUNC,A,B,ZTOL,C
      REAL A1,B1,FA,FB,FC,D,E,TOL1,XM,S,P,Q,R
      INTEGER MAXITR,IERR
C
      DATA EPS,TINY,HUGE /0.0,0.0,0.0/
      IERR=0
C
C     SET MACHINE DEPENDENT VALUES.
C
      IF (HUGE .EQ. 0.0) THEN
         CALL QTC045(EPS,TINY,HUGE)
      ENDIF
C
      A1=A
      B1=B
      FA=FUNC(A1)
      FB=FUNC(B1)
      IF(FB*FA.GT.0.0) IERR=1
      FC=FB
      DO 11 ITER=1,MAXITR
        IF(FB*FC.GT.0.0) THEN
          C=A1
          FC=FA
          D=B1-A1
          E=D
        ENDIF
        IF(ABS(FC).LT.ABS(FB)) THEN
          A1=B1
          B1=C
          C=A1
          FA=FB
          FB=FC
          FC=FA
        ENDIF
        TOL1=2.0*EPS*ABS(B1)+0.5*ZTOL
        XM=0.5*(C-B1)
        IF(ABS(XM).LE.TOL1 .OR. FB.EQ.0.0)THEN
          C=B1
          RETURN
        ENDIF
        IF(ABS(E).GE.TOL1 .AND. ABS(FA).GT.ABS(FB)) THEN
          S=FB/FA
          IF(A1.EQ.C) THEN
            P=2.0*XM*S
            Q=1.0-S
          ELSE
            Q=FA/FC
            R=FB/FC
            P=S*(2.0*XM*Q*(Q-R)-(B1-A1)*(R-1.0))
            Q=(Q-1.0)*(R-1.0)*(S-1.0)
          ENDIF
          IF(P.GT.0.0) Q=-Q
          P=ABS(P)
          IF(2.0*P.LT.MIN(3.0*XM*Q-ABS(TOL1*Q),ABS(E*Q))) THEN
            E=D
            D=P/Q
          ELSE
            D=XM
            E=D
          ENDIF
        ELSE
          D=XM
          E=D
        ENDIF
        A1=B1
        FA=FB
        IF(ABS(D) .GT. TOL1) THEN
          B1=B1+D
        ELSE
          B1=B1+SIGN(TOL1,XM)
        ENDIF
        FB=FUNC(B1)
11    CONTINUE
      IERR=2
      C=B1
      RETURN
      END
