C*****  ZRPOLY   Zeros of a Polynomial        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL ZRPOLY (A,ZEROR,ZEROI,N,IFLG)
C
C       where,
C
C       A       Real input vector of length N+1 containing the
C               coefficients of a polynomial in decreasing order.
C
C       ZEROR   Real output vector of length N containing the
C               real part of the roots of the polynomial.
C
C       ZEROI   Real output vector of length N containing the
C               imaginary part of the roots of a polynomial.
C
C       N       Integer input indicating the degree of the
C               polynomial to be solved.  Note that the degree
C               of the polynomial is 1 less than the number of
C               coefficients it will contain.  N must be less
C               than or equal to 100.
C
C       IFLG    Integer output indicating whether the routine
C               found the N roots.
C                   If IFLG=0, N roots were found.
C                   If IFLG=1, ZRPOLY has found fewer than N roots.
C
C
C  DESCRIPTION
C
C       This routine finds the roots of a tabulated polynomial,
C       returning both real and imaginary roots.  The input
C       polynomial may be up to degree 100.  The accuracy of
C       results may be degraded for very large polynomials.
C
C       WARNING: This routine may fault for some very large
C       polynomials depending on the machine precision.
C
C
C
C  REFERENCE
C
C       M.A. Jenkins and J.F. Traub. 1970. A three-stage algorithm
C       for real polynomials using quadratic iteration. SIAM Journal
C       of Numer. Anal. 7:545-566.
C
C       M.A. Jenkins and J.F. Traub. 1975. Principles for testing poly-
C       nomial zerofinding programs. ACM Trans. on Math. Softw. 1:26-34.
C
C
C  EXAMPLE
C                               4    3     2
C       Solving the polynomial X  - X  - 7X  + X + 6
C
C       CALL ZRPOLY (A,ZEROR,ZEROI,4,IFLG)
C
C       Input Operands:
C
C       A =  1.0
C           -1.0
C           -7.0
C            1.0
C            6.0
C
C       Output Operands:
C
C       ZEROR = -1.0    ZEROI = 0.0
C                1.0            0.0
C               -2.0            0.0
C                3.0            0.0
C
C       IFLG = 0
C
C
C  HISTORY
C         1) Feb 88     C. Ward         Original.
C
C
      SUBROUTINE ZRPOLY (A,ZEROR,ZEROI,N,IFLG)
C
      DOUBLE PRECISION P(101), QP(101), K(101),
     & QK(101), SVK(101), SR, SI, U, V, AAA, B, C, D,
     & A1, A3, A7, E, F, G, H, SZR, SZI, LZR, LZI
      DOUBLE PRECISION TEMP(101), T, AA, BB, CC, FACTOR,
     & ZRNM1, ZINM1, ZRN, ZIN
      REAL PT(101), LO, MAX, MIN, XX, YY, COSR,
     & SINR, XXX, X, SC, BND, XM, FF, DF, DX, INFIN,
     & SMALNO, BASE, L
      REAL A(1), ZEROR(1), ZEROI(1)
      REAL ETA, ARE, MRE
      INTEGER N, CNT, NZ, I, J, JJ, NM1, IFLG, ZEROK, NI, NN
C
      IF (N.LE.0) GOTO 800
C THE FOLLOWING STATEMENTS SET MACHINE CONSTANTS USED
C IN VARIOUS PARTS OF THE PROGRAM.  THE MEANING OF THE
C FOUR CONSTANTS ARE...
C ETA     THE MAXIMUM RELATIVE REPRESENTATION ERROR
C         WHICH CAN BE DESCRIBED AS THE SMALLEST
C         POSITIVE FLOATING POINT NUMBER SUCH THAT
C         1.0+ETA IS GREATER THAN 1
C INFINY  THE LARGEST FLOATING-POINT NUMBER
C SMALNO  THE SMALLEST POSITIVE FLOATING-POINT NUMBER
C         IF THE EXPONENT RANGE DIFFERS IN SINGLE AND
C         DOUBLE PRECISION THEN SMALNO AND INFIN
C         SHOULD INDICATE THE SMALLER RANGE.
C BASE    THE BASE OF THE FLOATING-POINT NUMBER
C         SYSTEM USED.
      DATA ETA,SMALNO,INFIN/0.0,0.0,0.0/
      BASE =  8.0
C  SET MACHINE DEPENDENT VAULES, IF NECESSARY
C
      IF (INFIN.EQ.0.0) THEN
         CALL QTC045(ETA,SMALNO,INFIN)
      ENDIF
C
C ARE AND MRE REFER TO THE UNIT ERROR IN + AND *
C RESPECTIVELY. THEY ARE ASSUMED TO BE THE SAME AS
C ETA
      ZEROK = 0
      ARE = ETA
      MRE = ETA
      LO  = SMALNO/ETA
C INITIALIZATION OF CONSTANTS FOR SHIFT ROTATION
      XX = 0.70710678
      YY = -XX
      COSR = -0.069756474
      SINR = 0.99756405
      IFLG = 0
      NI = N
      NN = NI + 1
C ALGORITHM FAILS IF THE LEADING COEFFICIENT IS ZERO.
      IF (A(1) .NE. 0.0) GO TO 10
      IFLG = 1
      N = 0
      RETURN
C REMOVE THE ZEROS AT THE ORIGIN IF ANY
   10 IF (A(NN) .NE. 0.0) GO TO 20
      J = N - NI + 1
      ZEROR(J) = 0.0
      ZEROI(J) = 0.0
      NN = NN - 1
      NI = NI - 1
      GO TO 10
C MAKE A COPY OF THE COEFFICIENTS
   20 DO 30 I = 1,NN
       P(I) = A(I)
   30 CONTINUE
C START THE ALGORITHM FOR ONE ZERO
   40 IF (NI .GT. 2) GO TO 60
      IF (NI .LT. 1) RETURN
C CALCULATE THE FINAL ZERO OR PAIR ZEROS
      IF (NI .EQ. 2) GO TO 50
      ZEROR(N) = -P(2)/P(1)
      ZEROI(N) = 0.0
      RETURN
   50 CALL QTC117(P(1), P(2), P(3), ZRNM1, ZINM1, ZRN, ZIN)
      ZEROR(N-1) = ZRNM1
      ZEROI(N-1) = ZINM1
      ZEROR(N)   = ZRN
      ZEROI(N)   = ZIN
      RETURN
C FIND THE LARGEST AND SMALLEST MODULI OF COEFFICIENTS.
   60 MAX = 0.0
      MIN = INFIN
      DO 70 I = 1, NN
        X = DABS(P(I))
        IF (X .GT. MAX) MAX = X
        IF (X .NE. 0 .AND. X .LT. MIN) MIN = X
   70 CONTINUE
C SCALE IF THERE ARE LARGE OR VERY SMALL COEFFICIENTS
C COMPUTES A SCALE FACTOR TO MULTIPLY THE
C COEFFICIENTS OF THE POLYNOMIAL.  THE SCALING IS DONE
C TO AVOID OVERFLOW AND TO AVOID UNDETECTED UNDERFLOW
C INTERFERING WITH THE CONVERGENCE CRITERION.
C THE FACTOR IS A POWER OF THE BASE
      SC = LO/MIN
      IF (SC.GT.1.0) GO TO 80
      IF (MAX.LT.10.0) GO TO 110
      IF (SC.EQ.0.0) SC = SMALNO
      GO TO 90
   80 IF (INFIN/SC.LT.MAX) GO TO 110
   90 L = ALOG(SC)/ALOG(BASE) + 0.5
      FACTOR = (BASE*1.D0)**L
      IF (FACTOR.EQ.1.D0) GOTO 110
      DO 100 I = 1,NN
        P(I) = FACTOR*P(I)
  100 CONTINUE
C COMPUTE LOWER BOUND ON MODULI OF ZEROS.
  110 DO 120 I = 1,NN
        PT(I) = DABS(P(I))
  120 CONTINUE
      PT(NN) = -PT(NN)
C COMPUTE UPPER ESTIMATE OF BOUND
      X = EXP((ALOG(-PT(NN))-ALOG(PT(1)))/FLOAT(NI))
      IF (PT(NI).EQ.0.0) GO TO 130
C IF NEWTON STEP AT THE ORIGIN IS BETTER, USE IT
      XM = -PT(NN)/PT(NI)
      IF (XM.LT.X) X = XM
C CHOP THE INTERVAL (0,X) UNTIL FF .LE. 0
  130 XM = X*0.1
      FF = PT(1)
      DO 140 I = 2, NN
        FF = FF*XM + PT(I)
  140 CONTINUE
      IF (FF.LE.0.0) GO TO 150
      X = XM
      GO TO 130
  150 DX = X
C DO NEWTON ITERATION UNTIL X CONVERGES TO TWO
C DECIMAL PLACES
  160 IF (ABS(DX/X).LE.0.005) GO TO 180
      FF = PT(1)
      DF = FF
      DO 170 I = 2,NI
         FF = FF*X + PT(I)
         DF = DF*X + FF
  170 CONTINUE
      FF = FF*X + PT(NN)
      DX = FF/DF
      X = X - DX
      GO TO 160
  180 BND = X
C COMPUTE THE DERIVATION AS THE INITIAL K POLYNOMIAL
C AND DO 5 STEPS WITH NO SHIFT
      NM1 = NI - 1
      DO 190 I = 2,NI
        K(I) = FLOAT(NN-I)*P(I)/FLOAT(NI)
  190 CONTINUE
      K(1) = P(1)
      AA = P(NN)
      BB = P(NI)
      IF (K(NI).EQ.0.D0) THEN
         ZEROK = 1
      ELSE
         ZEROK = 0
      ENDIF
      DO 230 JJ = 1,5
        CC = K(NI)
        IF (ZEROK.NE.0) GO TO 210
C USE SCALED FORM OF RECURRENCE IF THE VALUE OF K AT 0 IS
C NONZERO
        T = -AA/CC
        DO 200 I = 1,NM1
          J = NN-I
          K(J) = T*K(J-1) + P(J)
  200   CONTINUE
        K(1) = P(1)
        IF (DABS(K(NI)).LE.(DABS(BB)*ETA*10.0)) THEN
           ZEROK = 1
        ELSE
           ZEROK = 0
        ENDIF
        GOTO 230
C USE UNSCALED FORM OF RECURRENCE
  210   DO 220 I = 1,NM1
          J = NN - I
          K(J) = K(J-1)
  220   CONTINUE
        K(1) = 0.D0
        IF (K(NI).EQ.0.D0) THEN
           ZEROK = 1
        ELSE
           ZEROK = 0
        ENDIF
  230 CONTINUE
C SAVE K FOR RESTARTS WITH NEW SHIFTS
      DO 240 I = 1,NI
        TEMP(I) = K(I)
  240 CONTINUE
C LOOP TO SELECT THE QUADRATIC CORRESPONDING TO EACH
C NEW SHIFT
      DO 280 CNT = 1,20
C QUADRATIC CORRESPONDS TO A DOUBLE SHIFT TO A
C NON-REAL POINT AND ITS COMPLEX CONJUGATE.  THE POINT
C HAS MODULUS BND AND AMPLITUDE ROTATED BY 94 DEGREES
C FROM THE PREVIOUS SHIFT
        XXX = COSR*XX - SINR*YY
        YY = SINR*XX + COSR*YY
        XX = XXX
        SR = BND*XX
        SI = BND*YY
        U = -2.D0*SR
        V = BND
C SECOND STAGE CALCULATION, FIXED QUADRATIC
        CALL QTC110(P, QP, K, QK, SVK, SR, SI, U,
     &   V, AAA, B, C, D, A1, A3, A7, E, F, G,
     &   H, SZR, SZI, LZR, LZI, ETA, ARE, MRE, NI, NN,
     &   20*CNT, NZ)
        IF (NZ.EQ.0) GO TO 260
C THE SECOND STAGE JUMPS DIRECTLY TO ONE OF THE THIRD
C STAGE ITERATIONS AND RETURNS HERE IF SUCCESSFUL.
C DEFLATE THE POLYNOMIAL, STORE THE ZERO OR ZEROS AND
C RETURN TO THE MAIN ALGORITHM.
        J = N - NI + 1
        ZEROR(J) = SZR
        ZEROI(J) = SZI
        NN = NN - NZ
        NI = NN - 1
        DO 250 I=1,NN
          P(I) = QP(I)
  250   CONTINUE
        IF (NZ.EQ.1) GO TO 40
        ZEROR(J+1) = LZR
        ZEROI(J+1) = LZI
        GO TO 40
C IF THE ITERATION IS UNSUCCESSFUL ANOTHER QUADRATIC
C IS CHOSEN AFTER RESTORING K
  260   DO 270 I = 1,NI
          K(I) = TEMP(I)
  270   CONTINUE
  280 CONTINUE
C RETURN WITH FAILURE IF NO CONVERGENCE WITH 20
C SHIFTS
      IFLG = 1
      N = N - NI
 800  CONTINUE
      RETURN
      END
