C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE anmo
C
C**********************************************************************C
C
C anmo READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES NORMAL MOVEOUT (WITH OPTIONAL STATICS BEFORE),
C AND PRINTS UPDATED LINE HEADER AND REQUIRED RECORDS
C OR TRACES
C
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      integer   hbegin
      parameter (ndiv=10000,adiv=ndiv)
      integer     vflag,vrs,vre
      integer     vst,ved
      integer     obytes
      integer     slineheader(szsmpm),vlineheader(szsmpm)
      character   name * 4, ntap * 256, otap * 256, vmod *256
      character   hdrwrdx * 6, hdrwrdy * 6
#include <f77/pid.h>
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     limin, limax, dimin, dimax
      logical     verbos, query, stat,remove
      logical     top2bot,bot2top,XYs,shot,rcvr,cdp
      logical     linear,d3,f2m,m2f          
      integer     argis, pipe
      integer     irs, ire, ns, ne
      integer     nreout, ntrout, minsamp, lenpad, lenpadms
 
      DATA  name/'ANMO'/
      DATA  pipe/3/

      fmscl = 0.30480
      mfscl = 3.28084

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
        call help()
        call exit(0)
      endif
C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>
C**********************************************************************C
C     read command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,vmod,ns,ne,irs,ire,vrs,vre,stat,         
     1        remove,verbos,lenpadms,factor,top2bot,bot2top,linear,d3,
     2        scl,shot,rcvr,cdp,hdrwrdx,hdrwrdy,f2m,m2f,
     3        IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,XYs,
     4        limin,limax,dimin,dimax)

c----
c  XY feet -> m or m-> feet scaler
c----
          if     ( f2m ) then
             xyscl = fmscl
          elseif ( m2f ) then
             xyscl = mfscl
          else
             xyscl = 1.0
          endif

      vst = 1
      ved = 1
c     if ( verbos ) then
         write(LERR,*)' First record to process              =  ',irs
         write(LERR,*)' Last record to process               =  ',ire
         write(LERR,*)' First velocity to use                =  ',vrs
         write(LERR,*)' Last  velocity to use                =  ',vre
         write(LERR,*)' Starting trace number                =  ',ns
         write(LERR,*)' Ending   trace number                =  ',ne
         write(LERR,*)' Remove nmo correction?               =  ',remove
         write(LERR,*)' Apply linear moveout correction?     =  ',linear
         write(LERR,*)' Apply statics before nmo             =  ',stat
         write(LERR,*)' Reconstruct in top-to-bottom direction?   =  ',
     1                  top2bot
         write(LERR,*)' Reconstruct in bottom-to-top direction?   =  ',
     1                  bot2top
         write(LERR,*)' Trace padded in the front by         =  ',
     1                  lenpadms
         write(LERR,*)' Velocity scaler                      =  ',scl
         write(LERR,*)' NMO correction multiplication factor ',factor
         if (XYs) then
         write(LERR,*)' Velocity functions derived from trace XYs'
         write(LERR,*)' X1, Y1 = ',IX1,IY1
         write(LERR,*)' X2, Y2 = ',IX2,IY2
         write(LERR,*)' X3, Y3 = ',IX3,IY3
         write(LERR,*)' X4, Y4 = ',IX4,IY4
         write(LERR,*)' DX (along 3-4 direction) = ', DX 
         write(LERR,*)' DY (along 1-2 direction) = ', DY
         else
         write(LERR,*)' Velocity functions derived from trace LI/DI'
         endif
c     end if

C**********************************************************************C
C     open logical i/o units
C     check line header; save key values
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
	if (d3) then
		call sislgbuf(luvel,'off')
	endif

      if (vmod .ne. ' ') then
          call getln(luvel, vmod, 'r',-1)
      else
          write(LERR,*)'FATAL ERROR in anmo3d:'
          write(LERR,*)'No velocity file supplied - use -v[]'
          write(LER ,*)'FATAL ERROR in anmo3d:'
          write(LER ,*)'No velocity file supplied - use -v[]'
          call ccexit (666)
      endif
      if(luvel .lt. 0)   then
         write(lerr,*)'anmo3d error: velocity file -v not accessible'
         write(ler ,*)'anmo3d error: velocity file -v not accessible'
          call ccexit (666)
      endif
      call sislgbuf(luvel,'off')
c_____________________________________________________________________
c     read in input seismic data line header.
c_____________________________________________________________________
      vflag=1
      lbytes=0
      call rtape (luin,slineheader,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'ANMO: no header read on unit ',luin
         write(LERR,*)'FATAL'
         call exit(0)
      endif
      call hlhprt(slineheader,lbytes,name,4,lerr)
      call saver(slineheader,'NumSmp',nsamp,LINHED)
      call saver(slineheader,'SmpInt',nsi,LINHED)
      call saver(slineheader,'NumTrc',ntrc,LINHED)
      call saver(slineheader,'NumRec',nrec,LINHED)
      call saver(slineheader,'Format',iform,LINHED)
      call saver(slineheader,'UnitSc',unitsc,LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(slineheader, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

      call savelu(hdrwrdx,ifmt_hdrwrdx,l_hdrwrdx,ln_hdrwrdx,TRACEHEADER)
      call savelu(hdrwrdy,ifmt_hdrwrdy,l_hdrwrdy,ln_hdrwrdy,TRACEHEADER)

      lenhed=ITRWRD
      hbegin=1-lenhed

c_____________________________________________________________________
c     read in velocity worktape line header.
c_____________________________________________________________________
      lvbytes=0
      call rtape (luvel,vlineheader,lvbytes)
      if (lvbytes .eq. 0) then
         write(LERR,*)'ANMO: no header read on velocity unit ',luvel
         write(LERR,*)'FATAL'
         call exit(0)
      endif
      call saver(vlineheader,'NumSmp',nsampv,LINHED)
      call saver(vlineheader,'SmpInt',nsiv,LINHED)
      call saver(vlineheader,'NumTrc',ntrcv,LINHED)
      call saver(vlineheader,'NumRec',nrecv,LINHED)
      call saver(vlineheader,'Format',iformv,LINHED)
      call saver(vlineheader,'UnitSc',unitscv,LINHED)

C**********************************************************************C
C     build LI/DI coordinates if required
C**********************************************************************C
      IF (XYs) THEN

         CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1               IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

         if (limax .eq. 0) then
             maxli = NX
         else
             maxli = limax
         endif
         if (limin .eq. 0) then
             minli = 1
         else
             minli = limin
         endif
         if (dimax .eq. 0) then
             maxdi = NY
         else
             maxdi = dimax
         endif
         if (dimin .eq. 0) then
             mindi = 1
         else
             mindi = dimin
         endif
         NDI    = maxdi - mindi + 1
         NLI    = maxli - minli + 1

         write(LERR,*)' '
         write(LERR,*)'Number cells in LI direction = ',NLI
         write(LERR,*)'Number cells in DI direction = ',NDI
         write(LERR,*)'Minimum LI                   = ',minli
         write(LERR,*)'Maximum LI                   = ',maxli
         write(LERR,*)'Minimum DI                   = ',mindi
         write(LERR,*)'Maximum DI                   = ',maxdi
         if (shot)
     1   write(LERR,*)'LI/DI keyed off shot XYs'
         if (rcvr)
     1   write(LERR,*)'LI/DI keyed off receiver XYs'
         if (cdp)
     1   write(LERR,*)'LI/DI keyed off cdp XYs'
         write(LERR,*)' '

      ELSE

         minli  = limin
         maxli  = limax
         mindi  = dimin
         maxdi  = dimax
         NDI    = dimax - dimin + 1
         NLI    = limax - limin + 1

      ENDIF
c_____________________________________________________________________
c     vflag=0 single velocity function
c     vflag=1 multiple velocity function
c_____________________________________________________________________
      if (nrecv*ntrcv .eq. 1) then
         vflag=0
      else
         write(LERR,*)' '
         write(LERR,*)'Number cells in LI direction = ',NLI
         write(LERR,*)'Number cells in DI direction = ',NDI
         write(LERR,*)'Minimum LI                   = ',minli
         write(LERR,*)'Maximum LI                   = ',maxli
         write(LERR,*)'Minimum DI                   = ',mindi
         write(LERR,*)'Maximum DI                   = ',maxdi

         if (ntrcv .ne. NDI) then
            write(LERR,*)'FATAL ERROR in anmo3d LI/DI option:'
            write(LERR,*)'Must have velocity trcs/rec = ',NDI
            write(LERR,*)'which is based on limin/limax ',limin,limax
            write(LER ,*)'FATAL ERROR in anmo3d LI/DI option:'
            write(LER ,*)'Must have velocity trcs/rec = ',NDI
            write(LER ,*)'which is based on limin/limax ',limin,limax
            call ccexit (666)
         endif
         if (nrecv .ne. NLI) then
            write(LERR,*)'FATAL ERROR in anmo3d LI/DI option:'
            write(LERR,*)'Must have velocity # recs = ',NLI
            write(LERR,*)'which is based on dimin/dimax ',dimin,dimax
            write(LER ,*)'FATAL ERROR in anmo3d LI/DI option:'
            write(LER ,*)'Must have velocity # recs = ',NLI
            write(LER ,*)'which is based on dimin/dimax ',dimin,dimax
            call ccexit (666)
         endif

      endif
	
      dt = real (nsi) * unitsc

c     if(verbos) then
         write(LERR,*)' '
         write(LERR,*)' Values read from input seismic worktape'   
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Sample scaler      =  ',unitsc
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform
         if (vflag .eq. 0) then
            write(LERR,*)' Single velocity function will be used'
         endif
         if (stat) write(LERR,*)' Apply Internal Statics'
         if (remove)write(LERR,*)' Remove normal moveout'
         write(LERR,*)' Values read from velocity worktape '             
         write(LERR,*)' # of Samples/Trace =  ',nsampv
         write(LERR,*)' Sample Interval    =  ',nsiv
         write(LERR,*)' Sample scaler      =  ',unitscv
         write(LERR,*)' Traces per Record  =  ',ntrcv
         write(LERR,*)' Records per Line   =  ',nrecv
         write(LERR,*)' Format of Data     =  ',iformv
         write(lerr,*)' input data unit  luin  = ',luin
         write(lerr,*)' output data unit luout = ',luout
         write(lerr,*)' velocity unit    luvel = ',luvel
         write(LERR,*)' '
c     endif
C**********************************************************************C
C     deal with trace padding for forward/reverse nmo
C     compute number output samples/bytes
C     check length of velocity trace
C**********************************************************************C
      lenpad=nint(float(lenpadms)/nsi)
      minsamp=1-lenpad
      nsampin=nsamp
      if(remove)then
         nsampout=nsampin-lenpad
         nsamporig=nsampout
      else
         nsampout=nsampin+lenpad
         nsamporig=nsampin 
      endif
      obytes=(nsampout+lenhed)*szsmpd   
c     if (verbos) then
         write(LERR,*)' '
         write(LERR,*)' lenpad     = ', lenpad
         write(LERR,*)' minsamp    = ', minsamp
         write(LERR,*)' nsampin    = ', nsampin
         write(LERR,*)' nsampout   = ', nsampout
         write(LERR,*)' obytes     = ', obytes
         write(LERR,*)' '
c     endif
c
      if (nsampv .lt. nsamporig) then
          write(lerr,*)'velocity trace(s) too short; contains ',nsampv,
     1                  ' samples'
          write(lerr,*)'orig input data contains ',nsamporig,' samples'
          write(lerr,*)'rerun velin job so that trace at least ',
     1                  nsi*nsamporig,' ms long'
         call exit(2666)
      endif
C**********************************************************************C
C     check default values and set parameters
C**********************************************************************C
      call cmdchk (ns,ne,irs,ire,ntrc,nrec)
      call cmdchk (vst,ved,vrs,vre,ntrcv,nrecv)
c_____________________________________________________________________
c     modify header as needed
c_____________________________________________________________________
      nreout=ire-irs+1
      ntrout=ne-ns+1
      call savew(slineheader,'NumSmp',nsampout,LINHED)
      call savew(slineheader,'NumTrc',ntrout,LINHED)
      call savew(slineheader,'NumRec',nreout,LINHED)
      call savhlh(slineheader,lbytes,lbyout)
c_____________________________________________________________________
c     write out modified line header
c_____________________________________________________________________
      call wrtape(luout,slineheader,lbyout)
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,nsampin+lenhed,lerr)
      call mapmem('uout',l_uout,l_free,nsampout+lenhed,lerr)
      call mapmem('v',l_v,l_free,nsampv+lenhed,lerr)
      call mapmem('slow',l_slow,l_free,nsampv,lerr)
      call mapmem('slow2',l_slow2,l_free,nsampv,lerr)
      call mapmem('t0',l_t0,l_free,nsamporig,lerr)
      call mapmem('t02',l_t02,l_free,nsamporig,lerr)
      call mapmem('tnmo',l_tnmo,l_free,nsamporig,lerr)
      call mapmem('t0irreg',l_t0irreg,l_free,nsamporig,lerr)
      call mapmem('jleft',l_jleft,l_free,nsamporig,lerr)
      call mapmem('jdiv',l_jdiv,l_free,nsamporig,lerr)
      call mapmem('wgt',l_wgt,l_free,8*(ndiv+1),lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)
         write(lerr,*)'suggested solutions:'
         write(lerr,*)' check line headers of input data!'           
         write(lerr,*)
         write(lerr,*)'program ANMO aborted'
         call exit(3666)
      endif
c_____________________________________________________________________
c     get interpolation weights.
c_____________________________________________________________________
      call getw8(s(l_wgt),ndiv)
c_____________________________________________________________________
c     do the nmo correction.
c_____________________________________________________________________
      call nmo3dsub(s(l_uin),s(l_uin),s(l_uout),s(l_uout), 
     1            s(l_t0),s(l_t02),s(l_tnmo),shot,rcvr,cdp,
     2            s(l_slow),s(l_slow2),s(l_v),dt,
     2            s(l_wgt),s(l_jleft),s(l_jdiv),adiv,ndiv,  
     3            irs,ire,ns,ne,ntrc,obytes,remove,stat,  
     4            minsamp,nsamp,nsampin,nsampout,nsamporig,
     5            vrs,vre,nrecv,vflag,ntrcv,factor,
     6            hbegin,lenhed,lerr,luin,luout,luvel,xyscl,
     7            s(l_t0irreg),top2bot,bot2top,linear,d3,scl,XYs,
     8 ifmt_StaCor,l_StaCor,ln_StaCor,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     9 ifmt_DphInd,l_DphInd,ln_DphInd,ifmt_LinInd,l_LinInd,ln_LinInd,
     a ifmt_hdrwrdx,l_hdrwrdx,ln_hdrwrdx,ifmt_hdrwrdy,l_hdrwrdy,
     b ln_hdrwrdy,IX1,IY1,XX,XY,YX,YY,XXT,XYT,YXT,YYT,DX,DY,NDI,NLI,
     c ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,
     d ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,
     e limin,limax,dimin,dimax,verbos)

c__________________________________________________________________
c     close files
c__________________________________________________________________
      call lbclos(luin)
      call lbclos(luout)
      call lbclos(luvel)
      close(lerr)
c
      call exit(0)
      end
c__________________________________________________________________
c     online help screen
c__________________________________________________________________
      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Run this program by typing: anmo and the following arguments'
        write(LER,*)' '
         write(LER,*)
     :' -N [ntap]    (stdin)      : Input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)     : Output data file name'
        write(LER,*)
     :' -v [vmod]    (no default) : velocity model file name'
        write(LER,*)
     :'    create vmod with vi3d so that LI = Record, DI = Trace'
        write(LER,*) ' '
        write(LER,*)
     :' -ns[ns]  starting trace            (default = 1)'
        write(LER,*)
     :' -ne[ne]  ending trace              (default = all traces)'
        write(LER,*)
     :' -rs[irs] starting record           (default = 1)'
        write(LER,*)
     :' -re[ire] ending record             (default = all)'
        write(LER,*)
     :' -sv[vrs] starting velocity record  (default = 1)'
        write(LER,*)
     :' -ev[vrs] ending velocity record    (default = last)'
        write(LER,*) ' '
        write(LER,*)
     :' -t[len]  pad the data in the front (default = 0 ms)'
        write(LER,*)
     :' -s[scl]  scale the velocity traces (default = 1.0)'
        write(LER,*) ' '
        write(LER,*)
     :' -S     apply trace header statics'
        write(LER,*)
     :' -R     remove normal moveout'
        write(LER,*)
     :' -T     form the inverse moveout operation of multiply   '
        write(LER,*)   
     :'        mapped data from top to bottom '//
     :'        (default = mute such data)'
        write(LER,*)
     :' -B     form the inverse moveout operation of multiply   '
        write(LER,*)   
     :'        mapped data from bottom to top  '//
     :'        (default = mute such data)'
        write(LER,*)
     :' -L     apply linear moveout correction'//
     :        ' (default = hyperbolic) '
        write(LER,*)   
     :'        for multiply mapped data (default = mute such data)'
        write(LER,*) ' '
        write(LER,*)   
     :' -XY    LI/DI determined from input trace XYs, else input trace'
        write(LER,*)   
     :'        LI & DI values used.'
        write(LER,*)'If XYs used input corner coords'
        write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1 (N-E)'
        write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1 (N-E)'
        write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2'
        write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2'
        write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3'
        write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3'
        write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4'
        write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4'
        write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
        write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'
        write(LER,*)'-f2m          : scale XYs from feet to meters'
        write(LER,*)'-m2f          : scale XYs from meters to feet'
        write(LER,*)'                otherwise no XY scaling'
        write(LER,*)'-shot         : use source XYs to compute LI/DIs'
        write(LER,*)'-rcvr         : use receiver XYs to compute LI/DIs'
        write(LER,*)'-cdp          : use CDP XYs to compute LI/DIs'
        write(LER,*)
     :' Note: for XYs start/end velocity, -sv[] -ev[], not used'

        write(LER,*) ' '
        write(LER,*)
     :' -V     verbose printout'
        write(LER,*)' '
        write(LER,*)
     :'Usage:anmo3d -N[ntap] -O[otap] -v[vmod] -ns[] -ne[] -rs[] -re[]'
        write(LER,*)
     :'             [ -sv[] -ve[] ] -f[] -t[] -s[] [-S -R -T -B -L -V]'
        write(LER,*)
     :'             [ -XY -f2m -m2f -x1[] -y1[] -x2[] -y2[] -x3[] -y3[]'
        write(LER,*)
     :'               -x4[] -y4[] -ildm[] -icdm[] [ -shot -rcvr -cdp] ]'
        write(LER,*)
     :'***************************************************************'

      return
      end

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      subroutine cmdln(ntap,otap,vmod,ns,ne,irs,ire,vrs,vre,stat,
     1                 remove,verbos,lenpadms,factor,
     2                 top2bot,bot2top,linear,d3,scl,shot,rcvr,cdp,
     3                 hdrwrdx,hdrwrdy,f2m,m2f,IX1,IY1,IX2,IY2,IX3,IY3,
     4                 IX4,IY4,DY,DX,XYs,limin,limax,dimin,dimax)

#include <f77/iounit.h>

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     vmod  - C*100  velocity file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     vrs   - I      start velocity record
c     vre   - I      end velocity record
c    factor - R      stretch nmo function (helps with aliased events)
c   lenpadms- I      length of beginning trace pad
c   top2bot - L      Reconstruct in top to bottom
c   bot2top - L      Reconstruct in bottom to top
c    stat   - L      normalize stacked trace by # live traces
c   remove  - L      remove normal moveout
c     d3    - L      apply 3d normal moveout
c    verbos - L      verbose output or not
c-----
      integer     ns,ne,irs,ire,vrs,vre,argis,lenpadms
      integer     limin,limax,dimin,dimax
      real        factor, scl
      character   ntap*(*),otap*(*),vmod*(*), hdrwrdx*6, hdrwrdy*6
      logical     stat,remove,verbos,top2bot,bot2top,linear,d3,XYs
      logical     f2m,m2f,shot,rcvr,cdp

      call argstr ('-N', ntap, ' ', ' ' )
      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-v',vmod, ' ', ' ')
      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      call argi4  ('-sv',vrs,1,1)
      call argi4  ('-ev',vre,0,0)
      call argi4  ('-t',lenpadms,0,0)
      call argr4  ('-f',factor,1.0,1.0)
      call argr4  ('-s',scl,1.0,1.0)
      call argi4  ('-limin',limin,0,0)
      call argi4  ('-limax',limax,0,0)
      call argi4  ('-dimin',dimin,0,0)
      call argi4  ('-dimax',dimax,0,0)
      stat       = ( argis ('-S') .gt. 0 )
      top2bot    = ( argis ('-T') .gt. 0 )
      bot2top    = ( argis ('-B') .gt. 0 )
      remove     = ( argis ('-R') .gt. 0 )
      linear     = ( argis ('-L') .gt. 0 )
      verbos     = ( argis ('-V') .gt. 0 )
      XYs        = ( argis ('-XY') .gt. 0 )
      f2m        = ( argis( '-f2m' ) .gt. 0 )
      m2f        = ( argis( '-m2f' ) .gt. 0 )
      shot       = ( argis( '-shot' ) .gt. 0 )
      rcvr       = ( argis( '-rcvr' ) .gt. 0 )
      cdp        = ( argis( '-cdp' ) .gt. 0 )

      if (.not.shot .AND. .not.rcvr .AND. .not.cdp) cdp = .true.

c	until this becomes part of anmo, make d3 true alwayS
	d3 = .true.

         if (shot) then
            hdrwrdx = 'SrPtXC'
            hdrwrdy = 'SrPtYC'
         elseif (rcvr) then
            hdrwrdx = 'RcPtXC'
            hdrwrdy = 'RcPtYC'
         else
            hdrwrdx = 'SrRcMX'
            hdrwrdy = 'SrRcMY'
         endif

      IF (XYs) THEN

         vrs = 1
         vre = 0

         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )
 
         call argr4 ('-cldm', dx, 0., 0.)
         call argr4 ('-ildm', dy, 0., 0.)
 
         if (dx .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in anmo3d:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in anmo3d:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif
 
         if (dy .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in anmo3d:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in anmo3d:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif

         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in anmo3d:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in anmo3d:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif

      ENDIF

      return
      end
