C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nmof(uin,uout,dt,minsamp,nsamp, 
     1                x,v0,slow,slow2,t0,t02,tnmo,tstatic,factor,
     2                jleft,wgt,jdiv,ndiv,adiv,linear)
c___________________________________________________________________
C     routine to apply normal moveout correction
c___________________________________________________________________
c     uin    = input data.
c     uout   = output (nmo corrected) data.                         
c     dt     = sample interval
c     v0     = reduction velocity
c     minsamp= 1st sample
c     nsamp  = last sample
c     x      = distance/offset
c
c     dtnmo  = sqrt(t0**2+(x/v)**2)-t0
c     tnmo   = t0+factor*dtnmo                            
c___________________________________________________________________
      real      slow2(0:nsamp-1)
      real      slow(0:nsamp-1)
      real      t0(0:nsamp-1), t02(0:nsamp-1), tnmo(0:nsamp-1)
      real      uin(0:nsamp-1), uout(minsamp-1:nsamp-1)
      real      wgt(-3:+4,0:ndiv)                         
      integer   jleft(0:nsamp-1)
      integer   jdiv(0:nsamp-1)
      integer   firstsamp,lastsamp
      logical   linear
c
      xt=abs(x)/dt
      xt2=xt**2

c___________________________________________________________________
c     apply velocity reduction above the first nmo curve.
c     don't linearly push or pull data beyond the end of the trace.
c___________________________________________________________________
      treduce=xt/v0*factor+tstatic
      jreduce=treduce
      firstsamp=max(3-jreduce,minsamp)
      lastsamp=min(0,nsamp-1-jreduce-4)
      idiv=nint(adiv*(treduce-jreduce))
c
      do 5000 i=minsamp,firstsamp-1
       uout(i)=0.
5000  continue
c
      do 10000 i=firstsamp,lastsamp
       ileft=i+jreduce
       uout(i)= wgt(-3,idiv)*uin(ileft-3)
     1         +wgt(-2,idiv)*uin(ileft-2)
     1         +wgt(-1,idiv)*uin(ileft-1)
     2         +wgt( 0,idiv)*uin(ileft  )
     3         +wgt(+1,idiv)*uin(ileft+1)
     4         +wgt(+2,idiv)*uin(ileft+2)
     5         +wgt(+3,idiv)*uin(ileft+3)
     5         +wgt(+4,idiv)*uin(ileft+4)
10000 continue
      if(linear) then
c___________________________________________________________________
c        calculate linear moveout, tnmo, at each sample:
c___________________________________________________________________
         do 21000 i=0,nsamp-1
          dtnmo=xt*slow(i)
          tnmo(i)=t0(i)+factor*dtnmo+tstatic
          jleft(i)=tnmo(i)
          jdiv(i)=nint(adiv*(tnmo(i)-jleft(i)))
21000    continue
      else       
c___________________________________________________________________
c        calculate 'normal' hyperbolic moveout, tnmo, at each sample:
c___________________________________________________________________
         do 22000 i=0,nsamp-1
          dtnmo=sqrt(t02(i)+xt2*slow2(i))-t0(i)
          tnmo(i)=t0(i)+factor*dtnmo+tstatic
          jleft(i)=tnmo(i)
          jdiv(i)=nint(adiv*(tnmo(i)-jleft(i)))
22000    continue
      endif
C___________________________________________________________________
C     determine the first and last output sample that maps onto the 
c     input data limits.
C___________________________________________________________________
      do 30000 i=nsamp-1,0,-1
       if(jleft(i)+4    .le. (nsamp-1) ) then
          lastsamp=i
          go to 30001
       endif
30000 continue
30001 continue
      do 35000 i=0,nsamp-1,+1
       if(jleft(i)-3    .ge. 1) then
          firstsamp=i
          go to 35001
       endif
35000 continue
35001 continue
C___________________________________________________________________
C     interpolate
C___________________________________________________________________
      do 40000 i=firstsamp,lastsamp      
       ileft=jleft(i)   
       idiv =jdiv(i)
       uout(i)= wgt(-3,idiv)*uin(ileft-3)
     1         +wgt(-2,idiv)*uin(ileft-2)
     1         +wgt(-1,idiv)*uin(ileft-1)
     2         +wgt( 0,idiv)*uin(ileft  )
     3         +wgt(+1,idiv)*uin(ileft+1)
     4         +wgt(+2,idiv)*uin(ileft+2)
     5         +wgt(+3,idiv)*uin(ileft+3)
     5         +wgt(+4,idiv)*uin(ileft+4)
40000 continue
c
      do 50000 i=lastsamp+1,nsamp-1
       uout(i)=0.
50000 continue
      return
      end
