C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nmor(uin,uout,dt,minsamp,nsamporig, 
     1                x,v0,slow,slow2,t0,t02,tnmo,tstatic,factor,
     2                t0irreg,wgt,ndiv,adiv,bot2top,top2bot,
     3                jleft,jdiv,linear)
c___________________________________________________________________
C     routine to apply normal moveout correction
c___________________________________________________________________
c     uin    = input data.
c     uout   = output (nmo corrected) data.                         
c     dt     = sample interval
c     v0     = reduction velocity
c     minsamp= 1st sample
c     nsamporig  = last sample
c     x      = distance/offset
c
c     dtnmo  = sqrt(t0**2+(x/v)**2)-t0
c     tnmo   = t0+factor*dtnmo                            
c___________________________________________________________________
      real      slow(0:nsamporig-1)
      real      slow2(0:nsamporig-1)
      real      t0(0:nsamporig-1), t02(0:nsamporig-1)
      real      tnmo(0:nsamporig-1)
c
      real      t0irreg(0:nsamporig-1)
      real      uin(minsamp-1:nsamporig-1), uout(0:nsamporig-1)
      real      wgt(-3:+4,0:ndiv)                         
      integer   jleft(0:nsamporig-1),jdiv(0:nsamporig-1)
      integer   firstsamp,lastsamp
      logical   top2bot, bot2top
      logical   linear             
c
      xt=abs(x)/dt
      xt2=xt**2
c
      call vclr(uout(0),1,nsamporig)
c___________________________________________________________________
c     apply velocity reduction above the first nmo curve.
c     don't linearly push or pull data beyond the end of the trace.
c___________________________________________________________________
      treduce=-(xt/v0*factor+tstatic)
      jreduce=treduce-1.
      firstsamp=max(minsamp-jreduce+2,0)          
      lastsamp=min(nsamporig-1,-jreduce+3)
      idiv=nint(adiv*(treduce-jreduce))
c
      do 10000 i=firstsamp,lastsamp
       ileft=i+jreduce
       uout(i)= wgt(-3,idiv)*uin(ileft-3)
     1         +wgt(-2,idiv)*uin(ileft-2)
     1         +wgt(-1,idiv)*uin(ileft-1)
     2         +wgt( 0,idiv)*uin(ileft  )
     3         +wgt(+1,idiv)*uin(ileft+1)
     4         +wgt(+2,idiv)*uin(ileft+2)
     5         +wgt(+3,idiv)*uin(ileft+3)
     5         +wgt(+4,idiv)*uin(ileft+4)
10000 continue
      ibegin=firstsamp
      ilast=lastsamp
      if(linear) then
c___________________________________________________________________
c        calculate linear moveout at each sample.
c___________________________________________________________________
         do 21000 i=0,nsamporig-1
          dtnmo=xt*slow(i)
          tnmo(i)=t0(i)+factor*dtnmo+tstatic
21000    continue
      else
c___________________________________________________________________
c        calculate 'normal' hyperbolic moveout, tnmo at each sample.   
c___________________________________________________________________
         do 22000 i=0,nsamporig-1
          dtnmo=sqrt(t02(i)+xt2*slow2(i))-t0(i)
          tnmo(i)=t0(i)+factor*dtnmo+tstatic
22000    continue
      endif
c__________________________________________________________________
c     interpolate irregular value of t0 from regular values of tnmo.
c__________________________________________________________________
      firstsamp=nint(xt/v0*factor+tstatic)
      if(bot2top) then
c__________________________________________________________________
c        map from bottom to top, overwriting previous values of t0irreg.
c__________________________________________________________________
         do 21001 i=nsamporig-1,1,-1   
          j1=tnmo(i-1)+.99999
          j2=tnmo(i)
          del=tnmo(i)-tnmo(i-1)
          if(del .eq. 0.) then
             t0irreg(j1)=t0(i-1)         
          else 
             do 20501 j=j1,j2
              t0irreg(j)=t0(i-1)+(j-tnmo(i-1))/del
20501        continue
          endif
21001    continue
21011    continue
      elseif(top2bot) then
c__________________________________________________________________
c        map from top to bottom, overwriting previous values of t0irreg.
c__________________________________________________________________
         do 21002 i=1,nsamporig-1      
          j1=tnmo(i-1)+.99999
          j2=tnmo(i)
          del=tnmo(i)-tnmo(i-1)
          if(del .eq. 0.) then
             t0irreg(j1)=t0(i-1)         
          else 
             do 20502 j=j1,j2
              t0irreg(j)=t0(i-1)+(j-tnmo(i-1))/del
20502        continue
          endif
21002    continue
21012    continue
      else        
c__________________________________________________________________
c        implicitly mute (truncate) multivalued mappings.               
c____ ______________________________________________________________
         do 21003 i=nsamporig-1,1,-1    
          j1=tnmo(i-1)+.99999
          j2=tnmo(i)
          del=tnmo(i)-tnmo(i-1)
          if(del .le. 0.) then 
             firstsamp=max(firstsamp,j2)
             go to 21013
          endif
          do 20503 j=j1,j2
           t0irreg(j)=t0(i-1)+(j-tnmo(i-1))/del   
20503     continue
21003    continue
21013    continue
      endif
c
      do 23000 j=firstsamp,nsamporig-1
       jleft(j)=t0irreg(j)
       jdiv(j)=nint(adiv*(t0irreg(j)-jleft(j)))
23000 continue
C___________________________________________________________________
C       determine the first and last output sample that maps onto the
c       input data limits.
C___________________________________________________________________
        do 30000 j=nsamporig-1,0,-1
         if(jleft(j)+4 .le. ( nsamporig - 1 )) then
            lastsamp=j
            go to 30001
         endif
30000   continue
30001   continue
        do 35000 j=firstsamp,nsamporig-1,+1
         if(jleft(j)-3 .ge. minsamp-1) then
            firstsamp=j
            go to 35001
         endif
35000   continue
35001   continue
C___________________________________________________________________
C       interpolate the data.                   
C___________________________________________________________________
        do 28002 j=lastsamp,firstsamp,-1 
         ileft=jleft(j)  
         idiv=jdiv(j)                         
         uout(j)= wgt(-3,idiv)*uin(ileft-3)
     1           +wgt(-2,idiv)*uin(ileft-2)
     1           +wgt(-1,idiv)*uin(ileft-1)
     2           +wgt( 0,idiv)*uin(ileft  )
     3           +wgt(+1,idiv)*uin(ileft+1)
     4           +wgt(+2,idiv)*uin(ileft+2)
     5           +wgt(+3,idiv)*uin(ileft+3)
     5           +wgt(+4,idiv)*uin(ileft+4)
28002   continue
c
      return
      end
