C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine CalcWeights( CDP_X, CDP_Y, Neighbor_X, Neighbor_Y, dx, 
     :     dy, Weight )

c declare variables passed from calling routine

      real CDP_X, CDP_Y, Neighbor_X(4), Neighbor_Y(4), dx, dy
      real Weight(4)

c declare local variables

      real offset(4), max_offset, diagonal
      real pi, sum


c initialize variables

      do i = 1,4
         offset(i) = 0.
      enddo
      pi =  4. * atan(1.0)
      sum = 0.0

      diagonal = sqrt ( dx**2 + dy**2 )
      
      do i = 1, 4

         offset(i) = sqrt( ( Neighbor_X(i) - CDP_X )**2 + 
     :        ( Neighbor_Y(i) - CDP_Y )**2 )

         if ( i .gt. 1 ) then
            if ( offset(i) .gt. offset(i-1) ) max_offset = offset(i)
         else
            max_offset = offset(i)
         endif

      enddo

      if ( max_offset .gt. diagonal ) diagonal = max_offset + diagonal

c set diagonal to twice the furthest distance so that we weight using
c a minimum contribution of half to cosine weighting curve.  This results
c in a little more smoothing but prevents furthest trace from contributing
c nothing.  In most cases [probably all cases] this gives a nice result.
c If you don't like this approach then put a command line parameter in to
c control the smoothing.  The end members will be a simple average one
c on side and the following statement commented out on the other

      diagonal = 2. * diagonal

      do i = 1, 4
         call CosTaper ( offset(i), 0.0, diagonal, weight(i), pi, 1 )
         sum = sum + weight(i)
      enddo

c normalize

      do i = 1, 4
         weight(i) = weight(i) / sum
      enddo

      return
      end
