C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                       
C     SUBROUTINE NAME: Transform_Init  (INITIALIZATION)                          
C                                                                       
C     ABSTRACT: COMPUTE THE CONSTANTS NEEDED TO PERFORM THE FOLLOWING   
C               TRANSFORMATION OF A PARALLELOGRAM TO A RECTANGLE:       
C                 1- MAP CORNER 1 ONTO ORIGIN                           
C                 2- MAP CORNER 2 ONTO POSITIVE Y-AXIS                  
C                 3- MAP CORNER 3 ONTO QUADRANT 1                       
C                 4- MAP CORNER 4 ONTO POSITIVE X-AXIS                  
C                                                                       
C     CALLING SEQUENCE: CALL Transform_Init  (IX1, IY1, IX2, IY2, IX3, IY3,       
C                                   IX4, IY4, DY , DX , NX , NY , XX, XY, YX, 
C                                   YY, XXT, XYT, YXT, YYT       
C
C                WHERE: IX1 - X-COORDINATE OF CORNER 1                  
C                       IY1 - Y-COORDINATE OF CORNER 1                  
C                       IX2 - X-COORDINATE OF CORNER 2                  
C                       IY2 - Y-COORDINATE OF CORNER 2                  
C                       IX3 - X-COORDINATE OF CORNER 3                  
C                       IY3 - Y-COORDINATE OF CORNER 3                  
C                       IX4 - X-COORDINATE OF CORNER 4                  
C                       IY4 - Y-COORDINATE OF CORNER 4                  
C                       DY  - CELL DIMENSION  ALONG SIDE 1-2            
C                       DX  - CELL DIMENSION  ALONG SIDE 2-3            
C                       NX  - NUMBER OF CELLS ALONG SIDE 2-3            
C                       NY  - NUMBER OF CELLS ALONG SIDE 1-2            
C                                                                       
C***********************************************************************

      subroutine Transform_Init ( ix1, iy1, ix2, iy2, ix3, iy3, ix4, 
     :     iy4, dy, dx, nx, ny, XX, XY, YX, YY, XXT, XYT, YXT, YYT )

c declare variables passed from calling routine

      integer ix1, iy1, ix2, iy2, ix3, iy3, ix4, iy4, nx, ny

      real dx, dy

      REAL*8 XX, XY, YX, YY, XXT, XYT, YXT, YYT

c declare local variables 

      integer ISIGN

      real*8 X_41, Y_41, X_21, Y_21, Diagonal_41

      REAL*8 X, Y
      REAL*8 COS0, SIN0, SCOS0, SSIN0                           
      REAL*8 TANPHI, DYCPHI, CPHI 

C-----------------------------------------------------------------------
C                                                                       
C     COMPUTE THE CONSTANTS TO PERFORM THE TRANSFORMATION               
C                                                                       
C-----------------------------------------------------------------------

c      COS0 = dble(IX4 - IX1)                                    
      X_41 = dble(float(ix4 - ix1))
                                    
c      SIN0 = dble(IY4 - IY1)                                    
      Y_41 = dble(float(iy4 - iy1)) 
                                   
c      P41L = COS0 * COS0 + SIN0 * SIN0                   
      Diagonal_41 = X_41**2 + Y_41**2

c      XX = dble(IX2 - IX1)                                    
      X_21 = dble(float(ix2 - ix1))
                                    
c      YY = dble(IY2 - IY1)                                    
      Y_21 = dble(float(iy2 - iy1))

c      P41L = DSQRT(P41L)
      Diagonal_41 = DSQRT(Diagonal_41)

c      COS0 = COS0 / P41L
      COS0 = X_41 / Diagonal_41

c      SIN0 = SIN0 / P41L
      SIN0 = Y_41 / Diagonal_41

      ISIGN =  1

c      IF ( (XX * SIN0) .gt. (YY * COS0) ) ISIGN = -1
      IF ( (X_21 * SIN0) .gt. (Y_21 * COS0) ) ISIGN = -1

      SCOS0 = dble(float(ISIGN)) * COS0
      SSIN0 = dble(float(ISIGN)) * SIN0

c      X = YY * SIN0 + XX * COS0
      X = Y_21 * SIN0 + X_21 * COS0

c      Y = YY * SCOS0 - XX * SSIN0
      Y = Y_21 * SCOS0 - X_21 * SSIN0

      TANPHI = X / Y
      CPHI = DABS(Y) / DSQRT(X*X + Y*Y)
      DYCPHI = dble(DY) * CPHI

      XXT = COS0 + SSIN0 * TANPHI
      XYT = SIN0 - SCOS0 * TANPHI
      YXT = -SSIN0 / CPHI
      YYT = SCOS0 / CPHI

      XX = XXT / dble(DX)
      XY = XYT / dble(DX)
      YX = -SSIN0 / DYCPHI
      YY = SCOS0 / DYCPHI

C-----------------------------------------------------------------------
C                                                                       
C     COMPUTE THE NUMBER OF IN-LINE CELLS & CROSS-LINE CELLS            
C                                                                       
C-----------------------------------------------------------------------

      X = dble(float(IX4-IX1)) * XX + dble(float(IY4-IY1)) * XY + 
     :     dble(1.)
      NX =  nint ( sngl(X) )
      IF ( X - dble(NX) .LT. dble(0.5) ) NX = NX - 1
      Y = dble(float(IX2-IX1)) * YX  +  dble(float(IY2-IY1)) * YY  + 
     :     dble(1.)
      NY =  nint ( sngl(Y) )
      IF (  Y - dble(NY) .LT. dble(0.5)) NY = NY  - 1

      RETURN                                                            
      END
