C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C
C     SUBROUTINE NAME:  CDPXY  (CDP X,Y COORDINATES)

C     ABSTRACT:  GET CDP COORDINATES AT NEW CDP INTERVAL.
C
C     CALLING SEQUENCE:  CALL CDPXY (SEGXY , NPAIRS, CDPINT,
C                                    CDPX  , CDPY  , NCDPS, ICOUNT )
C
C                WHERE:  SEGXY  - BUFFER CONTAINING (X,Y) COORDINATES
C                                 OF CONTINUOUS SEGMENTS
C                        NPAIRS - NUMBER OF COORDINATE PAIRS IN "SEGXY"
C                        CDPINT - CDP INTERVAL
C                        CDPX   - X-COORDINATE AT NEW CDP INTERVAL
C                        CDPY   - Y-COORDINATE AT NEW CDP INTERVAL
C                        IDONE  - FINISH FLAG
C                                    0 = MORE SEGMENTS TO PROCESS
C                                    1 = ALL SEGMENTS PROCESSED
C
C
      SUBROUTINE CDPXY ( SEGXY, NPAIRS, CDPINT, CDPX, CDPY, nreco, 
     :     idone)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C DECLARATIONS, DEFINITIONS, & INITIALIZATIONS

      integer npairs, icount, NCDPS, idone, nreco

      REAL SEGXY (2,NPAIRS), CDPX, CDPY

      DATA        INDEX/0/

c by invoking save all variables used in this subroutine retain their values
c on the next call.  This makes it easy to just keep calling this routine
c to get the xy positions of all the cdps.

      save
      idone = 0

C FIRST TIME -- FIRST COORDINATE IS FIRST SEGMENT COORDINATE

      IF ( INDEX .NE. 0) GO TO 100
      DIST  = 0.0
      GO TO 300

C DETERMINE IF END OF line SEGMENT

  100 IF ( ICOUNT .GE. NCDPS ) GO TO 200

      GO TO 400

C DETERMINE IF LAST SEGMENT PROCESSED

 200  IF( INDEX+1 .GE. NPAIRS )then
         idone = 1
         GO TO 600
      endif

C COMPUTE PORTION OF CDP INTERVAL AT FIRST SLOPE

      XCHECK = XSUM + DELTAX
      YCHECK = YSUM + DELTAY

      XMORE = XCHECK - SEGXY(1,INDEX+1)
      YMORE = YCHECK - SEGXY(2,INDEX+1)

      DIST = SQRT(XMORE*XMORE + YMORE*YMORE)

C COMPUTE NEW SLOPE FOR NEXT SEGMENT
C COMPUTE DELTA-X & DELTA-Y COORDINATE INCREMENTS

  300 INDEX = INDEX  + 1
      ICOUNT = 0

      X = SEGXY(1,INDEX+1) - SEGXY(1,INDEX)
      Y = SEGXY(2,INDEX+1) - SEGXY(2,INDEX)

      HYPOT = SQRT(X*X + Y*Y)
      NCDPS = (HYPOT - DIST) / CDPINT  + 1
      nreco = nreco + ncdps
      COSINE = X / HYPOT
      SINE = Y / HYPOT

      DISTX  = COSINE * DIST
      DISTY  = SINE   * DIST
      DELTAX = COSINE * CDPINT
      DELTAY = SINE   * CDPINT

      XSUM = SEGXY(1,INDEX)  + DISTX
      YSUM = SEGXY(2,INDEX)  + DISTY

      GO TO 500

C INCREMENT TO NEXT CDP INTERVAL

 400  continue

      XSUM = XSUM + DELTAX
      YSUM = YSUM + DELTAY

C THAT'S ALL --  RETURN TO CALLING ROUTINE WITH NEW CDP COORDINATES

 500  continue
      CDPX = XSUM
      CDPY = YSUM

      ICOUNT = ICOUNT + 1

 600  continue
      RETURN
      END
