C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer     itr  ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum, limin, limax, dimin, dimax
      integer     linind, dphind, isrmx, isrmy
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   ntap * 256, otap * 256, name*6
      logical     verbos, query, xline
      integer     argis
 
c-----
c    we access the header values which can be short or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1) )

      data lbytes / 0 /, nbytes / 0 /, name/'BINXYS'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,x1,y1,dx,dy,
     1            nlii,ndii,xline,verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = ' '
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c     ( getln will assign the last parameter as the unit number if the dataset
c      name is ' ', ie. set up stdin and stdout if no filename are specified )
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of input dataset (rtape reads data into vector "itr")
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'binxys: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)


      if (nlii .eq. 0 .and. ndii .eq. 0) then
          call saver(itr, 'MnLnIn', limin, LINHED)
          call saver(itr, 'MxLnIn', limax, LINHED)
          call saver(itr, 'MnDpIn', dimin, LINHED)
          call saver(itr, 'MxDpIn', dimax, LINHED)
      else
          limin = 1
          limax = nlii
          dimin = 1
          dimax = ndii
      endif
 
      if (limin .le. 0 .OR. limax .le. 0 .OR.
     1    dimin .le. 0 .OR. dimax .le. 0    ) then

          write(LERR,*)'WARNING for binxys:'
          write(LERR,*)'No proper limin, limax, dimin, or dimax'
          write(LERR,*)'values in line header. Will use ',ntrc
          write(LERR,*)'as #DIs and ',nrec,' as # LIs'
          write(LERR,*)'If not acceptable use -nd[] -nl[] cmd line'
          write(LERR,*)'override entries'
          write(LER ,*)'WARNING for binxys:'
          write(LER ,*)'No proper limin, limax, dimin, or dimax'
          write(LER ,*)'values in line header. Will use ',ntrc
          write(LER ,*)'as #DIs and ',nrec,' as # LIs'
          write(LER ,*)'If not acceptable use -nd[] -nl[] cmd line'
          write(LER ,*)'override entries'

             limin = 1
             dimin = 1
             nli   = nrec
             ndi   = ntrc
             limax = nli
             dimax = ndi
      else
          nli = limax - limin + 1
          ndi = dimax - dimin + 1
      endif

c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
      call wrtape ( luout, itr, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  x1,y1,dx,dy,ntap,otap,xline,
     1                  limin,limax,dimin,dimax)
c     end if
 
      dx  = -dx
      dy  = -dy
      dx2 = .5 * dx
      dy2 = .5 * dy
      x1  = x1 + dx2
      y1  = y1 + dy2
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, insert SrRcMX & SrRcMY, write to output file
c-----
 
c-----
c     process desired trace records
c-----
      if (xline) then
          id = 1
          il = 0
      else
          id = 0
          il = 1
      endif

      DO  jj = 1, nrec
 
            do  kk = 1, ntrc
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
 
                  if (xline) then
                     il = il + 1
                     if (il .gt. nli) then
                        il = 1
                        id = id + 1
                     endif
                  else
                     id = id + 1
                     if (id .gt. ndi) then
                        id = 1
                        il = il + 1
                     endif
                  endif

                  dphind = dimin + id -1
                  linind = limin + il -1

                  isrmy  = y1 + (id - 1) * dy
                  isrmx  = x1 + (il - 1) * dx

c------
c     use previously derived pointers to trace header values
c------
                  call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call savew2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                        linind , TRACEHEADER)
                  call savew2(lhed,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                        isrmx  , TRACEHEADER)
                  call savew2(lhed,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                        isrmy  , TRACEHEADER)

                  call wrtape( luout, itr, nbytes)
            enddo
 
      ENDDO
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of binxys, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'end of binxys, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'binxys inserts CDP midpoint XYs into headers of a 3D data set'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute binxys by typing binxys and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)     : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)     : output data file name'
        write(LER,*)' '
        write(LER,*)
     :' -x1[x1]      (default = none) : corner x1 coordinate'
        write(LER,*)
     :' -y1[y1]      (default = none) : corner y1 coordinate'
        write(LER,*)
     :' -dx[dx]      (default = none) : cell x dimension'
        write(LER,*)
     :' -dy[dy]      (default = none) : cell y dimension'
        write(LER,*)
     :' -nl[nl]      (default = Lhdr) : LI survey dimension override'
        write(LER,*)
     :' -nd[nd]      (default = Lhdr) : DI survey dimension override'
        write(LER,*) ' '
        write(LER,*)
     :' -X  include on command line if input data is x-line order'
        write(LER,*)
     :'     (LIs vary fastest; otherwise DIs vary fastest)'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:'
        write(LER,*)
     :'       binxys -N[ntap] -O[otap] -x1[] -y1[] -dx[] -dy[]'
        write(LER,*)
     :'              [ -nl[] -nd[] -X -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,x1,y1,dx,dy,
     1                  nlii,ndii,xline,verbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      real        x1,y1,dx,dy
      logical     verbos, xline
      integer     argis, nlii, ndii

c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program binxys might be invoked in the following way:
 
c     binxys  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into binxys and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argr4 ( '-x1', x1 ,   0.  ,  0.    )
            call argr4 ( '-y1', y1 ,   0.  ,  0.    )
            call argr4 ( '-dx', dx ,   0.  ,  0.    )
            call argr4 ( '-dy', dy ,   0.  ,  0.    )

            call argi4 ( '-nl', nlii ,   0  ,  0    )
            call argi4 ( '-nd', ndii ,   0  ,  0    )

            if (x1 .eq. 0.) then
               write(LERR,*)'Fatal error in binxys:'
               write(LERR,*)'Must enter -x1[] corner coordinate'
               write(LER ,*)'Fatal error in binxys:'
               write(LER ,*)'Must enter -x1[] corner coordinate'
               stop
            endif
            if (y1 .eq. 0.) then
               write(LERR,*)'Fatal error in binxys:'
               write(LERR,*)'Must enter -y1[] corner coordinate'
               write(LER ,*)'Fatal error in binxys:'
               write(LER ,*)'Must enter -y1[] corner coordinate'
               stop
            endif
            if (dx .eq. 0.) then
               write(LERR,*)'Fatal error in binxys:'
               write(LERR,*)'Must enter -dx[] delta coordinate'
               write(LER ,*)'Fatal error in binxys:'
               write(LER ,*)'Must enter -dx[] delta coordinate'
               stop
            endif
            if (dx .eq. 0.) then
               write(LERR,*)'Fatal error in binxys:'
               write(LERR,*)'Must enter -dx[] delta coordinate'
               write(LER ,*)'Fatal error in binxys:'
               write(LER ,*)'Must enter -dx[] delta coordinate'
               stop
            endif


            xline  =   (argis('-X') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  x1,y1,dx,dy,ntap,otap,xline,
     1                  limin,limax,dimin,dimax)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, limin,limax,dimin,dimax
      real        x1, y1, dx, dy
      character   ntap*(*), otap*(*)
      logical     xline
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input min LI       =  ', limin
            write(LERR,*) ' input max LI       =  ', limax
            write(LERR,*) ' input min DI       =  ', dimin
            write(LERR,*) ' input max DI       =  ', dimax
            write(LERR,*)' '
            write(LERR,*) ' corner coordinates =  ',x1,y1,' x1y1'
            write(LERR,*) ' X-cell size        =  ',dx
            write(LERR,*) ' Y-cell size        =  ',dy
            if (xline) then
            write(LERR,*) ' input LIs vary fastest'
            else
            write(LERR,*) ' input DIs vary fastest'
            endif
            write(LERR,*)' '
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
