C***********************************************************************00000010
C                                                                       00000020
C     PROGRAM NAME: DM3D  (DIP MOVEOUT FOR 3D DATA)                     00000030
C                                                                       00000040
C     LANGUAGE: FORTRAN                                                 00000050
C                                                                       00000060
C     AUTHOR: G.MURPHY                                                  00000070
C                                                                       00000080
C     DATE WRITTEN: 07/01/88                                            00000090
C                                                                       00000100
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00000120
C                                                                       00000140
C     ABSTRACT: OUTPUT CDP GATHERS WITH PSUEDO TRACE SPACING.           00000150
C                                                                       00000160
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00000170
C                                                                       00000180
C***********************************************************************00000190
C                                                                       00000200
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      REAL          TC (63), VC (63)
      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      CHARACTER*66  CTITLE
      character     ntap * 256, otap * 256, name*8
      character     vtap * 256, tap1 * 256, mtap * 256
      integer       argis, aliasflag, ampflag, sprdflag, lumute
      logical       verbos, norm, shot, tape, intrp, restart, query
      logical       mute, tdfn, nmoap, agc
      real          XM (SZLNHD), TM (SZLNHD)
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      DATA CTITLE/'                      DIP MOVEOUT FOR 3-D DATA       
     &             '/                                                   
      DATA ICRD   /35/
      DATA lumute /51/
      DATA IBYTES /32256/
      DATA name /'CDPSTK3D'/
      DATA nmoap / .false./
      DATA agc   / .false./

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif

      IPRT = LERR

#include <f77/open.h>
 
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argstr( '-v', vtap, ' ', ' ' )
      call argstr( '-m', mtap, ' ', ' ' )
      call argstr( '-T', tap1, ' ', ' ' )

      tape = .true.
      tdfn = (argis('-tdfn') .gt. 0)
      if (tdfn) tape = .false.
      nmoap  = (argis('-nmoap') .gt. 0)

      if (nmoap) then
         tape = .false.
         tdfn = .false.
      else
         if (.not.tdfn .AND. .not.tape) then
            write(LERR,*)' '
            write(LERR,*)'cdpstk3d: FATAL ERROR in velocity input:'
            write(LERR,*)'Must enter velocity file and opttional'
            write(LERR,*)'flags using -v[vel disk file] and -tdfn if a'
            write(LERR,*)'TDFN velocity file'
            write(LER ,*)' '
            write(LER ,*)'cdpstk3d: FATAL ERROR in velocity input:'
            write(LER ,*)'Must enter velocity file and opttional'
            write(LER ,*)'flags using -v[vel disk file] and -tdfn if a'
            write(LER ,*)'TDFN velocity file'
         endif
      endif

      restart = (argis('-R') .gt. 0)

      call getln(ITAPIN, ntap,'r', 0)

      if (.not. restart) then
         call getln(ITAPOT, otap,'w+', -1)
         call getln(lunrm , tap1,'w+', -1)
      else
         call getln(ITAPOT, otap,'r+', -1)
         call rwd  (ITAPOT)
         call getln(lunrm , tap1,'r+', -1)
         call rwd  (lunrm)
      endif

      if (ITAPOT .lt. 1) then
          write(IPRT,*)' '
          write(IPRT,*)'Fatal error in cdpstk3d:'
          write(IPRT,*)'Cannot pipe out - use named disk file -O[]'
          stop
      endif

      if (tape) then
         call getln (luvel, vtap, 'r', -1)
          if (luvel .lt. 1) then
            write(IPRT,*)' '
            write(IPRT,*)'Fatal error in cdpstk3d:'
            write(IPRT,*)'Cannot pipe into velocity tape input. Must'
            write(IPRT,*)'use named disk file using -v[]'
            stop
          endif
          tape = .true.
      elseif (tdfn) then
         open (unit=ICRD, file = vtap, status='old', iostat=ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'Could not open cdpstk3d velocity card file ',
     1                    vtap
            write(LERR,*)'Check existence'
            stop
         endif
         tape = .false.
      endif

      mute = .false.
      if (mtap(1:1) .ne. ' ') mute = .true.


C *** INITIALIZE PROGRAM

      CALL DMLINE (CTITLE, IPRT,   ITAPIN, ITAPOT, NFOLD,
     &             NREC,   ICC,    IOLEN,  IBYTES, NTRCS,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             RECLEN, NSAMPS, dt, si, nsmpv, siv, tape,
     &             nrecv, intrp, luvel, restart, JHEAD)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** READ 1DM3D CARD AND ONE TDFN FUNCTION

      CALL DMCARD (IPRT,   ICRD,   NTRCS, NFOLD, mtap,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, TC,     VC,    NPAIRS, ANGMIN,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3,
     &             IY3, IX4, IY4,  NTPL,  NLI, NDI,
     &             DIVEXP, TRCSPC, verbos, norm, shot,
     &             aliasflag, ampflag, sprdflag,tape,mute,
     &             lumute, XM,TM, NM, tap1, nmoap, JHEAD,
     &             agc, iwind, agcs)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** PROCESS THE INPUT DATA SET.

      CALL DMTAPE (IPRT,   ITAPIN, ITAPOT, IBYTES, luvel,
     &             IREC,   NREC,   IOREC,  ICC,    IOLEN,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, TC, VC, nsmpv,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, siv,
     &             NSAMPS, IFMT,   SI,     RECLEN, IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, norm, shot, tape,
     &             aliasflag, ampflag, sprdflag, tap1, dt,
     &             nrecv, intrp, restart, divexp, angmin,
     &             mute, XM,TM, NM, lunrm, nmoap, tdfn, JHEAD,
     &             agc, iwind, agcs)

C *** FINISHED -- CLOSE I/O DEVICES

 9999 CONTINUE

      CALL LBCLOS (ITAPIN)
      CALL LBCLOS (ITAPOT)
      if (norm) call lbclos (lunrm)

      CALL CCEXIT (ICC)

      END
