C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stack (trace, stk, tab, wrk1, wrk2, V, nsamps,
     1                  dt, off, ampflag, sprdflag, reverse,
     2                  mute, xm, tm, nm, si, nmoap)

#include <f77/lhdrsz.h>

      real     trace (*), stk (*), wrk1 (*), wrk2 (*)
      real     V (*), tab (*), xm (*), tm (*)
      logical  reverse, mute, nmoap

      if (.not. nmoap) then
         call nmo  (trace, V, wrk1, off, nsamps, dt, wrk2, reverse)
      else
         call vmov (trace, 1, wrk2, 1, nsamps)
      endif

c----
c  option time-distance mute with 48ms ramp
c  as each trace comes in the offset is checked to set where within
c  the spread it lies and the time is linearly interpolated between
c  the 2 straddling distances
c----
      IF (mute) THEN

         imr = ifix (48. / si)
         if (off .lt. xm(1) .OR. off .gt. xm(nm)) then
            tmute = 0
         else
            do  i = 2, nm
                if (off .ge. xm(i-1) .AND. off .le. xm(i)) then
                   s = (tm(i) - tm(i-1)) / (xm(i) - xm(i-1))
                   tmute = tm(i-1) + (off - xm(i-1)) * s
                endif
            enddo
         endif
         im = tmute / si

         if (im .gt. 0 .AND. im .le. nsamps) then
            im2 = im
            im1 = im - imr
            if (im1 .lt. 1) im1 = 1
            imm = im2 - im1 + 1

            do  i = 1, im1
                wrk2 (i) = 0.
            enddo
            do  i = im1+1, im2
                rmp = float(i-im1) / float(imm)
                wrk2 (i) = rmp * wrk2 (i)
            enddo
         endif

      ENDIF

c----
c  take the nmo corrected (and perhaps muted) trace and stack it into
c  whatever was previously in the current bin. For non-zero samples
c  update the normalization vector
c----
      DO  i = 1, nsamps

          add = wrk2 (i)

          stk (i) = stk (i) + add
          if (add .ne. 0.0) tab (i) = tab (i) + 1.0

      ENDDO

      return
      end
