C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c------------
c       .. Fourier transform:  (y,x) --> (ky,kx)
c          2D X-correlation is product in kx,ky
c       .. Fourier transform: (ky,kx) --> (y,x)
c------------

      subroutine corf2d   (Input, nxIN, nyIN, Filter, nxF, nyF,
     :                     work,work1,workc,nffx,nffy,initx,inity,
     :                     lenitabx,lenitaby,lenrtabx,lenrtaby,
     :                     itabx,itaby,rtabx,rtaby,ipwrx,ipwry,
     :                     maxft, lagx, lagy, xcorr, SZSMPD,
     :                     debug,luout1,obytes1,ITHWP1,lhed2)
#include <f77/iounit.h>

      real     Input (nxIN,nyIN), Filter (nxF,nyF)
      real     xcorr (lagx,lagy)
      complex  work  (nffx,nffy)
      complex  work1 (nffx,nffy)
      complex  workc (maxft)
      integer  nxIN, nyIN, nxF, nyF
      integer  lenitabx, lenitaby, lenrtabx, lenrtaby
      integer  itabx (lenitabx), itaby(lenitaby)
      real     rtabx(lenrtabx), rtaby(lenrtaby)
      integer  ipwrx (5), ipwry (5), initx, inity
      integer  luout1,obytes1,ITHWP1,lhed2(*),ierr,iabort,SZSMPD
      real     tmp
      pointer  (wkadr, tmp(1))
      logical  debug
      iabort  = 0
      ierr    = 0

      lagx2 = lagx / 2
      lagy2 = lagy / 2
      nffx2 = nffx / 2
      nffy2 = nffy / 2

      if (debug) then
         item = nffx * SZSMPD
         call galloc (wkadr, item, ierr, iabort)
         if (ierr .ne. 0) then
            write(LER,*)'FATAL ERROR in cross2d debug:'
            write(LER,*)'Cannot alloc memory ',item,' bytes'
            call ccexit (666)
         endif
      endif

c------------
c       .. Fourier transform "Input":  (x,y) --> (Kx,y)
c------------

      DO  j = 1, nyIN

          do  i = 1, maxft
              workc (i) = cmplx (0.0, 0.0)
          enddo
          do  i = 1, nxIN
              workc (i) = cmplx (Input(i,j), 0.)
          enddo

          call cfftm  (workc, 2, nffx, 1, initx, itabx, rtabx, ierr)
          call cfftss (workc, 2, nffx)
          initx = 0

          do  i = 1, nffx
              work (i,j) = workc (i)
          enddo

      ENDDO

c------------
c       .. Fourier transform "Input":  (Kx,y) --> (Kx,Ky)
c------------
      DO  i = 1, nffx

          do  j = 1, maxft
              workc (j) = cmplx (0.0, 0.0)
          enddo
          do  j = 1, nffy
              workc (j) = work (i,j)
          enddo

          call cfftm  (workc, 2, nffy, 1, inity, itaby, rtaby, ierr)
          call cfftss (workc, 2, nffy)
          inity = 0

          do  j = 1, nffy
              work (i,j) = workc (j)
          enddo

      ENDDO


c------------
c       .. Fourier transform "Filter":  (x,y) --> (Kx,y)
c------------
 
      DO  j = 1, nyF
 
          do  i = 1, maxft
              workc (i) = cmplx (0.0, 0.0)
          enddo
          do  i = 1, nxF
              workc (i) = cmplx (Filter(i,j), 0.)
          enddo
 
          call cfftm  (workc, 2, nffx, 1, initx, itabx, rtabx, ierr)
 
          do  i = 1, nffx
              work1 (i,j) = workc (i)
          enddo
 
      ENDDO
 
c------------
c       .. Fourier transform "Filter":  (Kx,y) --> (Kx,Ky)
c------------
      DO  i = 1, nffx
 
          do  j = 1, maxft
              workc (j) = cmplx (0.0, 0.0)
          enddo
          do  j = 1, nffy
              workc (j) = work1 (i,j)
          enddo
 
          call cfftm  (workc, 2, nffy, 1, inity, itaby, rtaby, ierr)

          do  j = 1, nffy
              work1 (i,j) = workc (j)
          enddo
 
      ENDDO

c------------
c       .. Correlation ..
c------------
      do  j = 1, nffy

          do  i = 1, nffx

              work (i,j) = work (i,j) * conjg ( work1 (i,j) )
          enddo
      enddo

c------------
c       .. Fourier transform correlation:  (Kx,Ky) --> (Kx,y)
c------------

      DO  i = 1, nffx

          do  j = 1, maxft
              workc (j) = cmplx (0.0, 0.0)
          enddo
          do  j = 1, nffy
              workc (j) = work (i,j)
          enddo

          call cfftm  (workc, 2, nffy, -1, inity, itaby, rtaby, ierr)

          do  j = 1, nffy
              work (i,j) = workc (j)
          enddo

      ENDDO

c------------
c       .. Fourier transform correlation:  (Kx,y) --> (x,y)
c------------
      

      DO  j = 1, nffy

          do  i = 1, maxft
              workc (i) = cmplx (0.0, 0.0)
          enddo
          do  i = 1, nffx
              workc (i) = work (i,j)
          enddo
 
          call cfftm  (workc, 2, nffx, -1, initx, itabx, rtabx, ierr)
 
          do  i = 1, nffx
              work1 (i,j) = workc (i)
          enddo

      ENDDO

      do  j = 1, lagy
          do  i = 1, lagx
              xcorr (i,j) = 0.
          enddo
      enddo


      if (debug) then
         do j = 1,nffy
            do i =1,nffx
               tmp(i) = real (work1(i,j))
            enddo
            call vmov (tmp,1,lhed2(ITHWP1),1,nffx)
            call wrtape(luout1,lhed2,obytes1)
         enddo
      endif

c----
c   pack output quad 1
c----
      jj = 0
      do  j = lagy2+1, lagy
          ii = 0
          jj = jj + 1
          do  i = lagx2+1, 1, -1
 
              ii = ii + 1
              xcorr (i,lagy-j+1) = real ( work1 (ii,jj) )
          enddo
      enddo
c----
c   pack output quad 4
c----
      jj = 0
      do  j = lagy2+1, lagy
          ii = nffx + 1
          jj = jj + 1
          do  i = lagx2+2, lagx
 
              ii = ii - 1
              xcorr (i,lagy-j+1) = real ( work1 (ii,jj) )
          enddo
      enddo
c----
c   pack output quad 2
c----
      jj = nffy + 1
      do  j = lagy2, 1, -1
          ii = 0
          jj = jj - 1
          do  i = lagx2+1, 1, -1
 
              ii = ii + 1
              xcorr (i,lagy-j+1) = real ( work1 (ii,jj) )
          enddo
      enddo
c----
c   pack output quad 3
c----
      jj = nffy + 1
      do  j = lagy2, 1, -1
          ii = nffx + 1
          jj = jj - 1
          do  i = lagx2+2, lagx
 
              ii = ii - 1
              xcorr (i,lagy-j+1) = real ( work1 (ii,jj) )
          enddo
      enddo

      if (debug) call gfree (wkadr)

      return
      end
