C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c  Program FKKSTRIP : [Kx,Ky] filtering
c  Author: Paul G. A. Garossino [APR:1993]
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c
c usp system variables
c

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c -----
c basic usp variables
c -----

      integer     lhed1( SZLNHD )
      integer     lhed2( SZLNHD )
      integer     nsamp1, nsi1, ntrc1, nrec1, nreco, irs1, ire1
      integer     nsamp2, nsi2, ntrc2, nrec2, nrecc
      integer     luin1, luin2, lbytes, nbytes, luout, obytes
      integer     KK,JJ,argis,irs2,ire2,iform1,iform2
      integer     luout1, obytes1

c -----
c program variables defined with dynamic memory allocation
c -----

      integer     RecordHeaders
      integer     errcd1,errcd2,errcd3,errcd4,errcd5,abort
      integer     itemHeader,itemRecord
      integer     pipe1, pipe2

      complex     WorkSpace, WorkSpace1
      real        TimeSlice, Filter, xcorr
      real        rtabx, rtaby
      integer     itabx, itaby

      pointer     (wkadr1, RecordHeaders(200000))
      pointer     (wkadr2, TimeSlice(200000))
      pointer     (wkadr3, Filter(200000))
      pointer     (wkadr4, WorkSpace(200000))
      pointer     (wkadr5, WorkSpace1(200000))
      pointer     (wkadr6, xcorr(200000))
      pointer     (wkrtabx, rtabx(200000))
      pointer     (wkrtaby, rtaby(200000))
      pointer     (wkitabx, itabx(200000))
      pointer     (wkitaby, itaby(200000))
      pointer     (wkworkc, workc(200000))

c -----
c program variables defined with static memory allocation
c -----

      integer lagx, lagy
      integer ss1, es1, ss2, es2, ns1, ne1, ns2, ne2
      integer ipwrx (4), ipwry (4)

      real    CosTaper

      character   name*7, ntap1*256, otap*256, ntap2*256
      character   dtap * 256

      logical verbos, query, first, debug

c -----
c Initialize Required Variables
c -----

      data name/'CROSS2D'/,abort/0/,luin/1/,lbytes/0/,nbytes/0/
      data pipe1/3/, pipe2/4/
      verbos = .false.
      first  = .false.

c -----
c get online help if necessary
c -----

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)

      if( query ) then
          call help ()
          stop
      endif

c -----
c open printout
c -----

#include <f77/open.h>

c -----
c read program parameters from command line argument string
c -----

      call cmdln (ntap1,ntap2,otap,irs1,ire1,ns1,ne1,ss1,es1,
     1            irs2,ire2,ns2,ne2,ss2,es2,CosTaper,verbos,
     2            lagx, lagy, debug, dtap)
  
c -----
c open input/output datasets
c -----

      if (ntap1(1:1) .eq. ' ') then
         call sisfdfit (luin1, pipe1)
      else
         call getln ( luin1, ntap1, 'r', 0)
      endif
      if (ntap2(1:1) .eq. ' ') then
         call sisfdfit (luin2, pipe2)
      else
         call getln ( luin2, ntap2, 'r', 0)
      endif

      call getln ( luout, otap, 'w', 1)

      if (debug) then
         if (dtap(1:1) .eq. ' ') dtap = 'cross2d_debug'
         call getln ( luout1, dtap, 'w', 1)
      endif

c -----
c read and update line header,
c write line header, save key parameters.
c -----

      lbytes=0

      call rtape  ( luin1, lhed1, lbytes )

      if(lbytes .eq. 0) then
         write(LERR,*)'cross2d: no header read on DSN1 ',ntap1
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call saver(lhed1, 'NumSmp', nsamp1, LINHED)
      call saver(lhed1, 'SmpInt', nsi1  , LINHED)
      call saver(lhed1, 'Format', iform1, LINHED)
      call saver(lhed1, 'NumTrc', ntrc1 , LINHED)
      call saver(lhed1, 'NumRec', nrec1 , LINHED)

      lbytes=0
 
      call rtape  ( luin2, lhed2, lbytes )
 
      if(lbytes .eq. 0) then
         write(LERR,*)'cross2d: no header read on DSN2 ',ntap2
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
 
      call saver(lhed2, 'NumSmp', nsamp2, LINHED)
      call saver(lhed2, 'SmpInt', nsi2  , LINHED)
      call saver(lhed2, 'Format', iform2, LINHED)
      call saver(lhed2, 'NumTrc', ntrc2 , LINHED)
      call saver(lhed2, 'NumRec', nrec2 , LINHED)


      call hlhprt ( lhed2 , lbytes, name, 7, LERR )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)

c -----
c  Check Defaults and validity of command line entries
c  Note: DSN2 is the square data set
c -----

      if (ne1 .eq. 0) ne1 = ntrc1
      ixb = ne1 - ns1 + 1
      if (es1 .eq. 0) es1 = nsamp1
      iyb = es1 - ss1 + 1

      if (ne2 .eq. 0) ne2 = ntrc2
      ixa = ne2 - ns2 + 1
      if (es2 .eq. 0) es2 = nsamp2
      iya = es2 - ss2 + 1

      ixmin = min (ixa,ixb)
      iymin = min (iya,iyb)
      ixmax = max (ixa,ixb)
      iymax = max (iya,iyb)
      nffxmax = ixmax
      nffymax = iymax

      if (lagx .eq. 0) then
          ixmax2 = ixmax / 2
          lagx2  = ixmax2
          lagx   = 2 * ixmax2 + 1
      else
          if (mod(lagx,2) .eq. 0) then
              lagx = lagx + 1
          endif
          lagx2 = lagx / 2
      endif

      if (lagy .eq. 0) then
          iymax2 = iymax / 2
          lagy2  = iymax2
          lagy   = 2 * iymax2 + 1
      else
          if (mod(lagy,2) .eq. 0) then
              lagy = lagy + 1
          endif
          lagy2 = lagy / 2
      endif

      call ncfft (nffxmax, 5, nffx, ipwrx) 
      call ncfft (nffymax, 5, nffy, ipwry) 


      ioxmax = lagx
      ioymax = lagy

         write(LERR,*)' '
         write(LERR,*)'Y Direction Radix Powers:'
         write(LERR,*)(ipwry(ii),ii=1,4)
         write(LERR,*)' '
         write(LERR,*)'X Direction Radix Powers:'
         write(LERR,*)(ipwrx(ii),ii=1,4)
         write(LERR,*)' '

         lenitaby = 2 * nffy + 34
         lenrtaby = 2 * nffy + 13
         lenitabx = 2 * nffx + 34
         lenrtabx = 2 * nffx + 13

      
      if (ire1 .eq. 0) ire1 = nrec1
      nrecc = ire1 - irs1 + 1
      if (ire2 .eq. 0) ire2 = nrec2
      nreco = ire2 - irs2 + 1

      if (nrecc .ne. 1) then

         if (nrecc .ne. nreco) then
          write(LERR,*)' '
          write(LERR,*)'FATAL ERROR in cross2d:'
          write(LERR,*)'Number of records selected from DSN2 = ',nreco
          write(LERR,*)'must be same as # selected from DSN1 = ',nrecc
          stop
         endif
      endif

c -----
c  update historical line header & output header
c -----
      call savew (lhed2, 'NumSmp' , ioymax, LINHED)
      call savew (lhed2, 'NumTrc' , ioxmax, LINHED)
      call savew (lhed2, 'NumRec' , nreco , LINHED)

      nsampo = ioymax
      ntrco  = ioxmax
      obytes = SZTRHD + SZSMPD * ioymax

      call savhlh ( lhed2, lbytes, lbyout )
      call wrtape(luout, lhed2, lbyout)

      if (debug) then
         obytes1 = SZTRHD + SZSMPD * nffy
         call savew (lhed2, 'NumSmp' , nffy, LINHED)
         call savew (lhed2, 'NumTrc' , nffx, LINHED)
         call wrtape(luout1, lhed2, lbyout)
      endif

c -----
c  echo input parameters to printout
c -----

      call verbal(irs1,ire1,nsamp1,ntrc1,nsi1,nsamp2,ntrc2,nsi2,
     :     ioxmax, ioymax, ntap1,ntap2,otap,nffx,nffy,
     :     CosTaper,verbos,ns1,ne1,ss1,es1,ns2,ne2,ss2,es2,
     :     ixa, iya, ixb, iyb, irs2, ire2, lagx, lagy)

c -----
c  Dynamic Memory Allocation
c  note : SZSMPD is the native
c  size of a float or int in bytes
c -----

      itemHeader = ntrc2 * ITRWRD * SZSMPD
      itemFilter = ixb * iyb * SZSMPD
      itemRecord = ixa * iya * SZSMPD
      itemwork   = 2 * nffx * nffy * SZSMPD
      itemxcorr  = lagx * lagy * SZSMPD
      itemmax    = 2 * max(nffx,nffy)
      nffmax     = max(nffx,nffy)

      call galloc (wkadr1, itemHeader, errcd1, abort)
      call galloc (wkadr2, itemRecord, errcd2, abort)
      call galloc (wkadr3, itemFilter, errcd3, abort)
      call galloc (wkadr4, itemwork  , errcd4, abort)
      call galloc (wkadr5, itemwork  , errcd5, abort)
      call galloc (wkadr6, itemxcorr , errcd6, abort)
      call galloc (wkitabx, lenitabx*SZSMPD  , errcd5, abort)
      call galloc (wkitaby, lenitaby*SZSMPD  , errcd5, abort)
      call galloc (wkrtabx, lenrtabx*SZSMPD  , errcd5, abort)
      call galloc (wkrtaby, lenrtaby*SZSMPD  , errcd5, abort)
      call galloc (wkworkc, itemmax  , errcd5, abort)
 
      if (errcd1.ne.0 .or. errcd2.ne.0 .or. errcd3.ne.0
     :    .or. errcd4.ne.0 .or. errcd5.ne.0 .or. errcd6.ne.0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) itemRecord,'  bytes'
         write(LERR,*) itemFilter,'  bytes'
         write(LERR,*) 2*itemwork  ,'  bytes'
         write(LERR,*) itemxcorr  ,'  bytes'
         write(LERR,*) itemmax  ,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemHeader,' bytes'
         write(LER ,*) itemRecord,'  bytes'
         write(LER ,*) itemFilter,'  bytes'
         write(LER ,*) 2*itemwork  ,'  bytes'
         write(LER ,*) itemxcorr  ,'  bytes'
         write(LER ,*) itemmax  ,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) itemRecord,'  bytes'
         write(LERR,*) itemFilter,'  bytes'
         write(LERR,*) 2*itemwork  ,'  bytes'
         write(LERR,*) itemxcorr  ,'  bytes'
         write(LERR,*) itemmax  ,'  bytes'
         write(LERR,*)' '
      endif

c -----
c Build Filter
c -----

      
      CosTaper = CosTaper/100.

           initt = 1
           initx = 1


c -----
c Skip Down to User Defined Start Time Slice
c -----

      call recskp(1,irs1-1,luin1,ntrc1,lhed1)
      call recskp(1,irs2-1,luin2,ntrc2,lhed2)

c -----
c Process Data 
c -----
      irec = 0
      initx = 1
      inity = 1

      DO 1000 JJ = irs2,ire2

         irec = irec + 1

         call vclr (TimeSlice , 1, ixa*iya)

c -----
c Load Record from DSN 2 (A - data set)
c ----- 
         if (.not.first)
     1   call trcskp(jj,1,ns1-1,luin1,ntrc1,lhed1)
         call trcskp(jj,1,ns2-1,luin2,ntrc2,lhed2)

         ic = 0
         DO 1001 KK = ns2, ne2

            nbytes = 0
            call rtape( luin2, lhed2, nbytes)

            if(nbytes .eq. 0) then
               write(LERR,*)'Unexpected End Of File on input:'
               write(LERR,*)'at rec= ',jj,'  trace= ',kk
               go to 999
            endif
            ic = ic + 1

c -----
c     advance array indices for this trace
c -----
            ishdr = (ic-1) * ITRWRD + 1
            ipntr = (ic-1) * iya + 1

c -----
c load headers 
c -----

            call vmov (lhed2,1,RecordHeaders(ishdr),1,ITRWRD)

c -----
c load time series 
c -----

            call vmov(lhed2(ITHWP1+ss2-1),1,TimeSlice(ipntr),1,iya)

 1001    CONTINUE

c -----
c Load Record from DSN 1: Filter (B data set)
c -----
         IF ( .not. first ) THEN

            call trcskp(jj,1,ns1-1,luin1,ntrc1,lhed1)
 
            ic = 0
            DO 1011 KK = ns1, ne1
 
               nbytes = 0
               call rtape( luin1, lhed1, nbytes)
 
               if(nbytes .eq. 0) then
                  write(LERR,*)'Unexpected End Of File on input:'
                  write(LERR,*)'at rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               ic = ic + 1
 
c -----
c     advance array indices for this trace
c -----
               ipntr = (ic-1) * iyb + 1
 
c -----
c load time series
c -----
 
               call vmov(lhed1(ITHWP1+ss1-1),1,Filter(ipntr),1,iyb)
                                                              
 1011       CONTINUE


         ENDIF
 

c -----
c X-Correlate Time Slices
c -----

            call FKKFilter(TimeSlice,iya,ixa,Filter,iyb,ixb,
     :                     WorkSpace,WorkSpace1,workc,nffx,nffy,
     :                     lenitabx,lenitaby,lenrtabx,lenrtaby,
     :                     itabx,itaby,rtabx,rtaby,ipwrx,ipwry,
     :                     initx,inity,nffmax,lagy,lagx,
     :                     first, irec, CosTaper,xcorr,SZSMPD,
     :                     debug,luout1,obytes1,ITHWP1,lhed2)

            if (nrecc .eq. 1) first = .true.
c -----
c Output Record
c -----

         DO 1002 KK = 1, lagx

c -----
c restore header
c -----
            ishdr = (KK-1) * ITRWRD + 1
            ipntr = (KK-1) * lagy + 1

            call vmov (RecordHeaders(ishdr),1,lhed2,1,ITRWRD)

            call savew2(lhed2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  KK, TRACEHEADER)
c ------
c load filtered trace to output time series array
c -----

            call vmov(xcorr(ipntr),1,lhed2(ITHWP1),1,lagy)

            call wrtape(luout,lhed2,obytes)

 1002    CONTINUE

 1000 CONTINUE

 999  continue

      call lbclos ( luin1 )
      call lbclos ( luin2 )
      call lbclos ( luout )
      if (debug) call lbclos ( luout1)

      write(LERR,*)'cross2d: processed ',nreco,' record(s) with ',ntrco,
     1             ' traces'
      write(LER ,*)'cross2d: processed ',nreco,' record(s) with ',ntrco,
     1             ' traces'

      stop
      end
      



 
