C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c **********************************************************************
c
c program dbvec: vector database generation for 3D datasets.  The program
c                builds a vectors for inline, crossline, shot station,
c                group station, offset locations.  This routine is used
c                in connection with edit3d which accesses the dbvec 
c                database to feed up data from the included files in any
c                form specified by the user.  
c
c                The code is based loosely on the sr3d package [Ruckgaber
c                et al.] and is developed by Don Wagner and Marilyn Miller.
c
c Changes:
c
c     March 26, 1998 [Garossino] added command line options -hwshot and
c                    -hwgroup to allow the user to associate shot and 
c                    group station indexing with any header word of choice.
c                    Also added logic to allow use of any type of header
c                    format [Float, int etc.].
c
c **********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

        integer SeqTr, CellN, LiInd, DiInd,
     :          Offst,
     :          PartN, PNSeq
	integer ShSta, RcSta

	integer nrec(100), ntrc(100), luin(100)

cmam...set up for vectors to hold the database
        pointer (memadr_SeqTr,SeqTr(200000))
        pointer (memadr_PartN,PartN(200000))
        pointer (memadr_PNSeq,PNSeq(200000))
        pointer (memadr_CellN,CellN(200000))
        pointer (memadr_Offst,Offst(200000))
	pointer (memadr_kcell,kcell(200000))
	pointer (memadr_jcell,jcell(200000))
	pointer (memadr_junk1,junk1(200000))
	pointer (memadr_junk2,junk2(200000))
cmam.....added to be able to retrieve by receiver stations
	pointer (memadr_ShSta,ShSta(200000))
	pointer (memadr_RcSta,RcSta(200000))

cmam......from xform subroutine in pr3d
      DOUBLE PRECISION   P41L
      DOUBLE PRECISION   COS0  , SIN0  , SCOS0 , SSIN0
      DOUBLE PRECISION   TANPHI, DYCPHI, CPHI
      DOUBLE PRECISION   X , Y , XX, XY, YX, YY
      DOUBLE PRECISION       XXT   , XYT   , YXT , YYT
      DOUBLE PRECISION   DE,DF
      DOUBLE PRECISION aval, bval

      INTEGER   DATA4(4564)
      integer   argis, intbin
      integer   dindexx, dindexy, lupik
      integer      srptxmax, srptxmin, srptymax, srptymin
      integer      rcptxmax, rcptxmin, rcptymax, rcptymin
      integer      srrcxmax, srrcxmin, srrcymax, srrcymin
cmam  integer      cdpbxmax, cdpbxmin, cdpbymax, cdpbymin
      integer      dismax, dismin
      integer minli, maxli, mindi, maxdi
      integer cellct

      real      ndx, ndy

      character ntap(100) * 256 , otap * 256
      character*4 SR3D, name*5

C
      INTEGER   DATA2(9128)


      INTEGER   idist (SZLNHD), iangs (SZLNHD)
      REAL      spread (SZLNHD), angs (SZLNHD)

C
      INTEGER   LINE1 , LININC, DI1   , DIINCR
      INTEGER   lugrp, luang
      integer  ifmt_RecNum, l_RecNum, ln_RecNum
      integer  ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC
      integer  ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC
      integer  ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC
      integer  ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC
      integer  ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl
      integer  ifmt_GrpElv,l_GrpElv,ln_GrpElv
      integer  ifmt_UphlTm,l_UphlTm,ln_UphlTm
      integer  ifmt_ShtDep,l_ShtDep,ln_ShtDep
      integer  ifmt_GrpSta,l_GrpSta,ln_GrpSta,GrpSta
      integer  ifmt_ShtSta,l_ShtSta,ln_ShtSta,ShtSta
cmam...added 11-12-98
      integer  ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX
      integer  ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY

      real r_GrpSta, r_ShtSta

      character c_GrpSta*6, c_ShtSta*6


      LOGICAL   heap, line, verbos
      LOGICAL   xline, off, azm, rots
      logical append
cmam....added 11-12-98
      logical stack

C
      CHARACTER*1 PARR(66)
      CHARACTER*1 LIST(22)
      CHARACTER*1 DASH(19)
      CHARACTER*1 SPACE(17)
C
      EQUIVALENCE (DATA2(1),DATA4(1))

      DATA        PARR    /17*' ','3','-','D',' ','T','R','A','C','E',
     $  ' ','S','O','R','T','I','N','G',' ','(','S','T','E','P',' ','1',
     $  ' ','O','F',' ','2',')',18*' '/
      DATA        LIST    /'(','1','X',',','I','4',',','''',
     $  ' ','|','''',',',' ',' ','I','4',',','''',' ','|','''',')'/
      DATA        DASH    /'(','6','X',',','I','1',',',' ',' ',' ','(',
     $ '''','-','''',')',',','I','1',')'/
      DATA        SPACE    /'(','6','X',',','''','|','''',',',
     $ ' ',' ',' ','X',',','''','|','''',')'/
C
      DATA line/.false./
      DATA CHG/1.0/
      DATA ICC/0/
      DATA SR3D/'DB3D'/
      DATA name/'DB3D'/

      data      srptxmax/-999999999/, srptxmin/999999999/
      data      srptymax/-999999999/, srptymin/999999999/
      data      rcptxmax/-999999999/, rcptxmin/999999999/
      data      rcptymax/-999999999/, rcptymin/999999999/
      data      srrcxmax/-999999999/, srrcxmin/999999999/
      data      srrcymax/-999999999/, srrcymin/999999999/
cmam  data      cdpbxmax/-999999999/, cdpbxmin/999999999/
cmam  data      cdpbymax/-999999999/, cdpbymin/999999999/
      data      dismax  /-999999999/, dismin  /999999999/

	data	minli/999999999/, maxli/-999999999/
	data	mindi/999999999/, maxdi/-999999999/

      data      lupik/41/
      data      lugrp/51/
      data      luang/61/

      maxrec = 0
      pi  = 3.14159265
      deg = 180. / pi

      LUCRD = LUCARD

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or.
     :     argis('-help') .gt. 0 ) then
         call help()
         stop
      endif

#include <f77/open.h>

C-----------------------------------------------------------------------
C
C     WRITE THE BANNER PAGE & OPEN THE INPUT LOGICAL UNIT
C
C-----------------------------------------------------------------------

      CALL GAMOCO (PARR,1,LERR)

cmam.....open all partitions of input dataset to insure integrity of data
        nu = 0
        do i = 1,100
           call argstr ( '-N', ntap(i), ' ', ' ' )
           if (ntap(i) .eq. ' ' ) go to 10
           nu = nu + 1
        enddo
 
   10   continue

      IF (nu .ne. 0) THEN
         do 1 i = 1, nu
            call getln(luin(i),ntap(i),'r',0)
      write(LER,*)'ntap= ',i,ntap(i),luin(i)
          if (luin(i) .eq. 0 .and. i .gt. 1) then
	     write(LERR,*)'You specified -Ndataset and -N"blank";'
	     write(LERR,*)'you must have a dataset name after each'
	     write(LERR,*)'-N you specify.  If you are piping into'
	     write(LERR,*)'dbvec, do not use -N on command line'
	     write(LER ,*)'You specified -Ndataset and -N"blank";'
	     write(LER ,*)'you must have a dataset name after each'
	     write(LER ,*)'-N you specify.  If you are piping into'
	     write(LER ,*)'dbvec, do not use -N on command line'
             stop
          endif
          if(luin(i).eq.0)call sislgbuf( luin(i), 'off' )
1        continue
      ELSE
	  nu = 1
          call getln(luin(1),ntap(1),'r',0)
	  if(luin(1).ne.0) then
	     write(LERR,*)'FATAL ERROR:ntap is blank, luin=',luin(1)
	     write(LER ,*)'FATAL ERROR:ntap is blank, luin=',luin(1)
	     stop
	  endif
          if(luin(1).eq.0)call sislgbuf( luin(1), 'off' )
      ENDIF

      call argstr ('-O', otap, ' ', ' ')

cmam.....open output disk for writing database...MUST be specified
      if (otap .eq. ' ') then

c        luout = LOT
         write(LERR,*)'Must include output database filename:'
         write(LERR,*)'use -O[] cmd line arg and rerun'
         stop

      endif


      verbos  = ( argis( '-V') .gt. 0 )
      append  = ( argis( '-A') .gt. 0 )

cmam....added to get bin x,y's from CDPBCX,CDPBCY instead of computing
cmam          from source/receiver x,y's (Sandrine Aubard:STAT)
      stack = ( argis( '-stk') .gt. 0 )

C-----------------------------------------------------------------------
C
C     READ THE PARAMETERS
C
C-----------------------------------------------------------------------


      call argi4 ('-x1', ix1, -9999999, -9999999)
      call argi4 ('-y1', iy1, -9999999, -9999999)
      
      call argi4 ('-x2', ix2, -9999999, -9999999)
      call argi4 ('-y2', iy2, -9999999, -9999999)
      
      call argi4 ('-x3', ix3, -9999999, -9999999)
      call argi4 ('-y3', iy3, -9999999, -9999999)
      
      call argi4 ('-x4', ix4, -9999999, -9999999)
      call argi4 ('-y4', iy4, -9999999, -9999999)

      call argr4 ('-dx', dx, 0., 0.)
      call argr4 ('-dy', dy, 0., 0.)

      dxl = dx
      dyl = dy

      call argstr ('-hwshot',c_ShtSta,'SoPtNm','SoPtNm')
      call argstr ('-hwgroup',c_GrpSta,'RecInd','RecInd')

      call argr4 ('-dmin', dstmin, 0.0, 0.0)
      call argr4 ('-dmax', dstmax, 0.0, 0.0)
      call argr4 ('-ddel', dstdel, 0.0, 0.0)

cmam....determine whether we can compute distances or not
	if(dstmin.eq.0.0.and.dstmax.eq.0.0.and.dstdel.eq.0.0) then
	 off = .false.
	else
         off = .true.
cmam....move this down to insure we don't try to divide by zero!!!
cmam	endif
 
         dxg  = DSTDEL
         ngrp = (DSTMAX - DSTMIN) / DSTDEL + 1

c-------
c compute spread model
c-------
         ngrp2 = ngrp / 2
         call vfill (0.0, spread, 1, ngrp)
 
         do  j = 1, ngrp
 
             spread (j) = DSTMIN + (j-1) * dxg
             idist (j)  = 0
         enddo
        endif

      call argr4 ('-amin', azmin, 0.0, 0.0)
      call argr4 ('-amax', azmax, 360.0, 360.0)
      call argr4 ('-adel', azdel, 15.0, 15.0)
 
         azm = .true.
 
         nang = (azmax - azmin) / azdel
 
c-------
c compute spread model
c-------
         call vfill (0.0, angs, 1, nang)
 
         do  j = 1, nang
 
             angs (j)  = azmin + (j-1) * azdel
             iangs (j) = 0
         enddo
 
      write(LER,*)' '
      write(LER,*)'x1,x2,x3,x4= ',ix1,ix2,ix3,ix4
      write(LER,*)'y1,y2,y3,y4= ',iy1,iy2,iy3,iy4
      write(LER,*)' '

      if     (ix2 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy2 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                ix4 = ix1 + .5 * dxl * ndx
                ix1 = ix1 - .5 * dxl * ndx
                ix2 = ix3 - .5 * dxl * ndx
                ix3 = ix3 + .5 * dxl * ndx
                iy4 = iy1
                iy2 = iy3

      elseif (ix1 .eq. -9999999 .and. ix3 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy3 .eq. -9999999        ) then

                ix1 = ix2 - .5 * dxl * ndx
                ix2 = ix2 + .5 * dxl * ndx
                ix3 = ix4 + .5 * dxl * ndx
                ix4 = ix4 - .5 * dxl * ndx
                iy1 = iy4
                iy3 = iy2

      elseif (ix3 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy3 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                ix4 = ix1 + .5 * dxl * ndx
                ix1 = ix1 - .5 * dxl * ndx
                ix3 = ix2 + .5 * dxl * ndx
                ix2 = ix2 - .5 * dxl * ndx
                iy4 = iy1
                iy3 = iy2

      elseif (ix1 .eq. -9999999 .and. ix2 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy2 .eq. -9999999        ) then

                ix1 = ix4 - .5 * dxl * ndx
                ix4 = ix4 + .5 * dxl * ndx
                ix2 = ix3 - .5 * dxl * ndx
                ix3 = ix3 + .5 * dxl * ndx
                iy1 = iy4
                iy2 = iy3

      elseif (ix3 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy2 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                ix3 = ix2 + .5 * dxl * ndx
                ix2 = ix2 - .5 * dxl * ndx
                ix4 = ix1 + .5 * dxl * ndx
                ix1 = ix1 - .5 * dxl * ndx
                iy4 = iy1
                iy2 = iy3

      elseif (ix1 .eq. -9999999 .and. ix2 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy3 .eq. -9999999        ) then

                ix2 = ix3 - .5 * dxl * ndx
                ix3 = ix3 + .5 * dxl * ndx
                ix1 = ix4 - .5 * dxl * ndx
                ix4 = ix4 + .5 * dxl * ndx
                iy1 = iy4
                iy3 = iy2


      elseif (ix1 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

                iy1 = iy2 - .5 * dyl * ndy
                iy2 = iy2 + .5 * dyl * ndy
                iy4 = iy3 - .5 * dyl * ndy
                iy3 = iy3 + .5 * dyl * ndy
                ix1 = ix2
                ix4 = ix3

      elseif (ix2 .eq. -9999999 .and. ix3 .eq. -9999999  .AND.
     1        iy2 .eq. -9999999 .and. iy3 .eq. -9999999        ) then

                iy2 = iy1 + .5 * dyl * ndy
                iy1 = iy1 - .5 * dyl * ndy
                iy3 = iy4 + .5 * dyl * ndy
                iy4 = iy4 - .5 * dyl * ndy
                ix2 = ix1
                ix3 = ix4

      elseif (ix1 .eq. -9999999 .and. ix3 .eq. -9999999  .AND.
     1        iy1 .eq. -9999999 .and. iy3 .eq. -9999999  .AND.
     2        ix2 .eq. -9999999 .and. ix4 .eq. -9999999  .AND.
     3        iy2 .eq. -9999999 .and. iy4 .eq. -9999999        ) then

              write(LER,*)'sr3d1: FATAL ERROR'
              write(LER,*)'No coordinates given on command line.'
              write(LER,*)'Rerun with this info.'
              stop

      endif


      write(LER,*)' '
      write(LER ,*)'x1,x2,x3,x4= ',ix1,ix2,ix3,ix4
      write(LER ,*)'y1,y2,y3,y4= ',iy1,iy2,iy3,iy4

      if (ix1 .eq. -9999999) then
         write(LERR,*)'Must supply proper X1 (corner 1) coordinate'
         write(LERR,*)'using -x1[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy1 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y1 (corner 1) coordinate'
         write(LERR,*)'using -y1[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (ix2 .eq. -9999999) then
         write(LERR,*)'Must supply proper X2 (corner 2) coordinate'
         write(LERR,*)'using -x2[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy2 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y2 (corner 2) coordinate'
         write(LERR,*)'using -y2[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (ix3 .eq. -9999999) then
         write(LERR,*)'Must supply proper X3 (corner 3) coordinate'
         write(LERR,*)'using -x3[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy3 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y3 (corner 3) coordinate'
         write(LERR,*)'using -y3[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (ix4 .eq. -9999999) then
         write(LERR,*)'Must supply proper X4 (corner 4) coordinate'
         write(LERR,*)'using -x4[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (iy4 .eq. -9999999) then
         write(LERR,*)'Must supply proper Y4 (corner 4) coordinate'
         write(LERR,*)'using -y4[] cmd line arg -- FATAL'
         go to 4800
      endif

      if (dx .eq. 0.) then
         write(LERR,*)'Must supply proper DX cell dimension using'
         write(LERR,*)'-dx[] cmd line arg -- FATAL'
         go to 4800
      endif
      if (dy .eq. 0.) then
         write(LERR,*)'Must supply proper DY cell dimension using'
         write(LERR,*)'-dy[] cmd line arg -- FATAL'
         go to 4800
      endif

      write(LER ,*)'x1,x2,x3,x4= ',ix1,ix2,ix3,ix4
      write(LER ,*)'y1,y2,y3,y4= ',iy1,iy2,iy3,iy4
      write(LER,*)' '

      icc = 0

      if (off) then
         write(LER ,*)' '
         write(LER ,*)'dmin, dmax, ddel= ',dstmin, dstmax, dstdel
         write(LER ,*)'Number groups= ',ngrp
         write(LER ,*)'Spread:'
         write(LER ,*)(spread(i),i=1,ngrp)
         write(LER ,*)' '
      endif

      if (azm) then
         write(LER ,*)' '
         write(LER ,*)'amin, amax, adel= ',azmin, azmax, azdel
         write(LER ,*)'Number groups= ',nang
         write(LER ,*)'Angle Ranges:'
         write(LER ,*)(angs(i),i=1,nang)
         write(LER ,*)' '
      endif

C
C-----------------------------------------------------------------------
C
C     READ THE INPUT LINE HEADER(S)
C
C-----------------------------------------------------------------------
C
      IBYTES            = 0
      nrect = 0
      do  i = 1, nu
	write(LER,*)'reading lineheader from lu=',luin(i)
          call rtape  ( luin(i), data2, ibytes                  )
          if(ibytes .eq. 0) then
             write(LERR,*)'DB3D: no header read from unit ',
     :                  luin(i)
             write(LERR,*)'FATAL: piped input not allowed'
      ICC               = 100
      GO TO 4900
c            stop
          endif
          call saver(data2, 'NumTrc', ntrc(i) , LINHED)
          call saver(data2, 'NumRec', nrec(i) , LINHED)
          nrect = nrect + nrec(i) * ntrc(i)
	write(LER ,*)'ntap ',i,'  rec=',nrec(i),'  trc=',ntrc(i)
	write(LERR,*)'ntap ',i,'  rec=',nrec(i),'  trc=',ntrc(i)
	call sisabort (luin(i),"off")
      enddo
	write(LER ,*)'Total number of traces on ntap=',nrect
	write(LERR,*)'Total number of traces on ntap=',nrect

C
C-----------------------------------------------------------------------
C
C     UPDATE THE PROCESS HISTORY INFORMATION & START THE ACCOUNTING
C
C-----------------------------------------------------------------------
C
200   continue

      call hlhprt (DATA2, IBYTES, SR3D1, 4, LERR)

cmam--------------------------------------------------------------------
c	if -A (append) option specified, we must read in the old
c	   database, close it, build the vectors, and write out a
c	   new database consisting of the old + new data.
cmam--------------------------------------------------------------------
	if (append) then
cmam		open the database with recl=1 to read first record
		luns = LUDISK
	      ircl = 14 * SZSMPD
cmam	      ircl = 1
              open(luns,file=otap,status='unknown',
     :          access='direct', form = 'unformatted',
     :          recl = ircl, err = 302, iostat = ieropn )
        go to 303
  302   write(LERR,*)'302:error opening database:',ieropn
	write(LERR,*)'    program dbvec is aborting'
        write(LER, *)'302:error opening database:',ieropn
	write(LER, *)'    program dbvec is aborting'
	istop = 302
	go to 4900
  303   continue
        write(LER,*)'database open:',otap
cmam......read no. of vectors, no.of sequential traces, no. live traces,
cmam........min and max li, and min and max di on input dataset
 
        write(LERR,*)'reading rec 1 from database'
        write(LER ,*)'reading rec 1 from database'
cmam    read(luns,rec=1) numvec,nseq,nsize,minli,maxli,mindi,maxdi,
        read(luns,rec=1) numvec,nseg,nsize,minli,maxli,mindi,maxdi,
     :          nlive, ndead, cellct, knx, kny, nxy, mxrsct
	write(LERR,*)'read:CELLCT, nsize =',cellct, nsize
        numli = maxli - minli + 1
        numdi = maxdi - mindi + 1
        write(LERR,*)'read:nsize,minli,maxli,mindi,maxdi,cellct=',
     :          nsize,minli,maxli,mindi,maxdi,cellct
        write(LERR,*)'computed:numli,numdi=',numli,numdi
        write(LER,*)'read:nsize,minli,maxli,mindi,maxdi,cellct=',
     :          nsize,minli,maxli,mindi,maxdi,cellct
        write(LER,*)'computed:numli,numdi=',numli,numdi
        write(LERR,*)'read:nsize,cellct=',nsize,cellct
 
cmam		close database, reopen with correct value for recl
cmam		in order to read the vectors into core
        close(luns)
 
                ircl = nsize * SZSMPD
              open(luns,file=otap,status='unknown',
     :          access='direct', form = 'unformatted',
     :          recl = ircl, err = 304, iostat = ieropn )
        go to 305
  304   write(LERR,*)'304:error opening database:',ieropn
	write(LERR,*)'    program dbvec is aborting'
        write(LER, *)'304:error opening database:',ieropn
	write(LER, *)'    program dbvec is aborting'
	istop = 304
	go to 4900
  305   continue
        write(LER,*)'database open:',otap
        write(LERR,*)'database open:',otap
	endif

      heap = .true.

	if(append) then
		item = (nrect + nsize) * szsmpd
		mrect = nrect + nsize
		ksize = nsize
		maxrec = cellct
	else
      		item  =  nrect * SZSMPD
		mrect = nrect
		ksize = 0
		maxrec = 0
	endif

	write(LERR,*)'allocating vectors:mrect=',mrect,' item=',item
	write(LER ,*)'allocating vectors:mrect=',mrect,' item=',item
      write(LERR,*)'nrect,nsize,szsmpd,item=',nrect,nsize,szsmpd,item

        ierrcd = 1
      call galloc (memadr_SeqTr, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_PartN, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_PNSeq, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_CellN, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_RcSta, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_ShSta, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_Offst, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_junk1, item, errcd, abort)
        if(errcd .ne. 0) go to 100
        ierrcd = ierrcd + 1
      call galloc (memadr_junk2, item, errcd, abort)
        if(errcd .eq. 0) go to 110
 
cmam...........error allocating the vector spaces -- FATAL
  100 continue

         write(LER ,*)' '
         write(LER ,*)'FATAL: Unable to allocate workspace.'
         write(LER ,*)'       Cannot proceed.  Stop.'

	stop
C-----------------------------------------------------------------------
C
C
C-----------------------------------------------------------------------
C
  110 continue
      IF (LINE1 .EQ.0) LINE1  = 1
      IF (LININC.EQ.0) LININC = 1
      IF (DI1   .EQ.0) DI1    = 1
      IF (DIINCR.EQ.0) DIINCR = 1

	write(LERR,*)'vectors allocated; clearing them now'
	write(LER ,*)'vectors allocated; clearing them now'
      write(LERR,*)' clearing:mrect=',mrect
	call vclr (SeqTr,1,mrect )
	call vclr (PartN,1,mrect )
	call vclr (PNSeq,1,mrect )
	call vclr (CellN,1,mrect )
	call vclr (OffSt,1,mrect )
	call vclr (RcSta,1,mrect )
	call vclr (ShSta,1,mrect )
	call vclr (junk1,1,mrect )
	call vclr (junk2,1,mrect )

	write(LERR,*)'vectors cleared'
	write(LER ,*)'vectors cleared'

	if(append) then
	write(LERR,*)'appending to an existing database'
cmam.........read old database vectors into allocated space
		read(luns,rec=2,err=399) (SeqTr(i),i=1,nsize)
	write(LERR,*)'read SeqTr'
		read(luns,rec=3,err=399) (PartN(i),i=1,nsize)
	write(LERR,*)'read PartN'
		read(luns,rec=4,err=399) (PNSeq(i),i=1,nsize)
	write(LERR,*)'read PNSeq'
		read(luns,rec=5,err=399) (CellN(i),i=1,nsize)
	write(LERR,*)'read CellN'
		read(luns,rec=6,err=399) (Offst(i),i=1,nsize)
	write(LERR,*)'read Offst'
		read(luns,rec=7,err=399) (RcSta(i),i=1,nsize)
	write(LERR,*)'read RcSta'
		read(luns,rec=8,err=399) (ShSta(i),i=1,nsize)
	write(LERR,*)'read ShSta'
		read(luns,rec=9,err=399) (junk1(i),i=1,nsize)
cmam		read(luns,rec=9,err=399) (kcell(i),i=1,nsize)
cmam	print *,'read kcell'
	write(LERR,*)'read junk1'
		read(luns,rec=10,err=399) (junk2(i),i=1,nsize)
cmam		read(luns,rec=10,err=399) (jcell(i),i=1,nsize)
cmam	print *,'read jcell'
	write(LERR,*)'read junk2'
cmam.........close the database, reopen it write new data
		close(luns)
	write(LERR,*)'old database closed'
        go to 398
  399   write(LERR,*)'error reading database - terminating job'
        write(LER ,*)'error reading database - terminating job'
        istop = 399
	go to 4900
  398   continue
	endif
      IMULT             = SZHFWD
      write(LERR,*)' '

c-----

C
      IFILL = 0
      IFOLD = 256
C
C-----------------------------------------------------------------------
C
C     ENSURE THAT USER SPECIFIED COORDINATES DEFINE A PARALLELOGRAM
C
C-----------------------------------------------------------------------
C
 1900 COS0              = IX4  - IX1
      SIN0              = IY4  - IY1
      P41L              = COS0 * COS0  +  SIN0 * SIN0
      XX                = IX2  - IX1
      YY                = IY2  - IY1
       X                = P41L + 0.5
       Y                = XX   * XX    +  YY   * YY    + 0.5
      Xs = X
      Ys = Y
      IX = Xs
      IY = Ys
      X1 = IX1
      X2 = IX2
      X3 = IX3
      X4 = IX4
      Y1 = IY1
      Y2 = IY2
      Y3 = IY3
      Y4 = IY4

      write(LER,*)'COS0, SIN0, P41L= ',COS0,SIN0,P41L
      write(LER,*)'XX, YY, IX, IY, X, Y= ',XX,YY,IX,IY,Xs,Ys
      write(LER,*)'x1,x2,x3,x4= ',x1,x2,x3,x4
      write(LER,*)'y1,y2,y3,y4= ',y1,y2,y3,y4
      write(LER,*)'(IX3-IX2)*(IX3-IX2)= ',(X3-X2)*(X3-IX2)
      write(LER,*)'(IY3-IY2)*(IY3-IY2)= ',(Y3-Y2)*(Y3-IY2)
      write(LER,*)'sum = ',(X3-X2)*(X3-X2)+(Y3-Y2)*(Y3-Y2)
      write(LER,*)'(IX4-IX3)*(IX4-IX3)= ',(X4-X3)*(X4-X3)
      write(LER,*)'(IY4-IY3)*(IY4-IY3)= ',(Y4-Y3)*(Y4-Y3)
      write(LER,*)'sum = ',(X4-X3)*(X4-X3)+(Y4-Y3)*(Y4-Y3)
      difx = abs (Xs - (X3-X2)*(X3-X2)-(Y3-Y2)*(Y3-Y2) )
      dify = abs (Ys - (X4-X3)*(X4-X3)-(Y4-Y3)*(Y4-Y3) )
      write(LER,*)'difx, dify= ',difx,dify
      if (difx .le. dx) difx = 0.
      if (dify .le. dy) dify = 0.
C
c     IF (IX.EQ.(IX3-IX2)*(IX3-IX2)+(IY3-IY2)*(IY3-IY2).AND.
c    $    IY.EQ.(IX4-IX3)*(IX4-IX3)+(IY4-IY3)*(IY4-IY3))    GO TO 2100

      IF ( difx .eq. 0. .AND. dify .eq. 0.) GO TO 2100
      WRITE (LER ,2000)
      WRITE (LERR,2000)
 2000 FORMAT ('0** M3009 ** WARNING ISSUED BY PROGRAM DB3D:'/
     $ 13X, 'THE COORDINATES SPECIFIED FOR THE FOUR CORNERS ' /
     $ 13X, 'OF THE GRID DOES NOT DEFINE A PARALLELOGRAM.'/
     $ 13X, 'VERIFY THE COORDINATES ENTERED ON THE COMMAND LINE ')
C
C-----------------------------------------------------------------------
C
C     COMPUTE CONSTANTS NEEDED TO PERFORM THE FOLLOWING TRANSFORMATION
C         1- MAP CORNER 1 ONTO ORIGIN
C         2- MAP CORNER 2 ONTO POSITIVE Y-AXIS
C         3- MAP CORNER 3 ONTO QUADRANT 1
C         4- MAP CORNER 4 ONTO POSITIVE X-AXIS
C
C-----------------------------------------------------------------------
C
2100  CONTINUE

      P41L              = DSQRT(P41L)
      write(LER,*)'P41L= ',P41L,' DX, DY= ',dx,dy
      COS0              = COS0 / P41L
      write(LER,*)'COS0= ',COS0
      SIN0              = SIN0 / P41L
      write(LER,*)'SIN0= ',SIN0
C
      ISGN              = 1
      IF (XX*SIN0.GT.YY*COS0) ISGN = -1
C
      SCOS0             = ISGN * COS0
      SSIN0             = ISGN * SIN0
C
      X                 = YY * SIN0   +  XX * COS0
      Y                 = YY * SCOS0  -  XX * SSIN0
C
      TANPHI            = X / Y
C
      CPHI              =       DABS(Y)  / DSQRT(X*X  + Y*Y)            00001520
      DYCPHI            = DY  * CPHI                                    00001530

C
C                                                                       00001540
      XXT               = (COS0 + SSIN0 * TANPHI)                       00001550
      XYT               = (SIN0 - SCOS0 * TANPHI)                       00001560
      YXT               = -SSIN0        / CPHI                          00001570
      YYT               =  SCOS0        / CPHI                          00001580
C                                                                       00001590
        aval = IX1
        bval = IY1
        DE = aval * XXT + bval * XYT
        DF = aval * YXT + bval * YYT
C                                                                       00001620
      XX                = XXT   / DX                                    00001630
      XY                = XYT   / DX                                    00001640
      YX                =-SSIN0 / DYCPHI                                00001650
      YY                = SCOS0 / DYCPHI                                00001660
C                                                                       00001670
      write(LER,*)'XX, XY, YX, YY= ',XX,XY,YX,YY
C
C-----------------------------------------------------------------------
C
C     COMPUTE THE CELL DIMENSIONS & NUMBER OF CELLS IN THE GRID
C     ERROR CHECK - there is no MAXIMUM NUMBER OF CELLS IN THE GRID
C
C-----------------------------------------------------------------------
C
      X                  = (IX4 - IX1) * XX  +  (IY4 - IY1) * XY  +  1.
      Y                  = (IX2 - IX1) * YX  +  (IY2 - IY1) * YY  +  1.
C
      NX                 = X
      IF (X-NX.LT.0.5) NX = NX - 1
      if (NX .eq. 0)   NX = 1
      NY                 = Y
      IF (Y-NY.LT.0.5) NY = NY - 1
      if (NY .eq. 0)   NY = 1
      NXY                = NX * NY

      write(LERR,*)' '
      write(LERR,*)'Survey Parallelogram Size:'
      write(LERR,*)'X =  ',NX,'  Y =  ',NY,' XX,XY,YX,YY= ',XX,XY,YX,YY
      write(LERR,*)'NX x NY =  ',NX*NY,' cells (LI dimension x DI dimens
     1ion or [2-3] x [1-2])'
      write(LERR,*)'X4-X1 =  ',IX4 - IX1
      write(LERR,*)'X2-X1 =  ',IX2 - IX1
      write(LERR,*)'Y4-Y1 =  ',IY4 - IY1
      write(LERR,*)'Y2-Y1 =  ',IY2 - IY1
      write(LERR,*)' '
      write(LER ,*)' '
      write(LER ,*)'Survey Parallelogram Size:'
      write(LER ,*)'X =  ',NX,'  Y =  ',NY,' XX,XY,YX,YY= ',XX,XY,YX,YY
      write(LER ,*)'NX x NY =  ',NX*NY,' cells (LI dimension x DI dimens
     1ion or [2-3] x [1-2])'
      write(LER ,*)'X4-X1 =  ',IX4 - IX1
      write(LER ,*)'X2-X1 =  ',IX2 - IX1
      write(LER ,*)'Y4-Y1 =  ',IY4 - IY1
      write(LER ,*)'Y2-Y1 =  ',IY2 - IY1
      write(LER ,*)' '


cmam........kcell gives number of traces in the corresponding cell
      heap = .true.

      itemk = (NXY + 2) * SZSMPD
      item  =  NXY + 2 

      write(LERR,*)'alloc itemk=',itemk
      call galloc (memadr_kcell, itemk, errcd, abort)
cmam  call galloc (wkkount, itemk, errcd, abort)

      if (errcd .ne. 0.) heap = .false.

      if (.not.heap) then
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace for kcell:'
         write(LER ,*) itemk,'  bytes'
         write(LER ,*)' '
         go to 4800

      else
         write(LER ,*)' '
         write(LER ,*)'Allocating workspace for kcell:'
         write(LER ,*) itemk,'  bytes'
         write(LER ,*)' '
      endif

		write(LERR,*)'clearing kcell'
      write(LERR,*)' clearing:item=',item
      call vclr (kcell, 1, item)
		write(LERR,*)'kcell cleared'

cmam......jcell gives starting seqtr for each cell
      heap = .true.
 
      call galloc (memadr_jcell, itemk, errcd, abort)
cmam  call galloc (wkkount, itemk, errcd, abort)
 
      if (errcd .ne. 0.) heap = .false.
 
      if (.not.heap) then
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace for jcell:'
         write(LER ,*) itemk,'  bytes'
         write(LER ,*)' '
         go to 4800
 
      else
         write(LER ,*)' '
         write(LER ,*)'Allocating workspace for jcell:'
         write(LER ,*) itemk,'  bytes'
         write(LER ,*)' '
      endif
 
		write(LERR,*)'clearing jcell'
      call vclr (jcell, 1, item)
		write(LERR,*)'jcell cleared'

cmam....if appending, move junk1 to kcell, junk2 to jcell
	if (append) then
	  call vmov (junk1,1,kcell,1,item)
	  call vmov (junk2,1,jcell,1,item)
	write(LERR,*)'moved junk1 to kcell, junk2 to jcell'
	endif

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)

      call savelu('UphlTm',ifmt_UphlTm,l_UphlTm,ln_UphlTm,TRACEHEADER)
      call savelu('ShtDep',ifmt_ShtDep,l_ShtDep,ln_ShtDep,TRACEHEADER)
      call savelu(c_GrpSta,ifmt_GrpSta,l_GrpSta,ln_GrpSta,
     :     TRACEHEADER)
      call savelu(c_ShtSta,ifmt_ShtSta,l_ShtSta,ln_ShtSta,
     :     TRACEHEADER)

cmam...if -stk flag input, setup for using CDPBCX,CDPBCY
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

c      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
c      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
C
C-----------------------------------------------------------------------
C
C     IF ANY PRELIMINARY ERRORS HAVE BEEN FOUND PRIOR TO SPINNING TAPE,
C     TERMINATE THE JOB
C
C-----------------------------------------------------------------------
C
      IF (ICC.EQ.0) GO TO 2350
      IRECP = 0
      GO TO 4800
C
C-----------------------------------------------------------------------
C
C     READ A TRACE FROM THE INPUT DATA SET
C
C-----------------------------------------------------------------------
C
 2350 continue
cmam......define starting index depending on whether we are appending
cmam		new data to an existing database
c
	if(append) then
		il = nsize
		isegn = nseg
	else
      		il = 0
		isegn = 0
	endif


	nlive = 0

cmam........loop on number of input dataset partitions
      do iii = 1,nu

cmam.........increment dataset partition counter, zero trace counter
cmam...............for this partition
	isegn = isegn + 1
	isegct = 0
	maxtrc = nrec(iii) * ntrc(iii)

 2400 IBYTES            = 0
	if(isegct.ge.maxtrc) go to 2500
      CALL RTAPE (luin(iii)  ,DATA4,IBYTES)
	call siserror(luin(iii),kerror)
	if(kerror.gt.0) then
	   write(LERR,*)'read error:lu ',iii,'  error=',kerror,
     :		'  il=',il,'  isegct=',isegct
           write(LERR,*)'read error:lu ',iii,'  error=',kerror,
     :		'  il=',il,'  isegct=',isegct
	   stop 777
	endif
      IF (IBYTES.EQ.0) GO TO 2500

      itrc = itrc + 1
	isegct = isegct + 1

         il = il + 1
	SeqTr(il) = il
cmam......save partition number, and sequential position in this partition
	    PartN(il) = isegn
	    PNSeq(il) = isegct
C
C-----------------------------------------------------------------------
C
C     DETERMINE IN WHICH CELL THE TRACE BELONGS WITHIN GRID DEFINITIONS
C
C-----------------------------------------------------------------------
cmam.........get receiver station number and shot station number
cpgag...... pick up receiver and shot station information from any
c           format header word indicated by the user

            if ( ifmt_GrpSta .eq. SAVE_SHORT_DEF .or.
     :           ifmt_GrpSta .eq. SAVE_LONG_DEF ) then
               call saver2(data4,ifmt_GrpSta,l_GrpSta, ln_GrpSta,
     1              GrpSta  , TRACEHEADER)
               RcSta(il) = GrpSta
            else
               call saver2(data4,ifmt_GrpSta,l_GrpSta, ln_GrpSta,
     1              r_GrpSta  , TRACEHEADER)
               RcSta(il) = nint(r_GrpSta)
            endif

            if ( ifmt_ShtSta .eq. SAVE_SHORT_DEF .or.
     :           ifmt_ShtSta .eq. SAVE_LONG_DEF ) then
               call saver2(data4,ifmt_ShtSta,l_ShtSta, ln_ShtSta,
     1              ShtSta  , TRACEHEADER)
               ShSta(il) = ShtSta
            else
               call saver2(data4,ifmt_ShtSta,l_ShtSta, ln_ShtSta,
     1              r_ShtSta  , TRACEHEADER)
               ShSta(il) = nint(r_ShtSta)
            endif

c-----
c  receiver XYs
c-----
         call saver2(data4,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               ivalrx  , TRACEHEADER)
         call saver2(data4,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               ivalry  , TRACEHEADER)

cmam....	check for missing coordinates, implying dead trace
	   if(ivalrx.eq.0 .and. ivalry.eq.0) then
		idead = idead + 1
		go to 2400
	   endif

cmam........compute min,max x,y as we go along
         if (ivalrx .ge. rcptxmax) rcptxmax = ivalrx
         if (ivalrx .le. rcptxmin .and. ivalrx .ne. 0) 
     :		rcptxmin = ivalrx
         if (ivalry .ge. rcptymax) rcptymax = ivalry
         if (ivalry .le. rcptymin .and. ivalry .ne. 0) 
     :		rcptymin = ivalry



C******************************************************************
c    build stats on max & min coordinates for various src,rcvr,cdps
C-----

c-----
c  shot XYs
c-----
          call saver2(data4,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                ivalsx, TRACEHEADER)
          call saver2(data4,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                ivalsy, TRACEHEADER)

cmam....	check for missing coordinates, implying dead trace
	   if(ivalsx.eq.0 .and. ivalsy.eq.0) then
		idead = idead + 1
		go to 2400
	   endif

cmam........compute min,max x,y as we go along
          if (ivalsx .ge. srptxmax) srptxmax = ivalsx
          if (ivalsx .le. srptxmin .and. ivalsx .ne. 0) 
     :		srptxmin = ivalsx
          if (ivalsy .ge. srptymax) srptymax = ivalsy
          if (ivalsy .le. srptymin .and. ivalsy .ne. 0) 
     :		srptymin = ivalsy

c-----
c  find the pointer into the spread array for the current offset
c-----

	if(off) then
         dxt = ivalsx - ivalrx
         dyt = ivalsy - ivalry
         val = sqrt ( dxt * dxt + dyt * dyt )
         if (val .ge. dismax) dismax = val
         if (val .le. dismin) dismin = val
            dsta = val
            joff = intbin (ngrp, dxg, spread, dsta)
            idist (joff) = idist (joff) + 1
	 Offst(il) = val + 0.5
	endif

c-----
c  midpoint XYs
c-----

cmam....if -stk flag input, get midpoint XYs from CDPBCX,CDPBCY instead
cmam       of computing them

          if (stack) then
              call saver2(data4,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1               jvalrx  , TRACEHEADER)
              call saver2(data4,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1               jvalry  , TRACEHEADER)
              mvalx = float (jvalrx)
              mvaly = float (jvalry)

          else
              mvalx = .5 * float (ivalsx + ivalrx) + 0.5
              mvaly = .5 * float (ivalsy + ivalry) + 0.5
          endif

          if (mvalx .ge. srrcxmax) srrcxmax = mvalx
          if (mvalx .le. srrcxmin .and. mvalx .ne. 0) 
     :		srrcxmin = mvalx
          if (mvaly .ge. srrcymax) srrcymax = mvaly
          if (mvaly .le. srrcymin .and. mvaly .ne. 0) 
     :		srrcymin = mvaly


 2420 continue
C******************************************************************

c-----
c  check for XYs in given grid
c-----
              dindexx = mvalx
              dindexy = mvaly
	icode = 0

      IX = (dindexx - IX1) * XX  +  (dindexy - IY1) * XY + .999999

      IF (IX.LE.0.OR.IX.GT.NX) THEN
	icode = 1
      ENDIF


      IY = (dindexx - IX1) * YX  +  (dindexy - IY1) * YY + .999999

      IF (IY.LE.0.OR.IY.GT.NY) THEN
	icode = 1
      ENDIF

	if(icode.eq.1) then

	 if(verbos) then
	        IF (IX.LE.0.OR.IX.GT.NX)
     :   write(LERR,*)'Trace X-value= ',IX,' out of range: 1-',NX
      IF (IY.LE.0.OR.IY.GT.NY)
     :   write(LERR,*)'Trace Y-value= ',IY,' out of range: 1-',NY
	 endif
         GO TO 2400
	endif

C-----------------------------------------------------------------------
C
cmam..calculate cell number from computed LI,DI values
cmam..will depend on if xline or inline direction requested
C     KEEP COUNT OF LIVE TRACES WITHIN EACH CELL
C
C-----------------------------------------------------------------------
C
      if (xline) then
          IXX               =(IY-1) * NX + IX
	  LiInd = iy
	  DiInd = ix
      else
          IXX               =(IX-1) * NY + IY
	  LiInd = ix
	  DiInd = iy
      endif

	if(LiInd.ne.0 .and. LiInd.lt.minli)
     :		minli = LiInd
	if(LiInd.gt.maxli) maxli = LiInd

	if(DiInd.ne.0 .and. DiInd.lt.mindi)
     :		mindi = DiInd
	if(DiInd.gt.maxdi) maxdi = DiInd

	if(ixx.lt.1.or.ixx.gt.nxy) then
     		write(LERR,*)'IXX,nxy,ix,iy=',ixx,nxy,ix,iy
	else
	   kcell(IXX)        = kcell(IXX)  + 1
	   if (kcell(IXX) .ge. maxrec) maxrec = kcell(IXX)

	endif
	CellN(il) = IXX
	nlive = nlive + 1

C                                                                       00002420
C***********************************************************************00002430
      GO TO 2400
 
cmam....come here on EOF on an input partition..go to next one, or end loop
 2500 CONTINUE
	enddo
	nsize = il
C-----------------------------------------------------------------------
C
C     TRAP THE MAXIMUM FOLD (MAXIMUM "NO. OF TRACES" IN ANY ONE CELL)
C     TRAP THE TOTAL NUMBER OF LIVE TRACES IN THE GRID
C
C-----------------------------------------------------------------------
 
      ntot  = il
      MAX               = maxrec
cmam  MAX               = 0
      NTR               = il
cmam.....  NTR               = 0
 
cmam  write(LERR,*)' '
cmam  write(LERR,*)'NXY,NTR,MAX= ',NXY,NTR,MAX

 2600 CONTINUE

      write(LERR,*)' '
      write(LERR,*)'NXY,NTR,MAX= ',NXY,NTR,MAX
      write(LERR,*)'Total # traces read from input= ',ntot
      write(LERR,*)' '

      write(LERR,*)' '
      write(LERR,*)'Maximum source point X-coordinate    = ',srptxmax
      write(LERR,*)'Minimum source point X-coordinate    = ',srptxmin
      write(LERR,*)'Maximum source point Y-coordinate    = ',srptymax
      write(LERR,*)'Minimum source point Y-coordinate    = ',srptymin
      write(LERR,*)' '
      write(LERR,*)'Maximum receiver point X-coordinate   = ',rcptxmax
      write(LERR,*)'Minimum receiver point X-coordinate   = ',rcptxmin
      write(LERR,*)'Maximum receiver point Y-coordinate   = ',rcptymax
      write(LERR,*)'Minimum receiver point Y-coordinate   = ',rcptymin
      write(LERR,*)' '
      write(LERR,*)'Maximum src/rcvr midpoint X-coordinate= ',srrcxmax
      write(LERR,*)'Minimum src/rcvr midpoint X-coordinate= ',srrcxmin
      write(LERR,*)'Maximum src/rcvr midpoint Y-coordinate= ',srrcymax
      write(LERR,*)'Minimum src/rcvr midpoint Y-coordinate= ',srrcymin
      write(LERR,*)' '
cmam  write(LERR,*)'Maximum CDP bin center X-coordinate   = ',cdpbxmax
cmam  write(LERR,*)'Minimum CDP bin center X-coordinate   = ',cdpbxmin
cmam  write(LERR,*)'Maximum CDP bin center Y-coordinate   = ',cdpbymax
cmam  write(LERR,*)'Minimum CDP bin center Y-coordinate   = ',cdpbymin
cmam  write(LERR,*)' '
      write(LERR,*)'Maximum trace distance = ', dismax
      write(LERR,*)'Minimum trace distance = ', dismin
      write(LERR,*)' '
C-----------------------------------------------------------------------
C
C     PRINT INFORMATION ABOUT THE GRID
C
C-----------------------------------------------------------------------
C
      WRITE (LERR,3700) NX,NY
 3700 FORMAT (///, 1X, 'NO. OF CELLS ALONG SIDE 1-4 = ', I5,
     $             5X, 'NO. OF CELLS ALONG SIDE 1-2 = ', I5, /)
C
C-----------------------------------------------------------------------
C
C     WRITE SOME FINAL STATISTICS
C
C-----------------------------------------------------------------------
C
      WRITE (LERR,4100) NTR,MAX
 4100 FORMAT ( / 1X, 'NO. OF LIVE TRACES CONTAINED IN AREA = ', I9,
     $       5X, 'MAX. NO. OF LIVE TRACES/CELL = ', I6)
C
C-----------------------------------------------------------------------
C
C     DETERMINE THE OUTPUT FOLD
C
C-----------------------------------------------------------------------
C
      IF (IFILL.EQ.0) IFOLD = MAX

C
C

        numvec = 9
cmam    numvec = 28
	write(LERR,*)'writing database:'
	write(LERR,*)'numvec=',numvec,' nseg=',isegn,' ntr=',nsize
	write(LERR,*)'minli=',minli,' maxli=',maxli,' mindi=',
     :		mindi,' maxdi=',maxdi
	write(LERR,*)'nlive=',nlive,' idead=',idead, 'total=',ntot
	write(LERR,*)'max num of tr per cell=',maxrec
         luns = LUDISK
 
	 lsize = nsize
cmam	 lsize = ksize + nsize
	 irecsz = lsize * SZSMPD
      write(LERR,*)'lsize=',lsize,'  SZSMPD=',SZSMPD,'  irecsz=',
     :		irecsz
cmam......irecsz = nsize * SZSMPD
cmam...........set up jcell array that points to index in the vectors,
cmam...........when they are sorted into ascending cell number, of the
cmam...........starting index for each cell number.
	write(LERR,*)'moving SeqTr to junk2'
	write(LERR,*)'nsize,nrect,mrect,ksize,lsize=',
     :		nsize,nrect,mrect,ksize,lsize
	call vmov (SeqTr,1,junk2,1,lsize)
	write(LERR,*)'moving CellN to junk1'
	call vmov (CellN,1,junk1,1,lsize)
	call isort2 (lsize,junk1,junk2)
	if(junk1(1).gt.0) jcell(junk1(1)) = 1
	do 192 i = 2, lsize
	if(junk1(i).ne.junk1(i-1)) jcell(junk1(i)) = i
  192	continue
cmam........find max number of traces per receiver station
	write(LERR,*)'moving RcSta to junk1'
	call vmov (RcSta,1,junk1,1,lsize)
	write(LERR,*)'moved RcSta: sorting junk1'
	call isort1(lsize,junk1)
	write(LERR,*)'junk1 sorted'
	mxrsct = 0
	do i = 1,lsize
	if(junk1(i).gt.0) then
	   ist = i
	   go to 193
	endif
	enddo
	write(LERR,*)'WARNING:all receiver stations have zero value'
	write(LER,*)'WARNING:all receiver stations have zero value'
	write(LERR,*)'WARNING:all receiver stations have zero value'
	go to 195
  193   continue
	ivalue = junk1(ist)
	icount = 0
	write(LERR,*)'index=',ist,' of first nonzero junk1'
	do i = ist,lsize
	if(junk1(i).eq.ivalue) then
	   icount = icount + 1
	else
	   if(icount.gt.mxrsct) mxrsct = icount
	   icount = 1
	   ivalue = junk1(i)
	endif
	enddo
  195	continue
	write(LERR,*)'lsize=',lsize,'   mxrsct=',mxrsct
	write(LERR,*)'opening file to write database'

cmam...........write the database here
      write(LERR,*)' recl=irecsz=',irecsz
         open (unit = luns, file = otap, form = 'unformatted',
     :		recl = irecsz, err = 196,
cmam :		recl = irecsz,
     1         access = 'direct', status = 'unknown', iostat = ierr)
 
         if(ierr .ne. 0) then
	    write(LERR,*)'could not open output disk file'
            write(LERR,*)'Could not open output disk file'
            write(LERR,*)'for some damned reason'
	    write(LERR,*)'Database cannot be written'
            stop
         endif
	go to 197
cmam.....added 5-14-97
cmam....ERROR opening output database file
  196	write(LERR,*)'ERROR:could not open output database file'
	write(LER ,*)'ERROR:could not open output database file'
	if(ierr.eq.113) then
	  write(LERR,*)'ERROR=113:out of free space'
	  write(LERR,*)'  rerun on a larger machine or with fewer',
     :			' jobs running simultaneously'
	  write(LER ,*)'ERROR=113:out of free space'
	  write(LER ,*)'  rerun on a larger machine or with fewer',
     :			' jobs running simultaneously'
	else
	  write(LERR,*)'ERROR=',ierr
	  write(LERR,*)'  contact usp team for help'
	  write(LER ,*)'ERROR=',ierr
	  write(LER ,*)'  contact usp team for help'
	endif
	write(LERR,*)'***program dbvec aborting***'
	write(LER ,*)'***program dbvec aborting***'
	call ccexit(ierr)
	stop
  197	continue

cmam.........crayj90 will not allow rewind on direct access datafile
cmam..........do not need this anyway
cmam     rewind luns

cmam............vectors now built...write them out
cmam	luns = luout
	if(xline) then
		knx = ny
		kny = nx
	else
		knx = nx
		kny = ny
	endif

	write(LERR,*)'writing the database'
	write(LERR,*)'writing header record:numvec,isegn,lsize=',
     :		numvec,isegn,lsize
	write(LERR,*)' minli,maxli,mindi,maxdi,nlive,idead, maxrec=',
     :		minli,maxli,mindi,maxdi,nlive,idead, maxrec
	write(LERR,*)'     knx, kny, nxy, mxrsct=',
     :		knx, kny, nxy, mxrsct
        write(luns,rec=1) numvec,isegn,lsize,minli,maxli,mindi,maxdi,
     :		nlive,idead, maxrec, knx, kny, nxy, mxrsct
        write(luns,rec=2) (SeqTr(i),i=1,lsize)
cmam   write(LERR,*)'lsize=',lsize,'  SeqTr=',(SeqTr(i),i=1,lsize)
	write(LERR,*)'writing PartN'
        write(luns,rec=3) (PartN(i),i=1,lsize)
	write(LERR,*)'writing PNSeq'
        write(luns,rec=4) (PNSeq(i),i=1,lsize)
	write(LERR,*)'writing CellN'
        write(luns,rec=5) (CellN(i),i=1,lsize)
	write(LERR,*)'writing Offst'
        write(luns,rec=6) (Offst(i),i=1,lsize)
	write(LERR,*)'writing RcSta'
        write(luns,rec=7) (RcSta(i),i=1,lsize)
	write(LERR,*)'writing ShSta'
        write(luns,rec=8) (ShSta(i),i=1,lsize)
	write(LERR,*)'writing kcell'
cmam   write(LERR,*)'lsize=',lsize,'  kcell=',(kcell(i),i=1,lsize)
cmam	write(luns,rec=9) (kcell(i),i=1,lsize)
	write(luns,rec=9) (kcell(i),i=1,nxy)
cmam   write(LERR,*)'lsize=',lsize,'  jcell=',(jcell(i),i=1,lsize)
	write(LERR,*)'writing jcell'
cmam	write(luns,rec=10) (jcell(i),i=1,lsize)
	write(luns,rec=10) (jcell(i),i=1,nxy)
  777	continue
 
cmam.............close datasets
        close(luns)

      write(LERR,*)' '

C-----------------------------------------------------------------------
C
C-----------------------------------------------------------------------
C
      GO TO 4800
C
C-----------------------------------------------------------------------
C
C-----------------------------------------------------------------------
 4600 MAX               = IFOLD * NX
      IF (NTROUT .NE. 0)   MAX   = NTROUT
C
C-----------------------------------------------------------------------
      ICC               = 0
C
 4800 continue

      if (rots) then

         call fit (xcoordr, ycoordr, nlive, dummy, slope, trcept,
     1              siga, sigb, chi2)
         angr = 57.2957795785 * atan (a1)
         write(LERR,*)'**********************************************'
         write(LERR,*)'Solve Ax + B through the receiver XYs'
         write(LERR,*)'Number live traces                 =  ',nlive
         write(LERR,*)'Angle of rotation found for groups =  ',angr
         write(LERR,*)'Slope                              =  ',slope
         write(LERR,*)'X=0 intercept                      =  ',trcept
         write(LERR,*)'**********************************************'
      endif

C
 4900 continue
	do iii = 1,nu
	CALL LBCLOS (luin(iii) )
	enddo
cmam  close (LERR  )


      IF (ISTOP .NE. 0) then
        write(LERR,*)'3D database: ABNORMAL Termination'
        write(LER,*)'3D database: ABNORMAL Termination'
cmam    STOP 3
	call ccexit (ICC)
      endif

        write(LERR,*)'3D database written: NORMAL Termination'
        write(LER,*)'3D database written: NORMAL Termination'
      CALL CCEXIT (ICC)
      END
C
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'dbvec:  builds a database of vectors describing the input file.'
	write(LER,*)
     :'(This database and the same input file will be input to edit3d'
	write(LER,*)
     :'  to quickly edit off traces by the given LI,DI parameters.)'
      write(LER,*)
     :'execute dbvec by typing dbvec and a list of program parameters.'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
      write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)  : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout) : output database file'
	write(LER,*)
     :' -A   (def = no append): append the data from this run to an',
     :' existing database'
        write(LER,*)
     :' -stk (def = compute)  : get Bin Center X,Ys from header words'
        write(LER,*)
     :'                         CDPBCX,CDPBCY instead of computing'
        write(LER,*)
     :'                         them from source/receiver XYs'
        write(LER,*)
     :' -dmin [dmin] (0)   : min model spread offset'
        write(LER,*)
     :' -dmax [dmax] (none): max model spread offset'
        write(LER,*)
     :' -ddel [ddel] (none): model spread group interval'
      write(LER,*)' '
        write(LER,*)
     :' -hwshot []   (SoPtNm) : Shot Station Header Mnemonic'
        write(LER,*)
     :' -hwgroup []  (RecInd) : Group Station Header Mnemonic'
      write(LER,*)' '
        write(LER,*)
     :' -dx [dx]    (none)    : cross-line (3-4) cell dimension'
        write(LER,*)
     :' -dy [dy]    (none)    : in-line (1-2) cell dimension'
        write(LER,*)
     :' Note: for CDP sorts the cell dimensions will be 1/2 the line &'
        write(LER,*)
     :' group (receiver spacing in Y-direction) spacing'
      write(LER,*)' '
        write(LER,*)
     :' four corners of the survey (should be the entire survey):'
        write(LER,*)
     :' -x1 [x1]    (none)    : x-coord closest to origin'
        write(LER,*)
     :' -y1 [y1]    (none)    : y-coord closest to origin'
        write(LER,*)
     :' -x3 [x3]    (none)    : x-coord farthest (diagonal) from origin'
        write(LER,*)
     :' -y3 [y3]    (none)    : y-coord farthest (diagonal) from origin'
        write(LER,*)
     :' -x2 [x2]    (none)    : x-coord counterclockwise from x1y1-x3y3'
        write(LER,*)
     :' -y2 [y2]    (none)    : y-coord counterclockwise from x1y1-x3y3'
        write(LER,*)
     :' -x4 [x4]    (none)    : x-coord clockwise from x1y1-x3y3'
        write(LER,*)
     :' -y4 [y4]    (none)    : y-coord clockwise from x1y1-x3y3'
      write(LER,*)' '
        write(LER,*)
     :'                  coordinates read in on command line...'
        write(LER,*)
     :'                     ... either input (x1,y1) & (x3,y3), or'
        write(LER,*)
     :'                     ... input (x2,y2) & (x4,y4), or'
      write(LER,*)' '
        write(LER,*)
     :' -X                    : input data is in crossline'
        write(LER,*)
     :'                         order, else the data is inline order'

      write(LER,*)' '
         write(LER,*)
     :'usage:'
         write(LER,*)
     :'   dbvec -N[ntp] -O[otp] [ [ -X ] [ -A] [ -stk]'
         write(LER,*)
     :'        [ -dmin[] -dmax[] -ddel[] ]'
         write(LER,*)
     :'         -x1[] -y1[] -x2[] -x3[] -x4[] -y4[] -dx[] -dy[]'
         write(LER,*)
     :'***************************************************************'
      return
      end

