      SUBROUTINE DMCARD (IPRT,   ICRDa,   NTRCS, NFOLD, reverse,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, TC,     VC,    NPAIRS, ANGMIN,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3, spread,
     &             IY3,    IX4, IY4, NTPL,NLI, NDI, ngrp,
     &             DIVEXP, TRCSPC,   verbos, norm, shot, mode,
     &             aliasflag, ampflag, sprdflag, tape,
     &             amn, amx, nang, nca, jra, iem, ITAPOT,
     &             nu, nsamps, si, iord, saf, halt)
C***********************************************************************00001970
C                                                                       00001980
C     PROGRAM NAME: DMCARD (READ USER CARDS FOR DM3D)                   00001990
C                                                                       00002000
C     LANGUAGE: FORTRAN                                                 00002010
C                                                                       00002020
C     AUTHOR: G.MURPHY                                                  00002030
C                                                                       00002040
C     DATE WRITTEN: 07/01/88                                            00002050
C                                                                       00002060
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00002080
C                                                                       00002100
C     ABSTRACT: READ DM3D CARDS                                         00002110
C                                                                       00002120
C                                                                       00002130
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00002140
C                                                                       00002150
C***********************************************************************00002160
C                                                                       00002170
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      REAL          TC (*), VC (*)
      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      integer       argis, iem, mode
      integer       nca (*), jra (*), ITAPOT (*)
      real          spread (*), amn (63,70), amx (63,70)
      integer       aliasflag, ampflag, sprdflag
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      logical       alias, sprd, verbos, norm, shot, tape, reverse
      logical       csamp, coamp, bkamp, halt
      DATA IEND, IFLAG /0,1/

         call argr4 ('-dmin',  DSTMIN, 0., 0.)
         call argr4 ('-dmax',  DSTMAX, 0., 0.)
         call argr4 ('-ddel',  DSTDEL, 0., 0.)
         call argr4 ('-angmn', ANGMAX, 0., 0.)
         call argr4 ('-angmx', ANGMIN, 0., 0.)
         call argr4 ('-dipm',  ANGMAX, 90., 90.)
         call argr4 ('-dexp',  DIVEXP, 1., 1.)
         call argi4 ('-ntrc',  NTRCST, 0 , 0 )
         call argi4 ('-dimin', MINDI , 1 , 1 )
         call argi4 ('-dimax', MAXDI , 0 , 0 )
         call argi4 ('-limin', MINLI , 1 , 1 )
         call argi4 ('-limax', MAXLI , 0 , 0 )
         call argi4 ('-iorec', IOREC , 0 , 0 )
         call argi4 ('-emerg ', iem   , 0 , 0 )
         call argi4 ('-mode ', mode  , 2 , 2 )
         call argi4 ('-iord ', iord  , 0 , 0 )
         call argr4 ('-saf ', saf  , 0.0 , 0.0 )

         alias  = (argis('-AS') .gt. 0)
         if (alias) then
            aliasflag = 1
         else
            aliasflag = 0
         endif

         sprd   = (argis('-GS') .gt. 0)
         if (sprd) then
            sprdflag = 0
         else
            sprdflag = 1
         endif

         csamp    = (argis('-CSA') .gt. 0)
         coamp    = (argis('-COA') .gt. 0)
         bkamp    = (argis('-BKA') .gt. 0)
         ampflag = -1
         if (csamp) ampflag = 0
         if (coamp) ampflag = 1
         if (bkamp) ampflag = 2

         shot     = (argis('-shot') .gt. 0)
         halt     = (argis('-stop') .gt. 0)
         norm     = (argis('-norm') .gt. 0)
         reverse  = (argis('-rev') .gt. 0)
         verbos   = (argis('-V') .gt. 0)

C *** FILL IN THE DEFAULTS                                              00002460

         IOREC = 0

         if (iord .eq. 0) then
            write(LERR,*)'No angle smoothing'
         else
            write(LERR,*)'Angle smoothing order= ',iord
         endif


         IF (NTRCST .NE. 0 ) NTRCS  = NTRCST
         IF (IOREC  .EQ. 0 ) IOREC  = 1
         IF (ANGMAX .EQ. 0.) ANGMAX = 90.

c        READ (CARD, 160) IX3, IY3, IX4, IY4, DYT, DXT                  00002680

         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )

         call argr4 ('-cldm', dxt, 0., 0.)
         call argr4 ('-ildm', dyt, 0., 0.)

         if (dxt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmoangst3d:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmoangst3d:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif

         if (dyt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmoangst3d:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmoangst3d:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif

         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmoangst3d:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmoangst3d:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif
     
C *** COMPUTE NUMBER OF INPUT TRACES                                    00002700

         IF (DYT .NE. 0.) DY = DYT
         IF (DXT .NE. 0.) DX = DXT
         TRCSPC = MIN (DY, DX)

         if (DSTMAX .ne. 0.0 .AND. DSTMIN .ne. 0.0 .AND.
     1       DSTDEL .ne. 0.0) then
             NFOLD  = nint ((DSTMAX - DSTMIN) / DSTDEL) + 1
             TRCSPC = DSTDEL
         endif

        if (DSTDEL .eq. 0.) then
           dxg = (DSTMAX - DSTMIN) / float (NTRCS-1)
           TRCSPC = dxg
           ngrp = NTRCS
           DSTDEL = dxg
        else
           dxg = DSTDEL
           TRCSPC = dxg
           NFOLD  = nint ((DSTMAX - DSTMIN) / DSTDEL) + 1
           ngrp = NFOLD
        endif
c-------
c compute spread model
c-------
         ngrp = NFOLD
         ngrp2 = ngrp / 2
         call vfill (0.0, spread, 1, ngrp)
 
         do  j = 1, ngrp
 
             spread (j) = DSTMIN + (j-1) * dxg
         enddo


         if (DSTMAX .eq. 0.0) DSTMAX =  999999.
         if (DSTMIN .eq. 0.0) DSTMIN = -999999.

 2000 CONTINUE

      call rdangs (amn, amx, nca, jra, icrda, nang, nasets)
 
      write(IPRT,*)' '
        write(IPRT,'(a   )')' Minimum Angles:'
        call writer(amn,nang,1,IPRT)
      write(IPRT,*)' '
        write(IPRT,'(a   )')' Maximum Angles:'
        call writer(amx,nang,1,IPRT)
      write(IPRT,*)' '

      if (nu .gt. 1) then
         if (nu .ne. nang) then
             write(IPRT,*)'Fatal Error in dmoangst3d:'
             write(IPRT,*)'For more than 1 output file the # output'
             write(IPRT,*)'files must be exactly equal to the # angles'
             write(IPRT,*)'(which in this case is ',nang,')'
             stop
         endif
      endif


C *** WRITE PARAMETERS TO USER REPORT                                   00003220


      WRITE (IPRT, 180) DSTMIN, DSTMAX, DSTDEL, ANGMAX, ANGMIN, NTRCS,
     &                  MINLI, MAXLI, MINDI, MAXDI, TRCSPC, IORD,
     &                  DIVEXP
  180 FORMAT (//, 30X, 'COMMAND LINE PARAMETERS:'                 ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  DELTA DISTANCE... . . . . . . .',F15.5  ,
     &        //, 23X, '  MAXIMUM DIP . . . . . . . . . .',F15.5  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  NUMBER OF TRACES PER RECORD . .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  OUTPUT TRACE SPACING. . . . . .',F15.5  ,
     &        //, 23X, '  ANGLE SMOOTHING ORDER . . . . .',1X,I9  ,
     &        //, 23X, '  DIVISOR EXPONENT. . . . . . . .',F15.5  )
      WRITE (IPRT, 190) IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4,
     &                  IOREC, DY, DX
  190 FORMAT ( /, 23X, '  CORNER 1 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 1 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  STARTING OUTPUT RECORD NUMBER .',1X,I9  ,
     &        //, 23X, '  CROSSLINE CELL DIMENSION. . . .',F15.5  ,
     &        //, 23X, '  INLINE CELL DIMENSION . . . . .',F15.5,//)

      RETURN
      END
