      SUBROUTINE DMTAPE (IPRT,   ITAPIN, luout , IBYTES, luvel, nu,
     &             IREC,   NREC,   IOREC,  ICC,    IOLEN,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, TC, VC, nsmpv,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, siv,
     &             NSAMPS, IFMT,   SI,     RECLEN, IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, norm, shot, tape,
     &             aliasflag, ampflag, sprdflag, tap1, dt,
     &             nrecv, intrp, restart, divexp, amn, amx,
     &             nang, inca, luang, spread, ngrp, mode, iem,
     &             ttap, reverse, iord, lunrm, saf, halt)
C***********************************************************************00003620
C                                                                       00003630
C     PROGRAM NAME: DMTAPE (READ TAPE, DUMP AND WRITE MODIFIED OUTPUT)  00003640
C                                                                       00003650
C     LANGUAGE: FORTRAN                                                 00003660
C                                                                       00003670
C     AUTHOR: G.MURPHY                                                  00003680
C                                                                       00003690
C     DATE WRITTEN: 06/14/88                                            00003700
C                                                                       00003710
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00003730
C                                                                       00003750
C     ABSTRACT: READS INPUT DATASET DUMPS AND WRITES MODIFIED DATASET   00003760
C                                                                       00003770
C                                                                       00003780
C     MODIFICATION HISTORY: 06/14/88  -  INITIAL RELEASE                00003790
C                                                                       00003800
C***********************************************************************00003810
C                                                                       00003820
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      parameter     (npol = 6)
 
      external      fpoly
      integer       intbin
      DIMENSION     TC (*), VC (*)
      DIMENSION     RHEAD  (SZLNHD)
      DIMENSION     TRACE  (SZLNHD)
      INTEGER       VHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      integer       icelli (SZLNHD)
      integer       iceldi (SZLNHD)
      integer       aliasflag, ampflag, sprdflag, lunrm, obytes
      integer       ordfft, irrec, nrrec, abytes
      real          vel1(SZLNHD), timvec(SZLNHD),  spread (*)
      real          tvel(SZLNHD), vcoefs(npol), errparms(5)
      real          vrms(SZLNHD), vsrms(SZLNHD), sig(SZLNHD)
      real          vism(SZLNHD),vit(SZLNHD), V(SZLNHD)
      real          tima(SZLNHD), work(SZLNHD), vdmo(SZLNHD)
      real          vel_array(SZLNHD), t_array(SZLNHD)

      real          sincs (41), w(SZLNHD)
      complex       ctrace(SZLNHD)
      REAL          SUM, DMO, TAB, STK, angio, angio1, angles
      pointer       (wkdmo,   DMO(1))
      pointer       (wksum,   SUM(1))
      pointer       (wktab,   TAB(1))
      pointer       (wkstk,   STK(1))
      pointer       (wkangio,  ANGIO(1))
      pointer       (wkangio1, ANGIO1(1))
      pointer       (wkangles, ANGLES(1))


      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      character     tap1 * (*), ttap * (*)
      character     name * 10
      logical       verbos, norm, shot, tape, intrp, restart, reverse
      logical       fit, halt, detm, first

      real          amn (63,70), amx (63,70)
      integer       luout (*)
      real          angmn (SZLNHD), angmx (SZLNHD)

      real          tabl1 (SZLNHD), tabl2 (SZLNHD), zz (4*SZLNHD)
      real          zza (4*SZLNHD)
      integer       iz (SZLNHD)
      integer       iza (SZLNHD)

      integer       ISLIMN,ISDIMN,IRLIMN,IRDIMN,ICLIMN,ICDIMN,ISLIMX
      integer       ISDIMX,IRLIMX,IRDIMX,ICLIMX,ICDIMX,MINDST,MAXDST
      integer       MAXFLDs, MAXDMO
      integer       MAXFLDr
      integer       MAXFLDx
      integer       minJ, maxJ, minI, maxI

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)

      DATA first   / .false. /
      DATA name    / 'dmoangst3d' /

      DATA ISLIMN / 999999999 /
      DATA ISDIMN / 999999999 /
      DATA IRLIMN / 999999999 /
      DATA IRDIMN / 999999999 /
      DATA ICLIMN / 999999999 /
      DATA ICDIMN / 999999999 /
      DATA ISLIMX /-999999999 /
      DATA ISDIMX /-999999999 /
      DATA IRLIMX /-999999999 /
      DATA IRDIMX /-999999999 /
      DATA ICLIMX /-999999999 /
      DATA ICDIMX /-999999999 /
      DATA MINDST / 999999999 /
      DATA MAXDST /-999999999 /
      DATA MAXFLD /-999999999 /
      DATA MAXDMO /-999999999 /
      DATA MAXFLDs /-999999999 /
      DATA MAXFLDr /-999999999 /
      DATA MAXFLDx /-999999999 /
      DATA minJ / 999999999 /
      DATA maxJ /-999999999 /
      DATA minI / 999999999 /
      DATA maxI /-999999999 /
      DATA IRREC  /0/
      DATA NRREC  /0/
      DATA IOLD   /0/

      celscl = 0.5
      DX2 = celscl * DX
      DY2 = celscl * DY

      if (saf .eq. 0.) then
         fit = .false.
      else
         fit = .true.
      endif

      pi = 3.14159265
      deg   = 180. /  pi
      no = ordfft( nsamps )
      nt = 2 ** no

      call vclr (errparms, 1, 5)
      ierr = 0
      call minmgv (spread, 1, xmin, loc, ngrp)
      write(LER,*)' '
      write(LER,*)'Minimum offset= ',xmin,' at group ',loc
      if (abs (xmin) .lt. 1.e-10) then
         spread (loc) = .0005
      endif

      dxg = TRCSPC
      icinit = 1
      icflag = 1
 
      nsmpa = nsamps / inca
      dta = inca * dt
      sia = inca * si
 
      do  i = 1, nsamps
          timvec (i) = float (i-1) * dt
          t_array (i) = i * dt
      enddo
      do  i = 1, nsmpa
          tima (i) = float (i-1) * dta
      enddo
      vtmax  = timvec (nsamps)
      vtmaxa = tima (nsamps)
 
      do  k = 1, nang
          angmn (k) = amn (k,1)
          angmx (k) = amx (k,1)
      enddo
      write(LERR,*)'angmn'
      write(LERR,*)(angmn(ii),ii=1,nang)
      write(LERR,*)'angmx'
      write(LERR,*)(angmx(ii),ii=1,nang)
 
      do  i = 1, nsmpv
          tvel   (i) = float (i-1) * siv / 1000.
      enddo


C *** build pointers into trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcAz',ifmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      IREC = 0
      angmax = sin ( angmax * pi / 180.)
      scale  = 1. / (4 * sqrt (2*pi) )

c---
c  there are 3 output files that are basically read/write:
c  (1) output data itself - consists of binned angle stacks with
c      each bin containing "nang" traces (stacked traces for that
c      pair of min/max angles.
 
c  (2) angle data set - consists of angles computed by the ray tracer
c      and sampled every inca samples (will be cubic spline interpolated
c      when read in).
 
c  (3) normalization data set - consists of sample-by-sample normalization
c      for each of the output angle traces (will be the same size as the
c      main output data set).
 
c      in addition there is the RMS velocity data set (which may be sampled
c      coarsely).
c---


C *** SET THE TRANSLATION SUBSYSTEM                                     00004570

      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)
      
      if (MAXLI .eq. 0) then
          MAXLI  = NX
      endif
      if (MAXDI .eq. 0) then
          MAXDI  = NY
      endif
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)'DMO-ANGLE STACK starts:'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'Min offset used  =   ',DSTMIN
      write(LER,*)'Max offset used  =   ',DSTMAX
      write(LER,*)'*********************************'
      write(LER,*)' '

      NRECo  = NX * NY
      if (nu .eq. 1) then
         NRECo  = NX * NY
         NTRCo  = nang
         NTRKS  = NX * NY * nang
         nangi  = nang
      else
         NRECo  = NX
         NTRCo  = NY
         NTRKS  = NX * NY
         nangi  = 1
      endif
      NTRKSi = (ndi + 1) * (nli + 1) * nang
      NTRKA  = NX * NY * ngrp

      NBYTR  = NSAMPS * SZSMPD
      NBYTA  = nsmpa  * SZSMPD
      obytes = NBYTR + SZTRHD
      abytes = NBYTA + SZTRHD

      NXNY  = NX * NY
      NXY   = sqrt ( float(NX*NX) + float(NY*NY) )

      write(LERR,*)'nx, ny, nxny= ',nx,ny,nxny
      write(LERR,*)'nang, ngrp= ',nang, ngrp
      write(LER ,*)'nx, ny, nxny= ',nx,ny,nxny
      write(LER ,*)'nang, ngrp= ',nang, ngrp

      if (nrecv .ne. nxny) then
         write(LERR,*)'FATAL ERROR in dmoangst3d:'
         write(LERR,*)'number of records in velocity tape data set'
         write(LERR,*) nrecv
         write(LERR,*)'is not equal to number of output cells'
         write(LERR,*) nxny
         write(LERR,*)'Check velocity tape building steps'
         stop
      endif
      if (intrp) then
         do  i = 1, nsmpv
             tabl1 (i) = float (i) * siv
         enddo
         do  i = 1, nsamps
             tabl2 (i) = float (i) * si
         enddo
      endif


c---
c  dmo   - matrix for "spray" of dmo'd amplitudes
c---
      iswath = 3
      itemn = nsamps * iswath
      call galloc (wkdmo,   SZSMPD * itemn , ierr1, iabort1)

      if (ierr1 .ne. 0) then
         write(LER ,*)'Unable to allocate DMO array - too big'
         write(LER ,*)'array sized ',SZSMPD*itemn,' Mb'
         write(LER ,*)'Try killing off some of your jobs or'
         write(LER ,*)'rerunning on a bigger machine'
         stop
      endif

c---
c  angles - matrix of angle-time-offset info from ray tracer
c  angio  - I/O vector for the ray traced angle file
c  tab    - I/O vector for the D/A normalization file
c---
      itema = nsmpa
      itemt = nsamps
      items = nsamps * nang
      itemd = nsamps * ngrp
 
      call galloc (wktab,    SZSMPD * itemt , ierr1, iabort3)
      call galloc (wkstk,    SZSMPD * items , ierr2, iabort1)
      call galloc (wksum,    SZSMPD * items , ierr3, iabort2)
      call galloc (wkangles, SZSMPD * itemd , ierr4, iabort2)
      call galloc (wkangio,  SZSMPD * itema , ierr5, iabort2)
      call galloc (wkangio1, SZSMPD * itema , ierr6, iabort2)
 
 
      if (ierr1 .ne. 0 .or. ierr2 .ne. 0 .or. ierr3 .ne. 0 .or.
     1    ierr4 .ne. 0 .or. ierr5 .ne. 0 .or. ierr6 .ne. 0) then
         write(LER ,*)'Unable to allocate arrays - too big'
         write(LER ,*)'2 arrays each sized ',SZSMPD*items,' bytes'
         write(LER ,*)'1 arrays each sized ',SZSMPD*itemt,' bytes'
         write(LER ,*)'1 arrays each sized ',SZSMPD*itemd,' bytes'
         write(LER ,*)'2 arrays each sized ',SZSMPD*itema,' bytes'
         write(LER ,*)'Try killing off some of your jobs or'
         write(LER ,*)'rerunning on a bigger machine'
         stop
      endif

      call vclr ( TAB,   1, nsamps)
      call vclr ( angio,  1, nsmpa)
      call vclr ( angio1, 1, nsmpa)


      write(LERR,*)' '
      write(LERR,*)'ix,iy ',IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX
      write(LERR,*)'x,y ',xx,xy,yx,yy,xxt,xyt,yxt,yyt,nxy
      write(LERR,*)'NX,NY,nxy,items= ',NX,NY,NDI,NLI,nxy,items
      write(LERR,*)'minli,maxli,mindi,maxdi= ',minli,maxli,mindi,maxdi
      write(LERR,*)'ntrcs,angmax,scale= ',ntrcs,angmax,scale
      write(LERR,*)'TRCSPC= ',TRCSPC,' SI= ',si,' norm? ',norm,shot
      write(LERR,*)' '

c-----
C *** adjust line header & write output LH
c-----
      call savew (JHEAD, 'NumTrc', NY     , LINHED)
      call savew (JHEAD, 'NumRec', NX     , LINHED)
      call savew (JHEAD, 'NumSmp', NSAMPS , LINHED)
      call savew (JHEAD, 'Format', 3      , LINHED)
      call savew (JHEAD, 'CDPFld', NFOLD  , LINHED)
      call savew (JHEAD, 'MnLnIn', MINLI  , LINHED)
      call savew (JHEAD, 'MxLnIn', MAXLI  , LINHED)
      call savew (JHEAD, 'MnDpIn', MINDI  , LINHED)
      call savew (JHEAD, 'MxDpIn', MAXDI  , LINHED)
      call savew (JHEAD, 'ILClIn', DX     , LINHED)
      call savew (JHEAD, 'CLClIn', DY     , LINHED)

      if (.not. restart) then
         call savhlh (JHEAD, IBYTES, lbyout)
      endif

      if (.not. restart) then
 
         do  iu = 1, nu
             call rwd (luout (iu) )
             CALL WRTAPE (luout (iu) , JHEAD, lbyout)
         enddo
         call rwd (lunrm)
         call savew (JHEAD, 'NumTrc', nang   , LINHED)
         call savew (JHEAD, 'NumRec', NXNY   , LINHED)
         CALL WRTAPE (lunrm, JHEAD, lbyout)
         call rwd (luang)
         call savew (JHEAD, 'NumTrc', ngrp   , LINHED)
         call savew (JHEAD, 'NumRec', NXNY   , LINHED)
         call savew (JHEAD, 'NumSmp', nsmpa  , LINHED)
         CALL WRTAPE (luang, JHEAD, lbyout)
 
         call savew (JHEAD, 'NumTrc', NTRCo  , LINHED)
         call savew (JHEAD, 'NumRec', NRECo  , LINHED)
         call savew (JHEAD, 'NumSmp', nsamps , LINHED)
 
      else
 
         do  iu = 1, nu
             call rwd (luout (iu) )
             CALL  RTAPE (luout (iu) , JHEAD, LBYTES)
         enddo
         if (lbytes .eq. 0) then
            write(LERR,*)'Fatal error in dmoangst3d:'
            write(LERR,*)'Restart failed because output file does'
            write(LERR,*)'not have a line header. You must re-run'
            write(LERR,*)'from scratch.'
            stop 666
         endif
         call sislgbuf (luang, 'off')
         call sislgbuf (lunrm, 'off')
         call rwd (luang)
         CALL RTAPE (luang, JHEAD, KBYTES)
         call rwd (lunrm)
         CALL RTAPE (lunrm, JHEAD, KBYTES)

      endif

c-----
C *** fill up output data set and the rewind and read over LH
c     do same for the angles data (it may be sampled more coarsely)
c-----
      call vmov (tab, 1, jhead(ITHWP1), 1, nsamps)

      if (.not. restart) then
         call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000 , TRACEHEADER)
         call savew2(JHEAD,ifmt_VPick1,l_VPick1, ln_VPick1,
     1               0     , TRACEHEADER)
         do  iu = 1, nu
             write(LER,*)'Building output data file ',iu,
     1                   ' with ',NTRKS,' traces'
             do  i = 1, NTRKS
                 call wrtape (luout(iu) , jhead, obytes)
             enddo
         enddo
 
         write(LER,*)'Building angles data file',
     1                   ' with ',NTRKA,' traces'
         do  i = 1, NTRKA
             call wrtape (luang, jhead, abytes)
         enddo
         call sislgbuf (luang , 'off')
      endif

      call rwd (luang)
      call rtape (luang , jhead, IBYTES)
 
      do  iu = 1, nu
          call rwd (luout(iu) )
          call sislgbuf (luout(iu) , 'off')
          call rtape (luout(iu) , jhead, IBYTES)
      enddo
      call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            0 , TRACEHEADER)


c-----
c *** fill up optional scratch file for normalization
c-----
      call vclr (tab, 1, nsamps)
      call vmov (tab, 1, jhead(ITHWP1), 1, nsamps)

      if (.not.restart) then

         write(LER,*)'Building normalization data file',
     1                   ' with ',NTRKSi,' traces'
         do  i = 1, NTRKSi
             call wrtape (lunrm, jhead, obytes)
         enddo
         call sislgbuf (lunrm , 'off')
      endif

      msx = nxy

      write(LER,*)'Built I/O files: you have enough disk space'

c-----
c     For the spread geometry (trace distances) and for all bins:
c     read the velocities; pre-compute all the ray traced angles (which
c     we'll need when turning the trace to be stacked on and off), and
c     store the angle info on disk in decimated form
c-----
      IF (restart) go to 1400
 
      DO  J = mindi, maxdi
          DO  I = minli, maxli
 
c-----
c  get velocity if it is a velocity tape data set. each velocity trace
c  must reside at a location corresponding to the output grid. If
c  the velocity trace is coarsely sampled the interpolate.
c-----
              ipntr = (J - mindi) + (I - minli) * ndi + 1
              call sisseek (luvel, ipntr)
              call rtape (luvel, vhead, nvbytes)
              if (nvbytes .eq. 0) then
                 write(LERR,*)'FATAL ERROR in dmoangst3d:'
                 write(LERR,*)'Premature end of velocity data at LI/DI=
     1',I,J
                 write(LERR,*)'Check velocity tape building steps.'
                 stop
              endif
              call vmov (vhead(ITHWP1), 1, vel1, 1, nsmpv)
              if (intrp) then
                 call fcuint (tabl1, vel1, nsmpv, tabl2, vel_array,
     1                        nsamps, iz, zz, icinit)
                 icinit = 0
              else
                 call vmov (vel1, 1, vel_array, 1, nsamps)
              endif
              call minv (vel_array, 1, vmin, loc, nsamps)
              if (vmin .le. 0.) then
                 write(LERR,*)'FATAL ERROR in dmoangst3d:'
                 write(LERR,*)'detected velocity < 0. Something bad'
                 write(LERR,*)'either in input velocity traces, or'
                 write(LERR,*)'in the interpolation.'
                 stop
              endif
c----
c   for each bin we now have the RMS velocity
c   now we compute the smoothed RMS, the smoothed interval, and
c   the unsmoothed interval
c   NOTE: we now assume the RMS velocity field has already been properly
c         smoothed
c----
              if (fit) then
                 call sloper (t_array, vel_array, nsamps, saf)
              endif
              call fitvel (t_array, vel_array, nsamps, nsamps, dt,
     1                     vcoefs, sig, ch, vrms, vsrms, vism, vit,
     2                     iord, fit, jerr)
 
c----
c   now do the ray tracing and compute angles for the offsets
c----
              if (iem .eq. 0) then
 
                 call crvray (ngrp, angles, timvec, spread, vrms,
     1                        vcoefs, dt, nsamps, mode, vtmax, ierr,
     2                        errparms, vsrms, vism, vit, deg)
              else
                 call creray (ngrp, angles, timvec, spread, vrms,
     1                        vcoefs, dt, nsamps, mode, vtmax, ierr,
     2                        errparms, vsrms, vism, vit, deg)
              endif
c----
c   ray tracing done for this bin (I,J). Now decimate the angle records
c   in time and write to the output R/W file
c----
              do  k = 1, ngrp
 
                  istrc  = (k-1) * nsamps + 1
                  call vmov (angles(istrc), 1, work, 1, nsamps)
                  if (iord .gt. 0)
     1            call SmoothFit ( work, nsamps, iord)
                  ii = 0
                  do  l = 1, nsamps, inca
                      ii = ii + 1
                      angio (ii) = work (l)
                  enddo
 
                  kpntr  = (I - minli) * ndi * ngrp +
     1                     (J - mindi) * ngrp + k
                  call vmov (angio, 1, jhead(ITHWP1), 1, nsmpa)
                  call sisseek (luang, kpntr)
                  call wrtape  (luang, jhead, abytes)
              enddo
 
          ENDDO
      ENDDO
 
1400  CONTINUE

      write(LER,*)'Completed ray tracing for all bins'

      if (halt) then
         write(LER,*)'angst3d stopped after angle file built and after'
         write(LER,*)'normalization file ready for use. You can now'
         write(LER,*)'restart program using -R on cmd line'
         return
      endif

      write(LER,*)'Now reading & dmo-angle stacking traces'


c-----
C *** zero out dmo panel; compute frequency DMO scaling
c-----
      call vclr (dmo, 1, nsamps*iswath)
      call init (dt, w, sincs, nt)
c-----
C *** zero out output and normalization panels
c-----
      call vclr (stk, 1, nang * nsamps)
      call vclr (sum, 1, nang * nsamps)

c-----
C *** READ THE TRACES.                                                  00004650
c-----

 1500 CONTINUE

      IBYTES = IOLEN
      IWRN = 0
      call vclr (trace, 1, nt)

      CALL RTAPE (ITAPIN, JHEAD, IBYTES)
      call vmov  (JHEAD(ITHWP1), 1, TRACE, 1, NSAMPS)

C *** GO TO BEGIN OUTPUT IF END OF INPUT TAPE                           00004710

      IF (IBYTES .EQ. 0) GO TO 5000

      call saver2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            IRREC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            IRTRC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            IDEAD  , TRACEHEADER)
      call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1            IDIST  , TRACEHEADER)

      IF (IRREC .NE. IOLD) THEN
         IOLD  = IRREC
         NRREC = NRREC + 1
         write(LER,*)'DMO-ANGST on Record ',IRREC
      END IF

C *** GET SOURCE TO RECEIVER DISTANCE                                   00004810

      IF (IDEAD .GE. 30000) GO TO 1500

c-----
c  preprocess trace
c-----
      call iwtrace(trace, nsamps, nt, dt, ctrace, w)

      IDIST = IABS (IDIST)

C *** GET SHOT COORDINATE                                               00004930

         call saver2(JHEAD,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY

C *** GET RECEIVER COORDINATE                                           00004980

         call saver2(JHEAD,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY

C *** GET THE CDP COORDINATE (if shot mode we have to compute it)

         ICDPX = 0.5 * float (ISX + IRX) + 0.5
         ICDPY = 0.5 * float (ISY + IRY) + 0.5
         CX = ICDPX
         CY = ICDPY


C *** TRANSLATE SHOT AND RECEIVER INTO GRID COORDINATE SYSTEM

      CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      ISLIMN = MIN (ISLIMN, ISLI)
      ISDIMN = MIN (ISDIMN, ISDI)
      IRLIMN = MIN (IRLIMN, IRLI)
      IRDIMN = MIN (IRDIMN, IRDI)
      ICLIMN = MIN (ICLIMN, ICLI)
      ICDIMN = MIN (ICDIMN, ICDI)
      ISLIMX = MAX (ISLIMX, ISLI)
      ISDIMX = MAX (ISDIMX, ISDI)
      IRLIMX = MAX (IRLIMX, IRLI)
      IRDIMX = MAX (IRDIMX, IRDI)
      ICLIMX = MAX (ICLIMX, ICLI)
      ICDIMX = MAX (ICDIMX, ICDI)
      MINDST = MIN (MINDST, IDIST)
      MAXDST = MAX (MAXDST, IDIST)

C *** COMPUTE PRIMARY DIRECTION OF S/R AZIMUTH RELATIVE TO GRID
C *** COMPUTE offset and check offset limits

      DXT  = SXT - RXT
      DYT  = SYT - RYT
      off  = sqrt ( DXT*DXT + DYT*DYT )
      H    = 0.5 * off

      if (off .gt. DSTMAX) go to 1500
      if (off .lt. DSTMIN) go to 1500

c-----
c  figure out whether the S-R line is primarily in the DI (or X)
c  direction or the LI (orY) direction. this is necessary to
c  calculate the proper step sizes in each direction
c-----
      IF (ABS(DXT) .GE. ABS(DYT)) THEN
         DDX    = DX2
         DDY    = abs (DYT * DDX / DXT )
      ELSE
         DDY    = DY2
         DDX    = abs (DXT * DDY / DYT )
      END IF
c-----
c  based on the orientation of the S-R line we compute the sign
c  of the steps in the X and Y directions. thus we step from
c  the S cell location along the line to the R location.
c-----
      if (DXT .ne. 0.) then
          sgnx = -sign (1.0, DXT)
          DDX  = sgnx * DDX
      endif
      if (DYT .ne. 0.) then
          sgny = -sign (1.0, DYT)
          DDY  = sgny * DDY
      endif

C *** COMPUTE THE TRACE SPACING

      B = SQRT (DDX*DDX + DDY*DDY)

c----
c   if the current midpoint location of this trace is out of bounds
c   skip over any computations and drop to the end of the loop - go
c   back and read a new trace
c----

      IWRN = 0

      IF (ICLI .LT. MINLI) IWRN = 1
      IF (ICLI .GT. MAXLI) IWRN = 1
      IF (ICDI .LT. MINDI) IWRN = 1
      IF (ICDI .GT. MAXDI) IWRN = 1

      IF (IWRN .EQ. 0) THEN

c-----
c  get velocity for the current midpoint cell. each velocity trace
c  must reside at a location corresponding to the output grid. If
c  the velocity trace is coarsely sampled the interpolate.
c-----
              ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
              call sisseek (luvel, ipntr)
              call rtape (luvel, vhead, nvbytes)
              if (nvbytes .eq. 0) then
                 write(LERR,*)'FATAL ERROR in dmoangst3d:'
                 write(LERR,*)'Premature end of velocity data at LI/DI=
     1',ICLI,ICDI
                 write(LERR,*)'Check velocity tape building steps.'
                 stop
              endif
              call vmov (vhead(ITHWP1), 1, vel1, 1, nsmpv)
              if (intrp) then
                 call fcuint (tabl1, vel1, nsmpv, tabl2, vdmo, nsamps,
     1                        iz, zz, icinit)
                 icinit = 0
              else
                 call vmov (vel1, 1, vdmo, 1, nsamps)
              endif

c-----
c  find the pointer into the spread array for the current offset
c-----
          joff = intbin (ngrp, dxg, spread, off)

c-----
c  for current S & R positions find LI & DI cell numbers that lie
c  along this line starting from the S position...
c-----
          nrad = nint ( off / b )
          ic = 0
          offcum = 0.0
          cldii = DDY / DY2
          cllii = DDX / DX2

          do  i = 1, nrad
              offcum = offcum + b
              ddi   = celscl * float(I) * cldii
              dli   = celscl * float(I) * cllii
              icldi = ISDI + nint (ddi)
              iclli = ISLI + nint (dli)
              if (offcum .lt. off) then
                      ic = ic + 1
                      iceldi (ic) = icldi
                      icelli (ic) = iclli
              endif
          enddo
          ncells = ic

c-----
c  find the midpoint along the progression of cells from S to R. If ncells
c  even we need to drop the last cell; if ncells odd we need to move the
c  midpoint to the center
c-----
          if (ncells .ge. 2) then
              if (mod(ncells,2) .eq. 0) then
                  imid = ncells / 2
                  ncells = ncells - 1
              else
                  imid = ncells / 2 + 1
              endif
          else
              imid = ncells
          endif

          if (ncells .gt. iswath) then
             iswath = ncells
             MAXDMO = max (MAXDMO, iswath)
             items  = iswath * nsamps * SZSMPD
             call grealloc (wkdmo, items, ierr1, iabort1)
             call grealloc (wksum, items, ierr2, iabort2)
             if (ierr1 .ne. 0 .OR. ierr2 .ne. 0) then
                write(LER,*)' '
                write(LER,*)'dmoangst3d: FATAL ERROR'
                write(LER,*)'Unable to dmo swath ',ncells,' wide'
                write(LER,*)'because of too much memory.'
                write(LER,*)'Try freeing up some memory in your'
                write(LER,*)'machine or re-run on a larger machine.'
                return
             endif
          endif


c-----
c  pre-compute DMO for current input trace:
c  take current input trace, spray out along dmo ellipse along the cells
c  lying along the line between the current S & R
c  store results in array dmo (contains ncells traces)
c-----
          call born  (trace, dmo, vdmo, nsamps, dt, B, H,
     1                off, angmax, aliasflag, ampflag,
     2                sprdflag, sincs, ncells, iswath, scale, imid)


c-----
c  extract the current dmo summed data swatch from this part of the output
c  volume
c  find the midpoint along the line joining S & R
c  Note: swapping the i's & j's in the ipntr expression below transposes
c        the data (as viewed in time slice domain).

c            ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
c            ipntr =      icd       +       jcl      * ndi + 1
c-----
          IF (ncells .gt. 0) THEN

          imid = 0
          DO  i = 1, ncells

               icldi = iceldi (i)
               iclli = icelli (i)

              IF ( iclli .ge. minli .AND. iclli .le. maxli .AND.
     1             icldi .ge. mindi .AND. icldi .le. maxdi ) THEN

               istr  = (i-1) * nsamps

               jcl = iclli - minli
               icd = icldi - mindi
               ipntr = icd + jcl * ndi + 1

               maxJ = max (maxJ, jcl)
               minJ = min (minJ, jcl)
               maxI = max (maxI, icd)
               minI = min (minI, icd)

c     write(0,*)'R/T, ISLI/DI,IRLI/DI,iclli,icldi= ',
c    1irrec,irtrc,isli,isdi,irli,irdi,iclli,icldi,jcl,icd,ipntr

c-----
c  for each cell location between S & R extract the velocity
c-----
               call sisseek (luvel, ipntr)
               call rtape (luvel, vhead, nvbytes)
               if (nvbytes .eq. 0) then
                  write(LERR,*)'FATAL ERROR in dmoangst3d:'
                  write(LERR,*)'Premature end of velocity data. Check'
                  write(LERR,*)'velocity tape building steps.'
                  stop
               endif
               call vmov (vhead(ITHWP1), 1, vel1, 1, nsmpv)
               if (intrp) then
                  call fcuint (tabl1, vel1, nsmpv, tabl2, V, nsamps,
     1                         iz, zz, icinit)
                  icinit = 0
               else
                  call vmov (vel1, 1, V, 1, nsamps)
               endif

c-----
c  ...for each cell location between S & R extract the velocity...
c  (1) extract the current angle stacked data traces from this cell
c  (2) extract the current normalization traces from this cell
c-----
               call vclr (tab, 1, nsamps)
 
               ipntri = jcl * ndi * nangi +
     1                  icd * nangi + 1
               ic = 0
               do  iu = 1, nu
                  call sisseek (luout(iu) , ipntri)
                  do  k = 1, nangi
                      ic = ic + 1
                      istrc = (ic-1) * nsamps+1
                      call rtape (luout(iu) , jhead, nbytes)
                      call vmov (jhead(ITHWP1), 1, stk(istrc), 1,nsamps)
                  enddo
               enddo
 
               ipntrk  = jcl * ndi * nang  +
     1                   icd * nang
               do  k = 1, nang
                   ipntrk = ipntrk + 1
                   istrc = (k-1) * nsamps+1
c                  read (lunrm, rec = ipntrk) tab
                   call sisseek (lunrm, ipntrk)
                   call vmov    (jhead(ITHWP1), 1, tab, 1, nsamps)
                   call vmov (tab, 1, sum(istrc), 1, nsamps)
               enddo

c-----
c  extract the angle matrix from this cell & expand it
c-----
             jpntr = jcl * ndi * ngrp +
     1               icd * ngrp + joff
 
c            read (luang, rec = jpntr) angio
             call sisseek (luang, jpntr)
             call vmov    (jhead(ITHWP1), 1, angio, 1, nsmpa)

             if (joff .gt. 1) then
 
                jpntr1 = jpntr - 1
                call sisseek (luang, jpntr1)
                call rtape  (luang, jhead, nbytes)
                call vmov   (jhead(ITHWP1), 1, angio1, 1, nsmpa)
                call xtrp   (angio1, work, angio, off, nsmpa,
     1                       spread(joff-1), spread(joff)    )
             endif

             call fcuint (tima, angio, nsmpa, timvec, angles,
     1                    nsamps, iza, zza, icflag)
             icflag = 0

c-----
c  take current input dmo'd trace which has been sprayed into an array
c  of "ncells" traces and stack the samples into the current angle stacks:
c  i.e. for each cell between S & R we take a trace from the dmo array
c  and stack it into the current array of angle stacks according
c  according to which samples lie within the angle range based on the 
c  ray traced angles for the current cell (joff'th offset)
c-----
               istrc = (i-1) * nsamps + 1
               call vmov (dmo(istrc), 1, trace, 1, nsamps)

               call stack (nang, ngrp, nsamps, stk, sum, dt, off,
     1                     trace, angles, angmn, angmx, V, joff,
     2                     norm, reverse)
c-----
c  ...for each cell location between S & R extract the velocity...
c  put new summed swatch back into output volume(s) - matrix stk
c  and update the normalization file
c-----
               ipntri = jcl * ndi * nangi +
     1                  icd * nangi + 1
               ic = 0
               do  iu = 1, nu
                  call sisseek (luout(iu) , ipntri)
                  do  k = 1, nangi
                      ic = ic + 1
                      istrc = (ic-1) * nsamps + 1
                      call vmov (stk(istrc), 1, jhead(ITHWP1), 1,nsamps)
                      call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            0      , TRACEHEADER)
                      call savew2(JHEAD,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                            ICDPX   , TRACEHEADER)
                      call savew2(JHEAD,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                            ICDPY   , TRACEHEADER)
                      call wrtape (luout(iu) , jhead, obytes)
                  enddo
               enddo
 
               ipntrk  = jcl * ndi * nang  +
     1                   icd * nang
               do  k = 1, nang
                   ipntrk = ipntrk + 1
                   istrc  = (k-1) * nsamps+1
c                  call vmov (sum(istrc), 1, tab, 1, nsamps)
c                  write (lunrm, rec = ipntrk) tab
                   call vmov (sum(istrc), 1, jhead(ITHWP1), 1, nsamps)
                   call sisseek (lunrm, ipntrk)
                   call wrtape  (lunrm, jhead, obytes)
               enddo

              ENDIF

           ENDDO

          ENDIF

      if (verbos) then
      write(LERR,*)'S,D,R,bins: ',ISLI,ISDI,ICLI,ICDI,IRLI,IRDI,ncells,
     1 off,B
      endif

      END IF

      go to 1500
 5000 CONTINUE

      write(IPRT,*)' '
      write(IPRT,*)'minJ, maxJ, minI, maxI= ',minJ, maxJ, minI, maxI
      write(IPRT,*)' '

      write(LER,*)' '
      write(LER,*)'Completed dmo-angle stacking...'
      write(LER,*)'... now doing normalization step'
      write(LER,*)' '

c-----
c  re-visit every cell in the output volume(s) [ pointer is ipntri]
c  extract the appropriate normalization trace from the norm file
c  [pointer = ipntr] and apply the norm to the output traces and
c  re-write the data back into the output volume(s)
c-----
      DO  J = mindi, maxdi
          DO  I = minli, maxli
 
              ipntri = (I - minli) * ndi * nangi +
     1                 (J - mindi) * nangi + 1
              ipntr  = (I - minli) * ndi * nang  +
     1                 (J - mindi) * nang
 
                  ic = 0
                  do  k = 1, nang
 
                      ic = ic + 1
                      ipntr = ipntr + 1
                      call sisseek (lunrm, ipntr)
                      call rtape   (lunrm, jhead, nbytes)
                      call vmov (jhead(ITHWP1), 1, tab, 1, nsamps)
                      if (nu .gt. 1) then
                         call sisseek (luout(ic) , ipntri)
                      elseif (nu .eq. 1 .AND. ic .eq. 0) then
                         call sisseek (luout(1) , ipntri)
                      endif
                      call rtape (luout(ic) , jhead, nbytes)
                      call vmov (jhead(ITHWP1), 1, trace, 1, nsamps)
 
                      im = 0
                      detm = .false.
                      do  ii = 1, nsamps
                          xlive = tab (ii)
                          if (xlive .eq. 0.) then
                          if (.not.detm) im = im + 1
                              xlive = 1.
                          else
                              detm = .true.
                              imt  = im * si
                          endif
                          trace (ii) = trace (ii) / (xlive ** divexp)
                          live = nint (xlive)
                          maxfld = max (maxfld, live)
                      enddo

                      call center_xy ( I, J, IX1, IY1, dx, dy, name,
     1                                 XX, XY, YX, YY, XYT, YXT,
     2                                 XXT, YYT, LER, LERR, IXC, IYC,
     3                                 first)
                      call savew2(jhead,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                            IXC , TRACEHEADER)
                      call savew2(jhead,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                            IYC , TRACEHEADER)

                      if (im .eq. nsamps)
     1                call savew2(jhead,ifmt_StaCor,l_StaCor, ln_StaCor,
     2                            30000 , TRACEHEADER)
                      call savew2(jhead,ifmt_VPick1,l_VPick1, ln_VPick1,
     1                            imt , TRACEHEADER)
                      call savew2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            I      , TRACEHEADER)
                      call savew2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            J      , TRACEHEADER)
                      call savew2(jhead,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            I   , TRACEHEADER)
                      call savew2(jhead,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            J   , TRACEHEADER)
 
                      if (nu .gt. 1) then
                         call sisseek (luout(ic) , ipntri)
                      elseif (nu .eq. 1 .AND. ic .eq. 0) then
                         call sisseek (luout(1) , ipntri)
                      endif
                      call vmov (trace, 1, jhead(ITHWP1), 1, nsamps)
                      call wrtape (luout(ic) , jhead, obytes)
                  enddo
          ENDDO
      ENDDO


      WRITE (IPRT, 310) ISLIMN,ISLIMX,ISDIMN,ISDIMX,
     &                  IRLIMN,IRLIMX,IRDIMN,IRDIMX,
     &                  ICLIMN,ICLIMX,ICDIMN,ICDIMX,
     &                  MINDST,MAXDST,MAXDMO,MAXFLD
  310 FORMAT (//, 30X, 'LIMITS FOUND ON DATASET:'
     &        //, 23X, '  MINIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DMO SWATH.. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM STACK REDUNDANCY. . . .',1X,I9  ,//)

      write(LER,*)' '
      write(LER,*)'End of Data:'
      write(LER,*)'DMO-ANGLE STACKED ',NRREC,' records'
      ICC = 0

      RETURN
      END
