C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE RCTDFN(LIN  ,LERR ,NSAMP,NSI,TIME,VEL,LENVEL,LTDRI,
     1 CARD,ICDRDR,IERROR,IEOF)

C THIS SUBROUTINE READS AND VERIFIES A VELOCITY FUNCTION READ    
C FROM TDFN CARD IMAGES.  This is antique and a pain in the @%@%$                                         

      INTEGER INTIM(189), INVEL(189), LASTRI(27), ISEQ(27)                                                 

      REAL  VEL(1), TIME(1)                                                     

      CHARACTER*80 CARD                                                 
      CHARACTER*4 TDFN, COL4

      DATA TDFN/'TDFN'/                                                 
      DATA COL4/'    '/  
                                               

      ICDRDR = 0
C  initialize VELOCITY FUNCTION TIME ARRAY                         

      do i = 1, 189
         intim(i) = 0
         invel(i) = 0
      enddo

C initialize  ERROR FLAG, CARD COUNTER, AND VELOCITY FUNCTION LENGTH      

      IEOF=0
      IERROR=0                                                          
      KOUNT=0                                                           
      LENVEL=0                                                          

C  COME TO HERE FOR READING TDFN CARD FROM CARD READER       

C COMPUTE FIRST AND LAST INDICES OF INPUT TIMES AND         
C VELOCITIES                                                

C SET UPPER LIMIT OF DO FOR 3 SETS OF TDFN CARDS ( A TOTAL
C OF 27 CARDS )  PLUS 1 ( FOR NEXT 1CTFX CARD ).

      DO 6000 KOUNT=1,28
      IND1=(KOUNT-1)*7+1                                                
      IND2=IND1+6                                                       
      IF(ICDRDR.EQ.0) THEN
C                                                                       
C             READ TDFN CARD FROM CARD READER                           
C                                                                       
           READ(LIN,10,END=6100,err=9999) CARD,ISEQ(KOUNT),COL4,
     1     (INTIM(I),INVEL(I),I=IND1,IND2),LASTRI(KOUNT)                
   10      FORMAT(A80,T1,I1,A4,7(I4,I5),7X,I5)                          
C
         ELSE
C
C             READ TDFN CARD FROM INTERNAL FILE ALREADY IN MEMORY FROM
C                  PREVIOUS READ.
C
           READ(UNIT=CARD,FMT=11) ISEQ(KOUNT),COL4,
     1     (INTIM(I),INVEL(I),I=IND1,IND2),LASTRI(KOUNT)                
   11      FORMAT(I1,A4,7(I4,I5),7X,I5)                                 
           ICDRDR=0
      ENDIF
C                                                                       
C             IS CARD JUST READ A TDFN CARD
C                                                                       
      IF(COL4.NE.TDFN) GO TO 6200
C
C             IS LAST RI SAME AS ON FIRST CARD?
C
c     IF(LASTRI(KOUNT).NE.LASTRI(1)) GO TO 6200
C
c     CALL WRCARD(LERR,CARD)
c     call wrcard(card,3,lerr)
C     WRITE(6,8000) CARD
C8000 FORMAT(A80)
C
 6000 CONTINUE
C
C             28 TDFN CARDS WERE READ IN.  EXCEEDS MAX OF 27 CARDS.
C
      WRITE(LERR ,6050)
 6050 FORMAT(//,1X,'THERE ARE MORE THAN 27 TDFN CARDS IN THIS SET.')
      IERROR=1
      RETURN
C
 6100 CONTINUE
C
C             AN END OF FILE WAS READ FROM CARD READER.
C
      IEOF=1                                                            
C
 6200 CONTINUE
C
C             A NON-TDFN CARD WAS READ
C
C             SET CARD READER FLAG TO 1 INDICATING A CARD SHOULD BE
C                  READ FROM INTERNAL FILE
C
      ICDRDR=1
C
C             DECREMENT CARD COUNTER BY 1 TO ACCOUNT FOR EOF OR
C                  NON-TDFN CARD.
C
      KOUNT=KOUNT-1
C                                                                       
C             HAVE ANY TDFN CARDS BEEN READ?   IF NOT - ABEND           
C                                                                       
      IF(KOUNT.GT.0) GO TO 15                                           
C                                                                       
      WRITE(LERR ,1010)                                                 
 1010 FORMAT(//,1X,'TDFN CARDS MISSING FROM CARD SETUP.')               
C                                                                       
      IERROR=1
      RETURN                                                            
C                                                                       
   15 CONTINUE                                                          
C
C                                                                       
C             TDFN CARDS HAVE BEEN READ.  VERIFY DATA ON CARDS.         
C                                                                       
C             VERIFY SEQUENCE NUMBERS
C
      ISEQL=0
      DO 6400 I=1,KOUNT
      ISEQL=ISEQL+1
      IF(ISEQL.GT.9) ISEQL=1
      IF(ISEQL.NE.ISEQ(I)) THEN
        IF(I.NE.KOUNT) THEN
C
C             CARDS MISSING OR OUT OF SEQUENCE
C
         WRITE(LERR ,6350)
 6350    FORMAT(//,1X,'TDFN CARDS MISSING OR OUT OF ORDER.')
         IERROR=1
         RETURN
C
       ENDIF
      ENDIF
C
 6400 CONTINUE
C
C
C             CHECK LAST CARD FOR 9 IN COLUMN 1
C
         IF(ISEQ(KOUNT).NE.9) THEN
              WRITE(LERR ,6355)
 6355         FORMAT(//,1X,'LAST TDFN CARD DOES NOT HAVE A 9 IN',
     1        ' COLUMN 1.')
              IERROR=1
              RETURN
         ENDIF
C
C             VERIFY LAST RECORD NUMBERS
C
      DO 6500 I=2,KOUNT
      IF(LASTRI(I).NE.LASTRI(I-1)) THEN
C
C             LAST RECORD NUMBERS ARE DIFFERENT
C
         WRITE(LERR ,6450)
 6450    FORMAT(//,1X,'LAST RECORD NUMBERS ARE NOT THE SAME.')
         IERROR=1
         RETURN
C
      ENDIF
C
 6500 CONTINUE
C
C
C             NUMBER OF ENTRIES IN VELOCITY FUNCTION ARE BETWEEN
C                  KOUNT*7 AND (KOUNT-1)*7
C
C             KOUNT NUMBER OF ENTRIES IN VELOCITY FUNCTION
C
      MAXNUM=KOUNT*7
      DO 6510 I=2,MAXNUM
         IF(INTIM(I).EQ.0) GO TO 6520
 6510 CONTINUE
      LENVEL=MAXNUM
      GO TO 6540
C
 6520 CONTINUE
C
C             A ZERO TIME WAS FOUND.  BE SURE REST OF FUNCTION IS 0.
C
      LENVEL=I-1
      I1=I+1
      DO 6530 I=I1,MAXNUM
         IF(INTIM(I).GT.0) THEN
              WRITE(LERR ,6525)lastri(kount)
 6525         FORMAT(//,1X,'ZERO TIME APPEARS AFTER THE FIRST ENTRY',
     1        ' IN THE VELOCITY FUNCTION.',i6)
              IERROR=1
              RETURN
         ENDIF
C
 6530 CONTINUE
C
C             NUMENT IS NUMBER OF ENTRIES IN VELOCITY FUNCTION
C
 6540 CONTINUE
C
C             CHECK  ENTRIES FOR INCREASING TIMES
C
      DO 6600 I=2,LENVEL
           IF(INTIM(I).LE.INTIM(I-1)) THEN
                WRITE(LERR ,6550)lastri(kount)
 6550           FORMAT(//,1X,' Times are not increasing in function'
     1          ' number ',i6)
                IERROR=1
                RETURN
           ENDIF
C
 6600 CONTINUE
C
C
      ITRLEN=(NSAMP)*NSI

C             CHECK FOR TIMES EXCEEDING or falling short of TRACE LENGTH
C             (if short, truncate v-function below)
C
      IF(INTIM(LENVEL).GT.ITRLEN) THEN
         WRITE(LERR ,6700) INTIM(LENVEL),ITRLEN
 6700    FORMAT(//,1X,'TIME IN VELOCITY FUNCTION (',I6,' ) EXCEEDS',
     1   ' TRACE LENGTH (',I6,' ).')
         write(LERR,*)'Truncating given function'
      ELSEIF (INTIM(LENVEL) .LT. ITRLEN) THEN
         intim(lenvel+1) = itrlen
         invel(lenvel+1) = invel(lenvel)
         lenvel = lenvel + 1
      ENDIF

C
C             CONVERT TIMES AND VELOCITIES TO REAL
C             and truncate v-function if necessary
C
      DO 7000 I=1,LENVEL

         TIME(I)=INTIM(I)
         VEL(I)=INVEL(I)
 7000 CONTINUE
C
C
C             SET LAST RI TO PROCESS
C
      LTDRI=LASTRI(1)
C
C
      RETURN
 9999 continue

c
c ----- fortran read error on read of tdfn cards  -----
c       probable cause tab characters on the line
c

      ierror=1
      return
      END
