C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stack (nang, ngrp, nsamps, stk, sum, dt, off,
     1                  trace, angles, angmn, angmx, V, J, norm,
     2                  reverse)

#include <f77/lhdrsz.h>

      real     trace (*), V (*)
      real     stk (*), sum (*), angles (*), angmn (*), angmx (*)
      real     wrk2 (SZLNHD)
      logical  norm, reverse

      call vmov (trace, 1, wrk2, 1, nsamps)

c----
c   stack only if data samples are within angle range for this offset
c----
      wrk2 (1) = 0.
      DO  k = 1, nang

          indx = (k-1) * nsamps
          angmnk = angmn(k)
          angmxk = angmx(k)

          do  i = 1, nsamps

              iaddr  = indx  + i
              IF (wrk2(i) .ne. 0.0) THEN

                 if (angles(i) .ge. angmnk .AND.
     1               angles(i) .lt. angmxk      ) then
                     stk (iaddr) = stk (iaddr) + wrk2 (i)
                     sum (iaddr) = sum (iaddr) + 1.0
                 endif

              ENDIF
          enddo

      ENDDO

      return
      end
