C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      	subroutine born0 (trace, dmo, vmap, nt, dt, dx, H,
     1			  offset, sinth, aliasflag, ampflag,
     2			  sprdflag, sincs, mx, mxmax, scale, imid)

*****************************************************************
*
* BORN0 - This sub sprays a single trace into its impulse responses 
*	  in the zero-offset stack data panel. 
*
* Parameters:
*    TRACE()	- input data trace ( pre-processed ) 
*    DMO(,)	- DMO'd zero offset data panel ( outdata )
*    VMAP(,)	- RMS velocity map
*    NT		- number of time samples
*    DT		- time sample rate
*    XMIN	- minimum midpoint coordinate in outdata
*    NX		- number of traces ( midpoints ) in outdata
*    DX		- midpoint spacing in outdata
*    XS		- source coordinate for this trace
*    OFFSET	- full offset for this trace
*    XG		- receiver coordinate for this trace
*    MAXDIP	- maximum anticipated reflector dip
*    ALIASFLAG	- flag to allow aliasing
*			0 = no aliasing allowed
*			1 = process all dips, even aliased ones
*    AMPFLAG	- flag to choose amplitude term
*			0 = Born DMO common amp term
*			1 = Born DMO common offset amp term
*			2 = Kinematic DMO common offset amp term
*			    ( plus spreading corrections )
*    SPRDFLAG	- flag to remove zero-offset spreading
*			0 = output includes zero-offset spreading
*			1 = output has had zero-offset spreading removed
*    SINCS()	- sinc interpolation weights
*    MX		- global dimension: max output traces
*
****************************************************************

*	implicit none
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      	integer aliasflag,	ampflag , mxmax, mx, mx1
	integer	nt,	   	sprdflag

	real 	dt,	dx,	offset,		dmo(nt,mxmax)
	real	sincs(41),	trace(nt),	vmap(nt)
	real	delx

**
* Local integer variables:
*    IMID	- index of midpoint coord 'mid'
*    IT		- input time sample counter 
*    IX		- local trace index 
*    IXMIN	- index of midpoint coord 'xmin'
*    IXOUT	- output trace index
*    IXV	- vmap trace index 
*    MAXX	- max output trace for spreading 
*    MINX	- min output trace for spreading
*
* Local real variables:
*    ALIAS	-   max allowed operator slope ( in time samples per trace )
*    AMP	-   operator amplitude
*    BG		-   xg - x0 ... distance from receiver to output point
*    BGA	-   abs( bg )
*    BG2	-   bg * bg
*    BS		-   xs - x0 ... distance from source to output point
*    BSA	-   abs( bs )
*    BSBG	-   bs * bg
*    BS2	-   bs * bs
*    MID 	-   midpoint of input trace
*    OFFA 	-   abs( offset )
*    OFF2 	-   offa * offa
*    ONE 	-   1.0
*    PI 	-   pi
*    Q  	-   simplifying term
*    RG		-   vector length from receiver to reflection point
*    RG2	-   rg * rg
*    RS		-   vector length from source to reflection point
*    RSPRG	-   rs + rg
*    RSRG	-   rs * rg
*    RS2	-   rs * rs
*    R0		-   vector length from x0 to reflection point
*    R02	-   r0 * r0
*    SCALE	-   constant scale factor
*    SINTH	-   sin( maxdip )
*    T		-   time on input data ( raw reflection time )
*    TMP	-   temporary variable
*    TSLOPE	-   local slope of operator limb for aliasing treatment
*    TWO	-   2.0
*    TWOPI	-   2.0 * pi
*    T0		-   time on output data ( zero-offset time )
*    T2		-   t * t
*    V		-   velocity ( constant )
*    V2		-   v * v
*    X0		-   midpoint coordinate on output data
*    ZERO	-   0.0
*
**

      	integer imid,	it,	ix

	real	alias,	amp,	bg,	 bga,	bg2,	bs,	bsa
	real 	bsbg,	bs2,	mid,	offa,	off2,	pi
	real 	q,	rg,	rg2,	rs,	rsprg,	rsrg,	rs2
	real	r0,	r02,	scale,	sinth,	t,	tmp,	tslope
	real	twopi,	t0,	t2,	v,	v2

        pi    = 3.14159265
        twopi = 6.2831853
	alias = dt / dx 

c 	.. calc some indices 
        mid  = imid * dx
        mx1  = mx + 1
	off2 = offset * offset 
	offa = abs( offset )

c     write(0,*)'nt,mx,dx,dt,imid,off= ',dx,dt,imid,offset,nt,mx

c .. single trace (t,x)-domain algorithm for Born Theory DMO 
	
 
c	.. Loop over input times (raw reflection time) 
      	do 22 it = 1, nt

	    t  = ( it - 1 ) * dt
	    t2 = t * t

c   	    .. if this sample is zero, there is nothing to spread
c	    .. (a tolerance criteria could be inserted here)
	    if ( trace(it) .eq. 0.0 ) goto 22

c   	    .. only output traces between source and receiver
c	    .. can possibly be involved
c	    .. (and use adhoc 80% max aperture rule)

c	    .. Loop over output traces between source and receiver
c	    .. (ix is the MIDPOINT index on the zero offset data)

	    do 23 ix = 1, mx

                delx = iabs(imid - ix) * dx
                
c	    	... get processing velocity for this sample 
	    	v  = vmap (it)
	    	v2 = v*v

c	    	.. set up beta terms
		bs   = -ix * dx
		bs2  = bs * bs
		bg   = (mx1-ix) * dx
		bg2  = bg * bg
		bsbg = bs * bg
		bsa  = abs ( bs )
		bga  = abs ( bg )

		if ( bsbg .eq. 0.0 .OR. off2 .eq. 0.0 ) goto 23

		q = 1.0 - t2*v2 / off2
 
c		.. find t0: impulse response time-intercept 
c		.. on this output trace
		tmp = bsbg * q

c     write(0,*)'bs,bg,bsbg= ',bs,bg,bsbg
c     write(0,*)'it,t2,q,off2= ',it,ix,t2,q,off2,t2*v2

		if ( tmp .le. 0.0 ) goto 23

		t0  = 2.0 * sqrt( tmp ) / v

c     write(0,*)'it,ix,t,bs,bg,t0= ',it,ix,t,bs,bg,t0

c		.. local time-slope of operator limb
		tmp = sqrt( q / bsbg )
		tmp = tmp * ( bs + bg ) / v
		tslope = abs ( tmp )

c     write(0,*)'ix,bs,bg,v,q= ',ix,bs,bg,v,q,delx,t0,tmp,tslope
c     write(0,*)'it,ix,t,bs,bg,t0= ',it,ix,bs,bg,t0

c		.. operator truncation
c		.. 
c		.. 1. to avoid spatial aliasing
		if ( aliasflag .eq. 0 .and. tslope .gt. alias ) then
                    goto 23
                endif

c		.. 2. based on max reflector dip
		if ( tslope .gt. 2.0*sinth/v ) goto 23

		if (ampflag .lt. 0) then
		    amp = 1.0
		    go to 24
		endif
c		.. set up the 'r's
		r0    = v  * t0 / 2.0
		r02   = r0  * r0
		tmp   = 1.0 - r02 / bsbg
		if ( tmp .le. 0.0 ) goto 23
		tmp   = sqrt(tmp)
		rs    = bsa * tmp
		rs2   = rs  * rs
		rg    = bga * tmp
		rg2   = rg  * rg
		rsprg = rs  + rg
		rsrg  = rs  * rg

c		.. choice of amplitude terms 
c		.. 
c		.. inversion theory common shot amplitude term
		if ( ampflag .eq. 0 ) then
		  tmp = r0 * offa * sqrt( offa )
		  tmp = tmp / ( bg2 * sqrt( v*rs*bga ) )
c		  .. mult by 2 since integration variable
c		  .. is xg and dxg = df ( full offset, not midpoint)
		  tmp = 2.0 * tmp

c		.. inversion theory common offset amplitude term
		else if ( ampflag .eq. 1 ) then
		  tmp = r0 * offa * ( rs2 + rg2 )
		  tmp = tmp / ( rg2 * bs2 )
		  tmp = tmp * sqrt( offa / ( v*rg*bsa ) )

c		.. Berg's Kinematic DMO amplitude term
		else if ( ampflag .eq. 2 ) then
		  tmp = 4.0 * ( delx ) * ( delx ) / off2
		  tmp = offa * ( 1.0 - tmp ) / 2.0
		  tmp = sqrt( t0 ) / ( twopi * tmp )
c		  .. GS + IGS corrections
		  tmp = ( rs + rg ) * tmp / ( 2 * r0 )
c		  .. common shot form and compensate for scale
		  tmp = 2.0 * tmp / scale

		end if

c		.. option to remove zero offset geometric spreading
		if ( sprdflag .eq. 1 ) then
		  tmp = tmp * 8.0 * pi * r0
		end if

c		.. final amplitude term
		amp = scale * tmp 

c		.. total numerical value for spreading
 24	    continue

     		amp = trace(it) * amp * dx

c		... find output midpoint index for this trace
c		... use eight-point sinc iterpolation to
c		... add this value to the output data 

                call sincit( dmo(1,ix), amp, t0, 1, nt,
     :                       dt, nt, sincs )

c               itdmo = int (t0 / dt) + 1
c               if (itdmo .ge. 1 .AND. itdmo .le. nt)
c    1          dmo (itdmo,ix) = dmo (itdmo,ix) + amp


 23          continue

 22	continue

	return
	end

      	subroutine born1 (trace, dmo, vmap, nt, dt, dx, H, msx,
     1			  offset, sinth, aliasflag, ampflag, sum,
     2			  sprdflag, sincs, mx, mxmax, scale, imid)

*****************************************************************
*
* BORN0 - This sub sprays a single trace into its impulse responses 
*	  in the zero-offset stack data panel. 
*
* Parameters:
*    TRACE()	- input data trace ( pre-processed ) 
*    DMO(,)	- DMO'd zero offset data panel ( outdata )
*    VMAP(,)	- RMS velocity map
*    NT		- number of time samples
*    DT		- time sample rate
*    XMIN	- minimum midpoint coordinate in outdata
*    NX		- number of traces ( midpoints ) in outdata
*    DX		- midpoint spacing in outdata
*    XS		- source coordinate for this trace
*    OFFSET	- full offset for this trace
*    XG		- receiver coordinate for this trace
*    MAXDIP	- maximum anticipated reflector dip
*    ALIASFLAG	- flag to allow aliasing
*			0 = no aliasing allowed
*			1 = process all dips, even aliased ones
*    AMPFLAG	- flag to choose amplitude term
*			0 = Born DMO common amp term
*			1 = Born DMO common offset amp term
*			2 = Kinematic DMO common offset amp term
*			    ( plus spreading corrections )
*    SPRDFLAG	- flag to remove zero-offset spreading
*			0 = output includes zero-offset spreading
*			1 = output has had zero-offset spreading removed
*    SINCS()	- sinc interpolation weights
*    MX		- global dimension: max output traces
*
****************************************************************

*	implicit none
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      	integer aliasflag,	ampflag , mxmax, mx, mx1
	integer	nt,	   	sprdflag, msx

	real 	dt,	dx,	offset,		dmo(nt,mxmax)
	real	sincs(41),	trace(nt),	vmap(nt)
	real	delx,	sum(nt,msx)

**
* Local integer variables:
*    IMID	- index of midpoint coord 'mid'
*    IT		- input time sample counter 
*    IX		- local trace index 
*    IXMIN	- index of midpoint coord 'xmin'
*    IXOUT	- output trace index
*    IXV	- vmap trace index 
*    MAXX	- max output trace for spreading 
*    MINX	- min output trace for spreading
*
* Local real variables:
*    ALIAS	-   max allowed operator slope ( in time samples per trace )
*    AMP	-   operator amplitude
*    BG		-   xg - x0 ... distance from receiver to output point
*    BGA	-   abs( bg )
*    BG2	-   bg * bg
*    BS		-   xs - x0 ... distance from source to output point
*    BSA	-   abs( bs )
*    BSBG	-   bs * bg
*    BS2	-   bs * bs
*    MID 	-   midpoint of input trace
*    OFFA 	-   abs( offset )
*    OFF2 	-   offa * offa
*    ONE 	-   1.0
*    PI 	-   pi
*    Q  	-   simplifying term
*    RG		-   vector length from receiver to reflection point
*    RG2	-   rg * rg
*    RS		-   vector length from source to reflection point
*    RSPRG	-   rs + rg
*    RSRG	-   rs * rg
*    RS2	-   rs * rs
*    R0		-   vector length from x0 to reflection point
*    R02	-   r0 * r0
*    SCALE	-   constant scale factor
*    SINTH	-   sin( maxdip )
*    T		-   time on input data ( raw reflection time )
*    TMP	-   temporary variable
*    TSLOPE	-   local slope of operator limb for aliasing treatment
*    TWO	-   2.0
*    TWOPI	-   2.0 * pi
*    T0		-   time on output data ( zero-offset time )
*    T2		-   t * t
*    V		-   velocity ( constant )
*    V2		-   v * v
*    X0		-   midpoint coordinate on output data
*    ZERO	-   0.0
*
**

      	integer imid,	it,	ix

	real	alias,	amp,	bg,	 bga,	bg2,	bs,	bsa
	real 	bsbg,	bs2,	mid,	offa,	off2,	pi
	real 	q,	rg,	rg2,	rs,	rsprg,	rsrg,	rs2
	real	r0,	r02,	scale,	sinth,	t,	tmp,	tslope
	real	twopi,	t0,	t2,	v,	v2

        pi    = 3.14159265
        twopi = 6.2831853
	alias = dt / dx 

c 	.. calc some indices 
        mid  = imid * dx
        mx1  = mx + 1
	off2 = offset * offset 
	offa = abs( offset )

c     write(0,*)'nt,mx,dx,dt,imid,off= ',dx,dt,imid,offset,nt,mx

c .. single trace (t,x)-domain algorithm for Born Theory DMO 
	
 
c	.. Loop over input times (raw reflection time) 
      	do 22 it = 1, nt

	    t  = ( it - 1 ) * dt
	    t2 = t * t

c   	    .. if this sample is zero, there is nothing to spread
c	    .. (a tolerance criteria could be inserted here)
	    if ( trace(it) .eq. 0.0 ) goto 22

c   	    .. only output traces between source and receiver
c	    .. can possibly be involved
c	    .. (and use adhoc 80% max aperture rule)

c	    .. Loop over output traces between source and receiver
c	    .. (ix is the MIDPOINT index on the zero offset data)

	    do 23 ix = 1, mx

                delx = iabs(imid - ix) * dx
                
c	    	... get processing velocity for this sample 
	    	v  = vmap (it)
	    	v2 = v*v

c	    	.. set up beta terms
		bs   = -ix * dx
		bs2  = bs * bs
		bg   = (mx1-ix) * dx
		bg2  = bg * bg
		bsbg = bs * bg
		bsa  = abs ( bs )
		bga  = abs ( bg )

		if ( bsbg .eq. 0.0 .OR. off2 .eq. 0.0 ) goto 23

		q = 1.0 - t2*v2 / off2
 
c		.. find t0: impulse response time-intercept 
c		.. on this output trace
		tmp = bsbg * q

c     write(0,*)'bs,bg,bsbg= ',bs,bg,bsbg
c     write(0,*)'it,t2,q,off2= ',it,ix,t2,q,off2,t2*v2

		if ( tmp .le. 0.0 ) goto 23

		t0  = 2.0 * sqrt( tmp ) / v

c     write(0,*)'it,ix,t,bs,bg,t0= ',it,ix,t,bs,bg,t0

c		.. local time-slope of operator limb
		tmp = sqrt( q / bsbg )
		tmp = tmp * ( bs + bg ) / v
		tslope = abs ( tmp )

c     write(0,*)'ix,bs,bg,v,q= ',ix,bs,bg,v,q,delx,t0,tmp,tslope
c     write(0,*)'it,ix,t,bs,bg,t0= ',it,ix,bs,bg,t0

c		.. operator truncation
c		.. 
c		.. 1. to avoid spatial aliasing
		if ( aliasflag .eq. 0 .and. tslope .gt. alias ) then
                    goto 23
                endif

c		.. 2. based on max reflector dip
		if ( tslope .gt. 2.0*sinth/v ) goto 23

		if (ampflag .lt. 0) then
		    amp = 1.0
		    go to 24
		endif

c		.. set up the 'r's
		r0    = v  * t0 / 2.0
		r02   = r0  * r0
		tmp   = 1.0 - r02 / bsbg
		if ( tmp .le. 0.0 ) goto 23
		tmp   = sqrt(tmp)
		rs    = bsa * tmp
		rs2   = rs  * rs
		rg    = bga * tmp
		rg2   = rg  * rg
		rsprg = rs  + rg
		rsrg  = rs  * rg

c		.. choice of amplitude terms 
c		.. 
c		.. inversion theory common shot amplitude term
		if ( ampflag .eq. 0 ) then
		  tmp = r0 * offa * sqrt( offa )
		  tmp = tmp / ( bg2 * sqrt( v*rs*bga ) )
c		  .. mult by 2 since integration variable
c		  .. is xg and dxg = df ( full offset, not midpoint)
		  tmp = 2.0 * tmp

c		.. inversion theory common offset amplitude term
		else if ( ampflag .eq. 1 ) then
		  tmp = r0 * offa * ( rs2 + rg2 )
		  tmp = tmp / ( rg2 * bs2 )
		  tmp = tmp * sqrt( offa / ( v*rg*bsa ) )

c		.. Berg's Kinematic DMO amplitude term
		else if ( ampflag .eq. 2 ) then
		  tmp = 4.0 * ( delx ) * ( delx ) / off2
		  tmp = offa * ( 1.0 - tmp ) / 2.0
		  tmp = sqrt( t0 ) / ( twopi * tmp )
c		  .. GS + IGS corrections
		  tmp = ( rs + rg ) * tmp / ( 2 * r0 )
c		  .. common shot form and compensate for scale
		  tmp = 2.0 * tmp / scale

		end if

c		.. option to remove zero offset geometric spreading
		if ( sprdflag .eq. 1 ) then
		  tmp = tmp * 8.0 * pi * r0
		end if

c		.. final amplitude term
		amp = scale * tmp 

c		.. total numerical value for spreading
 24	    continue

     		amp = trace(it) * amp * dx

c		... find output midpoint index for this trace
c		... use eight-point sinc iterpolation to
c		... add this value to the output data 

                call sinct1( dmo(1,ix), amp, t0, 1, nt,
     :                       sum(1,ix), dt, nt, sincs )

c               itdmo = int (t0 / dt) + 1
c               if (itdmo .ge. 1 .AND. itdmo .le. nt)
c    1          dmo (itdmo,ix) = dmo (itdmo,ix) + amp


 23          continue

 22	continue

	return
	end

