C***********************************************************************00000010
C                                                                       00000020
C     PROGRAM NAME: DM3D  (DIP MOVEOUT FOR 3D DATA)                     00000030
C                                                                       00000040
C     LANGUAGE: FORTRAN                                                 00000050
C                                                                       00000060
C     AUTHOR: G.MURPHY                                                  00000070
C                                                                       00000080
C     DATE WRITTEN: 07/01/88                                            00000090
C                                                                       00000100
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00000120
C                                                                       00000140
C     ABSTRACT: OUTPUT CDP GATHERS WITH PSUEDO TRACE SPACING.           00000150
C                                                                       00000160
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00000170
C                                                                       00000180
C***********************************************************************00000190

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      REAL          TC (63), VC (63)
      REAL          spread (SZLNHD)
      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      CHARACTER*48  CHEAD
      CHARACTER*66  CTITLE
      character     ntap * 256, otap * 256, name*8
      character     vtap * 256, ttap * 256
      integer       aliasflag, ampflag, sprdflag, argis
      logical       verbos, shot, restart, query
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (CHEAD, JHEAD, IHEAD, RHEAD)
      DATA CTITLE/'                      DIP MOVEOUT FOR 3-D DATA       
     &             '/                                                   
      DATA ICRD   /35/
      DATA IBYTES /32256/
      DATA name /'DMOVEL3D'/

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif

      IPRT = LERR

#include <f77/open.h>
 
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argstr( '-v', vtap, ' ', ' ' )
      call argstr( '-T', ttap, ' ', ' ' )

      call getln(ITAPIN, ntap,'r', 0)

      if (.not. restart) then
         call getln(ITAPOT, otap,'w+', -1)
         call getln(ITANRM, ttap,'w+', -1)
      else
         call getln(ITAPOT, otap,'r+', -1)
         call getln(ITANRM, ttap,'r+', -1)
         call rwd  (ITAPOT)
         call rwd  (ITANRM)
      endif

      if (ITAPOT .lt. 1) then
          write(IPRT,*)' '
          write(IPRT,*)'Fatal error in dmovel3d:'
          write(IPRT,*)'Cannot pipe out - use named disk file -O[]'
          stop
      endif
      if (ITANRM .lt. 1) then
          write(IPRT,*)' '
          write(IPRT,*)'Fatal error in dmovel3d:'
          write(IPRT,*)'Cannot pipe out - use named disk file -T[]'
          stop
      endif

      open (unit=ICRD, file = vtap, status='old', iostat=ierr)
      if (ierr .ne. 0) then
         write(LERR,*)'Could not open dmovel3d velocity card file ',vtap
         write(LERR,*)'Check existence'
         stop
      endif


C *** INITIALIZE PROGRAM

      CALL DMLINE (CTITLE, IPRT,   ITAPIN, ITAPOT, ITANRM, NFOLD,
     &             NRECi,  ICC,    IOLEN,  IBYTES, NTRCi,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             RECLEN, NSAMPS, dt, si, restart)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** READ 1DM3D CARD AND ONE TDFN FUNCTION

      CALL DMCARD (IPRT,   ICRD,   NTRCS, NFOLD,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, TC,     VC,    NPAIRS, spread,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3,
     &             IY3, IX4, IY4,  NTPL,  NLI, NDI,
     &             TRCSPC, verbos, shot, dxg,
     &             aliasflag, ampflag, sprdflag)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** PROCESS THE INPUT DATA SET.

      CALL DMTAPE (IPRT,   ITAPIN, ITAPOT, IBYTES, ITANRM,
     &             IREC,   NREC,   IOREC,  ICC,    IOLEN,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, TC, VC, spread,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, dxg,
     &             NSAMPS, IFMT,   SI,     RECLEN, IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, shot, restart,
     &             aliasflag, ampflag, sprdflag, dt, ntrci, nreci)

C *** FINISHED -- CLOSE I/O DEVICES

 9999 CONTINUE

      CALL LBCLOS (ITAPIN)
      CALL LBCLOS (ITAPOT)

      CALL CCEXIT (ICC)

      END
