C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c edit3d ... routine to feed up 3D data in various useful formats for
c            subsequent processing.  Uses database generated by the
c            USP routine dbvec.  Developed by Don Wagner and 
c            Marilyn Miller.
c
c
c Changes:
c
c     April 8/98 -- added policeman to sorting loops to prevent sorting
c                   on single trace receiver or shot station records as
c                   this resulted in a segmentation fault and core dump.
c
c                   also switched offset output to DstSgn from DstUsg to
c                   be compatible with the rest of the 3d world.
c     Garossino
c
c     March 27/98 -- added -liveonly command line option to allow output
c                    of shot or receiver station records with all live
c                    traces only.  This is useful when station indexing is
c                    not sequential in some nonuniform way.
c     Garossino
c
c     June 2/99   -- changed InTrCn to TVPT21 for incremental trace identifier
c                    as InTrCn is going to be used for ProMAX trace identifier
c     Garossino
c
c     August 6, 2001  -- added implicit none, declared all undeclared variables
c                        verified function under FreeUSP, fixed references to
c                        ntap(1:0)
c     Garossino
c
c**********************************************************************c
c
c     declare variables
c
      implicit none
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer nsamp, nsi, ntrc(100), nrec(100), iform
      integer luin(100) , luout, lbytes, nbytes, lbyout
      integer argis, icc, cellct, luns
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_LinInd, l_LinInd, ln_LinInd
      integer ifmt_TVPT21, l_TVPT21, ln_TVPT21
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn

      integer itr  ( SZLNHD ), lhed ( SZLNHD ), rcshout (SZLNHD )

      real      head ( SZLNHD )

      character   ntap(100) * 255, otap * 255, name*6, dbnam*255
      character   rfile*255, sfile*255

      logical verbos
      logical ltrace
      logical xline, sect
      logical ihdflg
      logical rcsort
      logical rfilno, sfilno, old_db
      logical LiveOnly

c variables used in dynamic memory allocation

      integer licell, dicell, cellno
      integer SeqTr, LiInd, DiInd, PartN, PNSeq, CellN
      integer RcSta, ShSta, Offst, jcell, kcell

      pointer (memadr_licell,licell(2))
      pointer (memadr_dicell,dicell(2))
      pointer (memadr_cellno,cellno(2))

      pointer (memadr_SeqTr,SeqTr(2))
      pointer (memadr_LiInd,LiInd(2))
      pointer (memadr_DiInd,DiInd(2))
      pointer (memadr_PartN,PartN(2))
      pointer (memadr_PNSeq,PNSeq(2))
      pointer (memadr_CellN,CellN(2))
      pointer (memadr_RcSta,RcSta(2))
      pointer (memadr_ShSta,ShSta(2))
      pointer (memadr_Offst,Offst(2))
      pointer (memadr_jcell,jcell(2))
      pointer (memadr_kcell,kcell(2))

c variables required by implicit none

      integer jerr, nu, ili1, ili2, idi1, idi2, ili, idi, nli, ndi
      integer ncell, irc1, irc2, irci, ish1, ish2, ishi, iflg
      integer numsro, j, i, nrect
      integer ifmt_NumSmp, l_NumSmp, ln_NumSmp
      integer ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer nwords, kbytes, nligrp, ndigrp, nreco, nrcsta, nshsta
      integer ircl, ieropn, numvec, nseq, nsize, minli, maxli, mindi
      integer maxdi, nlive, ndead, knx, kny, nxy, mxrsct, mxshct
      integer numli, numdi, ierrcd, errcd, abort, iii, icell, mili1
      integer mili2, mili, midi1, midi2, midi, jj, ii, izero, ireco
      integer kreco, kst, ist, kct, kzero, mread, k, ibytes, mxsh_max
      integer itemp, icto, ij, icur, kflg, jfrst, itrct, irsct, kk
      integer jst, jjst, jcount, mst

      real UnitSc 

c initialize variables
      
      equivalence ( itr( 1), head(1), lhed(1) )

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'EDIT3D'/
      data icc / 0 /
 
      rfilno = .false.
      sfilno = .false.
      old_db = .false.

c-----
c     read program parameters from command line card image file
c-----

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0) then
         call help()
         stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln( ntap, otap, verbos, nu,dbnam,sect,
     *     rfile,sfile,
     *     ili1,ili2,idi1,idi2,ili,idi,nli,ndi,ncell,xline,
     *     irc1,irc2,irci,ish1,ish2,ishi,rcsort,iflg,ihdflg,
     *     LiveOnly )

 
cmam........if rfile, then read receiver or shot sta nos to output

      if (rfile(1:1) .ne. ' ' .or. sfile(1:1) .ne. ' ') then
 	 numsro = 0
         do  3 j = 1, SZSMPM
            read (ludisk, *, end=4) rcshout(j)
            numsro = j
 3       continue
 4       continue
      endif

      if(rfile(1:1) .ne. ' ') then
         rfilno = .true.
      elseif(sfile(1:1) .ne. ' ') then
         sfilno = .true.
      endif

c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = ' '
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c     ( getln will assign the last parameter as the unit number if the dataset
c      name is ' ', ie. set up stdin and stdout if no filename are specified )
c-----

      IF (nu .ne. 0) THEN
         do 1 i = 1, nu
            
            call getln(luin(i),ntap(i),'r',0)

            write(LER,*)'ntap= ',i,ntap(i),luin(i)
            if (luin(i) .eq. 0.and.i.gt.1) then
               write(LERR,*)'You specified -Ndataset and -N"blank";'
               write(LERR,*)'you must have a dataset name after each'
               write(LERR,*)'-N you specify.  If you are piping into'
               write(LERR,*)'dbvec, do not use -N on command line'
               write(LER ,*)'You specified -Ndataset and -N"blank";'
               write(LER ,*)'you must have a dataset name after each'
               write(LER ,*)'-N you specify.  If you are piping into'
               write(LER ,*)'dbvec, do not use -N on command line'
               stop
            endif
            call sislgbuf( luin(i), 'off' )

 1       continue
      ELSE
         nu = 1
         call getln(luin(1),ntap(1),'r',0)
         if(luin(1).ne.0) then
            write(LERR,*)'FATAL ERROR:ntap is blank, luin=',luin(1)
            write(LER ,*)'FATAL ERROR:ntap is blank, luin=',luin(1)
            stop
         endif
         if(luin(1).eq.0)call sislgbuf( luin(1), 'off' )
      ENDIF

 
c-----
c     open output data stream
c-----

      call getln(luout, otap,'w', 1)

c-----
c     read line header of input dataset (rtape reads data into vector "itr")
c     lbytes is the number of bytes actually read
c-----

      nrect = 0
      
      do  10 i = 1, nu

         call rtape  ( luin(i), itr, lbytes                  )

         if(lbytes .eq. 0) then
            write(LOT,*)'edit3d: no header read from unit ',luin(i)
            write(LOT,*)'edit3d: partition number=',i
            write(LOT,*)'FATAL'
            stop
         endif
         call hlhprt ( itr , lbytes, name, 6, LERR        )
 10   continue

c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

#include <f77/saveh.h>

      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call saver2(itr,ifmt_NumSmp, l_NumSmp, ln_NumSmp,
     :     nsamp, LINEHEADER)

      nwords = nsamp + ITRWRD
      kbytes = 0

      write(LERR,*)'outputting nwords=',nwords
      
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------
c     format values are:
c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----

      call verbal( ntrc, nrec, ntap, otap, nu,sect,
     *     ili1,ili2,idi1,idi2,ili,idi,nli,ndi,ncell,xline,
     *     irc1,irc2,irci,ish1,ish2,ishi,rcsort,iflg,ihdflg,
     *     rfile,sfile, LiveOnly )
 

cmam.....check iflg:1=retrieve by li,di; 2=retrieve by receiver sta;
cmam			3=retrieve by shot station.

      IF (iflg.eq.1) then

cmam........sort by li/di
cmam.........modify output header values

         nligrp = 0

         if(ili.gt.0) then
	
            do 300 i = ili1,ili2,ili
               nligrp = nligrp + 1
 300        continue
         endif

         if(nligrp.eq.0) nligrp = 1
         write(LER,*)'nligrp =',nligrp
         write(LERR,*)'nligrp =',nligrp
         write(LERR,*)'ili1,ili2,ili=',ili1,ili2,ili

         ndigrp = 0
         if(idi.gt.0) then
            
            do 301 i = idi1,idi2,idi
               ndigrp = ndigrp + 1
 301        continue
         endif

         if(ndigrp.eq.0) ndigrp = 1
         write(LER,*)'ndigrp =',ndigrp
         write(LERR,*)'ndigrp =',ndigrp
         write(LERR,*)'idi1,idi2,idi=',idi1,idi2,idi
         nreco = (nligrp*nli) * (ndigrp*ndi)

      ELSEIF (iflg.eq.2) then

cmam......sort by receiver station

         nrcsta = 0

         do i = irc1,irc2,irci
            nrcsta = nrcsta + 1
         enddo
         write(LERR,*)'nrcsta=',nrcsta
         write(LERR,*)'irc1,irc2,irci=',irc1,irc2,irci
         nreco = nrcsta

      ELSE

cmam......sort by shot station

         nshsta = 0

         do i = ish1,ish2,ishi
            nshsta = nshsta + 1
         enddo
         write(LERR,*)'nshsta=',nshsta
         write(LERR,*)'ish1,ish2,ishi=',ish1,ish2,ishi
         nreco = nshsta

      ENDIF

      write(LER,*)'nreco=',nreco
      write(LERR,*)'nreco=',nreco
      
cmam.....now we have to read the selected vectors into core

      call alloclun (luns)
      ircl = 15 * SZSMPD

      open(luns,file=dbnam,status='unknown',
     :     access='direct', form = 'unformatted',
     :     recl = ircl, err = 302, iostat = ieropn )

      go to 303

 302  write(LERR,*)'error opening database:',ieropn
      write(LERR,*)'FATAL: cannot open database file=',dbnam
      write(LERR,*)'       job terminating; check database filename.'
      write(LER, *)'error opening database:',ieropn
      write(LER, *)'FATAL: cannot open database file=',dbnam
      write(LER, *)'       job terminating; check database filename.'
      stop 302

 303  continue
      write(LER,*)'database open:',dbnam
      write(LERR,*)'database open:',dbnam

cmam......read no. of vectors, no.of sequential traces, no. live traces,
cmam........min and max li, and min and max di on input dataset

      write(LERR,*)'reading rec 1 from database'
      write(LER ,*)'reading rec 1 from database'

      read(luns,rec=1) numvec,nseq,nsize,minli,maxli,mindi,maxdi,
     :     nlive, ndead, cellct, knx, kny, nxy, mxrsct, mxshct

      if(mxshct.eq.0) old_db = .true.

      numli = knx
      numdi = kny

      write(LERR,*)'read:nsize,minli,maxli,mindi,maxdi,cellct=',
     :     nsize,minli,maxli,mindi,maxdi,cellct
      write(LERR,*)'    mxrsct, mxshct=',mxrsct, mxshct
      write(LERR,*)'computed:numli,numdi=',numli,numdi
      write(LER,*)'read:nsize,minli,maxli,mindi,maxdi,cellct=',
     :     nsize,minli,maxli,mindi,maxdi,cellct
      write(LER,*)'    mxrsct, mxshct=',mxrsct, mxshct
      write(LER,*)'computed:numli,numdi=',numli,numdi

      close(luns)

      ircl = nsize * SZSMPD
      open(luns,file=dbnam,status='unknown',
     :     access='direct', form = 'unformatted',
     :     recl = ircl, err = 304, iostat = ieropn )

      go to 305

 304  write(LERR,*)'error opening database:',ieropn
      write(LER, *)'error opening database:',ieropn
 305  continue
      write(LER,*)'database open:',dbnam
      write(LERR,*)'database open:',dbnam

      ierrcd = 1
      call galloc (memadr_SeqTr, nsize * SZSMPD, errcd, abort)
      if(errcd .ne. 0) go to 100
      write(LER,*)'allocated SeqTr space'
      write(LERR,*)'allocated SeqTr space'
      ierrcd = ierrcd + 1

      call galloc (memadr_PartN, nsize * SZSMPD, errcd, abort)
      if(errcd .ne. 0) go to 100
      write(LER,*)'allocated PartN space'
      write(LERR,*)'allocated PartN space'
      ierrcd = ierrcd + 1

      call galloc (memadr_PNSeq, nsize * SZSMPD, errcd, abort)
      if(errcd .ne. 0) go to 100
      write(LER,*)'allocated PNSeq space'
      write(LERR,*)'allocated PNSeq space'
      ierrcd = ierrcd + 1

cmam..........allocate arrays for li,di retrieval

      IF (iflg.eq.1) then

         call galloc (memadr_CellN, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated CellN space'
         write(LERR,*)'allocated CellN space'
         ierrcd = ierrcd + 1

         call galloc (memadr_kcell, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated kcell space'
         write(LERR,*)'allocated kcell space'
         ierrcd = ierrcd + 1

         call galloc (memadr_jcell, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated jcell space'
         write(LERR,*)'allocated jcell space'
         ierrcd = ierrcd + 1

cmam.........allocate arrays for rec.sta. retrieval
cmam		use same arrays for shot station retrieval

      ELSE

cmam........iflg .ne. 1

         call galloc (memadr_CellN, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated CellN space'
         write(LERR,*)'allocated CellN space'
         ierrcd = ierrcd + 1

         call galloc (memadr_RcSta, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated RcSta space'
         write(LERR,*)'allocated RcSta space'
         ierrcd = ierrcd + 1

         call galloc (memadr_Offst, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated Offst space'
         write(LERR,*)'allocated Offst space'
         ierrcd = ierrcd + 1

         call galloc (memadr_ShSta, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated ShSta space'
         write(LERR,*)'allocated ShSta space'
         ierrcd = ierrcd + 1

         call galloc (memadr_DiInd, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated DiInd space'
         write(LERR,*)'allocated DiInd space'
         ierrcd = ierrcd + 1

         call galloc (memadr_LiInd, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         write(LER,*)'allocated LiInd space'
         write(LERR,*)'allocated LiInd space'
         
      ENDIF

      go to 110

 100  continue
      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR occurred.'
      write(LERR,*)'Unable to allocate workspace for vectors:'
      write(LERR,*)'  Error occurred allocating vector ',ierrcd
      write(LERR,*)'  Need 23 vectors of size=',nrect*SZSMPD,
     :     ' bytes each'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'FATAL ERROR occurred.'
      write(LER,*)'Unable to allocate workspace for vectors:'
      write(LER,*)'  Error occurred allocating vector ',ierrcd
      write(LER,*)'  Need 23 vectors of size=',nrect*SZSMPD,
     :     ' bytes each'
      write(LER,*)' '

      go to 333
cmam...........vector space allocated -- proceed

 110  continue
      write(LER,*)'allocated junke space'
      write(LER,*)'nsize=',nsize
      write(LER,*)'ready to read vectors from database'
      write(LERR,*)'allocated junke space'
      write(LERR,*)'nsize=',nsize
      write(LERR,*)'ready to read vectors from database'

cmam.....read SeqTr
      write(LER,*)'reading SeqTr'
      write(LERR,*)'reading SeqTr'
      read(luns,rec=2,err=399) (SeqTr(i),i=1,nsize)

cmam......read PartN
      write(LER,*)'reading PartN'
      write(LERR,*)'reading PartN'
      read(luns,rec=3,err=399) (PartN(i),i=1,nsize)
 
cmam......read PNSeq
      write(LER,*)'reading PNSeq'
      write(LERR,*)'reading PNSeq'
      read(luns,rec=4,err=399) (PNSeq(i),i=1,nsize)
 
      IF (iflg.eq.1) then

cmam......read CellN
         write(LER,*)'reading CellN'
         write(LERR,*)'reading CellN'
         read(luns,rec=5,err=399) (CellN(i),i=1,nsize)

         write(LER ,*)'reading kcell'
         write(LERR,*)'reading kcell'
         read(luns,rec=9,err=399) (kcell(i),i=1,nxy)

         write(LER ,*)'reading jcell'
         write(LERR,*)'reading jcell'
         read(luns,rec=10,err=399) (jcell(i),i=1,nxy)

      ELSE

cmam..........iflg .ne. 1
cmam..........read vectors for rec.sta. or shot sta. retrieval
cmam......read CellN ... 5-28-96 per d.wagner report of problem

         write(LER,*)'reading CellN'
         write(LERR,*)'reading CellN'
         read(luns,rec=5,err=399) (CellN(i),i=1,nsize)

         write(LER,*)'reading RcSta'
         write(LERR,*)'reading RcSta'
         read(luns,rec=7,err=399) (RcSta(i),i=1,nsize)

         write(LER ,*)'reading ShSta'
         write(LERR,*)'reading ShSta'
         read(luns,rec=8,err=399) (ShSta(i),i=1,nsize)
         
         write(LER ,*)'reading Offst'
         write(LERR,*)'reading Offst'
         read(luns,rec=6,err=399) (Offst(i),i=1,nsize)

      ENDIF

      go to 398

 399  write(LERR,*)'error reading database - terminating job'
      write(LER ,*)'error reading database - terminating job'
      stop
 398  continue

cmam......close the database file

      close(luns)
 
      IF (iflg.eq.1) then

cmam.........retrieval based on li,di or cell no.
cmam.....sort the vectors into ascending CellN order

         if(nsize.gt.1) call isort3(nsize, CellN, PartN, PNSeq)

         do 123 iii = 1,nsize
            if(CellN(iii).gt.0) go to 124
 123     continue

         go to 333

 124     write(LER,*)'first nonzero CellN=',CellN(iii),' at ',iii
         write(LERR,*)'first nonzero CellN=',CellN(iii),' at ',iii
	 
cmam....allocate space for defining the cells to retrieve

         ierrcd = 0
         call galloc(memadr_licell, nreco * SZSMPD, errcd, abort)
         if(errcd.ne.0)go to 170
         call galloc(memadr_dicell, nreco * SZSMPD, errcd, abort)
         if(errcd.ne.0)go to 170
         call galloc(memadr_cellno, nreco * SZSMPD, errcd, abort)
         if(errcd.eq.0)go to 180
 170     continue
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR occurred.'
         write(LERR,*)'Unable to allocate workspace for vectors:'
         write(LERR,*)'  Error occurred allocating vector ',ierrcd
         write(LERR,*)'  Need 23 vectors of size=',nrect*SZSMPD,
     :        ' bytes each'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'FATAL ERROR occurred.'
         write(LER,*)'Unable to allocate workspace for vectors:'
         write(LER,*)'  Error occurred allocating vector ',ierrcd
         write(LER,*)'  Need 23 vectors of size=',nrect*SZSMPD,
     :        ' bytes each'
         write(LER,*)' '
         go to 333

 180     continue
 
cmam....set up arrays for cells to be retrieved
         icell = 0

         if(ili.eq.0) then
            mili1 = ili1
            mili2 = ili1
            mili  = 1
         else
            mili1 = ili1
            mili2 = ili2
            mili  = ili
         endif
         
         if(idi.eq.0) then
            midi1 = idi1
            midi2 = idi1
            midi  = 1
         else
            midi1 = idi1
            midi2 = idi2
            midi  = idi
         endif

         if(xline) then
cmam..........retrieve in crossline direction
            if(sect) then
cmam............retrieve by adjacent pieces

               do 413 j = midi1, midi2, midi
                  do 412 i = mili1, mili2, mili
                     do 415 jj = j, j+ndi-1
                        do 414 ii = i, i+nli-1
cmam.......check that requested cell is in bounds of survey

                           if(ii.gt.numli.or.jj.gt.numdi) then
                              write(LER,*)'requested cell out of bounds'
     :                             ,':  LI,DI=',ii,jj,'  numli,numdi=',
     :                             numli,numdi
                              go to 414
                           endif

                           icell = icell + 1
                           licell(icell) = ii
                           dicell(icell) = jj
                           cellno(icell) = (ii-1) * numdi + jj
 414                    continue
 415                 continue
 412              continue
 413           continue

            else
               do 403 j = midi1, midi2, midi
                  do 402 jj = j, j+ndi-1
                     do 405 i = mili1, mili2, mili
                        do 404 ii = i, i+nli-1
c     mam.......check that requested cell is in bounds of survey

                           if(ii.gt.numli.or.jj.gt.numdi) then
                              write(LER,*)'requested cell out of bounds'
     :                             ,':  LI,DI=',ii,jj,'  numli,numdi=',
     :                             numli,numdi
                              go to 404
                           endif
                           icell = icell + 1
                           licell(icell) = ii
                           dicell(icell) = jj
                           cellno(icell) = (ii-1) * numdi + jj
 404                    continue
 405                 continue
 402              continue
 403           continue
            endif

         else
cmam..........retrieve in inline direction
            if(sect) then
cmam.......retrieve by adjacent pieces
               do 215 i = mili1, mili2, mili
                  do 214 j = midi1, midi2, midi
                     do 213 ii = i, i+nli-1
                        do 212 jj = j, j+ndi-1
cmam.......check that requested cell is in bounds of survey

                           if(ii.gt.numli.or.jj.gt.numdi) then
                              write(LER,*)'requested cell out of bounds'
     :                             ,':  LI,DI=',ii,jj,'  numli,numdi=',
     :                             numli,numdi
                              go to 212
                           endif
                           icell = icell + 1
                           licell(icell) = ii
                           dicell(icell) = jj
                           cellno(icell) = (ii-1) * numdi + jj
 212                    continue
 213                 continue
 214              continue
 215           continue

            else
               do 205 i = mili1, mili2, mili
                  do 204 ii = i, i+nli-1
                     do 203 j = midi1, midi2, midi
                        do 202 jj = j, j+ndi-1
c     mam.......check that requested cell is in bounds of survey
                           if(ii.gt.numli.or.jj.gt.numdi) then
                              write(LER,*)'requested cell out of bounds'
     :                             ,':  LI,DI=',ii,jj,'  numli,numdi=',
     :                             numli,numdi
                              go to 202
                           endif
                           icell = icell + 1
                           licell(icell) = ii
                           dicell(icell) = jj
                           cellno(icell) = (ii-1) * numdi + jj
 202                    continue
 203                 continue
 204              continue
 205           continue
            endif
         endif
	
         nreco = icell

cmam......write the output lineheader 
         if(ncell.eq.0) ncell = cellct
         call savew(itr,'NumRec',nreco,LINHED)
         call savew(itr,'NumTrc',ncell,LINHED)
 
         call wrtape ( luout, itr, lbyout  )

	write(LERR,*)'writing output lineheader'

cmam.........fix for crayj90
cmam........get length of trace to write out
	call rtape (luin(1),itr,kbytes)


	izero = 0
	ireco = 0

cmam....loop on number of cells to output
	kreco = 0
	kst = 1

cmam........set up a flag to write out first ri,tr that is not dead
	ltrace = .true.

cmam...........loop on cells to retrieve
	do 350 i = 1,icell
           kreco = kreco + 1
           ist = jcell(cellno(i))
           kct = kcell(cellno(i))
           
           if(kct.eq.0) then
cmam........no traces for this cell -- output zero traces
              
              do 310 j = 1,ncell

                 call vclr(itr,1,nwords)

                 call savew2(itr,ifmt_RecNum, l_RecNum, ln_RecNum,
     :                kreco, TRACEHEADER)
                 call savew2(itr,ifmt_LinInd, l_LinInd, ln_LinInd,
     :                licell(i), TRACEHEADER)
                 call savew2(itr,ifmt_DphInd, l_DphInd, ln_DphInd,
     :                dicell(i), TRACEHEADER)
                 call savew2(itr,ifmt_TVPT21, l_TVPT21, ln_TVPT21,
     :                cellno(i), TRACEHEADER)
                 call savew2(itr,ifmt_StaCor, l_StaCor, ln_StaCor,
     :                30000, TRACEHEADER)
                 call savew2(itr,ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                j, TRACEHEADER)
                 call wrtape (luout, itr,kbytes)
 310          continue

              go to 350
           endif

           if(kct.lt.ncell) then
              kzero = ncell - kct
              mread = kct
           else
              kzero = 0
              mread = ncell
           endif

cmam....................retrieve traces.......
           do 315 k = 1, mread
              call sisseek ( luin(PartN(ist)), PNSeq(ist) )

              call rtape (luin(PartN(ist)),itr,ibytes)
 
              call savew2(itr,ifmt_RecNum, l_RecNum, ln_RecNum,
     :             kreco, TRACEHEADER)

cmam......check flag for updating LinInd,DphInd in TraceHeader

              if(.not.ihdflg) then
                 call savew2(itr,ifmt_LinInd, l_LinInd, ln_LinInd,
     :                licell(i), TRACEHEADER)
                 call savew2(itr,ifmt_DphInd, l_DphInd, ln_DphInd,
     :                dicell(i), TRACEHEADER)
              endif

              call savew2(itr,ifmt_TVPT21, l_TVPT21, ln_TVPT21,
     :             CellN(ist), TRACEHEADER)
              call savew2(itr,ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :             k, TRACEHEADER)

              call wrtape (luout, itr,ibytes)

cmam.........check ltrace flag
              if(ltrace) then
                 ltrace = .false.
                 write(LER,*)'1st good ri,tr=',kreco,k,'  cell,prt,sq=',
     :                CellN(ist),PartN(ist),PNSeq(ist)
                 write(LERR,*)'1st good ri,tr=',kreco,k,' cell,prt,sq=',
     :                CellN(ist),PartN(ist),PNSeq(ist)
              endif

              ist = ist + 1
 315       continue

           if(kzero.gt.0) then
              do 320 k = mread+1, ncell

cmam......ran out of traces on input ... put out zero traces to fill cell
                 call vclr(itr,1,nwords)
                 call savew2(itr,ifmt_RecNum, l_RecNum, ln_RecNum,
     :                kreco, TRACEHEADER)
                 call savew2(itr,ifmt_LinInd, l_LinInd, ln_LinInd,
     :                licell(i), TRACEHEADER)
                 call savew2(itr,ifmt_DphInd, l_DphInd, ln_DphInd,
     :                dicell(i), TRACEHEADER)
                 call savew2(itr,ifmt_TVPT21, l_TVPT21, ln_TVPT21,
     :                cellno(i), TRACEHEADER)
                 call savew2(itr,ifmt_StaCor, l_StaCor, ln_StaCor,
     :                30000, TRACEHEADER)
                 call savew2(itr,ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                k, TRACEHEADER)
 
                 call wrtape (luout, itr,kbytes)

 320          continue
           endif

 350    continue

      ELSE

cmam..............RETRIEVAL BASED ON RECEIVER OR SHOT STATION

         if (iflg.eq.2) then

cmam...........sort on receiver stations

            if ( nsize .gt. 1 ) then
               if(rcsort) then
                  call isort4 (nsize,RcSta,SeqTr,ShSta,Offst)
               else
                  call isort3 (nsize,RcSta,SeqTr,Offst)
               endif
            endif

         else

cmam...........sort on shot stations
         
            if ( nsize .gt. 1 ) then
               if(rcsort) then
                  call isort4 (nsize,ShSta,SeqTr,RcSta,Offst)
               else
                  call isort3 (nsize,ShSta,SeqTr,Offst)
               endif
            endif

         endif
         
cmam......write the output lineheader

         if(rfile.ne.' ' .or. sfile.ne.' ') nreco = numsro
         call savew(itr,'NumRec',nreco,LINHED)

         if(iflg.eq.2) then

            call savew(itr,'NumTrc',mxrsct,LINHED)
         else
c     mam......if using old database, we have to compute mxshct

            if(old_db) then

               do 417 i = 1,nsize

                  if(ShSta(i).ne.0) then
                     j = i+1
                     go to 418
                  endif
 417           continue
 418           mxsh_max = 1
               itemp = ShSta(j-1)
               do 419 i = j,nsize
                  if(ShSta(i).eq.itemp) then
                     mxsh_max = mxsh_max + 1
                  else
                     if(mxsh_max.gt.mxshct) mxshct = mxsh_max
                     mxsh_max = 1
                     itemp = ShSta(i)
                  endif
 419           continue
               mxshct = mxsh_max

            endif

cmam.......end of computing mxshct

            call savew(itr,'NumTrc',mxshct,LINHED)
         endif
 
         call wrtape ( luout, itr, lbyout  )

         write(LERR,*)'writing output lineheader'

cmam.........fix for crayj90
cmam........get length of trace to write out

         call rtape (luin(1),itr,kbytes)

         if(iflg.eq.2) then

cmam.......receiver station sort
cmam......check for flat file input

            if(rfile .ne. ' ') then

cmam.......flat file to match against

               icto = 0
               ij = 1

               do ii = 1, numsro
                  icur = rcshout(ii)
                  kflg = 0

                  if(icur.lt.RcSta(ij) ) then
                     if(ij.eq.1) then

cmam...asking for a RcSta that is lt what is on dataset -- output zero traces
                        go to 497
                     else

cmam...reset ij to start search at beginning RcSta value
                        ij = 1
                     endif
                  endif

cmam.......come here after a match was found and output...
 485              continue

cmam...search for matches
                  do jj = ij, nsize
                     if(icur.eq.RcSta(jj) ) then

cmam....found first match
                        jfrst = jj
                        kflg = 1

cmam....increment output record counter
                        icto = icto + 1
                        itrct = 0
                        irsct =0
                        do kk = jj,nsize
                           if(icur.eq.RcSta(kk) ) then
                              irsct = irsct + 1
                           else

cmam....icur no longer equal -- we're thru with this RcSta -- go put out traces
                              go to 486
                           endif
                        enddo

 486                    if(irsct.eq.0) go to 497

cmam....found some matches--sort as directed
                        ij = jj + irsct

                        if ( irsct .gt. 1 ) then
                           if(rcsort)then

cmam.....sort RcSta by ShSta
                              call isort4(irsct,ShSta(jfrst),
     :                             SeqTr(jfrst), Offst(jfrst), 
     :                             RcSta(jfrst) )
                           else

cmam.....sort RcSta by Offst
                              call isort3(irsct,Offst(jfrst),
     :                             SeqTr(jfrst), RcSta(jfrst) )
                           endif
                        endif

cmam....put out traces
                        jst = jfrst

                        do kk = 1,irsct
                           jjst = SeqTr(jst)
                           call sisseek ( luin(PartN(jjst)), 
     :                          PNSeq(jjst) )
                           call rtape (luin(PartN(jjst)),itr,ibytes)
 
                           call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                          ln_RecNum, icto, TRACEHEADER)

cmam......check flag for updating LinInd,DphInd in TraceHeader

                           if(.not.ihdflg) then
                              call savew2(itr,ifmt_LinInd, l_LinInd, 
     :                             ln_LinInd, LiInd(jjst), TRACEHEADER)
                              call savew2(itr,ifmt_DphInd, l_DphInd, 
     :                             ln_DphInd, DiInd(jjst), TRACEHEADER)
                           endif

                           call savew2(itr,ifmt_TVPT21, l_TVPT21, 
     :                          ln_TVPT21, CellN(jjst), TRACEHEADER)
                           call savew2(itr,ifmt_DstSgn, l_DstSgn, 
     :                          ln_DstSgn, Offst(jst), TRACEHEADER)

                           call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                          ln_TrcNum, kk, TRACEHEADER)
                           
                           call wrtape (luout, itr,ibytes)
                           jst = jst + 1
                        enddo

                        if(kflg.eq.1 .and. irsct.lt.mxrsct) then

cmam......need to fill record with zero traces
                           call vclr(itr,1,nwords)

                           do kk = irsct+1, mxrsct
                              call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                             ln_RecNum, icto, TRACEHEADER)
                              call savew2(itr,ifmt_StaCor, l_StaCor, 
     :                             ln_StaCor, 30000, TRACEHEADER)
                              call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                             ln_TrcNum, kk, TRACEHEADER)
                              
                              call wrtape (luout, itr,kbytes)
                           enddo
		  
                        endif

cmam......check here to see if match has been found and output
                        
                        if(irsct.gt.0) go to 485
                     endif
                  enddo

 497              continue

                  if(kflg.eq.0) then
                     write(LERR,*)'no traces found matching RcSta=',icur
                     write(LERR,*)'a record of ',mxrsct,
     :                    ' zero traces will be output'
                     call vclr(itr,1,nwords)

cmam....increment output record counter
                     icto = icto + 1
                     do kk = 1, mxrsct
                        call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                       ln_RecNum, icto, TRACEHEADER)
                        call savew2(itr,ifmt_StaCor, l_StaCor, 
     :                       ln_StaCor, 30000, TRACEHEADER)
                        call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                       ln_TrcNum, kk, TRACEHEADER)
                        
                        call wrtape (luout, itr,kbytes)
                     enddo
                  endif
               enddo
            else

cmam......no flat file to match against
               kst = 1
               kreco = 0

               do 420 i = irc1, irc2, irci
                  kreco = kreco + 1

                  do j = kst,nsize
                     
                     if(RcSta(j).eq.i) then
                        jst = j

                        write(ler,*)' Receiver Station ',i, ' output'
                        go to 422
                     endif
                  enddo

                  if ( LiveOnly ) then
cpgag....no receiver station match...skip to next rec stat

                     write(ler,*)' Receiver Station ',i,'empty..skipped'
                     jcount = 0
                     go to 420
                  else

cmam....no receiver station match...put out zero record
                     jcount = 0
                     go to 426
                  endif

cmam....found a match
 422              jcount = 0
                  mst = jst
           
 424              continue

                  if(RcSta(mst).eq.i) then
                     jcount = jcount + 1
                     mst = mst + 1
                     if(jcount.lt.mxrsct) go to 424
                  endif

cmam........do secondary sort 
c pgag       if more than a single trace

                  if ( jcount .gt. 1 ) then
                     if(rcsort) then
                        call isort4( jcount, ShSta(jst), SeqTr(jst),
     :                       Offst(jst), RcSta(jst) )
                     else
                        call isort3( jcount, Offst(jst), SeqTr(jst), 
     :                       RcSta(jst) )
                     endif
                  endif

cmam.........retrieve found traces, output to file
                  do j = 1,jcount
                     jjst = SeqTr(jst)
                     call sisseek ( luin(PartN(jjst)), PNSeq(jjst) )
                     call rtape (luin(PartN(jjst)),itr,ibytes)
 
                     call savew2(itr,ifmt_RecNum, l_RecNum, ln_RecNum,
     :                    kreco, TRACEHEADER)

cmam......check flag for updating LinInd,DphInd in TraceHeader

                     if(.not.ihdflg) then
                        call savew2(itr,ifmt_LinInd, l_LinInd, 
     :                       ln_LinInd, LiInd(jjst), TRACEHEADER)
                        call savew2(itr,ifmt_DphInd, l_DphInd, 
     :                       ln_DphInd, DiInd(jjst), TRACEHEADER)
                     endif

                     call savew2(itr,ifmt_TVPT21, l_TVPT21, ln_TVPT21,
     :                    CellN(jjst), TRACEHEADER)
                     call savew2(itr,ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :                    Offst(jst), TRACEHEADER)
                     call savew2(itr,ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                    j, TRACEHEADER)
 
                     call wrtape (luout, itr,ibytes)
 
                     jst = jst + 1
                  enddo

cmam...........fill up with zero traces

                  kst = jst

 426              if(jcount.lt.mxrsct) then
                     call vclr(itr,1,nwords)

                     do j = jcount+1, mxrsct
                        call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                       ln_RecNum, kreco, TRACEHEADER)
                        call savew2(itr,ifmt_RecInd, l_RecInd, 
     :                       ln_RecInd, i, TRACEHEADER)
                        call savew2(itr,ifmt_StaCor, l_StaCor, 
     :                       ln_StaCor, 30000, TRACEHEADER)
                        call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                       ln_TrcNum, j, TRACEHEADER)
 
                        call wrtape (luout, itr,kbytes)

                     enddo
                  endif
 420           continue

cmam...........end of receiver station sort

            endif
            
         else

cmam...........shot station sort
cmam......check for flat file input

            if(sfile .ne. ' ') then

cmam.......flat file to match against

               icto = 0
               ij = 1
               do ii = 1, numsro
                  icur = rcshout(ii)
                  kflg = 0
                  
                  if(icur.lt.ShSta(ij) ) then
                     if(ij.eq.1) then
                        go to 597
                     else
                        ij = 1
                     endif
                  endif

 585              continue
 
                  do jj = ij, nsize

                     if(icur.eq.ShSta(jj) ) then
                        jfrst = jj
                        kflg = 1
                        icto = icto + 1
                        irsct = 0

                        do kk = jj,nsize
                           if(icur.eq.ShSta(kk) ) then
                              irsct = irsct + 1
                           else
                              go to 586
                           endif
                        enddo

 586                    if(irsct.eq.0) go to 597
                        ij = jj + irsct

                        if ( irsct .gt. 1 ) then
                           if(rcsort) then
cmam.....sort ShSta by RcSta
                              call isort4(irsct,RcSta(jfrst),
     :                             SeqTr(jfrst), Offst(jfrst), 
     :                             ShSta(jfrst) )
                           else
cmam.....sort ShSta by Offst
                              call isort3(irsct,Offst(jfrst),
     :                             SeqTr(jfrst), ShSta(jfrst) )
                           endif
                        endif
cmam....put out traces

                        jst = jfrst

                        do kk = 1,irsct

                           jjst = SeqTr(jst)
                           call sisseek ( luin(PartN(jjst)), 
     :                          PNSeq(jjst) )
                           call rtape (luin(PartN(jjst)),itr,ibytes)
 
                           call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                          ln_RecNum,icto, TRACEHEADER)

cmam......check flag for updating LinInd,DphInd in TraceHeader
                           if(.not.ihdflg) then
                              call savew2(itr,ifmt_LinInd, l_LinInd, 
     :                             ln_LinInd, LiInd(jjst), TRACEHEADER)
                              call savew2(itr,ifmt_DphInd, l_DphInd, 
     :                             ln_DphInd, DiInd(jjst), TRACEHEADER)
                           endif
                           call savew2(itr,ifmt_TVPT21, l_TVPT21, 
     :                          ln_TVPT21, CellN(jjst), TRACEHEADER)
                           call savew2(itr,ifmt_DstSgn, l_DstSgn, 
     :                          ln_DstSgn, Offst(jst), TRACEHEADER)
                           call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                          ln_TrcNum, kk, TRACEHEADER)
 
                           call wrtape (luout, itr,ibytes)
                           jst = jst + 1
                        enddo
 
                        if(kflg.eq.1 .and. irsct.lt.mxshct) then

cmam......need to fill record with zero traces
                           call vclr(itr,1,nwords)

                           do kk = irsct+1, mxshct
                              call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                             ln_RecNum, icto, TRACEHEADER)
                              call savew2(itr,ifmt_StaCor, l_StaCor, 
     :                             ln_StaCor, 30000, TRACEHEADER)
                              call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                             ln_TrcNum, kk, TRACEHEADER)
 
                              call wrtape (luout, itr,kbytes)
                           enddo
                           
                        endif

                        if(irsct.gt.0) then
                           go to 585
                        endif

                     endif
                  enddo
 
 597              continue

                  if(kflg.eq.0) then
                     write(LERR,*)'no traces found matching RcSta=',icur
                     write(LERR,*)'a record of ',mxshct,
     :                    ' zero traces will be output'
                     call vclr(itr,1,nwords)

cmam.........increment record out counter
                     icto = icto + 1

                     do kk = 1, mxshct
                        call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                       ln_RecNum, icto, TRACEHEADER)
                        call savew2(itr,ifmt_StaCor, l_StaCor, 
     :                       ln_StaCor, 30000, TRACEHEADER)
                        call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                       ln_TrcNum, kk, TRACEHEADER)
                        
                        call wrtape (luout, itr,kbytes)
                     enddo
                  endif
               enddo

            else

cmam...........no flat file to match against
               kst = 1
               kreco = 0

               do 520 i = ish1, ish2, ishi
                  kreco = kreco + 1
 
                  do j = kst,nsize
 
                     if(ShSta(j).eq.i) then
                        jst = j

                        write(ler,*)' Shot Station ',i, ' output'
                        go to 522
                     endif
                  enddo

                  if ( LiveOnly ) then
c pgag....no shot station match...skip any output at all
                     write(ler,*)' Shot Station ',i,'empty..skipped'
                     jcount = 0
                     go to 520
                  else
cmam....no shot station match...put out zero record
                     jcount = 0
                     go to 526
                  endif

cmam....found a match
 522              jcount = 0
                  mst = jst
 524              continue

                  if(ShSta(mst).eq.i) then
                     jcount = jcount + 1
                     mst = mst + 1
                     if(jcount.lt.mxshct) go to 524
                  endif

cmam........do secondary sort
c pgag       if more than a single trace

                  if ( jcount .gt. 1 ) then
                     if(rcsort) then
                        call isort4(jcount,RcSta(jst),SeqTr(jst),
     :                       Offst(jst), ShSta(jst) )
                     else
                        call isort3(jcount,Offst(jst),SeqTr(jst),
     :                       ShSta(jst) )
                     endif
                  endif

cmam.........retrieve found traces, output to file
                  do j = 1,jcount
                     jjst = SeqTr(jst)
                     call sisseek ( luin(PartN(jjst)), PNSeq(jjst) )
                     call rtape (luin(PartN(jjst)),itr,ibytes)
                     
                     call savew2(itr,ifmt_RecNum, l_RecNum, ln_RecNum,
     :                    kreco, TRACEHEADER)

c     mam......check flag for updating LinInd,DphInd in TraceHeader
                     if(.not.ihdflg) then
                        call savew2(itr,ifmt_LinInd, l_LinInd, 
     :                       ln_LinInd, LiInd(jjst), TRACEHEADER)
                        call savew2(itr,ifmt_DphInd, l_DphInd, 
     :                       ln_DphInd, DiInd(jjst), TRACEHEADER)
                     endif

                     call savew2(itr,ifmt_TVPT21, l_TVPT21, ln_TVPT21,
     :                    CellN(jjst), TRACEHEADER)
                     call savew2(itr,ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :                    Offst(jst), TRACEHEADER)
                     call savew2(itr,ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                    j, TRACEHEADER)
 
                     call wrtape (luout, itr,ibytes)
 
                     jst = jst + 1
                  enddo

cmam...........fill up with zero traces
                  kst = jst

 526              if(jcount.lt.mxshct) then

                     call vclr(itr,1,nwords)

                     do j = jcount+1, mxshct

                        call savew2(itr,ifmt_RecNum, l_RecNum, 
     :                       ln_RecNum, kreco, TRACEHEADER)
                        call savew2(itr,ifmt_RecInd, l_RecInd, 
     :                       ln_RecInd, i, TRACEHEADER)
                        call savew2(itr,ifmt_StaCor, l_StaCor, 
     :                       ln_StaCor, 30000, TRACEHEADER)
                        call savew2(itr,ifmt_TrcNum, l_TrcNum, 
     :                       ln_TrcNum, j, TRACEHEADER)
 
                        call wrtape (luout, itr,kbytes)

                     enddo
                  endif
 520           continue

            endif

         endif
cmam.............end of rec/shot station sorts
      ENDIF

c-----
c Normal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      do 200 i = 1,nu
         call lbclos ( luin(i) )
 200  continue
      call lbclos ( luout )
 
      write(LERR,*)'edit3d: Normal Completion'
      if(iflg.eq.1) then
         write(LERR,*)'     output ',nreco,' records, ',ncell,' traces'
      elseif(iflg.eq.1) then
         write(LERR,*)'     output ',nreco,' records, ',mxrsct,' traces'
      else
         write(LERR,*)'     output ',nreco,' records, ',mxshct,' traces'
      endif
      write(LER,*)'edit3d: Normal Completion'

      call ccexit(icc)
    
 999  write(LERR,*)'ERROR reading database - EOF encountered'
      icc = 98
 333  continue
 
c-----
c Abnormal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      do 400 i = 1,nu
         call lbclos ( luin(i) )
 400  continue
      call lbclos ( luout )
 
      write(LERR,*)'edit3d: Abormal Completion'
      write(LER,*)'edit3d: Abormal Completion'

      call ccexit(icc)

      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'edit3d reads a 3d database created by program dbvec.'
        write(LER,*)
     :'  the user inputs via command line arguments the LIs,DIs'
        write(LER,*)
     :'  or receiver stations or shot stations'
        write(LER,*)
     :'  desired to retrieve from the original input dataset(s).'
        write(LER,*)
     :'  These selected traces are written to an output dataset, or'
        write(LER,*)
     :'  most likely, piped into another program to display them.'
        write(LER,*)' '
        write(LER,*)
     :'execute by typing edit3d and the program parameters.'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N[ntap]    (no Default)       : input data file name'
        write(LER,*)
     :'                                 (up to 100 partitions allowed)'     
        write(LER,*)
     :' NOTE:Be sure to specify partitions by multiple -Nfile entries.'
        write(LER,*)
     :' -O[otap]    (default=pipe)     : output data file name'
	write(LER,*)
     :' -DB[dbnam]  (no default)       : database file name'
	write(LER,*)
     :'To retrieve an Inline or Crossline section:'
        write(LER,*)
     :' -lis[ili1]  (default = 1)      : first LI of first group to'
        write(LER,*)
     :'                                  retrieve'
        write(LER,*)
     :' -lie[ili2]  (default = 1)      : first LI of last group to'
        write(LER,*)
     :'                                  retrieve'
        write(LER,*)
     :' -dis[idi1]  (default = 1)      : first DI of first group to'
        write(LER,*)
     :'                                  retrieve'
        write(LER,*)
     :' -die[idi2]  (default = 1)      : first DI of last group to'
        write(LER,*)
     :'                                  retrieve'
        write(LER,*)
     :' -dli[ili]   (default = 0)      : increment between groups of'
        write(LER,*)
     :'                                  LIs'
        write(LER,*)
     :' -ddi[idi]   (default = 0)      : increment between groups of'
        write(LER,*)
     :'                                  DIs'
        write(LER,*)
     :' -nli[nli]   (default = 1)      : number of LIs in a group'
        write(LER,*)
     :' -ndi[ndi]   (default = 1)      : number of DIs in a group'
	write(LER,*)
     :' -ncell[ncell]                  : max. no. of traces to retrieve'
	write(LER,*)
     :'                                  per cell. (default is max.'
	write(LER,*)
     :'                                  count taken from the database)'
	write(LER,*)
     :' -xline    (default = in-line)  : retrieve traces in crossline',
     :' direction'
cmam............put this back in 4-23-97
        write(LER,*)
     :' -sect                          : retrieve data in pieces by'
        write(LER,*)
     :'                                  adjacent lis,dis specified'
        write(LER,*)
     :'           (default is to retrieve all dis for each li, or all'
        write(LER,*)
     :'            lis for each di if xline is specified.)'

        write(LER,*)' '
        write(LER,*)
     :'To retrieve by Receiver Stations (RecInd):'
        write(LER,*)
     :' -R[rfile] (optional)           : optional flat file of receiver'
        write(LER,*)
     :'                                  stations (RecInd) to get; one'
        write(LER,*)
     :'                                  RecInd entry per line in file.'
        write(LER,*)
     :'Or:'
        write(LER,*)
     :' -rcst1[irc1] (default = 1)     : first Receiver Station to',
     :' retrieve'
        write(LER,*)
     :' -rcst2[irc2] (default = 1)     : last Receiver Station to',
     :' retrieve'
        write(LER,*)
     :' -rcinc                         : increment between Rec. Sta.'
        write(LER,*) ' '
        write(LER,*)
     :' -sopt     (default = offset)   : sort each retrieved Rec.',
     :' Sta. by SoPtNm'
        write(LER,*)
     :'                                  (default = sort by offset)'
        write(LER,*)
     :' -U        (default = update)   : DO NOT update LinInd,DphInd'
        write(LER,*)
     :'                                  in output file; default is'
        write(LER,*)
     :'                                  to update.'
        write(LER,*)
     :' -liveonly (default = all)      : skip dead records on output'
          write(LER,*) ' '
	write(LER,*)
     :'To retrieve by Shot Stations (SoPtNm):'
        write(LER,*)
     :' -S[sfile] (optional)           : optional flat file of shot'
        write(LER,*)
     :'                                  stations (SoPtNm) to get; one'
        write(LER,*)
     :'                                  SoPtNm entry per line in file'
        write(LER,*)
     :'Or:'
	write(LER,*)
     :' -shst1[ish1] (default = 1)     : first Shot Station to',
     :' retrieve'
	write(LER,*)
     :' -shst2[ish2] (default = 1)     : last Shot Station to',
     :' retrieve'
	write(LER,*)
     :' -shinc                         : increment between Shot Sta.'
        write(LER,*) ' '
        write(LER,*)
     :' -sopt     (default = offset)   : sort each retrieved Rec.',
     :' Sta. by SoPtNm'
        write(LER,*)
     :'                                  (default = sort by offset)'
	write(LER,*)
     :' -U        (default = update)   : DO NOT update LinInd,DphInd'
	write(LER,*)
     :'                                  in output file; default is'
	write(LER,*)
     :'                                  to update.'
        write(LER,*)
     :' -liveonly (default = all)      : skip dead records on output'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :'usage:   edit3d [ -N[] -N[] .... -N[] ] -O[] -DB[] '
        write(LER,*)
     :'              -R[]  -S[] -sopt'
        write(LER,*)
     :'              [ -lis[] -lie[] -dis[] -die[]'
        write(LER,*)
     :'              -dli[] -ddi[] -nli[] -ndi[]'
	write(LER,*)
     :'              -ncell[] -xline -sect -U ]'
	write(LER,*)
     :'              [ -rcst1[] -rcst2[] -rcinc[] -sopt -liveonly ]'
	write(LER,*)
     :'              [-shst1[] -shst2[] -shinc[] -sopt -liveonly ]'
        write(LER,*)
     :'example 1: edit3d -Ndata1 -Ndata2 -lis29 -dli30 -nli3 -lie119'
        write(LER,*)
     :'      -dis25 -ddi30 -ndi11 -die115 -ncell25 -DBdbnam | .......'
        write(LER,*)
     :'this command line should produce a piped dataset consisting of:'
        write(LER,*)
     :'   li 29-31   (dis  25-35, 55-65, 85-95, 115-125)'
        write(LER,*)
     :'   li 59-61   (dis  25-35, 55-65, 85-95, 115-125)'
        write(LER,*)
     :'   li 89-91   (dis  25-35, 55-65, 85-95, 115-125)'
        write(LER,*)
     :'   li119-121  (dis  25-35, 55-65, 85-95, 115-125)'
cmam........added this 4-23-97
        write(LER,*) ' '
        write(LER,*)
     :'example 1A: edit3d -Ndata1 -Ndata2 -lis29 -dli30 -nli2 -lie59'
        write(LER,*)
     :'      -dis25 -ddi30 -ndi11 -die55 -ncell25 -DBdbnam -sect |....'
        write(LER,*)
     :'this command line should produce a piped dataset consisting of:'
        write(LER,*)
     :'   li 29   (dis  25-35)'
        write(LER,*)
     :'   li 30   (dis  25-35)'
        write(LER,*)
     :'   li 29   (dis  55-65)'
        write(LER,*)
     :'   li 30   (dis  55-65)'
        write(LER,*)
     :'   li 59   (dis  25-35)'
        write(LER,*)
     :'   li 60   (dis  25-35)'
        write(LER,*)
     :'   li 59   (dis  55-65)'
        write(LER,*)
     :'   li 60   (dis  55-65)'
        write(LER,*)
     :'(retrieval by pieces of adjacent cells, in inline direction)'
cmam..............................
        write(LER,*) ' '
	write(LER,*)
     :'Each LI,DI combination output will have 25 traces output'
	write(LER,*) ' '
	write(LER,*)
     :'example 2: edit3d -Ndata1 -Ndata2 -rcst1300 -rcst2310'
	write(LER,*)
     :'             -rcinc2 -sopt -DBdbnam -Odata.out'
	write(LER,*)
     :'this command line will produce a dataset consisting of:'
	write(LER,*)
     :'      RecInd 300, 302, 304, 306, 308, and 310'
	write(LER,*)
     :'      each record will contain the maximum number of traces'
	write(LER,*)
     :'      found for a receiver station (taken from the database)'
	write(LER,*)
     :'      Records will be padded with zero traces if deficient.'
	write(LER,*)
     :'      Traces in each record(RecInd) will be sorted by SoPtNm'
	write(LER,*) ' '
	write(LER,*)
     :'example 3: edit3d -Ndata1 -Ndata2 -Rrec.file -sopt'
	write(LER,*)
     :'             -DBdbnam -Odata.out'
	write(LER,*)
     :'this command line will produce a dataset consisting of:'
	write(LER,*)
     :'      receiver stations (RecInd) listed in the file rec.file,'
        write(LER,*)
     :'      each RecInd being sorted by SoPtNm.  Each record will'
        write(LER,*)
     :'      have the max. no. of traces found for a RecInd(taken'
        write(LER,*)
     :'      from the database).  Records will be padded with zero'
        write(LER,*)
     :'      traces if needed.  No match from database will give a'
        write(LER,*)
     :'      record of all zero traces.'
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln( ntap, otap, verbos, nu, dbnam, sect,
     *     rfile, sfile,
     *     ili1,ili2,idi1,idi2,ili,idi,nli,ndi,ncell,xline,
     *     irc1,irc2,irci,ish1,ish2,ishi,rcsort,iflg,ihdflg,
     *     LiveOnly )

c-----
c     get command arguments
c
c     ntap  - C*255    input file name (up to 100 partitions)
c     otap  - C*255    output file name
c     nu    _ I*4      number of input partitions (-Nfiles)
c     verbos  L        verbose output or not
c-----

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nu, ili1, ili2, idi1, idi2, ili, idi, nli, ndi
      integer ncell, irc1, irc2, irci, ish1, ish2, ishi, iflg 

      character   ntap(100)*255, otap*255, dbnam*255
      character rfile*255, sfile*255

      logical xline, sect
      logical rcsort
      logical ihdflg
      logical verbos
      logical LiveOnly

c declare local variables

      integer  argis, i, ierr
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program prgm might be invoked in the following way:
 
c     prgm  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------

	iflg = 0
cmam................get list of input datasets to use
            nu = 0
            do  i = 1, 100
                call argstr( '-N', ntap(i), ' ', ' ' )
                if (ntap(i) .eq. ' ') go to 1
                nu = nu + 1
            enddo
1           continue

cmam................get output dataset name
            call argstr( '-O', otap, ' ', ' ' )

cmam................get database name (output from dbvec)
            call argstr( '-DB', dbnam, ' ', ' ' )

cmam......look for file of receiver nos. or shot nos. to pull off in
cmam			given order
	    call argstr('-R',rfile,' ',' ')
	    call argstr('-S',sfile,' ',' ')

cmam..................if(rfile(1:1).eq.' ' .and. sfile(1:1).eq.' ') then
cmam......get receiver station specs
cmam	    iflg = 2
	    call argi4('-rcst1',irc1,1,-999)
	    call argi4('-rcst2',irc2,1,-999)
	    call argi4('-rcinc',irci,0,-999)
	    call argi4('-shst1',ish1,1,-999)
	    call argi4('-shst2',ish2,1,-999)
	    call argi4('-shinc',ishi,0,-999)
cmam..................endif
	    rcsort = (argis('-sopt') .gt. 0)

cmam....only check for li,di specs if rec.sta specs not present
	if(irc1.eq.-999 .and. irc2.eq.-999 .and.
     *	ish1.eq.-999 .and. ish2.eq.-999 .and.
     *  rfile(1:1).eq.' ' .and. sfile(1:1).eq.' ' ) then
	    iflg=1
cmam........get li,di specs
	    call argi4('-lis', ili1, 1, 1)
	    call argi4('-lie', ili2, 1, 1)
	    call argi4('-dis', idi1, 1, 1)
	    call argi4('-die', idi2, 1, 1)
	    call argi4('-nli', nli , 1, 1)
	    call argi4('-ndi', ndi , 1, 1)
	    call argi4('-dli', ili , 0, 0)
	    call argi4('-ddi', idi , 0, 0)
	    call argi4('-ncell', ncell , 0, 0)
	    xline = (argis('-xline') .gt. 0)
	    sect = (argis('-sect') .gt. 0)

cmam...........open file of recvr sta nos. to retrieve in order
        elseif (rfile(1:1) .ne. ' ') then
             open(unit=ludisk, file=rfile, status='old', iostat=ierr)
             if(ierr .ne. 0) then
                write(LERR,*)'Could not open receiver numbers file'
                write(LERR,*)'Check existence'
                stop
             endif
	     iflg = 2
 
cmam...........open file of shot sta nos. to retrieve in order
        elseif (sfile(1:1) .ne. ' ') then
             open(unit=ludisk, file=sfile, status='old', iostat=ierr)
             if(ierr .ne. 0) then
                write(LERR,*)'Could not open shot numbers file'
                write(LERR,*)'Check existence'
                stop
             endif
	     iflg = 3
 
	else
cmam..........get recvr sta or shot sta specs
	    if(ish1.eq.-999.and.ish2.eq.-999 .and.
     *		rfile(1:1).eq.' ' ) then
	      if(irc1.eq.-999) irc1 = 1
	      if(irc2.eq.-999) irc2 = irc1
	      if(irci.eq.-999) irci = 1
	      iflg = 2
	    else if (irc1.eq.-999.and.irc2.eq.-999 .and.
     *		sfile(1:1).eq.' ' ) then
	      if(ish1.eq.-999) ish1 = 1
	      if(ish2.eq.-999) ish2 = ish1
	      if(ishi.eq.-999) ishi = 1
	      iflg = 3
	    endif
	endif

            ihdflg =   (argis('-U') .gt. 0)

            LiveOnly  =   (argis('-liveonly') .gt. 0)
            verbos =   (argis('-V') .gt. 0)

c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal( ntrc, nrec,ntap,otap, nu,sect,
     *     ili1,ili2,idi1,idi2,ili,idi,nli,ndi,ncell,xline,
     *     irc1,irc2,irci,ish1,ish2,ishi,rcsort,iflg,ihdflg,
     *     rfile,sfile, LiveOnly )
c-----
c     verbose output of processing parameters
c
c     ntrc  - I*4     traces per record per partition
c     nrec  - I*4     number of records per partition
c     ntap  - C*255   input file name
c     otap  - C*255   output file name
c     nu    - I*4     number of input partitions
c     ili1  - I*4     1st LI of first group of LI's to retrieve
c     ili2  - I*4     1st LI of last group of LI's to retrieve
c     idi1  - I*4     1st DI of first group of DI's to retrieve
c     idi2  - I*4     1st DI of last group of DI's to retrieve
c     ili   - I*4     increment between groups of LI's
c     idi   - I*4     increment between groups of DI's
c     nli   - I*4     number of LI's in each group of LI's
c     ndi   - I*4     number of DI's in each group of DI's	
c     ncell - I*4     maximum number of traces to retrieve per cell
c     xline - L       retrieve LI,DI data in crossline direction
c     irc1  - I*4     1st receiver station to retrieve
c     irc2  - I*4     last receiver station to retieve
c     irci  - I*4     increment between receiver stations to retrieve
c     ish1  - I*4     1st shot station to retrieve
c     ish2  - I*4     last shot station to retieve
c     ishi  - I*4     increment between shot stations to retrieve
c     rcsort- L       sort receiver station by SoPtNm ...or...
c                     sort shot station by RecInd  (def=offset)
c     iflg  - I*4     =1 for retrieve by LI,DI; =2 for retrieve by rec.sta;
c		      =3 for retrieve by shot stations
c     ihdflg- L       .true. for updating LinInd,DphInd in output lineheader
c                     (default is to output what was in header on input)
c-----
      
      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine      
 
      integer ntrc(*), nrec(*)
      integer nu, ili1, ili2, idi1, idi2, ili, idi, nli, ndi
      integer ncell, irc1, irc2, irci, ish1, ish2, ishi, iflg

      character ntap(100)*255, otap*255
      character   rfile*255, sfile*255

      logical xline, sect, rcsort, ihdflg, LiveOnly

c declare local variables

      integer i

 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '

            write(LERR,*)' number of input partitions= ', nu

            write(LERR,*) ' input data set names=  ', (ntap(i),
     1      i=1,nu)

            write(LERR,*) ' records per data set=  ', (nrec(i),
     1      i=1,nu)

            write(LERR,*) ' traces per data set=  ', (ntrc(i),
     1      i=1,nu)

	    if(otap(1:1) .eq. ' ') then
		write(LERR,*) ' output will be a pipe'
	    else
                write(LERR,*) ' output data set name=  ', otap
	    endif

	if(iflg.eq.1) then
            write(LERR,*) ' first LI of first group to retrieve=',
     :		ili1

            write(LERR,*) ' first DI of first group to retrieve=',
     :		idi1

            write(LERR,*) ' first LI of last group to retrieve=',
     :		ili2

            write(LERR,*) ' first DI of last group to retrieve=',
     :		idi2

	    write(LERR,*) ' increment between groups of LIs=',
     :		ili

	    write(LERR,*) ' increment between groups of DIs=',
     :		idi

	    write(LERR,*) ' number of LIs in each LI group=',
     :		nli

	    write(LERR,*) ' number of DIs in each DI group=',
     :		ndi

	    write(LERR,*) ' max. no. of tr. to retrieve per cell=',
     :		ncell

	if(xline) then
            write(LERR,*) ' retrieving in the crossline direction',
     :		' (DI direction)'
	else
            write(LERR,*) ' retrieving in the inline direction',
     :		' (LI direction)'
	endif
	if(sect) then
	    write(LERR,*) ' retrieving by adjacent pieces'
	else
	    write(LERR,*) ' retrieving by lines'
	endif

	elseif(iflg.eq.2) then
cmam.........receiver station....
	  if(rfile(1:1).eq.' ') then
	    write(LERR,*)' first receiver station to retrieve=',
     :		irc1
	    write(LERR,*)' last receiver station to retrieve=',
     :		irc2
	    write(LERR,*)' increment between receiver stations=',
     :		irci
	  else
	    write(LERR,*)' input dataset containing receiver',
     :' stations(RecInd) to retrieve=',rfile
	  endif
	if(rcsort) then
	    write(LERR,*)' each receiver station will be sorted',
     :' by SoPtNm'
	else
	    write(LERR,*)' each receiver station will be sorted',
     :' by offset'
	endif
	 if(ihdflg) then
	   write(LERR,*) 'update LinInd, DphInd in output file'
	 else
           write(LERR,*) 'do not update LinInd, DphInd in output file'
	 endif

        else
cmam.........shot station....
	  if(sfile(1:1).eq.' ') then
            write(LERR,*)' first shot station to retrieve=',
     :          irc1
            write(LERR,*)' last shot station to retrieve=',
     :          irc2
            write(LERR,*)' increment between shot stations=',
     :          irci
          else
            write(LERR,*)' input dataset containing shot',
     :' stations(SoPtNm) to retrieve=',sfile
          endif

        if(rcsort) then
            write(LERR,*)' each shot station will be sorted',
     :' by RecInd'
        else
            write(LERR,*)' each shot station will be sorted',
     :' by offset'
        endif
         if(ihdflg) then
           write(LERR,*) 'update LinInd, DphInd in output file'
         else
           write(LERR,*) 'do not update LinInd, DphInd in output file'
         endif

	endif

        if(LiveOnly) then
           write(LERR,*) 'only gathers containing live traces will be '
           write(LERR,*) 'output'
        endif

            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
