C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c fix4sc3d ... this routine uses the database generated by the USP routine
c              dbvec, is modified from the code for USP routine edit3d, and
c              assigns PRI and PTR based upon receiver station and shot
c              station information in the database.  This performs the
c              job of getting the data into the form needed by USP routine
c              sc3d.
c
c              May 13, 1998 .. Marilyn Miller
c
c
c edit3d ... routine to feed up 3D data in various useful formats for
c            subsequent processing.  Uses database generated by the
c            USP routine dbvec.  Developed by Don Wagner and 
c            Marilyn Miller.
c
c
c Changes:
c
c     April 8/98 -- added policeman to sorting loops to prevent sorting
c                   on single trace receiver or shot station records as
c                   this resulted in a segmentation fault and core dump.
c
c                   also switched offset output to DstSgn from DstUsg to
c                   be compatible with the rest of the 3d world.
c     Garossino
c
c     March 27/98 -- added -liveonly command line option to allow output
c                    of shot or receiver station records with all live
c                    traces only.  This is useful when station indexing is
c                    not sequential in some nonuniform way.
c     Garossino
c
c
c**********************************************************************c
c
c     declare variables
c
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer nsamp, nsi, ntrc(100), nrec(100), iform
      integer luin(100) , luout, lbytes, nbytes, lbyout
      integer argis, icc, cellct, luns

      integer itr  ( SZLNHD ), lhed ( SZLNHD )

      real      head ( SZLNHD )

      character   ntap(100) * 255, otap * 255, name*6, dbnam*255

      logical verbos, picker
      logical rfilno, sfilno, old_db

c variables used in dynamic memory allocation

      integer SeqTr, PartN, PNSeq
      integer RcSta, ShSta

      pointer (memadr_SeqTr,SeqTr(1))
      pointer (memadr_PartN,PartN(1))
      pointer (memadr_PNSeq,PNSeq(1))
      pointer (memadr_RcSta,RcSta(1))
      pointer (memadr_ShSta,ShSta(1))
      
      equivalence ( itr( 1), head(1), lhed(1) )

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'FIX4SC3D'/
      data icc / 0 /
 
      rfilno = .false.
      sfilno = .false.
      old_db = .false.

c-----
c     read program parameters from command line card image file
c-----

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0) then
         call help()
         stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln( ntap, otap, verbos, nu,dbnam, picker )
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = ' '
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c     ( getln will assign the last parameter as the unit number if the dataset
c      name is ' ', ie. set up stdin and stdout if no filename are specified )
c-----

      IF (nu .ne. 0) THEN
         do 1 i = 1, nu
            call getln(luin(i),ntap(i),'r',0)
            write(LER,*)'ntap= ',i,ntap(i),luin(i)
            if (luin(i) .eq. 0.and.i.gt.1) then
               write(LERR,*)'You specified -Ndataset and -N"blank";'
               write(LERR,*)'you must have a dataset name after each'
               write(LERR,*)'-N you specify.  If you are piping into'
               write(LERR,*)'dbvec, do not use -N on command line'
               write(LER ,*)'You specified -Ndataset and -N"blank";'
               write(LER ,*)'you must have a dataset name after each'
               write(LER ,*)'-N you specify.  If you are piping into'
               write(LER ,*)'dbvec, do not use -N on command line'
               stop
            endif
            call sislgbuf( luin(i), 'off' )
 1       continue
      ELSE
         nu = 1
         call getln(luin(1),ntap(1),'r',0)
         if(luin(1).ne.0) then
            write(LERR,*)'FATAL ERROR:ntap is blank, luin=',luin(1)
            write(LER ,*)'FATAL ERROR:ntap is blank, luin=',luin(1)
            stop
         endif
         if(luin(1).eq.0)call sislgbuf( luin(1), 'off' )
      ENDIF

 
c-----
c     open output data stream
c-----

      call getln(luout, otap,'w', 1)

c-----
c     read line header of input dataset (rtape reads data into vector "itr")
c     lbytes is the number of bytes actually read
c-----

      nrect = 0
      
      do  10 i = 1, nu
         call rtape  ( luin(i), itr, lbytes                  )
         if(lbytes .eq. 0) then
            write(LOT,*)'fix4sc3d: no header read from unit ',luin(i)
            write(LOT,*)'fix4sc3d: partition number=',i
            write(LOT,*)'FATAL'
            stop
         endif
         call hlhprt ( itr , lbytes, name, 6, LERR        )
 10   continue

c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

#include <f77/saveh.h>

      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call saver2(itr,ifmt_NumSmp, l_NumSmp, ln_NumSmp,
     :     nsamp, LINEHEADER)

      nwords = nsamp + ITRWRD
      kbytes = 0

      if (verbos) write(LERR,*)'outputting nwords=',nwords
      
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)

c-----------
c     format values are:
c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----

      call verbal( ntrc, nrec, ntap, otap, nu, picker )

cmam.....now we have to read the selected vectors into core

      call alloclun (luns)
      ircl = 15 * SZSMPD

      open(luns,file=dbnam,status='unknown',
     :     access='direct', form = 'unformatted',
     :     recl = ircl, err = 302, iostat = ieropn )

      go to 303

 302  write(LERR,*)'error opening database:',ieropn
      write(LERR,*)'FATAL: cannot open database file=',dbnam
      write(LERR,*)'       job terminating; check database filename.'
      write(LER, *)'error opening database:',ieropn
      write(LER, *)'FATAL: cannot open database file=',dbnam
      write(LER, *)'       job terminating; check database filename.'
      go to 333

 303  continue
      if (verbos) write(LERR,*)'database open:',dbnam

cmam......read no. of vectors, no.of sequential traces, no. live traces,
cmam........min and max li, and min and max di on input dataset

      if (verbos) write(LERR,*)'reading rec 1 from database'

      read(luns,rec=1) numvec,nseq,nsize,minli,maxli,mindi,maxdi,
     :     nlive, ndead, cellct, knx, kny, nxy, mxrsct, mxshct
      if (verbos) write(LERR,*)'mxrsct,mxshct=',mxrsct,mxshct

      if(mxrsct.eq.0) then
         write(LERR,*)' FATAL ERROR: fix4sc3d'
         write(LERR,*)' This database is the old version!'
         write(LERR,*)' Shot Stations and Receiver Stations'
         write(LERR,*)' are not in the database.  You must'
         write(LERR,*)' rerun dbvec to generate a new database.'
         go to 333
      endif

      numli = knx
      numdi = kny

      if (verbos) then
        write(LERR,*)'read:nsize,minli,maxli,mindi,maxdi,cellct=',
     :     nsize,minli,maxli,mindi,maxdi,cellct
        write(LERR,*)'    mxrsct, mxshct=',mxrsct, mxshct
        write(LERR,*)'computed:numli,numdi=',numli,numdi
      endif

      close(luns)

      ircl = nsize * SZSMPD
      open(luns,file=dbnam,status='unknown',
     :     access='direct', form = 'unformatted',
     :     recl = ircl, err = 304, iostat = ieropn )

      go to 305

 304  write(LERR,*)'FATAL: cannot run program'
      write(LERR,*)'error opening database:',ieropn
      write(LER, *)'FATAL: cannot run program'
      write(LER, *)'error opening database:',ieropn
      go to 333

 305  continue
      if (verbos) write(LERR,*)'database open:',dbnam

      ierrcd = 1
      call galloc (memadr_SeqTr, nsize * SZSMPD, errcd, abort)
      if(errcd .ne. 0) go to 100
      if (verbos) write(LERR,*)'allocated SeqTr space'
      ierrcd = ierrcd + 1

      call galloc (memadr_PartN, nsize * SZSMPD, errcd, abort)
      if(errcd .ne. 0) go to 100
      if (verbos) write(LERR,*)'allocated PartN space'
      ierrcd = ierrcd + 1

      call galloc (memadr_PNSeq, nsize * SZSMPD, errcd, abort)
      if(errcd .ne. 0) go to 100
      if (verbos) write(LERR,*)'allocated PNSeq space'
      ierrcd = ierrcd + 1

cmam.........allocate arrays for reading ShSta, RcSta, SeqTr

         call galloc (memadr_RcSta, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         if (verbos) write(LERR,*)'allocated RcSta space'
         ierrcd = ierrcd + 1

         call galloc (memadr_ShSta, nsize * SZSMPD, errcd, abort)
         if(errcd .ne. 0) go to 100
         if (verbos) write(LERR,*)'allocated ShSta space'
         ierrcd = ierrcd + 1

      go to 110

 100  continue
      write(LERR,*)' '
      write(LERR,*)'FATAL ERROR occurred.'
      write(LERR,*)'Unable to allocate workspace for vectors:'
      write(LERR,*)'  Error occurred allocating vector ',ierrcd
      write(LERR,*)'  Need 23 vectors of size=',nrect*SZSMPD,
     :     ' bytes each'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'FATAL ERROR occurred.'
      write(LER,*)'Unable to allocate workspace for vectors:'
      write(LER,*)'  Error occurred allocating vector ',ierrcd
      write(LER,*)'  Need 23 vectors of size=',nrect*SZSMPD,
     :     ' bytes each'
      write(LER,*)' '

      go to 333
cmam...........vector space allocated -- proceed

 110  continue
      if (verbos) then
        write(LERR,*)'nsize=',nsize
        write(LERR,*)'ready to read vectors from database'
      endif

cmam.....order of vectors in database:
cmam     1 = header
cmam     2 = SeqTr
cmam     3 = PartN
cmam     4 = PNSeq
cmam     5 = CellN
cmam     6 = Offst
cmam     7 = RcSta
cmam     8 = ShSta
cmam     9 = kcell (no. of traces in each cell)
cmam     10= jcell (index in vectors sorted into ascending cell number)

cmam.....read SeqTr
      if (verbos) write(LERR,*)'reading SeqTr'
      read(luns,rec=2,err=399) (SeqTr(i),i=1,nsize)

cmam......read PartN
      if (verbos) write(LERR,*)'reading PartN'
      read(luns,rec=3,err=399) (PartN(i),i=1,nsize)
 
cmam......read PNSeq
      if (verbos) write(LERR,*)'reading PNSeq'
      read(luns,rec=4,err=399) (PNSeq(i),i=1,nsize)
 
cmam......read RcSta
      if (verbos) write(LERR,*)'reading RcSta'
      read(luns,rec=7,err=399) (RcSta(i),i=1,nsize)

cmam......read ShSta
      if (verbos) write(LERR,*)'reading ShSta'
      read(luns,rec=8,err=399) (ShSta(i),i=1,nsize)
         

      go to 398

 399  write(LERR,*)'error reading database - terminating job'
      write(LER ,*)'error reading database - terminating job'
      go to 333

 398  continue

cmam......close the database file

      close(luns)
 
cmam...........sort on receiver stations

            if ( nsize .gt. 1 ) then
                  call isort3 (nsize,RcSta,SeqTr,ShSta)
            endif

cmam........build the new array, substituting 1 thru n for the rec.sta.no.
            do i = 1,nsize
            if (RcSta(i).ne. 0) then
             ifirst = i
             kfirst = RcSta(i)
             go to 1410
            endif
            enddo

cmam........ERROR: all RcSta are zero
            write(LER,*)'error in fix4sc3d:  all receiver stations',
     :     ' are zero'
            write(LERR,*)'error in fix4sc3d:  all receiver stations',
     :     ' are zero'

            go to 333


 1410       continue
            
            IRcSta = 1
            RcSta(ifirst) = IRcSta

            do i = ifirst+1,nsize

              if(RcSta(i).gt.kfirst) then
                kfirst = RcSta(i)
                IRcSta = IRcSta + 1
                RcSta(i) = IRcSta
              else
                RcSta(i) = IRcSta
              endif

            enddo
            

cmam...........sort on shot stations
         
            if ( nsize .gt. 1 ) then
                  call isort3 (nsize,ShSta,SeqTr,RcSta)
            endif
cmam........build the new array, substituting 1 thru n for the shot.sta.no.
            do i = 1,nsize
            if (ShSta(i).ne. 0) then
             ifirst = i
             kfirst = ShSta(i)
             go to 1420
            endif
            enddo

cmam........ERROR: all ShSta are zero
            write(LER,*)'error in fix4sc3d:  all shot stations',
     :     ' are zero'
            write(LERR,*)'error in fix4sc3d:  all shot stations',
     :     ' are zero'

            go to 333

 
 1420       continue
           
            IShSta = 1
            ShSta(ifirst) = IShSta
 
            do i = ifirst+1,nsize
 
              if(ShSta(i).gt.kfirst) then
                kfirst = ShSta(i)
                IShSta = IShSta + 1
                ShSta(i) = IShSta
              else
                ShSta(i) = IShSta
              endif
 
            enddo

cmam.......write out range of shot and receiver stations assigned
           ione = 1
           write(LERR,*)' range of shot stations assigned to ',
     :     ' PrRcNm = ',ione,' to ',IShSta
           write(LERR,*)' range of receiver stations assigned to ',
     :     ' RecInd = ',ione,' to ',IRcSta

cmam......new receiver station and shot station numbers are assigned
cmam       resort into the input sequence

            if ( nsize .gt. 1 ) then
                  call isort3 (nsize,SeqTr,RcSta,ShSta)
            endif


cmam......set number of bytes to write out, depending on -picker flag
         if (picker) then
            nbytes = SZTRHD + SZSMPD * nsamp
         else
            nbytes = SZTRHD + SZSMPD
            ione = 1
            call savew2(itr,ifmt_NumSmp, l_NumSmp,
     :               ln_NumSmp, ione, LINEHEADER)
         endif
         
cmam......write the output lineheader

         if (verbos) write(LERR,*)'writing output lineheader'
         call wrtape ( luout, itr, lbyout  )

cmam......loop on number of traces in input dataset
         do i = 1, nsize

cmam......read input USP format dataset
         call rtape (luin(1),itr,kbytes)


cmam......put computed shot station into permanent record number
         call savew2(itr,ifmt_PrRcNm, l_PrRcNm, 
     :               ln_PrRcNm, ShSta(i), TRACEHEADER)
cmam......put computed receiver station into group index
         call savew2(itr,ifmt_RecInd, l_RecInd, 
     :               ln_RecInd, RcSta(i), TRACEHEADER)

cmam......write output USP format dataset
         call wrtape (luout, itr,nbytes)

         enddo


c-----
c Normal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      do 200 i = 1,nu
         call lbclos ( luin(i) )
 200  continue
      call lbclos ( luout )
 
      if (verbos) write(LERR,*)'fix4sc3d: Normal Completion'
      write(LERR,*)'     output ',nsize,' traces'

      call ccexit(icc)
    
 999  write(LERR,*)'ERROR reading database - EOF encountered'
      icc = 98
 333  continue
 
c-----
c Abnormal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      do 400 i = 1,nu
         call lbclos ( luin(i) )
 400  continue
      call lbclos ( luout )
 
      write(LERR,*)'fix4sc3d: Abormal Completion'
      write(LER,*)'fix4sc3d: Abormal Completion'

      call ccexit(icc)

      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'fix4sc3d reads a 3d database created by program dbvec.'
        write(LER,*)
     :'the purpose of fix4sc3d is to generate PrRcNm and RecInd '
        write(LER,*)
     :'values so that program sc3d can be run on 3D data that has'
        write(LER,*)
     :'values that are too large to fit in I*2 trace header words.'
        write(LER,*)
     :'dbvec allows you to select which header words to take the'
        write(LER,*)
     :'Shot Station (-hwshot) and Receiver Station (-hwgroup) values'
        write(LER,*)
     :'from to generate the database.  fix4sc3d reads those values'
        write(LER,*)
     :'and sorts them.  The first nonzero value is assigned the value'
        write(LER,*)
     :' 1, the second nonzero value is assigned the value 2, etc.'
        write(LER,*)
     :'The generated values are written into the trace header words'
        write(LER,*)
     :'PrRcNm (-hwshot) and RecInd (-hwgroup).  If the input datafile'
        write(LER,*)
     :'is NOT a picker event file, only 1 data sample will be written'
        write(LER,*)
     :'per output trace.  Then you will need to run hdrswap to attach'
        write(LER,*)
     :'these generated headers to the actual datafile.'
        write(LER,*)
     :'execute by typing fix4sc3d and the program parameters.'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N[ntap]    (no Default)       : input data file name'
        write(LER,*)
     :'                                 (up to 100 partitions allowed)'     
        write(LER,*)
     :' NOTE:Be sure to specify partitions by multiple -Nfile entries.'
        write(LER,*)
     :' -O[otap]    (default=pipe)     : output data file name'
	write(LER,*)
     :' -DB[dbnam]  (no default)       : dbvec database file name'
        write(LER,*)
     :' -picker                        : flag that the input file'
        write(LER,*)
     :'                                  (ntap) is a picker event file'
        write(LER,*)
     :' -V                             : verbose output in print file'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :'usage:   fix4sc3d [ -N[] -N[] .... -N[] ] -O[] -DB[] '
        write(LER,*)
     :'              [ -picker ]'
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,verbos, nu,dbnam, picker )

c-----
c     get command arguments
c
c     ntap  - C*255    input file name (up to 100 partitions)
c     otap  - C*255    output file name
c     dbnam - C*255    database file name (from dbvec)
c     picker- L        flag for output
c                      true=input is event file from picker, and we
c                           will output same no. of samples as input
c                      false=input is any USP formatted dataset, but
c                           we will output only 1 dummy data sample
c                           (use hdrswap later to get these trace
c                           headers attached to the real data)
c     nu    _ I*4      number of input partitions (-Nfiles)
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>

      integer     argis

      character   ntap(*)*(*), otap*(*), dbnam*(*)

      logical     verbos, picker
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program prgm might be invoked in the following way:
 
c     prgm  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------

	iflg = 0
cmam................get list of input datasets to use
            nu = 0
            do  i = 1, 100
                call argstr( '-N', ntap(i), ' ', ' ' )
                if (ntap(i) .eq. ' ') go to 1
                nu = nu + 1
            enddo
1           continue

cmam................get output dataset name
            call argstr( '-O', otap, ' ', ' ' )

cmam................get database name (output from dbvec)
            call argstr( '-DB', dbnam, ' ', ' ' )

            verbos =   (argis('-V') .gt. 0)
            picker =   (argis('-picker') .gt. 0)

c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal( ntrc, nrec,ntap,otap, nu, picker )
c-----
c     verbose output of processing parameters
c
c     ntrc  - I*4     traces per record per partition
c     nrec  - I*4     number of records per partition
c     ntap  - C*255   input file name
c     otap  - C*255   output file name
c     nu    - I*4     number of input partitions
c-----
#include <f77/iounit.h>
 
      integer     ntrc(*), nrec(*), nu
      character   ntap(*)*(*), otap*(*)
      logical     picker
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '

      write(LERR,*)' number of input partitions= ', nu

      if (ntap(1) .eq. ' ') then
        write(LERR,*)' input data set if a pipe'
      else
        write(LERR,*) ' input data set names=  ', (ntap(i),i=1,nu)
      endif

      write(LERR,*) ' records per data set=  ', (nrec(i),i=1,nu)

      write(LERR,*) ' traces per data set=  ', (ntrc(i),i=1,nu)

      if(otap(1:1) .eq. ' ') then
	write(LERR,*) ' output will be a pipe'
      else
        write(LERR,*) ' output data set name=  ', otap
      endif

      if (picker) then
        write(LERR,*)' input datafile is a picker event tape'
        write(LERR,*)' the output datafile will have the same'
        write(LERR,*)' number of samples as the input file'
      else
        write(LERR,*)' input datafile is a not a picker event tape'
        write(LERR,*)' the output datafile will contain only 1'
        write(LERR,*)' dummy sample per trace.  this is basically'
        write(LERR,*)' just headers for input to the header-swap'
        write(LERR,*)' program.'
      endif
      write(LERR,*)' '
      write(LERR,*)' '

      return
      end
 
