C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XYFilter(Intercept,CosTaper,FilterLength,nf2,J0,Filter,
     1                    edge,edgev,edgeh,edgedl,edgedr,avmed,med,har,
     2                    gauss,sigma)

c
c  routine to form a symmetrical (dx = dy = intercept) j0 
c  N x N filter. 
c  
c

      external J0
      integer FilterLength,A

      real Filter(FilterLength,FilterLength),Intercept,J0,X,Y,R
      real PIby2,Rtaper,CosTaper

      logical edge,edgev,edgeh,edgedl,edgedr,avmed,med,har,gauss

      PIby2 = 3.14159265/2.0

      IF (.not.edge .and. .not.edgev .and. .not.edgeh
     1    .and. .not.edgedl .and. .not.edgedr .and. 
     2    .not.avmed .and. .not.med .and. .not.har .and.
     3    .not.gauss                                     ) THEN
c
c Assign the origin and axes
c
      A = FilterLength/2 + 1
      Rtaper = CosTaper * float(A) 
      Filter(A,A) = J0(0.0)

      do i = 1,A-1
         R = float(i) * Intercept
         Filter(A+i,A) = J0(R)
         Filter(A-i,A) = Filter(A+i,A) 
         Filter(A,A+i) = Filter(A+i,A)
         Filter(A,A-i) = Filter(A+i,A)
      enddo

c
c Compute positive Quadrant
c

      do i = 1,A-1
         do j = 1,A-1
            X = float(i) * Intercept
            Y = float(j) * Intercept
            R = sqrt(X**2 + Y**2)

            Filter(A+j,A+i) = J0(R)

         enddo
      enddo

c
c Assign Symmetrical Quadrants
c

      do i = 1,A-1
         do j = 1,A-1
            Filter(i,j)   = Filter(2*A-i,2*A-j)
            Filter(2*A-i,j) = Filter(i,j)
            Filter(i,2*A-j) = Filter(i,j)
         enddo
      enddo

c
c cosine taper on filter and circular symmetry
c
      do i = 1,2*A-1
         do j = 1,2*A-1

            R = sqrt(float(A - i)**2 + float(A - j)**2)
            if(R.ge.Rtaper.and.R.le.float(A))then

               filter(i,j) = filter(i,j)*cos(R/float(A)*PIby2)

            elseif(R.gt.float(A))then

               filter(i,j) = 0.0

            endif

         enddo
      enddo

c
c Compute Sum of All Weights
c

      SumWeights = 0.0

      do i = 1,2*A-1
         do j = 1,2*A-1
            SumWeights = SumWeights + Filter(i,j)
         enddo
      enddo

c
c  Normalize Filter
c

      do i = 1,2*A-1
         do j = 1,2*A-1
            filter(i,j) = filter(i,j)/abs(SumWeights)
         enddo
      enddo

c----
c   build simple edge detection filter (from Two Dimensional Signal &
c   Image Processing by J.S. Lim, Prentice Hall, 1990, pp 481-6
c----
      ELSEIF ( (.not.avmed .and. .not.med .and. .not.gauss) .and. 
     1         (edge .or. edgev .or. edgeh .or. edgedl .or. edgedr) 
     2                           ) THEN

         if (edge) then
             filter (1,1) =  1.
             filter (2,1) =  1.
             filter (3,1) =  1.
             filter (1,2) =  1.
             filter (2,2) = -8.
             filter (3,2) =  1.
             filter (1,3) =  1.
             filter (2,3) =  1.
             filter (3,3) =  1.
         elseif (edgev) then
             filter (1,1) = -1.
             filter (2,1) = -1.
             filter (3,1) = -1.
             filter (1,2) =  0.
             filter (2,2) =  0.
             filter (3,2) =  0.
             filter (1,3) =  1.
             filter (2,3) =  1.
             filter (3,3) =  1.
         elseif (edgeh) then
             filter (1,1) =  1.
             filter (2,1) =  0.
             filter (3,1) = -1.
             filter (1,2) =  1.
             filter (2,2) =  0.
             filter (3,2) = -1.
             filter (1,3) =  1.
             filter (2,3) =  0.
             filter (3,3) = -1.
         elseif (edgedl) then
             filter (1,1) =  1.
             filter (2,1) =  1.
             filter (3,1) =  0.
             filter (1,2) =  1.
             filter (2,2) =  0.
             filter (3,2) = -1.
             filter (1,3) =  0.
             filter (2,3) = -1.
             filter (3,3) = -1.
         elseif (edgedr) then
             filter (1,1) =  0.
             filter (2,1) = -1.
             filter (3,1) = -1.
             filter (1,2) =  1.
             filter (2,2) =  0.
             filter (3,2) = -1.
             filter (1,3) =  1.
             filter (2,3) =  1.
             filter (3,3) =  0.
         endif
         
      ELSEIF ((avmed .or. med .or. har) .and. .not.gauss) THEN

         nf2 = FilterLength / 2
         return

      ELSEIF (gauss) THEN

         call gaussmask (Filter, FilterLength, sigma)

      ENDIF

      return
      end
