C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,otap,irs,ire,StartRec,EndRec,FilterLength,
     :     Intercept,CosTaper,Xtaper,Ytaper,Xpad,Ypad,pass,ftap,verbos,
     :     edge,edgev,edgeh,edgedr,edgedl,avmed,med,har,iopa,ioph,chp,
     :     gauss,sigma,dup)

#include <f77/iounit.h>

      integer irs, ire, FilterLength, StartRec, EndRec, Xpad, Ypad
      integer Xtaper, Ytaper, argis, iopa, ioph

      real Intercept,CosTaper,chp

      character ntap*(*), otap*(*), ftap*(*)

      logical verbos, pass, edge, edgev,edgeh,edgedr,edgedl
      logical avmed, med, har, gauss, all_edge, dup

      pass   = (argis('-pass') .gt. 0)
      dup    = (argis('-dup') .gt. 0)

      call argstr('-N',ntap,' ',' ') 
      call argstr('-O',otap,' ',' ')
      call argstr('-F',ftap,' ',' ')
      call argr4('-sig',sigma,4.,4.)
      call argi4('-e',EndRec,0,0)
      call argr4('-ftaper',CosTaper,50.0,50.0)
      call argr4('-i',Intercept,0.05,0.05)
      call argi4('-l',FilterLength, 21, 21)
      call argi4('-re',ire,0,0)
      call argi4('-rs',irs,1,1)
      call argi4('-s',StartRec,1,1)
      call argi4('-xtaper',Xtaper,10,10)
      call argi4('-xpad',Xpad,10,10)
      call argi4('-ytaper',Ytaper,10,10)
      call argi4('-ypad',Ypad,10,10)
      call argi4('-oa',iopa,1,1)
      call argi4('-oh',ioph,1,1)
      call argr4('-p',chp,2.,2.)
      avmed    = (argis('-AM') .gt. 0)
      gauss    = (argis('-EG') .gt. 0)
      med      = (argis('-M') .gt. 0)
      edgedl   = (argis('-EDR') .gt. 0)
      edgedr   = (argis('-EDL') .gt. 0)
      edgev    = (argis('-EV') .gt. 0)
      edgeh    = (argis('-EH') .gt. 0)
      edge     = (argis('-E') .gt. 0)
      har      = (argis('-H') .gt. 0)
      verbos   = (argis('-V') .gt. 0)

      if (edge .or. edgedl .or. edgedr .or. edgev .or. edgeh) then
         FilterLength = 3
         Xtaper = 0
         Ytaper = 0
         all_edge = .true.
      else
         all_edge = .false.
      endif

      IF (gauss) THEN
         if (all_edge) then
           write(LERR,*)' '
           write(LERR,*)'FATAL ERROR in fkkstrip -G option:'
           write(LERR,*)'Cannot have -E and -G flags'
           write(LER ,*)' '
           write(LER ,*)'FATAL ERROR in fkkstrip -G option:'
           write(LER ,*)'Cannot have -E and -G flags'
           stop
         endif
         if (mod(FilterLength,2) .eq. 0) then
            FilterLength = FilterLength + 1
            write(LERR,*)' '
            write(LERR,*)'WARNING from fkkstrip (-G option):'
            write(LERR,*)'Filter length must be odd. Resetting to ',
     1                    FilterLength
         endif
         Xpad   = FilterLength / 2
         Ypad   = FilterLength / 2
         Xtaper = 0
         Ytaper = 0
      ENDIF

      IF (avmed .or. med .or. har) THEN
         if (mod(FilterLength,2) .eq. 0) then
            FilterLength = FilterLength + 1
            write(LERR,*)' '
            write(LERR,*)'WARNING from fkkstrip (avmed option):'
            write(LERR,*)'Filter length must be odd. Resetting to ',
     1                    FilterLength
         endif
         Xpad   = FilterLength / 2
         Ypad   = FilterLength / 2
         Xtaper = 0
         Ytaper = 0
         if (har .and. chp.lt.2.) then
           write(LERR,*)' '
           write(LERR,*)'FATAL ERRIR in fkkstrip (harmonic option):'
           write(LERR,*)'-p[] can not be less than 2'
           write(LER ,*)' '
           write(LER ,*)'FATAL ERRIR in fkkstrip (harmonic option):'
           write(LER ,*)'-p[] must be greater than 2'
           stop 666
         endif

      ENDIF

      return
      end



      

 
