C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gaussmask (Filter, nf, sigma)

      real     Filter (nf, nf)
      integer  nf
      real     sigma

      nf2 = nf / 2 + 1
      sum = 0.
      sigma2 = sigma ** 2

      DO  I = 1, nf

          m = (i - nf2)

          do  j = 1, nf

              n = (j - nf2)

              ff = ( float( m **2) + float( n **2 ) ) / sigma2
              Filter (i,j) = (1. - ff) * exp ( -ff/2. )
              sum = sum + Filter (i,j)
          enddo
      ENDDO

      DO  i = 1, nf
          do  j = 1, nf

              Filter (i,j) = Filter (i,j) / sum
          enddo
      ENDDO

      return
      end
