C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nlmed (Input, Output, nxIN, nyIN, nf, nf2, 
     1                   Filter, nlo, p )

c
c
c  This subroutine computes the arithmetic, harmonic, geometric and the Lp
c  mean of image windows
c
c  written by: Anthony A. Vassiliou (10/95)
c
c
      real    Input(nxIN,nyIN), Output(nxIN,nyIN)
      real    Filter (nf*nf)   
      real    p
      integer nlo

c---
c---

        nfc   = nf2 + 1
        fp    = p
        fp1   = p+1.
        nf2t  = 2 * nf2 + 1
        nf2t2 = nf2t * nf2t


c---
c  non-linear mean filters:  for example a 5x5 case...

c  data matrix D centered at point ix,iy in overall two dimensional
c  data array:

c      d11  d12  d13  d14  d15
c      d21  d22  d23  d24  d25
c      d31  d32  d33  d34  d35
c      d41  d42  d43  d44  d45
c      d51  d52  d53  d54  d55


c  case: nlo=1
c  the arithmetic sums are formed:
c  sum1=(d11+d12+d13+...+d54+d55)/25.
c  The output of the filter is then
c
c
c
c
c   case: nlo=4
c
c   the harmonic mean of the 5x5 image window is found
c
c
c
c
c   case: nlo=2 
c
c   the geometric mean  of the data
c
c
c
c   case: nlo=3
c
c   the contraharmonic filter with power p
c
c   it is the harmonic mean of the data, weighted by the x**p power
c   function as coefficients
c
c---
 
      IF (nlo .eq. 1) THEN

      DO  IY = nf2+1, nxIN-nf2
          DO  IX = nf2+1, nyIN-nf2
c
c             arithmetic mean
c
              sum1=0.0
              do  i = IX-nf2,IX+nf2
              do  j = IY-nf2,IY+nf2
                 sum1=sum1+Input(j,i)
              end do
              end do
              sum1=sum1/float(nf2t2)
              Output (IY,IX) = sum1
         ENDDO
      ENDDO

      ELSEIF (nlo .eq. 4) THEN
c
c             harmonic mean (with clamping)
c
      tmax = 0.
      tmin = 0.
      DO  IY = nf2+1, nxIN-nf2
          DO  IX = nf2+1, nyIN-nf2
              if (Input(IY,IX) .ge. tmax) tmax = Input(IY,IX)
              if (Input(IY,IX) .le. tmin) tmin = Input(IY,IX)
         ENDDO
      ENDDO

      DO  IY = nf2+1, nxIN-nf2
          DO  IX = nf2+1, nyIN-nf2
              sum1=0.0
              ic = 0
              do i = IX-nf2, IX+nf2
              do j = IY-nf2, IY+nf2
                 amp = Input(j,i)
                 if (abs(amp) .gt. 1.e-10) then
                     ic = ic + 1
                     sum1 = sum1 + 1/amp
                 endif
              end do
              end do
              sum1=sum1/float(ic)
              if (abs(sum1) .gt. 1.e-10) then
                 sum1 = 1. / sum1
                 if (sum1 .gt. tmax) sum1 = tmax
                 if (sum1 .lt. tmin) sum1 = tmin
                 Output (IY,IX) = sum1
              else
                 Output (IY,IX) = 0.0
              endif
         ENDDO
      ENDDO

      ELSEIF (nlo .eq. 2) THEN
c
c             geometric mean
c
      DO  IY = nf2+1, nxIN-nf2
          DO  IX = nf2+1, nyIN-nf2
              sum1=0.0
              ic = 0
              do i = IX-nf2, IX+nf2
              do j = IY-nf2, IY+nf2
                 amp = Input(j,i)
                 sgn = sign (1.0,amp)
                 if (amp .ne. 0.0) then
                     ic = ic + 1
                     sum1 = sum1 + sgn * ( alog (abs(amp)) )
                 endif
              end do
              end do
              sum1 = sum1/float(ic)
              sgn = sign (1.0,sum1)
              sum1 = sgn * exp( abs(sum1) )
              Output (IY,IX) = sum1
         ENDDO
      ENDDO

      ELSEIF (nlo .eq. 3) THEN
c
c             contraharmonic mean
c
      DO  IY = nf2+1, nxIN-nf2
          DO  IX = nf2+1, nyIN-nf2
              sum1=0.0
              sum2=0.0
              do i = IX-nf2, IX+nf2
              do j = IY-nf2, IY+nf2
                 sum1=sum1+(Input(j,i)**fp1)
                 sum2=sum2+(Input(j,i)**fp)
              end do
              end do
              if (sum2 .ne. 0.0) then
                 Output (IY,IX) = -sum1/sum2
              else
                 Output (IY,IX) = 0.0
              endif

          ENDDO
      ENDDO

      ENDIF

      return
      end
