!...|....1....|....2....|....3....|....4....|....5....|....6....|....7....|....8
!*******************************************************************************
!
! return coefficients for a least-squares plane through a regular grid
!
!*******************************************************************************
      subroutine get_plane_coeff ( x0,dx,nx, y0,dy,ny, Map, slope_x,
     :  slope_y,zbias )

      implicit none

      integer  :: nz,nx,ny
      real     :: z0,x0,y0, dz,dx,dy
      real     :: Map(nx,ny)
      real     :: slope_x,slope_y,zbias

      integer  :: ix,iy,ipt,npts
      real     :: y_here,x_here
      real     :: z(nx*ny), x(nx*ny), y(nx*ny)
      logical  :: xline,yline

!-------------------------------------------------------------------------------
! Done with declarations
!-------------------------------------------------------------------------------
!
! First fill z,x,y vetors
!
      ipt = 0
      do iy = 1,ny
        y_here = y0 + (iy-1)*dy
        do ix = 1,nx
          x_here = x0 + (ix-1)*dx
          ipt = ipt+1

          z(ipt) = map(ix,iy)
          x(ipt) = x_here
          y(ipt) = y_here

        enddo
      enddo

      npts = ipt

!
! Now see if we aren't really dealing with a line
!
      xline = .true.
      if(ny>1 .and. dy/=0.0) xline = .false.
      yline = .true.
      if(nx>1 .and. dx/=0.0) yline = .false.

!
! Solve the appropriate problem
!
      if (xline) then

        call ls_line(x,z,npts,slope_x,zbias)
        slope_y = 0.0

      elseif (yline) then

        call ls_line(y,z,npts,slope_y,zbias)
        slope_x = 0.0

      else

        call ls_plane(x,y,z,npts,slope_x,slope_y,zbias)

      endif

      return
      end subroutine get_plane_coeff
