c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c  Subroutine to get parameters for a least-squares plane through
c  x,y,z data points.
c***********************************************************************
      subroutine ls_plane(x,y,z,npts,slope_x,slope_y,bias)
 
      integer npts
      real    x(npts),y(npts),z(npts)
      real    slope_x,slope_y,bias
 
c variables to compute the guide if it's a least squares plane
      real*8  sumX,sumY,sumZ,sumX2,sumY2,sumXY,sumXZ,sumYZ
      real*8  Alpha(3,4),Beta(3,4),Gamma(3,4),Delta(3,4)

c Other local variables
      integer ipt
 
c-----------------------------------------------------------------------
c DONE WITH DECLARATIONS
c-----------------------------------------------------------------------
c
c initialize
c
        sumX  = 0.0
        sumY  = 0.0
        sumZ  = 0.0
        sumXY = 0.0
        sumXZ = 0.0
        sumYZ = 0.0
        sumX2 = 0.0
        sumY2 = 0.0

c
c compute sums
c
        do ipt = 1,npts
          sumX  = sumX  + x(ipt)
          sumY  = sumY  + y(ipt)
          sumZ  = sumZ  + z(ipt)
          sumXY = sumXY + x(ipt)*y(ipt)
          sumXZ = sumXZ + x(ipt)*z(ipt)
          sumYZ = sumYZ + y(ipt)*z(ipt)
          sumX2 = sumX2 + x(ipt)*x(ipt)
          sumY2 = sumY2 + y(ipt)*y(ipt)
        enddo

c These sums are coefficients of a 3x4 matrix that can be
c 'reduced' in 3 steps. First I fill an Alpha matrix directly, then I
c reduce ... to Beta ... to Gamma ... to Delta. The final coefficients
c of a least-squares plane are the non-trivial elements of Delta()
c Trivial elements after reduction at each step are shown, but removed
c by comment.
c
c fill the 3x4 Alpha matrix (3_rows x 4_columns)
c
        Alpha(1,1) = sumX2
        Alpha(2,1) = sumXY
        Alpha(3,1) = sumX
        Alpha(1,2) = sumXY
        Alpha(2,2) = sumY2
        Alpha(3,2) = sumY
        Alpha(1,3) = sumX
        Alpha(2,3) = sumY
        Alpha(3,3) = float(npts)
        Alpha(1,4) = sumXZ
        Alpha(2,4) = sumYZ
        Alpha(3,4) = sumZ

c
c compute the 3x4 Beta matrix by reducing column 1 of Alpha
c
c        Beta(1,1) = 1.0
c        Beta(2,1) = 0.0
c        Beta(3,1) = 0.0
        Beta(1,2) = Alpha(1,2) / Alpha(1,1)
        Beta(2,2) = Alpha(2,2) - Alpha(2,1)*Alpha(1,2)/Alpha(1,1)
        Beta(3,2) = Alpha(3,2) - Alpha(3,1)*Alpha(1,2)/Alpha(1,1)
        Beta(1,3) = Alpha(1,3) / Alpha(1,1)
        Beta(2,3) = Alpha(2,3) - Alpha(2,1)*Alpha(1,3)/Alpha(1,1)
        Beta(3,3) = Alpha(3,3) - Alpha(3,1)*Alpha(1,3)/Alpha(1,1)
        Beta(1,4) = Alpha(1,4) / Alpha(1,1)
        Beta(2,4) = Alpha(2,4) - Alpha(2,1)*Alpha(1,4)/Alpha(1,1)
        Beta(3,4) = Alpha(3,4) - Alpha(3,1)*Alpha(1,4)/Alpha(1,1)

c
c compute the 3x4 Gamma matrix by reducing column 2 of Beta
c
c        Gamma(1,1) = 1.0
c        Gamma(2,1) = 0.0
c        Gamma(3,1) = 0.0
c        Gamma(1,2) = 0.0
c        Gamma(2,2) = 1.0
c        Gamma(3,2) = 0.0
        Gamma(1,3) = Beta(1,3) - Beta(1,2)*Beta(2,3)/Beta(2,2)
        Gamma(2,3) = Beta(2,3) / Beta(2,2)
        Gamma(3,3) = Beta(3,3) - Beta(3,2)*Beta(2,3)/Beta(2,2)
        Gamma(1,4) = Beta(1,4) - Beta(1,2)*Beta(2,4)/Beta(2,2)
        Gamma(2,4) = Beta(2,4) / Beta(2,2)
        Gamma(3,4) = Beta(3,4) - Beta(3,2)*Beta(2,4)/Beta(2,2)

c
c compute the 3x4 Delta matrix by reducing column 3 of Gamma
c
c        Delta(1,1) = 1.0
c        Delta(2,1) = 0.0
c        Delta(3,1) = 0.0
c        Delta(1,2) = 0.0
c        Delta(2,2) = 1.0
c        Delta(3,2) = 0.0
c        Delta(1,3) = 0.0
c        Delta(2,3) = 0.0
c        Delta(3,3) = 1.0
        Delta(1,4) = Gamma(1,4) - Gamma(1,3)*Gamma(3,4)/Gamma(3,3)
        Delta(2,4) = Gamma(2,4) - Gamma(2,3)*Gamma(3,4)/Gamma(3,3)
        Delta(3,4) = Gamma(3,4) / Gamma(3,3)

c
c Assign values for coefficients of the plane
c
        slope_x = Delta(1,4)
        slope_y = Delta(2,4)
        bias    = Delta(3,4)

c All Done
c
      return
      end
