C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine smth2d (nf, nli, ndi, filter, times, work)

      real  filter (nf*nf), times (ndi, nli), work (ndi, nli)

         nfc = nf / 2 + 1
 
         DO  IY = nfc, nli-nfc
             DO  IX = nfc, ndi-nfc
 
                 ic = 0
                 do  j = 1, nf
                 do  i = 1, nf
 
                     IYj = IY - nfc + j
                     IXi = IX - nfc + i
 
                     if (IYj .ge. 1 .AND. IYj .le. nli .AND.
     1                   IXi .ge. 1 .AND. IXi .le. ndi)     then
                         amp = times (IXi, IYj)
                         if (amp .ne. 0.0) then
                            ic = ic + 1
                            filter (ic) = amp
                         endif
                     endif
                enddo
                enddo
 
                if (ic .gt. 1) then
                   call median (filter, ic, xmed)
                elseif (ic .eq. 1) then
                   xmed = filter (1)
                else
                   xmed = 0.
                endif

                work (IX,IY) = xmed
 
             ENDDO
         ENDDO

      return
      end
