C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  li_di: survey box corners and then either
C                            1. stuff proper XYs into trace hdrs, or
C                            2. limit output data to shots within box
c                            3. limit output data to shots outside box

c     mode A (1,2,or3 above): apply to whole records
c     mode B (1,2,or3 above): apply trace by trace

c     mode B also allows rebinning data based on record/trace numbers
c     or LI/DI numbers, i.e. new XYs are computed given corner 1 of a
c     survey and the trace numbers
c
c     Changes:
c
c     Mar 4, 1999: changed flat file output format to be 2(f15.2,2x)
c                  to achieve precision required for geometry
c     Garossino
c     Feb 11, 1999: fixed fold map under cdp option which segmented
c                   memory due to not checking to see if the input
c                   point was inside the grid.  result was an index
c                   calculation greater than the memory allocated
c                   for the fold map.  I added the check on IWRN
c                   which solved the problem.
c     Garossino
C
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     itr (SZLNHD)

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     argis

      character   name * 5, ntap * 256, otap * 256

      logical     verbos
      logical     go

c declare program specific variables

      integer limin, limax, dimin, dimax, lufld
      integer IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4
      integer NX, NY, IWRN, ISX, ISY, ISLI, ISDI, IRX, IRY
      integer itrc, irec, iix, iiy, icxx, icyy
      integer IRLI, IRDI, ICDPX, ICDPY, ICLI, ICDI, NDI, NLI
      integer linestrt, idistrt, ipntr

      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_DphInd,l_DphInd,ln_DphInd
      integer ifmt_LinInd,l_LinInd,ln_LinInd
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC
      integer ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC
      integer ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC
      integer ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC
      integer ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX
      integer ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY

      real    fmscl, mfscl, BXT, BYT, RX, RY, CX, CY
      real    DX, DY, CDPX, CDPY, SX, SY
      real    DXT, DYT, off

      REAL*8  XX, XY, YX, YY, XXT, XYT, YXT, YYT
      REAL*8  DE, DF, E, F, XYYXXY

      character ftap * 256

      logical     limit, shot, rcvr, cdp
      logical     f2m, m2f, fld, stk, rebinr, rebinl
      logical     lidi_rnum, reject, records, bcxy, flat

c declare variables used with dynamic memory allocation

      integer errcd, errcd1, abort

      real        fold
      integer     data
      pointer     (wkfold, fold(1))
      pointer     (wkdata, data(1))

c initialize variables
 
      data abort/0/
      data name/'LI_DI'/
      data luin / 1 /
      data luout  / 2 /
      data lbytes / 0 /
      data  obytes / 0 /
      data verbos/.false./
      data limit /.false./
      data go /.false./
      data flat /.false./

      fmscl = 0.30480
      mfscl = 3.28084

c get online help if necesssary

      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c  open printout file

#include <f77/open.h>

c parse command line parameters

      call cmdln ( ntap, otap, limin, limax, dimin, dimax, verbos,
     1     IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, DY, DX,
     2     f2m, m2f, limit, shot, rcvr, cdp, fld, ftap, stk,
     3     linestrt, idistrt, rebinr, rebinl, lidi_rnum, reject,
     4     records, bcxy, flat)

c  load XY feet -> m or m-> feet scaler

      if ( f2m ) then
         xyscl = fmscl
      elseif ( m2f ) then
         xyscl = mfscl
      else
         xyscl = 1.0
      endif

      if (flat) then
cmam open input and output flat files
	luin = 5
	if (ntap .ne. ' ') then

	 luin = 75
         open(unit=luin,file=ntap,status='old',iostat=ieri)
         if (ieri .gt. 0) then
              write(LER,*)'li_di: Could not open input flat file ',
     :             ntap
            write(LER,*)'       Check existance and rerun '
            write(LER,*)'FATAL'
            stop
         endif

	endif

	luout = 6
	if(otap .ne. ' ') then
	 luout = 77
         open(unit=luout,file=otap,status='unknown',iostat=iero)
         if (iero .gt. 0) then
              write(LER,*)'li_di: Could not open output flat file ',
     :             otap
            write(LER,*)'       Check existance and rerun '
            write(LER,*)'FATAL'
            stop
         endif

	endif

	 go to 10
 
      endif

c open input and output data streams
     
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open output fold map data stream if requested

      if (fld) then
         call getln(lufld, ftap, 'w', -1)
         write(LER,*)'Opened unit ',lufld,' for fold map'
         if (lufld .lt. 2) then
            write(LERR,*)'ERROR in li_di:'
            write(LERR,*)'Unable to create fold data set.'
            write(LER ,*)'ERROR in li_di:'
            write(LER ,*)'Unable to create fold data set.'
            stop
         endif
      endif

c  read line header of input save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'li_di: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c print historical line header to printout file

      call hlhprt (itr, lbytes, name, 5, LERR)

c set up pointers to header values required by routine

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)


C build LI/DI coordinates

   10 continue
      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

      if (rebinr .or. rebinl) then

          DE = DBLE(FLOAT(IX1)) * XXT + DBLE(FLOAT(IY1)) * XYT
          DF = DBLE(FLOAT(IX1)) * YXT + DBLE(FLOAT(IY1)) * YYT
          XYYXXY =  XYT * YXT - XXT * YYT
          if (XYYXXY .eq. 0.) then
          write(LERR,*)' '
          write(LERR,*)'FATAL ERROR in li_di re-bin options'
          write(LERR,*)'Attempt to use survey coords to fill in bin'
          write(LERR,*)'centers failed due to coord transform'
          write(LERR,*)'singularity (bad coord choice most likely)'
          stop 666
          endif

      endif

      if (flat) then
cmam this is for flat file input and output

               jcount = 0
cmam check for x,y to li,di -or- li,di to x,y
	 if ( rebinl ) then

cmam li,di to x,y

          DE = DBLE(FLOAT(IX1)) * XXT + DBLE(FLOAT(IY1)) * XYT
          DF = DBLE(FLOAT(IX1)) * YXT + DBLE(FLOAT(IY1)) * YYT
          XYYXXY =  XYT * YXT - XXT * YYT
          if (XYYXXY .eq. 0.) then
          write(LERR,*)' '
          write(LERR,*)'FATAL ERROR in li_di re-bin options'
          write(LERR,*)'Attempt to use survey coords to fill in bin'
          write(LERR,*)'centers failed due to coord transform'
          write(LERR,*)'singularity (bad coord choice most likely)'
          stop 666
          endif

cmam read next pair of li,di values from the input file
	 do while (1 .eq. 1)
      	       read(luin,*,end=520,err=510) xli, xdi
               jcount = jcount + 1

               E = (DBLE(xli) - 0.5) * DX + DE
               F = (DBLE(xdi) - 0.5) * DY + DF
               CDPX  = (F * XYT - E * YYT) / XYYXXY
c               if (YYT .ne. 0.) then
               if (dabs(YYT) .ge. 0.001 ) then
                  CDPY  = (F - CDPX * YXT) / YYT
               elseif (XYT .ne. 0.) then
                  CDPY  = (E - CDPX * XXT) / XYT
               endif

cmam write this pair of x,y values to output file

               write(luout,'(f15.2,2x,f15.2)') CDPX, CDPY
	 enddo

cmam error occured on reading x,y values
  510          write(LERR,*)'Error occured reading input file.'
               write(LERR,*)'Attempting to close file to save'
               write(LERR,*)'any output to this point.  Last'
               write(LERR,*)'good pair read was on line=',jcount
cmam close input and output files
  520          endfile (unit=luout)
               close (luin)
               close (luout)
cmam we're through here -- go to end of program
               go to 1000

	 elseif ( lidi_rnum ) then
cmam x,y to li,di
cmam read next pair of x,y values from the input file
         do while (1 .eq. 1)
               read(luin,*,end=620,err=610) cx,cy
               jcount = jcount + 1

               IWRN = 0
               CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT,IWRN,
     1              IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2              DX, DY, NDI, NLI)
 
cmam write this pair of li,di values to output file
               write(luout,*) icli,icdi
         enddo
cmam error occured on reading li,di values
  610          write(LERR,*)'Error occured reading input file.'
               write(LERR,*)'Attempting to close file to save'
               write(LERR,*)'any output to this point.  Last'
               write(LERR,*)'good pair read was on line=',jcount
cmam close input and output files
  620          endfile (unit=luout)
               close (luin)
               close (luout)
cmam we're through here -- go to end of program
               go to 1000

	 else
cmam error: user did not specify which values are being input
                  write(LERR,*)'FATAL ERROR: you specified flat'
                  write(LERR,*)'             input,output. You'
                  write(LERR,*)'             must specify either'
                  write(LERR,*)'             -LIDI for x,y input'
                  write(LERR,*)'          or -BRI for li,di input'
         endif
 
        go to 1000
      endif

c continue here for usp format in and out
      if (limax .eq. 0) then
          maxli = NX
      else
          maxli = limax
      endif
      if (limin .eq. 0) then
          minli = 1
      else
          minli = limin
      endif
      if (dimax .eq. 0) then
          maxdi = NY
      else
          maxdi = dimax
      endif
      if (dimin .eq. 0) then
          mindi = 1
      else
          mindi = dimin
      endif

      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

      IF (limit .AND. .not.reject) THEN

         call savew(itr, 'MnDpIn', mindi, LINHED)
         call savew(itr, 'MxDpIn', maxdi, LINHED)
         call savew(itr, 'MnLnIn', minli, LINHED)
         call savew(itr, 'MxLnIn', maxli, LINHED)

         if (stk) then
            call savew(itr, 'NumTrc', NDI  , LINHED)
            call savew(itr, 'NumRec', NLI  , LINHED)
         endif

      ENDIF

c inject command line into historical lineheader
 
      call savhlh ( itr, lbytes, lbyout )
 
c write output lineheader
 
      call wrtape ( luout, itr, lbyout )
 
      if (fld) then
         item = (NLI+1) * (NDI+1) * SZSMPD
         call savew(itr, 'NumTrc', NLI  , LINHED)
         call savew(itr, 'NumSmp', NDI  , LINHED)
         call savew(itr, 'NumRec',   1  , LINHED)
         call wrtape ( lufld, itr, lbyout )

c define number output bytes
 
         obytes = SZTRHD + NDI * SZSMPD
 
      else
         item = SZSMPD
      endif

c dynamic memory allocation 

      if ( records ) then

         items = (nsamp + ITRWRD) * ntrc * SZSMPD
         nitems = nsamp + ITRWRD
         call galloc ( wkdata, items, errcd, abort )
 
         if ( errcd  .ne. 0 .AND. errcd1 .ne. 0)  then
            write(LERR,*)' '
            write(LERR,*)'ERROR in li_di:'
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) items,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'ERROR in li_di:'
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*) items,'  bytes'
            stop
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) items,'  bytes'
         endif
 
         call vclr (data, 1, ntrc*nsamp)

      endif

      if ( fld ) then

         call galloc ( wkfold, item, errcd, abort )

         if ( errcd  .ne. 0 )  then
            write(LERR,*)' '
            write(LERR,*)'ERROR in li_di:'
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) item,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'ERROR in li_di:'
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*) item,'  bytes'
            stop
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) item,'  bytes'
         endif

         call vclr (fold, 1, NDI*NLI)
      endif

c echo program parameterization to printout file

      write(LERR,*)' '
      write(LERR,*)'*********************************'
      write(LERR,*)' '
      write(LERR,*)'Min LI asked for =  ',minli
      write(LERR,*)'Max LI asked for =  ',maxli
      write(LERR,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LERR,*)'Min DI asked for =  ',mindi
      write(LERR,*)'Max DI asked for =  ',maxdi
      write(LERR,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LERR,*)'XY scaler        =  ',xyscl
      write(LERR,*)'Limit trace output? ',limit
      write(LERR,*)'Start LI number  =  ',linestrt
      write(LERR,*)'Start DI number  =  ',idistrt
      if (records) then
          write(LERR,*)'Mode A: application based on whole records'
      else
          write(LERR,*)'Mode B: application is trace by trace'
      endif
      if (lidi_rnum)
     1write(LERR,*)'Put LIs & DIs in trace headers'
      if (rebinr)
     1write(LERR,*)'Re-bin bin center XYs using rec & trc numbers'
      if (rebinl)
     1write(LERR,*)'Re-bin bin center XYs using LI & DI numbers'
      if (limit) then
         if (reject) write(LERR,*)'Rejecting data inside box'
         if (shot)
     1        write(LERR,*)'Limit traces based on shot XYs'
         if (rcvr)
     1        write(LERR,*)'Limit traces based on group XYs'
         if (cdp)
     1        write(LERR,*)'Limit traces based on midpoint XYs'
      endif
      if (fld) then
         write(LERR,*)'Generating bulk fold map '
      endif
      write(LERR,*)'*********************************'
      write(LERR,*)' '

c echo program parameterization to stderr

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'XY scaler        =  ',xyscl
      write(LER,*)'Limit trace output? ',limit
      write(LER,*)'Start LI number  =  ',linestrt
      write(LER,*)'Start DI number  =  ',idistrt
      if (records) then
          write(LER ,*)'Mode A: application based on whole records'
      else
          write(LER ,*)'Mode B: application is trace by trace'
      endif
      if (lidi_rnum)
     1write(LER ,*)'Put LIs & DIs in trace headers'
      if (rebinr)
     1write(LER ,*)'Re-bin bin center XYs using rec & trc numbers'
      if (rebinl)
     1write(LER ,*)'Re-bin bin center XYs using LI & DI numbers'
      if (limit) then
         if (reject) write(LER,*)'Rejecting data inside box'
         if (shot)
     1        write(LER,*)'Limit traces based on shot XYs'
         if (rcvr)
     1        write(LER,*)'Limit traces based on group XYs'
         if (cdp)
     1        write(LER,*)'Limit traces based on midpoint XYs'
      endif
      if (fld) then
      write(LER,*)'Generating bulk fold map '
      endif
      write(LER,*)'*********************************'
      write(LER,*)' '

c read through data. find midpoint LI & DI for each trace. stuff
c these values into the trace headers

      itrc = 0
      irec = 1

c************************        Mode A: apply to whole records
      IF ( records ) THEN
c************************        Mode A: apply to whole records

         DO  while (1.eq.1)

           call vclr (data, 1, nitems)
           go = .false.
           live = 0
           cxsum = 0.
           cysum = 0.

           DO  KK = 1, ntrc
             nbytes = 0
             call rtape (luin, itr, nbytes)
             if(nbytes .eq. 0) then
                write(LERR,*)'End of file on input:'
                write(LERR,*)'  rec= ',irec,'  trace= ',itrc
cmam            write(LERR,*)'  rec= ',irec,'  trace= ',irec
                go to 999
             endif
             call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            StaCor  , TRACEHEADER)
 
             if ( StaCor .ne. 30000 ) then


                call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
                call saver2(itr,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
                call saver2(itr,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
                call saver2(itr,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
                ICX = 0.5 * float (ISX + IRX) + 0.5
                ICY = 0.5 * float (ISY + IRY) + 0.5
                CX  = ICX
                CY  = ICY

                if (lidi_rnum) then
                  IWRN = 0
                  CALL XFMFWD (CX,CY,ICLI,ICDI,CXT,CYT,BXT,BYT,IWRN,
     1            IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2            DX, DY, NDI, NLI)
                endif

                if     ( shot ) then

                  SX = ISX
                  SY = ISY
                  IWRN = 0
                  CALL XFMFWD (SX,SY,ISLI,ISDI,SXT,SYT,BXT,BYT,IWRN,
     1            IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2            DX, DY, NDI, NLI)
                  IF (ISLI .LT. MINLI) IWRN = 1
                  if (ISLI .GT. MAXLI) IWRN = 1
                  IF (ISDI .LT. MINDI) IWRN = 1
                  IF (ISDI .GT. MAXDI) IWRN = 1
                  if (reject) IWRN = IWRN - 1
                  if ((.not. go) .AND. (IWRN .eq. 0) ) go = .true.

                elseif ( cdp ) then

                  if (.not. lidi_rnum) then
                  CX = ICX
                  CY = ICY
                  IWRN = 0
                  CALL XFMFWD (CX,CY,ICLI,ICDI,CXT,CYT,BXT,BYT,IWRN,
     1            IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2            DX, DY, NDI, NLI)
                  endif
                  IF (ICLI .LT. MINLI) IWRN = 1
                  if (ICLI .GT. MAXLI) IWRN = 1
                  IF (ICDI .LT. MINDI) IWRN = 1
                  IF (ICDI .GT. MAXDI) IWRN = 1
                  if (reject) IWRN = IWRN - 1
                  if ((.not. go) .AND. (IWRN .eq. 0) ) go = .true.
                  if ( go ) then
                     live = live + 1
                     cxsum = cxsum + cx
                     cysum = cysum + cy
                  endif

                elseif ( rcvr ) then

                  RX = IRX
                  RY = IRY
                  IWRN = 0
                  CALL XFMFWD (RX,RY,IRLI,IRDI,RXT,RYT,BXT,BYT,IWRN,
     1            IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2            DX, DY, NDI, NLI)
                  IF (IRLI .LT. MINLI) IWRN = 1
                  if (IRLI .GT. MAXLI) IWRN = 1
                  IF (IRDI .LT. MINDI) IWRN = 1
                  IF (IRDI .GT. MAXDI) IWRN = 1
                  if (reject) IWRN = IWRN - 1
                  if ((.not. go) .AND. (IWRN .eq. 0) ) go = .true.

                endif

                if (lidi_rnum .AND. .not.reject) then
 
                   ICLIo = ICLI + linestrt - 1
                   ICDIo = ICDI + idistrt - 1
                   call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                  ICLIo   , TRACEHEADER)
                   call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                  ICDIo   , TRACEHEADER)
                endif

                if (fld .AND. (IWRN .eq. 0) ) then

                   ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
                   fold (ipntr) = fold (ipntr) + 1.0
                endif


             endif
             irec = irec + 1
             istrc = (KK-1) * nitems + 1
             call vmov (itr, 1, data(istrc), 1, nitems)


           ENDDO

           IF ( go ) THEN

              if ( bcxy ) then
                 cxsum = cxsum / float (live)
                 icxsum = cxsum
                 cysum = cysum / float (live)
                 icysum = cysum
              endif

              DO  KK = 1, ntrc
                 istrc = (KK-1) * nitems + 1
                 call vmov (data(istrc), 1, itr, 1, nitems)
                 if ( bcxy ) then
                   call savew2(itr,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                  icxsum  , TRACEHEADER)
                   call savew2(itr,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                  icysum  , TRACEHEADER)
                 endif
                 call wrtape (luout, itr, nbytes)
              ENDDO
           ENDIF

         ENDDO

c************************       Mode B: apply trace by trace
      ELSE
c************************       Mode B: apply trace by trace

      DO  while (1.eq.1)

         nbytes = 0
         call rtape (luin, itr, nbytes)
         if(nbytes .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)'  rec= ',irec,'  trace= ',itrc
cmam        write(LERR,*)'  rec= ',irec,'  trace= ',irec
            go to 999
         endif

         itrc = itrc + 1
         IF (itrc .gt. ntrc) THEN
            itrc = 1
            irec = irec + 1
            if (verbos) then
               write(LERR,*)'Reading record ',irec
               write(LER ,*)'Reading record ',irec
            endif
         ENDIF

         call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1        StaCor  , TRACEHEADER)

c----
c   FOR RE-BINNING DATA
c   re-bin bin center XYs based on either rec/trc numbers or LI/DI numbers
c   after re-binning we drop down to output trace
c----
         IF (rebinr .or. rebinl) THEN
 
            if (rebinr) then
               call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     1              iix, TRACEHEADER)
               call saver2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              iiy, TRACEHEADER)
            elseif (rebinl) then
               call saver2(itr,ifmt_LinInd,l_LinInd,ln_LinInd,
     1              iix, TRACEHEADER)
               call saver2(itr,ifmt_DphInd,l_DphInd,ln_DphInd,
     1              iiy, TRACEHEADER)

            endif
 
c watch for dead trace with no indexing.  We can only process live
c traces [which better have indexing] and dead traces that have 
c indexing.  Drop any trace that is dead and does not have indexing
c as we have no way of knowing where it came from.

            if ( StaCor .ne. 30000 .or. ( StaCor .eq. 30000 .and. 
     :           ( iix .ne. 0 .or. iiy .ne. 0 ) ) ) then

c here is where we start.......the implicit assumption made here
c for the first time....up til now things have been fairly universal
c is that dx is associated with iix which is associated with LinInd
c and that dy is associated with iiy which is associated with DphInd
c
c to test this I will run a system like I have and check the X assignment
c which if correct for all cases will leave me with the cdpy assignment
c below to puzzle out.

               E = (DBLE(FLOAT(iix)) - 0.5) * DX + DE
               F = (DBLE(FLOAT(iiy)) - 0.5) * DY + DF
               CDPX  = (F * XYT - E * YYT) / XYYXXY

               if (dabs(YYT) .ge. 0.001 )then
                  CDPY  = (F - CDPX * YXT) / YYT
               elseif (XYT .ne. 0.) then
                  CDPY  = (E - CDPX * XXT) / XYT
               endif

               icxx = CDPX
               icyy = CDPY

               call savew2(itr,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1              icxx   , TRACEHEADER)
               call savew2(itr,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1              icyy   , TRACEHEADER)

               if (lidi_rnum) then
 
                  call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                 iix    , TRACEHEADER)
                  call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                 iiy    , TRACEHEADER)
               endif
               
               go to 100

            else
               go to 200
            endif

         ENDIF


c get shot coordinate 
 
         call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1        ISX     , TRACEHEADER)
         call saver2(itr,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1        ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY

c   FOR LIMITING OUTPUT DATA (SHOTS)...
c   for limit option is trace shot XY within survey boundary?

         IF (shot) THEN

c watch for dead trace with no indexing.  We can only process live
c traces [which better have indexing] and dead traces that have 
c indexing.  Drop any trace that is dead and does not have indexing
c as we have no way of knowing where it came from.

            if ( StaCor .ne. 30000 .or. ( StaCor .eq. 30000 .and. 
     :           ( ISX .ne. 9999999 .or. ISY .ne. 9999999 ) ) ) then

               IWRN = 0
               CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT,BXT,BYT,IWRN,
     1              IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2              DX, DY, NDI, NLI)
            
               if (lidi_rnum) then

                  call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                 ISLI    , TRACEHEADER)
                  call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                 ISDI    , TRACEHEADER)

               endif

               if (limit) then

                  IF (ISLI .LT. MINLI) IWRN = 1
                  if (isli .gt. maxli) iwrN = 1
                  IF (ISDI .LT. MINDI) IWRN = 1
                  IF (ISDI .GT. MAXDI) IWRN = 1

                  if (IWRN .eq. 1) then
                     if (reject) goto 100
                     go to 200
                  else
                     if (reject) goto 200
                     goto 100
                  endif

               endif

            else
               go to 200
            endif

         ENDIF
 
c get receiver coordinate
 
         call saver2(itr,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1        IRX     , TRACEHEADER)
         call saver2(itr,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1        IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY

c   FOR LIMITING OUTPUT DATA (GROUPS)...
c   for limit option is trace group XY within survey boundary?

         IF (rcvr) THEN

c watch for dead trace with no indexing.  We can only process live
c traces [which better have indexing] and dead traces that have 
c indexing.  Drop any trace that is dead and does not have indexing
c as we have no way of knowing where it came from.

            if ( StaCor .ne. 30000 .or. ( StaCor .eq. 30000 .and. 
     :           ( IRX .ne. 9999999 .or. IRY .ne. 9999999 ) ) ) then

               IWRN = 0
               CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT,BXT,BYT,IWRN,
     1              IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2              DX, DY, NDI, NLI)

               if (lidi_rnum) then

                  call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                 IRLI    , TRACEHEADER)
                  call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                 IRDI    , TRACEHEADER)

               endif

               if (limit) then

                  IF (IRLI .LT. MINLI) IWRN = 1
                  IF (IRLI .GT. MAXLI) IWRN = 1
                  IF (IRDI .LT. MINDI) IWRN = 1
                  IF (IRDI .GT. MAXDI) IWRN = 1
                  if (IWRN .eq. 1) then
                     if (reject) goto 100
                     go to 200
                  else
                     if ( reject ) goto 200
                     goto 100
                  endif
                  
               endif

            else
               go to 200
            endif
 
         ENDIF
 
c working with stacked data

         IF (stk) THEN

c watch for dead trace with no indexing.  We can only process live
c traces [which better have indexing] and dead traces that have 
c indexing.  Drop any trace that is dead and does not have indexing
c as we have no way of knowing where it came from.  Most dead traces
c coming from sr3d2 will have 9999999 in CDPBCX and CDPBCY.

            if ( StaCor .ne. 30000 .or. ( StaCor .eq. 30000 .and. 
     :           ( IRX .ne. 0 .or. IRY .ne. 0 ) .and. 
     :           ( IRX .ne. 9999999 .or. IRY .ne. 9999999 ) ) ) then

               call saver2(itr,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1              ICDPX   , TRACEHEADER)
               call saver2(itr,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1              ICDPY   , TRACEHEADER)

            else
               go to 200
            endif
         ELSE
 
            ICDPX = 0.5 * float (ISX + IRX) + 0.5
            ICDPY = 0.5 * float (ISY + IRY) + 0.5
            
         ENDIF

         CX = ICDPX
         CY = ICDPY

c   FOR LIMITING OUTPUT DATA (CDPS)...
c   if this trace within survey coords based on CDP XYs?
c   then compute new LI & DI numbers and offsets - store

         IF (cdp) THEN

c watch for dead trace with no indexing.  We can only process live
c traces [which better have indexing] and dead traces that have 
c indexing.  Drop any trace that is dead and does not have indexing
c as we have no way of knowing where it came from.

            if ( StaCor .ne. 30000 .or. ( StaCor .eq. 30000 .and. 
     :           ( ICDPX .ne. 0 .or. ICDPY .ne. 0 ) ) ) then

               IWRN = 0
               CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT,IWRN,
     1              IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2              DX, DY, NDI, NLI)

               if (lidi_rnum) then

                  call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                 ICLI    , TRACEHEADER)
                  call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                 ICDI    , TRACEHEADER)

c compute the offset

                  DXT  = ISX - IRX
                  DYT  = ISY - IRY
                  off  = sqrt ( DXT*DXT + DYT*DYT ) + 0.5
                  DstSgn = off
                  ICLIo = ICLI + linestrt - 1
                  ICDIo = ICDI + idistrt - 1

                  call savew2(itr,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                 ICDPX   , TRACEHEADER)
                  call savew2(itr,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                 ICDPY   , TRACEHEADER)
                  call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                 ICDIo   , TRACEHEADER)
                  call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                 ICLIo   , TRACEHEADER)
                  call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                 DstSgn    , TRACEHEADER)

                  if (fld .AND. (IWRN .eq. 0)) then
                     ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
                     fold (ipntr) = fold (ipntr) + 1.0
                  endif

               endif

               if (limit) then

                  IF (ICLI .LT. MINLI) IWRN = 1
                  IF (ICLI .GT. MAXLI) IWRN = 1
                  IF (ICDI .LT. MINDI) IWRN = 1
                  IF (ICDI .GT. MAXDI) IWRN = 1

                  if (IWRN .eq. 1) then
                     if (reject) goto 100
                     go to 200
                  else
                     if ( reject ) goto 200
                     goto 100
                  endif

               endif

            else
               go to 200
            endif

         ENDIF

 100     continue

         call wrtape (luout, itr, nbytes)

 200     continue

      ENDDO

c************************
      ENDIF
c************************

 999  continue

      if (fld) then

         call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1        1  , TRACEHEADER)

         do  ili = 1, NLI

            do  idi = 1, NDI
               ipntr = (idi - 1) + (ili - 1) * ndi + 1
            enddo

            call vmov (fold(ipntr), 1, itr(ITHWP1), 1, NDI)
            call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1           ili  , TRACEHEADER)
            call wrtape (lufld, itr, obytes)

         enddo  
              
         call lbclos (lufld)

      endif

      write(LERR,*)'li_di completed processing ',irec,' records'
      write(LER ,*)'li_di completed processing ',irec,' records'

      call lbclos (luin)
      call lbclos (luout)

c end of program
 1000 continue

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'Command Line Arguments for li_di: insert LI &'
      write(LER,*)'DI numbers into input traces (any sort order)'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[ntap] (def = stdin) : input seismic data'
      write(LER,*)'-O[otap] (def = stdout): output seismic data'
      write(LER,*)' '
      write(LER,*)'-flat     : input and output files are NOT usp'
      write(LER,*)'            format data but flat files containing'
      write(LER,*)'            X,Y pairs or LI,DI pairs'
      write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1 '
      write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1 '
      write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2'
      write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2'
      write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3'
      write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3'
      write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4'
      write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4'
      write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
      write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'
      write(LER,*)
     :' -limin[]     (def = 1)                    : minimum LI '
      write(LER,*)
     :' -limax[]     (def = number of bins in x)  : maximum LI '
      write(LER,*)
     :' -dimin[]     (def = 1)                    : minimum DI '
      write(LER,*)
     :' -dimax[]     (def = number of bins in y)  : maximum DI '
      write(LER,*)
     :' -LI1[listart] (def = 1)    : starting line number'
      write(LER,*)
     :' -DI1[listart] (def = 1)    : starting x-line (or trace) number'
      
      write(LER,*)' '
      write(LER,*)'-f2m      : scale XYs from feet to meters'
      write(LER,*)'-m2f      : scale XYs from meters to feet'
      write(LER,*)'            otherwise no XY scaling'
      write(LER,*)'            pick file is Landmark format'
      write(LER,*)'-L        : perform limit function, otherwise'
      write(LER,*)'            just stuff LI & DIs into trc headers'
      write(LER,*)'-shot     : limit trace based on shot XYs'
      write(LER,*)'-records  : limit whole shot based on cdp XYs'
      write(LER,*)'-rcvr     : limit trace based on group XYs'
      write(LER,*)'-cdp      : limit trace based on midpoint XYs'
      write(LER,*)'-stk      : input is stack (look at CDPBCX/Y)'
      write(LER,*)'-F[ftap]  : optional output bulk fold map'
      write(LER,*)'-BRI      : re-compute bin center XYs based on rec'
      write(LER,*)'            and trace numbers (RecNum & TrcNum)'
      write(LER,*)'-BLI      : re-compute bin center XYs based on LI'
      write(LER,*)'            and and DI numbers'
cmam....
      write(LER,*)'          NOTE: if using flat files, input is',
     :' LI,DI pairs,'
      write(LER,*)'            output is bin center X,Y pairs'
      write(LER,*)' '

      write(LER,*)'-LIDI     : compute LI/DIs based on shot, rcvr, or',
     1   ' cdp'
cmam....
      write(LER,*)'          NOTE: if using flat files, input is X,Y'
      write(LER,*)'            pairs, output is LI,DI pairs'
      write(LER,*)' '

      write(LER,*)'-bcxy     : simple compute bin center XYs from src/'
      write(LER,*)'            rcvr XYs (no limiting)'
      write(LER,*)'-reject   : pass data outside box only'
      write(LER,*)'-V        : verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)' li_di -N[] -P[] -O[] -x1[] -y1[] -x2[]'
      write(LER,*)'       -y2[] -x3[] -y3[] -x4[] -y4[]'
      write(LER,*)'       -ildm[] -icdm[] [-L -shot -records-rcvr -cdp'
      write(LER,*)'       -reject -stk -F[ftap] -BRI -BLI -LIDI -V]'
      write(LER,*)'       [-limin[] -limax[] -dimin[] -dimax[] ] -bcxy'
      write(LER,*)'   '     
      write(LER,*)'Usage with flat files:'
      write(LER,*)' li_di -N[] -O[] -x1[] -y1[] -x2[] -y2[]'
      write(LER,*)'       -x3[] -y3[] -x4[] -y4[] -ildm[] -icdm[]'
      write(LER,*)'       [-LIDI] [-BRI] [-V]'
      write(LER,*)'   '

      return
      end

c-----
c     get command arguments
c
c     otap  - C*100  output file name
c      t0   - R      normal incidence time
c       v   - R      velocity (ft/s or m/s)
c      x0   - R      near offset
c     ntr   - I      number traces
c     nsi   - I      sample interval
c     amp   - R      amplitude of spikes
c      ns   - I      number samples
c    refl   - L      reflection
c    refr   - L      refraction
c    up     - L      updip refraction
c    down   - L      downdip refraction
c    dip    - R      dip angle of reflector/refractor
c    v2     - R      velocity below refractor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln( ntap, otap, limin, limax, dimin, dimax, verbos,
     1     IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, DY, DX,
     2     f2m, m2f, limit, shot, rcvr, cdp, fld, ftap, stk,
     3     linestrt, idistrt, rebinr, rebinl, lidi_rnum , reject,
     4     records, bcxy, flat)

#include <f77/iounit.h>
      integer    argis
      integer    limin,limax,dimin,dimax,linestrt,idistrt
      integer    IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4

      character  ntap *(*), otap *(*), ftap *(*)

      logical    verbos, f2m, m2f, limit, shot, rcvr, cdp, fld, stk
      logical    rebinr, rebinl, lidi_rnum, reject, records, bcxy
      logical	 flat

c declare local variables

      lidi_rnum = .false.
      limit     = .false.
      rebinr    = .false.
      rebinl    = .false.
      shot      = .false.
      records   = .false.
      rcvr      = .false.
      cdp       = .false.
      fld       = .false.
      stk       = .false.
      reject    = .false.
      bcxy      = .false.

      rebinl    = ( argis( '-BLI' ) .gt. 0 )
      rebinr    = ( argis( '-BRI' ) .gt. 0 )

      flat      = ( argis( '-flat' ) .gt. 0)

      records   = ( argis( '-records' ) .gt. 0 )
      cdp       = ( argis( '-cdp' ) .gt. 0 )
      bcxy      = ( argis( '-bcxy' ) .gt. 0 )
      if ( bcxy ) then
         records = .true.
         cdp = .true.
         write(LERR,*)' '
         write(LERR,*)'For computing bin center XYs must do this on'
         write(LERR,*)'record oriented basis, e.g. CDPs'
       endif
      call argr4 ('-cldm', dx, 0., 0.)

      if (dx .eq. 0.) then
         write(LERR,*)' '
         write(LERR,*)'Fatal Error in li_di:'
         write(LERR,*)'Must enter x-line cell dimension -cldm[]'
         write(LER ,*)' '
         write(LER ,*)'Fatal Error in li_di:'
         write(LER ,*)'Must enter x-line cell dimension -cldm[]'
         stop
      endif
      
      call argi4 ('-dimin', dimin , 1 , 1 )
      call argi4 ('-dimax', dimax , 0 , 0 )
      call argi4 ('-DI1', idistrt, 1 , 1 )

      f2m       = ( argis( '-f2m' ) .gt. 0 )
      call argstr ('-F',ftap,' ',' ')
      if (ftap(1:1) .eq. ' ') then
         fld = .false.
      else
         fld = .true.
      endif

      call argr4 ('-ildm', dy, 0., 0.)
      
      if (dy .eq. 0.) then
         write(LERR,*)' '
         write(LERR,*)'Fatal Error in li_di:'
         write(LERR,*)'Must enter inline cell dimension -cldm[]'
         write(LER ,*)' '
         write(LER ,*)'Fatal Error in li_di:'
         write(LER ,*)'Must enter inline cell dimension -ildm[]'
         stop
      endif
      
      call argi4 ('-limin', limin , 1 , 1 )
      call argi4 ('-limax', limax , 0 , 0 )
      lidi_rnum = ( argis( '-LIDI' ) .gt. 0 )
      call argi4 ('-LI1', linestrt, 1 , 1 )

      if (.not. records) then
         limit     = ( argis( '-L' ) .gt. 0 )
      else
         limit     = .true.
         rebinr    = .false.
         rebinl    = .false.
      endif

      if (.not. lidi_rnum .AND. .not. limit .AND. .not. rebinl .AND.
     1     .not. rebinr) lidi_rnum = .true.
      
      
      m2f  = ( argis( '-m2f' ) .gt. 0 )
      
      call argstr ('-N',ntap,' ',' ')
      
      call argstr ('-O',otap,' ',' ')
      
      reject    = ( argis( '-reject' ) .gt. 0 )
      rcvr      = ( argis( '-rcvr' ) .gt. 0 )
      
      shot      = ( argis( '-shot' ) .gt. 0 )
      stk       = ( argis( '-stk' ) .gt. 0 )
      if (stk) cdp = .true.

      if (records) then
         if (stk) then
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in li_di:'
         write(LERR,*)'-records option only for prestack data'
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in li_di:'
         write(LER ,*)'-records option only for prestack data'
         stop
         endif
      endif
      
      
      if (limit .AND.
     1     (.not.shot .and. .not.rcvr .and. .not.cdp)) then
         write(LERR,*)' '
         write(LERR,*)'WARNING from li_di:'
         write(LERR,*)'For limit option defaulting XYs to shots'
         write(LER ,*)' '
         write(LER ,*)'WARNING from li_di:'
         write(LER ,*)'For limit option defaulting XYs to shots'
         shot = .true.
      endif
      
      if (lidi_rnum .AND. (.not.flat) .AND.
     1     (.not.shot .and. .not.rcvr .and. .not.cdp)) then
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR from li_di:'
         write(LERR,*)'For putting LI/DIs into header must specify:'
         write(LERR,*)'-shot or -rcvr or -cdp'
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR from li_di:'
         write(LER ,*)'For putting LI/DIs into header must specify:'
         write(LER ,*)'-shot or -rcvr or -cdp'
         stop
      endif
      
      call argi4 ('-x1', ix1, 0 , 0 )
      call argi4 ('-y1', iy1, 0 , 0 )
      
      call argi4 ('-x2', ix2, 0 , 0 )
      call argi4 ('-y2', iy2, 0 , 0 )
      
      call argi4 ('-x3', ix3, 0 , 0 )
      call argi4 ('-y3', iy3, 0 , 0 )
      
      call argi4 ('-x4', ix4, 0 , 0 )
      call argi4 ('-y4', iy4, 0 , 0 )
      
      if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1     .AND.
     2     ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3     then
         write(LERR,*)' '
         write(LERR,*)'Fatal Error in li_di:'
         write(LERR,*)'Must enter 4 corners of survey using -x1[]'
         write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
         write(LER ,*)' '
         write(LER ,*)'Fatal Error in li_di:'
         write(LER ,*)'Must enter 4 corners of survey using -x1[]'
         write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
         stop
      endif
      
      return
      end
      
