c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
C***********************************************************************
C Copyright 2001, Allied Geophysics, Inc. All Rights Reserved          *
C***********************************************************************
c***********************************************************************
c count the number of grid points inside a circle 
c***********************************************************************
      subroutine count_mask_pts(d1,d2,radius,npt_mask)
      
      implicit none

c Arguments
      integer npt_mask
      real    d1,d2,radius

c Local variables
      integer npt1,npt2, icenter1,icenter2, i1,i2
      real    dist, dist2
      
c Do it
      npt1 = int(radius/d1) + 1
      npt2 = int(radius/d2) + 1
      icenter1 = (npt1-1)/2
      icenter2 = (npt2-1)/2
      npt_mask = 0
      do i2 = 1,npt2
        dist2 = (icenter2-i2)**2
        do i1 = 1,npt1
          dist = sqrt((icenter1-i1)**2 + dist2)
          if (dist .le. radius) npt_mask = npt_mask+1
        enddo
      enddo
      
c Done
      return
      end
