C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine LoadNavData ( Headers, FieldRecNum, Nav_Shot_X,
     :     Nav_Shot_Y, Nav_Shot_WaterBottom,  Nav_Group_X, 
     :     Nav_Group_Y, ns, ne, HeaderSize, ntrc, ntrco, 
     :     ifmt_RecNum, l_RecNum, ln_RecNum,
     :     ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     :     ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC,
     :     ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC,
     :     ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC,
     :     ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :     ifmt_StaCor, l_StaCor, ln_StaCor,
     :     ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm,
     :     ifmt_WDepDP, l_WDepDP, ln_WDepDP,
     :     verbos )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <save_defs.h> 

c declare variables passed from calling routine

      integer HeaderSize, FieldRecNum, ns ,ne, ntrc, ntrco
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor
      integer ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC
      integer ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC
      integer ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC
      integer ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC
      integer ifmt_WDepDP,l_WDepDP,ln_WDepDP
      integer ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm
      integer Headers(HeaderSize)

      real Nav_Shot_X, Nav_Shot_Y, nav_Shot_WaterBottom
      real Nav_Group_X(ntrc), Nav_Group_Y(ntrc)
      
c declare local variables

      integer KK, SrPtXC, SrPtYC, RcPtXC, RcPtYC, DstSgn
      integer StaCor, RecNum, WDepDP, SoPtNm, hdr_ndx

c initialize variables

      StaCor = 0

      hdr_ndx = 1 - ITRWRD

      do KK = ns, ne

         hdr_ndx = hdr_ndx + ITRWRD

c calculate header entries

         SrPtXC = nint ( Nav_Shot_X )
         SrPtYC = nint ( Nav_Shot_Y )
         RcPtXC = nint ( Nav_Group_X(KK - ns + 1 ) )
         RcPtYC = nint ( Nav_Group_Y(KK - ns + 1 ) )
         RecNum = FieldRecNum
         WDepDP = nint ( Nav_Shot_WaterBottom )
         SoPtNm = FieldRecNum

c calculate source - receiver offset

         x = abs ( Nav_Shot_X - Nav_Group_X(KK - ns + 1 ) )
         y = abs ( Nav_Shot_Y - Nav_Group_Y(KK - ns + 1 ) )
         DstSgn = nint ( sqrt ( x * x + y * y ) )

         call savew2 ( Headers(hdr_ndx), ifmt_RecNum, l_RecNum, 
     :        ln_RecNum, RecNum, TRACEHEADER )

         call savew2 ( Headers(hdr_ndx), ifmt_SrPtXC, l_SrPtXC, 
     :        ln_SrPtXC, SrPtXC, TRACEHEADER )
         call savew2 ( Headers(hdr_ndx), ifmt_SrPtYC, l_SrPtYC, 
     :        ln_SrPtYC, SrPtYC, TRACEHEADER )
         call savew2 ( Headers(hdr_ndx), ifmt_RcPtXC, l_RcPtXC, 
     :        ln_RcPtXC, RcPtXC, TRACEHEADER )
         call savew2 ( Headers(hdr_ndx), ifmt_RcPtYC, l_RcPtYC, 
     :        ln_RcPtYC, RcPtYC, TRACEHEADER )
         call savew2 ( Headers(hdr_ndx), ifmt_DstSgn, l_DstSgn, 
     :        ln_DstSgn, DstSgn, TRACEHEADER )
         call savew2 ( Headers(hdr_ndx), ifmt_StaCor, l_StaCor, 
     :        ln_StaCor, StaCor, TRACEHEADER )
         call savew2 ( Headers(hdr_ndx), ifmt_SoPtNm, l_SoPtNm, 
     :        ln_SoPtNm, SoPtNm, TRACEHEADER )
         call savew2 ( Headers(hdr_ndx), ifmt_WDepDP, l_WDepDP, 
     :        ln_WDepDP, WDepDP, TRACEHEADER )

      enddo

      return
      end

         
