C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ---------------------------  navmerge --------------------------------

c     Program Changes:

c      - original written: Feb/96 for Hammouda Nada GUPCO: P. Garossino

c     Program Description:

c      - read in 3D marine records and associated UKOOA_SegP navigation data 
c        and merge the nav data with the seismic data on a field shot point 
c        reference.  Shot skips are recorded in an attached -S skips file.  
c        The numbering in that file must also be in the raw field shot 
c        numbering scheme.  It is MANDITORY that the seismic and nav data
c        increment in sync.  If they do not this routine will fail.


c
c
c  am going to put in a policeman to abort if the indexing
c  gets out of sync between the nav and data files.   Also I need
c  to add an option to allow the user to key on something other than
c  RecNum.  i.e. -hw on the command line.

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD ), Dead_Trace ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis

      character   ntap*255, otap*255, name*8

      logical     verbos

c Program Specific _ dynamic memory variables

      integer Headers, Skip_Shot

      integer RecordSize, HeaderSize
      integer errcd1, errcd2, errcd3, errcd4, errcd5
      integer abort

      real    Record, Nav_Group_X, Nav_Group_Y 

      pointer (mem_Record, Record(200000))
      pointer (mem_Headers, Headers(200000))
      pointer (mem_Nav_Group_X, Nav_Group_X(200000))
      pointer (mem_Nav_Group_Y, Nav_Group_Y(200000))
      pointer (mem_Skip_Shot, Skip_Shot(200000))

c Program Specific _ static memory variables

      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor
      integer ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC
      integer ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC
      integer ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC
      integer ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC
      integer ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm
      integer ifmt_WDepDP,l_WDepDP,ln_WDepDP
      integer skip_index, tr_index, hdr_index
      integer water_velocity, NumSkips, FieldRecNum

      real Nav_Shot_X, Nav_Shot_Y, Nav_Shot_WaterBottom
      real junk

      character navtap*255, skiptap*255

c Initialize variables

      data abort/0/
      data name/"NAVMERGE"/
      data Dead_Trace/SZLNHD * 0/
      data skip_index/1/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, navtap, skiptap, name, water_velocity, 
     :     ns, ne, irs, ire, ist, iend, verbos )

c open input and output seismic data files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open input UKOOA dataset

      if ( navtap .ne. ' ' ) then
         call alloclun ( lunav )
         length = lenth( navtap )
         open ( lunav, file=navtap(1:length), status='old', err=990)
      else
         write(LERR,*)' '
         write(LERR,*)' You must attach a UKOOA file to this routine '
         write(LERR,*)' using the -U command line option.  Fix this '
         write(LERR,*)' situation and resubmit'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'NAVMERGE: '
         write(LER,*)'   You must attach a UKOOA file to this routine '
         write(LER,*)'   using the -U command line option.  Fix this '
         write(LER,*)'   situation and resubmit'
         write(LER,*)'FATAL'
         write(LER,*)' '
         goto 999
      endif

c open input skips dataset if present

      if ( skiptap .ne. ' ' ) then

         call alloclun ( luskip )
         length = lenth( skiptap )
         open ( luskip, file=skiptap(1:length), status='old', err=991 )

         call CountSkips (luskip, NumSkips)
      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'NAVMERGE: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('WDepDP',ifmt_WDepDP,l_WDepDP,ln_WDepDP,TRACEHEADER)

c historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 8, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
      ntrco = ne - ns + 1
      nsampo = iend - ist + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)
      call savew(itr, 'NumSmp', nsampo  , LINHED)
      call savew(itr, 'WatVel', water_velocity, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsampo 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsampo, nsi, ntrc, ntrco, nrec, 
     :     nreco, iform, ist, iend, irs, ire, ns, ne, navtap, 
     :     skiptap, water_velocity, verbos )

c dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      HeaderSize = ntrc * ITRWRD 

      call galloc (mem_Record, RecordSize * SZSMPD, errcd1, abort)
      call galloc (mem_Headers, HeaderSize * SZSMPD, errcd2, abort)
      call galloc (mem_Nav_Group_X, ntrc * SZSMPD, errcd3, abort)
      call galloc (mem_Nav_Group_Y, ntrc * SZSMPD, errcd4, abort)
    
      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) RecordSize * SZSMPD, '  bytes'
         write(LERR,*) HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 2 * ntrc * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) RecordSize * SZSMPD, '  bytes'
         write(LER,*) HeaderSize * SZSMPD, '  bytes'
         write(LER,*) 2 * ntrc * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) RecordSize * SZSMPD, '  bytes'
         write(LERR,*) HeaderSize * SZSMPD, '  bytes'
         write(LERR,*) 2 * ntrc * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

      if ( skiptap .ne. ' ' ) then

         call galloc (mem_Skip_Shot, NumSkips * SZSMPD, errcd5, abort)

         if ( errcd5 .ne. 0 )then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) NumSkips * SZSMPD, '  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) NumSkips * SZSMPD, '  bytes'
            write(LER,*)' '
            goto 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) NumSkips * SZSMPD, '  bytes'
            write(LERR,*)' '
         endif
         
         do i = 1, NumSkips
            read ( luskip, * ) junk
            Skip_Shot(i) = nint(junk)
         enddo

      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( Nav_Group_X, 1, ntrc )
      call vclr ( Nav_Group_Y, 1, ntrc )

      do i = 1, HeaderSize
         Headers(i) = 0
      enddo

c read in all
c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         tr_index = 1 - nsampo
         hdr_index = 1 - ITRWRD

         DO KK = ns, ne

c set array load points for this trace 

           tr_index = tr_index + nsampo
           hdr_index = hdr_index + ITRWRD

c read input trace

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               goto 999
            endif

c load trace to array Record[]

            call vmov ( itr(ITHWP1 + ist - 1 ), 1, Record(tr_index), 1, 
     :           nsampo )

c load trace header to array Headers[]

            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

         ENDDO

c get required trace header information

         call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :        RecNum, TRACEHEADER )

c get UKOOA navigation data for this record

         done = 0

         do while ( done .eq. 0 )

            call GetNavData ( lunav, ntrc, FieldRecNum, Nav_Shot_X, 
     :           Nav_Shot_Y, Nav_Shot_WaterBottom, Nav_Group_X, 
     :           Nav_Group_Y, ns )
         
            if ( FieldRecnum .eq. Skip_Shot(skip_index) ) then
            
               call PadThisRecord ( Headers, FieldRecNum, Nav_Shot_X,
     :              Nav_Shot_Y, Nav_Shot_WaterBottom, Nav_Group_X, 
     :              Nav_Group_Y, ns, ne, HeaderSize, ntrc, ntrco, 
     :              ifmt_RecNum, l_RecNum, ln_RecNum,
     :              ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     :              ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC,
     :              ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC,
     :              ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC,
     :              ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :              ifmt_StaCor, l_StaCor, ln_StaCor,
     :              ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm,
     :              ifmt_WDepDP, l_WDepDP, ln_WDepDP,
     :              verbos )
               
               skip_index = skip_index + 1
               if ( skip_index .gt. NumSkips ) skip_index = NumSkips

c reset array load points for this trace 

               hdr_index = 1 - ITRWRD

               DO KK = ns, ne

c write out padded record

                  hdr_index = hdr_index + ITRWRD

                  call vmov ( Dead_Trace, 1, itr(ITHWP1), 1, nsampo )
                  call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
                  call wrtape (luout, itr, obytes)
 
               ENDDO
 
            else
               
               done = 1
            endif

         enddo


c load UKOOA navigation data to this record

         call LoadNavData ( Headers, FieldRecNum, Nav_Shot_X, 
     :        Nav_Shot_Y, Nav_Shot_WaterBottom, Nav_Group_X, 
     :        Nav_Group_Y, ns, ne, HeaderSize, ntrc, ntrco,
     :        ifmt_RecNum, l_RecNum, ln_RecNum,
     :        ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     :        ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC,
     :        ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC,
     :        ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC,
     :        ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :        ifmt_StaCor, l_StaCor, ln_StaCor,
     :        ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm,
     :        ifmt_WDepDP, l_WDepDP, ln_WDepDP,
     :        verbos )
            
c reset array load points for this trace 

         tr_index = 1 - nsampo
         hdr_index = 1 - ITRWRD

c write output data

         DO KK = ns, ne

c write output data

            tr_index = tr_index + nsampo
            hdr_index = hdr_index + ITRWRD

            call vmov ( Record(tr_index), 1, itr(ITHWP1), 1, nsampo )
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape (luout, itr, obytes)
 
         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      close ( lunav )
      if ( skiptap .ne. ' ' ) close(luskip)
      write(LERR,*)'navmerge: Normal Termination'
      write(LER,*)'navmerge: Normal Termination'
      stop

c error messages

 990  continue

      write(LERR,*)' '
      write(LERR,*)'Cannot open the UKOOA input file ',navtap(1:length)
      write(LERR,*)'Check spelling / existence and resubmit '
      write(LERR,*)'FATAL '
      write(LER,*)' '
      write(LER,*)'NAVMERGE: '
      write(LER,*)'  Cannot open the UKOOA input file ',navtap(1:length)
      write(LER,*)'  Check spelling / existence and resubmit '
      write(LER,*)'FATAL '
      write(LER,*)' '
      stop

 991  continue

      write(LERR,*)' '
      write(LERR,*)'Cannot open the Skips input file ',skiptap(1:length)
      write(LERR,*)'Check spelling / existence and resubmit '
      write(LERR,*)'FATAL '
      write(LER,*)' '
      write(LER,*)'NAVMERGE: '
      write(LER,*)' Cannot open the Skips input file ',skiptap(1:length)
      write(LER,*)' Check spelling / existence and resubmit '
      write(LER,*)'FATAL '
      write(LER,*)' '
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      close ( lunav )
      if ( skiptap .ne. ' ' ) close(luskip)
      write(LERR,*)'navmerge: ABNORMAL Termination'
      write(LER,*)'navmerge: ABNORMAL Termination'
      stop
      end
