      SUBROUTINE DMCARD (IPRT,   ICRD,   NTRCS, NFOLD, ngrp,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3,
     &             IY3,    IX4, IY4, NTPL,NLI, NDI,
     &             DIVEXP, TRCSPC,   verbos, norm, shot,
     &             spread, pr, ol, prew, TV, lslide, ist, ied, vel)
C***********************************************************************00001970
C                                                                       00001980
C     PROGRAM NAME: DMCARD (READ USER CARDS FOR DM3D)                   00001990
C                                                                       00002000
C     LANGUAGE: FORTRAN                                                 00002010
C                                                                       00002020
C     AUTHOR: G.MURPHY                                                  00002030
C                                                                       00002040
C     DATE WRITTEN: 07/01/88                                            00002050
C                                                                       00002060
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00002080
C                                                                       00002100
C     ABSTRACT: READ DM3D CARDS                                         00002110
C                                                                       00002120
C                                                                       00002130
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00002140
C                                                                       00002150
C***********************************************************************00002160
C                                                                       00002170
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      REAL          spread (*)
      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      integer       argis
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      CHARACTER*80  CARD
      logical       verbos, norm, shot, TV
      DATA IEND, IFLAG /0,1/

         call argr4 ('-dmin',  DSTMIN, 0., 0.)
         call argr4 ('-dmax',  DSTMAX, 0., 0.)
         call argr4 ('-ddel',  DSTDEL, 0., 0.)
c        call argr4 ('-angmn', ANGMIN, 0., 0.)
c        call argr4 ('-angmx', ANGMAX, 0., 0.)
         call argr4 ('-dexp',  DIVEXP, .7, .7)
         call argi4 ('-dimin', MINDI , 1 , 1 )
         call argi4 ('-dimax', MAXDI , 0 , 0 )
         call argi4 ('-limin', MINLI , 1 , 1 )
         call argi4 ('-limax', MAXLI , 0 , 0 )

         call argi4 ('-sw', ist , 0 , 0 )
         call argi4 ('-ew', ied , 0 , 0 )
         call argr4 ('-vw', vel , 0., 0.)

         call argr4 ('-p' , pr, 0., 0.)
         call argr4 ('-ol', ol, 0., 0.)
         call argr4 ('-P', prew, 0.01, 0.01)
         TV = ( argis( '-TV' ) .gt. 0 )
         call argi4('-w', lslide, 500, 500)

         if (ol .eq. 0.0) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in predecon3d:'
            write(LERR,*)'Must enter nonzero operator length -ol[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in predecon3d:'
            write(LER ,*)'Must enter nonzero operator length -ol[]'
            stop
         endif

         if (dstdel .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in predecon3d:'
            write(LERR,*)'Must enter spread group interval -ddel[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in predecon3d:'
            write(LER ,*)'Must enter spread group interval -ddel[]'
            stop
         endif

         shot   = (argis('-shot') .gt. 0)
         norm   = (argis('-norm') .gt. 0)
         verbos = (argis('-V') .gt. 0)

C *** FILL IN THE DEFAULTS                                              00002460


c        READ (CARD, 160) IX3, IY3, IX4, IY4, DYT, DXT                  00002680

         if (lags .eq. 0) lags = 1000

         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )

         call argr4 ('-cldm', dxt, 0., 0.)
         call argr4 ('-ildm', dyt, 0., 0.)

         if (dxt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in predecon3d:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in predecon3d:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif

         if (dyt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in predecon3d:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in predecon3d:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif

         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in predecon3d:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in predecon3d:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif


C *** COMPUTE NUMBER OF INPUT TRACES                                    00002700
	
         IF (DYT .NE. 0.) DY = DYT
         IF (DXT .NE. 0.) DX = DXT

         if (DSTMAX .eq. 0.0 .AND. DSTMIN .eq. 0.0 .AND.
     1       DSTDEL .eq. 0.0) then
             write(IPRT,*)'FATAL ERROR in predecon3d:'
             write(IPRT,*)'Must enter spread geometry using'
             write(IPRT,*)'-dmin[] -dmax[] -ddel[] cmd line args'
             stop
         endif

         NFOLD  = nint ((DSTMAX - DSTMIN) / DSTDEL) + 1
         TRCSPC = DSTDEL
         NTRCS = NFOLD
         NTPL  = NFOLD
         NREC  = (NDI * NLI)
         dxg   = DSTDEL
c-------
c compute spread model
c-------
         ngrp = NFOLD
         ngrp2 = ngrp / 2
         call vfill (0.0, spread, 1, ngrp)
 
            do  j = 1, ngrp
 
                       spread (j) = DSTMIN + (j-1) * dxg
            enddo
 
         call minmgv (spread, 1, rmin, lmin, ngrp)
         call maxmgv (spread, 1, rmax, lmax, ngrp)
         DSTMAX = spread (ngrp)
 
         write(IPRT,*)' '
         write(IPRT,*)'Spread model:'
         write(IPRT,*)'Number of groups in spread   = ',ngrp
         write(IPRT,*)'Minimum distance located at grp= ',lmin
         write(IPRT,*)(spread(i),i=1,ngrp)
         write(IPRT,*)' '

     

      WRITE (IPRT, 180) DSTMIN, DSTMAX, DSTDEL, LAGS,
     &                  MINLI, MAXLI, MINDI, MAXDI, DIVEXP
  180 FORMAT (//, 30X, 'COMMAND LINE PARAMETERS:'                 ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  DELTA DISTANCE... . . . . . . .',F15.5  ,
     &        //, 23X, '  NUMBER OF AUTO LAGS . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  NORMALIZATION EXPONENT. . . . .',F15.5  )
      WRITE (IPRT, 190) IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4,
     &                  IOREC, DY, DX
  190 FORMAT ( /, 23X, '  CORNER 1 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 1 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  STARTING OUTPUT RECORD NUMBER .',1X,I9  ,
     &        //, 23X, '  CROSSLINE CELL DIMENSION. . . .',F15.5  ,
     &        //, 23X, '  INLINE CELL DIMENSION . . . . .',F15.5,//)

      RETURN
      END
