C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  computes the time varying autocorrelation from the input
c  data - x and stores the result in output vector auto

      subroutine prdapt (nsamps, pred, lopp, peo, prew,
     1                   lslide, nwin, ovlp, lacorr,
     1                   acorr, work)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real    work (*)
      real    acorr (*), peo (*)
      real    acorrn (SZLNHD), right (SZLNHD)
      real    decop (SZLNHD)
      integer lslide, nwin, ovlp, lacorr, nsamps
      integer pred, lopp, ioff

      LF   = pred + lopp
      ioff = pred
      DO  KK = 1, nwin
 
         ip = (KK-1) * lacorr
         do  i = 1, lacorr
             acorrn (i) = acorr (i+ip)
         enddo
         acorrn (1) =  (1.0 + prew) * acorrn (1)

         if (ioff .le. 1) then

            call vmov (acorrn(2), 1, right, 1, lopp)
         else
            call vmov (acorrn(ioff+1), 1, right, 1, lopp)
         endif

         if (acorrn(1) .gt. 0.0) then
             call wiener (lopp, acorrn, right, decop, peo, 1, ierr)
         else
             ierr = 1
         endif
         if (ierr .ne. 0) then
            call vclr (decop, 1, lopp)
            call vclr (peo  , 1, lopp)
            peo (1) = 1.0
         endif

C +----------------------------------------------------+
C | CREATE PROPER peo FOR GIVEN PREDICTION DISTANCE    |
C +----------------------------------------------------+
         lconv = lopp + ioff

         if (ioff .gt. 1) then

            do  i = lopp, 1, -1
                work (i+ioff) = -decop (i)
            end do
            do  i = 1, ioff
                work (i) = 0.0
            enddo
            work (1) = 1.

         else

            do  i = 1, lopp
                work (i) = peo (i)
            enddo

         endif
 
         ia = (KK-1) * LF + 1
         call vclr (acorr(ip+1), 1, lacorr)
         call vmov (work, 1, acorr(ia), 1, lconv)

      ENDDO

      return
      END
